#Generate CA Key
openssl genrsa -out root-ca-key.pem 2048

#Convert Key to DER format
openssl rsa -in root-ca-key.pem -inform PEM -out root-ca-key.der -outform DER

#Generate CA cert
openssl req -new -x509 -days 10000 -key root-ca-key.pem -out root-ca-cert.pem

#Convert CA cert to DER format
openssl x509 -in root-ca-cert.pem -inform PEM -out root-ca-cert.der -outform DER

#Removing DER extension
mv root-ca-cert.der root-ca-cert

#=================================================================================

#Generate my private key
openssl genrsa -out my-key.pem 2048

#Convert my Key to DER format
openssl rsa -in my-key.pem -inform PEM -out my-key.der -outform DER

#Generate my Cert (untrusted)
openssl req -new -key my-key.pem -out my-cert.pem

#Sign with CA key
openssl x509 -req -days 10000 -in my-cert.pem -CA root-ca-cert.pem -CAkey root-ca-key.pem -set_serial 01 -out my-cert-trusted.pem

#Convert my Cert (trusted) to DER format
openssl x509 -in my-cert-trusted.pem -inform PEM -out my-cert-trusted.der -outform DER

mv my-cert-trusted.der my-cert-trusted

#=================================================================================
#
##Generate TI-fake Key
#openssl genrsa -out ti-fake-key.pem 2048
#
##Convert TI-fake Key to DER format
#openssl rsa -in ti-fake-key.pem -inform PEM -out ti-fake-key.der -outform DER
#
##Generate TI-fake cert
#openssl req -new -x509 -days 10000 -key ti-fake-key.pem -out ti-fake-cert.pem
#
##Convert TI-fake cert to DER format
#openssl x509 -in ti-fake-cert.pem -inform PEM -out ti-fake-cert.der -outform DER
