//*****************************************************************************
//
//! \addtogroup mqtt_client
//! @{
//
//*****************************************************************************

// Standard includes
#include <stdlib.h>


// simplelink includes
#include "simplelink.h"

// driverlib includes
#include "hw_types.h"
#include "hw_ints.h"
#include "hw_memmap.h"
#include "interrupt.h"
#include "rom_map.h"
#include "prcm.h"
#include "uart.h"
//#include "timer.h"

// common interface includes
#include "network_if.h"
#ifndef NOTERM
#include "uart_if.h"
#endif


#include "systick.h"

#include "button_if.h"
#include "gpio_if.h"

#include "udma.h"
//#include "timer_if.h"
#include "udma_if.h"
#include "common.h"
#include "timer.h"
#include "timer_if.h"
//servono per il json
//#include "jsmn.h"
#include "log.h"
//fine
#include "utils.h"



#include "sl_mqtt_client.h"

// application specific includes
#include "pinmux.h"
//per ota e pi precisamente per tDisplayInfo
//#include "flc_api.h"
#include "flc.h"
//#include "ota_api.h"
//#include "MQTTCC3200.h"
//#include "MQTTClient.h"
#include "otaconfig.h"

//client http
#include <http/client/httpcli.h>
#include <http/client/common.h>


#define APPLICATION_VERSION 	"1.1.1"

/*Operate Lib in MQTT 3.1 mode.*/
#define MQTT_3_1_1              false /*MQTT 3.1.1 */
#define MQTT_3_1                true /*MQTT 3.1*/

#define WILL_TOPIC              "Client"
#define WILL_MSG                "Client Stopped"
#define WILL_QOS                QOS2
#define WILL_RETAIN             false
#define BUFF_SIZE 32
/*Defining Broker IP address and port Number*/

#define SERVER_ADDRESS          "my_mqtt_host" //dominio provvisorio aws EC2
#define PORT_NUMBER             1111 //porta del vps provvisoria

#define DATE                28    /* Current Date */
#define MONTH               1     /* Month 1-12 */
#define YEAR                2016  /* Current year */
#define HOUR                17    /* Time - hours */
#define MINUTE              37    /* Time - minutes */
#define SECOND              0     /* Time - seconds */

#define MAX_BROKER_CONN         1

#define SERVER_MODE             MQTT_3_1
/*Specifying Receive time out for the Receive task*/
#define RCV_TIMEOUT             30

/*Background receive task priority*/
#define TASK_PRIORITY           3

/* Keep Alive Timer value*/
#define KEEP_ALIVE_TIMER        25
//#define KEEP_ALIVE_TIMER        18

/*Clean session flag*/
#define CLEAN_SESSION           true

/*Retain Flag. Used in publish message. */
#define RETAIN                  0

/*Defining Publish Topic*/
#define PUB_TOPIC_FOR_SW3       "enzo/cc3200/ButtonPressEvtSw3"
#define PUB_TOPIC_FOR_SW2       "enzo/cc3200/ButtonPressEvtSw2"

/*Defining Number of topics*/
#define TOPIC_COUNT             4



//#define SL_SSL_CA_CERT_FILE_NAME        "/cert/129.der"


#define WIFI_SSID_FILE			"wifi_ssid.txt"
#define WIFI_PASS_FILE			"wifi_pass.txt"
#define MQTT_USER_FILE			"mqtt_user.txt"
#define MQTT_PASS_FILE			"mqtt_pass.txt"
//questo file mi serve per gestire
//la prima configurazione dello slave
//se all'interno del file c' scritto 0 allora
//devo fare la conferma di registrazione dello slave
//per l'account desiderato...altrimenti no
#define	FIRST_START_FILE		"first_start.txt"

/*Defining QOS levels*/
#define QOS0                    0
#define QOS1                    1
#define QOS2                    2

/*Spawn task priority and OSI Stack Size*/
#define OSI_STACK_SIZE          2048
#define UART_PRINT              Report

#define PORT_NUM            5001
#define BUF_SIZE			40
#define BUF_SIZE_HTTP		100
#define BUF_SIZE_SOCK       1400
#define TCP_PACKET_COUNT    1

#define MAX_BUFF_SIZE       1460

#define JSON_TOKENS 256;

#define SIZE_40K                100960  /* Serial flash file size 40 KB */


//web client data
#define HOST_NAME       	"www.ti.com" //"<host name>"
//#define HOST_NAME       	"192.168.1.103" //"<host name>"
#define HOST_PORT           80

//il prefix per il download del firmware che dovrebbe costituire la cartella da cui scaricare il file
#define PREFIX_BUFFER           "/graphics/folders/partimages/CC3200.jpg"

// dove devo salvarlo? provo a settare /sys/mcuimg2.bin
#define FILE_NAME               "http_server.bin"

#define IMMAGINE_SISTEMA		"/sys/mcuimg2.bin"

//provvisorio
#define POST_REQUEST_URI 	"/RegisterbyMqtt.php"
//#define POST_REQUEST_URI 	"/index.php"

//#define POST_DATA           "{\n\"name\":\"xyz\",\n\"address\":\n{\n\"plot#\":12,\n\"street\":\"abc\",\n\"city\":\"ijk\"\n},\n\"age\":30\n}"
#define POST_DATA			  "{\n\"mail\":\"%s\",\n\"mac\":\"%02X:%02X:%02X:%02X:%02X:%02X\"}"



typedef struct connection_config{
    SlMqttClientCtxCfg_t broker_config;
    void *clt_ctx;
    unsigned char *client_id;
    unsigned char *usr_name;
    unsigned char *usr_pwd;
    bool is_clean;
    unsigned int keep_alive_time;
    SlMqttClientCbs_t CallBAcks;
    int num_topics;
    char *topic[TOPIC_COUNT];
    unsigned char qos[TOPIC_COUNT];
    SlMqttWill_t will_params;
    bool is_connected;
}connect_config;

typedef enum events
{
    PUSH_BUTTON_SW2_PRESSED,
    PUSH_BUTTON_SW3_PRESSED,
    BROKER_DISCONNECTION,
	REGISTRATION_RESPONSE,
	DOWN_POSITION,
	UP_POSITION,
	STOP_TIMER,
	UPDATE_FIRMWARE,
}osi_messages;

// Queue Structure
typedef struct
{
    //Queue_Elem _elem;
	osi_messages ricevuto;
    P_OSI_SPAWN_ENTRY pEntry;
    void* pValue;
}tPushButtonMsg;


typedef struct
{
   /* time */
   unsigned long tm_sec;
   unsigned long tm_min;
   unsigned long tm_hour;
   /* date */
   unsigned long tm_day;
   unsigned long tm_mon;
   unsigned long tm_year;
   unsigned long tm_week_day; //not required
   unsigned long tm_year_day; //not required
   unsigned long reserved[3];
}SlDateTime;


typedef enum{
    // Choosing -0x7D0 to avoid overlap w/ host-driver's error codes
    SOCKET_CREATE_ERROR = -0x7D0,
    BIND_ERROR = SOCKET_CREATE_ERROR - 1,
    LISTEN_ERROR = BIND_ERROR -1,
    SOCKET_OPT_ERROR = LISTEN_ERROR -1,
    CONNECT_ERROR = SOCKET_OPT_ERROR -1,
    ACCEPT_ERROR = CONNECT_ERROR - 1,
    SEND_ERROR = ACCEPT_ERROR -1,
    RECV_ERROR = SEND_ERROR -1,
    SOCKET_CLOSE_ERROR = RECV_ERROR -1,
    DEVICE_NOT_IN_STATION_MODE = SOCKET_CLOSE_ERROR - 1,
    DEVICE_START_FAILED = DEVICE_NOT_IN_STATION_MODE - 1,
    FILE_NOT_FOUND_ERROR = SEND_ERROR - 1,
    INVALID_SERVER_RESPONSE = FILE_NOT_FOUND_ERROR - 1,
    FORMAT_NOT_SUPPORTED = INVALID_SERVER_RESPONSE - 1,
    FILE_OPEN_FAILED = FORMAT_NOT_SUPPORTED - 1,
    FILE_WRITE_ERROR = FILE_OPEN_FAILED - 1,
    INVALID_FILE = FILE_WRITE_ERROR - 1,
    SERVER_CONNECTION_FAILED = SEND_ERROR - 1,
    GET_HOST_IP_FAILED = SERVER_CONNECTION_FAILED  - 1,
    STATUS_CODE_MAX = -0xBB8
}e_AppStatusCodes;



//*****************************************************************************
//                      LOCAL FUNCTION PROTOTYPES
//*****************************************************************************
static void
Mqtt_Recv(void *app_hndl, const char  *topstr, long top_len, const void *payload,
          long pay_len, bool dup,unsigned char qos, bool retain);
static void sl_MqttEvt(void *app_hndl,long evt, const void *buf,
                       unsigned long len);
static void sl_MqttDisconnect(void *app_hndl);
void pushButtonInterruptHandler2();
void pushButtonInterruptHandler3();
void BoardInit(void);
static void DisplayBanner(char * AppName);
void MqttClient(void *pvParameters);
//void restituisci(jsmntok_t *t, unsigned char* p,unsigned int indice);
void gestisci_keepAlive(void);
void inviaResponso();
static int FlushHTTPResponse(HTTPCli_Handle cli);
//*****************************************************************************
//                 GLOBAL VARIABLES -- Start
//*****************************************************************************
#ifdef USE_FREERTOS
#if defined(ewarm)
extern uVectorEntry __vector_table;
#endif
#if defined(ccs)
extern void (* const g_pfnVectors[])(void);
#endif
#endif





//unsigned short g_usTimerInts;
/* AP Security Parameters */
SlSecParams_t SecurityParams = {0};

static volatile unsigned long g_ulBaseA2;

unsigned char g_buff[MAX_BUFF_SIZE+1];

unsigned char mqtt_username[BUF_SIZE];
unsigned char mqtt_password[BUF_SIZE];
unsigned char wifi_pass[BUF_SIZE];
unsigned char first_time_start[BUF_SIZE];
unsigned char fts_standard[BUF_SIZE];

//stringhe per richieste http
unsigned char http_request_msg[BUF_SIZE_HTTP];
unsigned char http_request_uri[BUF_SIZE_HTTP];


unsigned long  g_ulDestinationIP; // IP address of destination server

int timeinmilliseconds_temp=15;
unsigned long max_duty_cycle=0;

_u8 macAddressVal[SL_MAC_ADDR_LEN];
_u8 macAddressLen = SL_MAC_ADDR_LEN;

//topic mqtt provvisori--> da concordare con sossio
unsigned char topic_set[BUF_SIZE];
unsigned char topic_get[BUF_SIZE];
unsigned char topic_reboot[BUF_SIZE];
unsigned char topic_setup[BUF_SIZE];


int timeinmilliseconds_main=0;
int timeinmilliseconds_main2=0;

int iCount=0;

unsigned long duty_cycle=0;


unsigned int stato_luce_1=0;
unsigned int stato_luce_2=0;



//shutter
unsigned int fine_corsa=0;
unsigned int tempo_registrato=0;
unsigned int g_commandregister=0;
float distanza=0;
unsigned short pressione_tasto_1=0;
unsigned short pressione_tasto_2=0;
unsigned short controllo_abbassa_tutto=0;
unsigned short controllo_alza_tutto=0;
unsigned int	counter_fronti_1=0;
unsigned int	counter_fronti_2=0;
//unsigned int posizione;
float posizione;


//vettore di interi dove il primo elemento identifica GPIO1 mentre il secondo GPIO2
unsigned int tipo_gpio[2];

//i tipi sono LAMPADINA(ON/OFF)=1 DIMMER=2 TAPPARELLA=3 TEMPERATURA=4



unsigned char parametro_scrittura1_file1[BUF_SIZE];
unsigned char parametro_scrittura1_file2[BUF_SIZE];


//client http
HTTPCli_Struct httpClient;
HTTPCli_Struct httpClient_update;


//oggetto per bloccare l'accesso al timer di sblocco
OsiLockObj_t semaforo_timer;
OsiLockObj_t semaforo_timer2;
OsiLockObj_t semaforo_timer3;

OsiLockObj_t semaforo_gestore_ka; //semaforo gestore mutua esclusione gestore keep_alive - gestore messaggio



OsiSyncObj_t semaforo_scritture;
OsiSyncObj_t semaforo_esclusione;
OsiSyncObj_t semaforo_reset_interrupt;



/*Message Queue*/
OsiMsgQ_t g_PBQueue;

//mi serve per il dimmer
OsiMsgQ_t coda_dimmer;
//sostituisco con i certificati di amazon

char *security_file_list[] = {"/certs/prov.der"};
/* connection configuration */
connect_config usr_connect_config[] =
{
    {
        {
            {
            	SL_MQTT_NETCONN_SEC | SL_MQTT_NETCONN_URL,
                //SL_MQTT_NETCONN_URL,
                SERVER_ADDRESS,
                PORT_NUMBER,
				SL_SO_SEC_METHOD_SSLv3_TLSV1_2,
				SL_SEC_MASK_TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
                1,
                security_file_list
            },
            SERVER_MODE,
            true,
        },
        NULL,
        "user1",
        mqtt_username,
        mqtt_password,
        true,
        KEEP_ALIVE_TIMER,
        {Mqtt_Recv, sl_MqttEvt, sl_MqttDisconnect},
        TOPIC_COUNT,
        {topic_set, topic_get, topic_setup, topic_reboot},
        {QOS2, QOS2, QOS2},
        {WILL_TOPIC,WILL_MSG,WILL_QOS,WILL_RETAIN},
        false
    }
};

SlDateTime g_time;

/* library configuration */
SlMqttClientLibCfg_t Mqtt_Client={
    8883,
    TASK_PRIORITY,
    30,
    true,
    //(long(*)(const char *, ...))UART_PRINT
	(long(*)(const char *, ...))gestisci_keepAlive
};

/*Publishing topics and messages*/
const char *pub_topic_sw2 = PUB_TOPIC_FOR_SW2;
const char *pub_topic_sw3 = PUB_TOPIC_FOR_SW3;
unsigned char *data_sw2={"Push button sw2 is pressed on CC32XX device"};
unsigned char *data_sw3={"Push button sw3 is pressed on CC32XX device"};
volatile unsigned long  g_ulPacketCount = TCP_PACKET_COUNT;

unsigned char wifi_ssid[BUF_SIZE];
unsigned char wifi_ssid_standard[BUF_SIZE];

unsigned int da_modificare=0;

unsigned char finale[BUF_SIZE_SOCK];

//byte per controllo OTA
long bytesReceived = 0; // variable to store the file size


//la variabile conteggio interrupt mi serve per i contatori
//di up e down position per confrontare il numero di volte che
//i contatori hanno contato con il tempo
int conteggio_interrupt=0;

//tempo residuo il tempo con cui confrontare conteggio_interrupt
int tempo_residuo=0;

//int incremento=0;
float incremento=0;


_u32 indirizzo_configuratore;

unsigned int stato=1;

long lFileHandle;
unsigned long ulToken;

char g_cBsdBuf[BUF_SIZE];

//variabile globale tempo
tGetTime sGetTime;
struct SlTimeval_t timeVal;



static tDisplayInfo sDisplayInfo;



void *app_hndl = (void*)usr_connect_config;


//diventa globale
//connect_config *local_con_conf = (connect_config *)app_hndl;

//connect_config *globale_connessione;

//*****************************************************************************
//                 GLOBAL VARIABLES -- End
//*****************************************************************************

//****************************************************************************
//! Defines Mqtt_Pub_Message_Receive event handler.
//! Client App needs to register this event handler with sl_ExtLib_mqtt_Init
//! API. Background receive task invokes this handler whenever MQTT Client
//! receives a Publish Message from the broker.
//!
//!\param[out]     topstr => pointer to topic of the message
//!\param[out]     top_len => topic length
//!\param[out]     payload => pointer to payload
//!\param[out]     pay_len => payload length
//!\param[out]     retain => Tells whether its a Retained message or not
//!\param[out]     dup => Tells whether its a duplicate message or not
//!\param[out]     qos => Tells the Qos level
//!
//!\return none
//****************************************************************************
static void
Mqtt_Recv(void *app_hndl, const char  *topstr, long top_len, const void *payload,
                       long pay_len, bool dup,unsigned char qos, bool retain)
{

    
}

//****************************************************************************
//! Defines sl_MqttEvt event handler.
//! Client App needs to register this event handler with sl_ExtLib_mqtt_Init
//! API. Background receive task invokes this handler whenever MQTT Client
//! receives an ack(whenever user is in non-blocking mode) or encounters an error.
//!
//! param[out]      evt => Event that invokes the handler. Event can be of the
//!                        following types:
//!                        MQTT_ACK - Ack Received
//!                        MQTT_ERROR - unknown error
//!
//!
//! \param[out]     buf => points to buffer
//! \param[out]     len => buffer length
//!
//! \return none
//****************************************************************************
static void
sl_MqttEvt(void *app_hndl, long evt, const void *buf,unsigned long len)
{
   
}

//****************************************************************************
//
//! callback event in case of MQTT disconnection
//!
//! \param app_hndl is the handle for the disconnected connection
//!
//! return none
//
//****************************************************************************
static void
sl_MqttDisconnect(void *app_hndl)
{
	tPushButtonMsg sMsg;
    connect_config *local_con_conf;
    osi_messages var = BROKER_DISCONNECTION;
    local_con_conf = app_hndl;
    sl_ExtLib_MqttClientUnsub(local_con_conf->clt_ctx, local_con_conf->topic,
                              TOPIC_COUNT);
    UART_PRINT("disconnect from broker %s\r\n",
           (local_con_conf->broker_config).server_info.server_addr);
    local_con_conf->is_connected = false;
    sl_ExtLib_MqttClientCtxDelete(local_con_conf->clt_ctx);


    sMsg.ricevuto=var;

    //
    // write message indicating publish message
    //
    //osi_MsgQWrite(&g_PBQueue,&var,OSI_NO_WAIT);
    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);

}

//****************************************************************************
//
//! Push Button Handler1(GPIOS2). Press push button2 (GPIOSW2) Whenever user
//! wants to publish a message. Write message into message queue signaling the
//!    event publish messages
//!
//! \param none
//!
//! return none
//
//****************************************************************************
void pushButtonInterruptHandler2()
{
	tPushButtonMsg sMsg;

    osi_messages var = PUSH_BUTTON_SW2_PRESSED;

    sMsg.ricevuto=var;
    //
    // write message indicating publish message
    //
    //osi_MsgQWrite(&g_PBQueue,&var,OSI_NO_WAIT);

    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
}

//****************************************************************************
//
//! Push Button Handler3(GPIOS3). Press push button3 (GPIOSW3) Whenever user
//! wants to publish a message. Write message into message queue signaling the
//!    event publish messages
//!
//! \param none
//!
//! return none
//
//****************************************************************************
void pushButtonInterruptHandler3()
{
	tPushButtonMsg sMsg;
    osi_messages var = PUSH_BUTTON_SW3_PRESSED;

    sMsg.ricevuto=var;
    //
    // write message indicating exit from sending loop
    //
    //osi_MsgQWrite(&g_PBQueue,&var,OSI_NO_WAIT);
    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);

}

void gestisci_keepAlive(){
    osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
	osi_SyncObjSignal(&semaforo_reset_interrupt);
    osi_LockObjUnlock(&semaforo_gestore_ka);


}


//funzione che setta il tipo di dispositivo collegato ad uno dei gpio di uscita

void setta_tipo_uscita(int n_gpio, unsigned char* tipo){

	//UART_PRINT("Mi hai chiesto di settare %s\n\r",tipo);

if(strcmp(tipo,"SWITCH")==0){

	tipo_gpio[n_gpio]=1;

}
else if(strcmp(tipo,"DIMMER")==0){
	tipo_gpio[n_gpio]=2;


}
else if(strcmp(tipo,"SHUTTER")==0){
	//per le tapparelle sono impegnati tutti e due i GPIO
	tipo_gpio[0]=3;
	tipo_gpio[1]=3;

}
else if(strcmp(tipo,"HEATH")==0){
	tipo_gpio[n_gpio]=4;
}

}



//****************************************************************************
//
//						FUNZIONI AGGIUNTE DA ME
//
//****************************************************************************



#if 0
void SimpleLinkHttpServerCallback(SlHttpServerEvent_t *pHttpEvent,
                                  SlHttpServerResponse_t *pHttpResponse)
{
    // Unused in this application
}
#endif


//funzioni per la gestione dell'aggiornamento OTA


void inviaResponso(){

	tPushButtonMsg sMsg;

	osi_messages var = REGISTRATION_RESPONSE;

	sMsg.ricevuto=var;

	osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);

}

long NetFwInfoGet(SlVersionFull *sVersion)
{
  unsigned long lRetVal;
  unsigned char ucConfigOpt = 0;
  unsigned char ucConfigLen = 0;

  //
  // Get the device's version-information
  //
  ucConfigOpt = SL_DEVICE_GENERAL_VERSION;
  ucConfigLen = sizeof(SlVersionFull);
  lRetVal = sl_DevGet(SL_DEVICE_GENERAL_CONFIGURATION, &ucConfigOpt,
                              &ucConfigLen, (unsigned char *)(sVersion));

  return lRetVal;
}

//restituisce il mac address
void NetMACAddressGet(unsigned char *pMACAddress)
{
    unsigned char macAddressLen = SL_MAC_ADDR_LEN;

    //
    // Get the MAC address
    //
    sl_NetCfgGet(SL_MAC_ADDRESS_GET, NULL, &macAddressLen, pMACAddress);

}

//fine



//funzione che prende i dati dal webserver e li scarica su un file
//poi cancella il file contenente la rom e lo ricrea in scrittura
//scrivendo all'interno del nuovo mcuimg2.bin i binari nell'update
unsigned char stringa_da_scrivere[10*1024];
static int GetData(HTTPCli_Handle cli)
{
    long          lRetVal = 0;
    long          fileHandle = -1;
    long          fileHandle2 = -1;
    unsigned long Token = 0;


    int id;
    int len=0;
    bool moreFlag = 0;
    HTTPCli_Field fields[3] = {
                                {HTTPCli_FIELD_NAME_HOST, HOST_NAME},
                                {HTTPCli_FIELD_NAME_ACCEPT, "text/html, application/xhtml+xml, */*"},
                                {NULL, NULL}
                              };

    const char *ids[4] = {
                            HTTPCli_FIELD_NAME_CONTENT_LENGTH,
                            HTTPCli_FIELD_NAME_TRANSFER_ENCODING,
                            HTTPCli_FIELD_NAME_CONNECTION,
                            NULL
                         };


    UART_PRINT("Start downloading the file\r\n");

    // Set request fields
    HTTPCli_setRequestFields(cli, fields);

    UART_PRINT("Sono arrivato qui\n\r");
    memset(g_buff, 0, sizeof(g_buff));
    UART_PRINT("Sono arrivato di nuovo qui\n\r");
    // Make HTTP 1.1 GET request
    lRetVal = HTTPCli_sendRequest(cli, HTTPCli_METHOD_GET, PREFIX_BUFFER, 0);
    if (lRetVal < 0)
    {
        // error
        ASSERT_ON_ERROR(SEND_ERROR);
    }

    UART_PRINT("Sono arrivato ancora qui\n\r");
    // Test getResponseStatus: handle
    lRetVal = HTTPCli_getResponseStatus(cli);
    UART_PRINT("Responso: %d\n\r",lRetVal);
    if (lRetVal != 200)
    {
        FlushHTTPResponse(cli);
        if(lRetVal == 404)
        {
            ASSERT_ON_ERROR(FILE_NOT_FOUND_ERROR);
        }
        ASSERT_ON_ERROR(INVALID_SERVER_RESPONSE);
    }

    UART_PRINT("Responso: %d\n\r",lRetVal);


    HTTPCli_setResponseFields(cli, ids);

    UART_PRINT("Sono arrivato dopo responsefields qui\n\r");
    // Read response headers
    while ((id = HTTPCli_getResponseField(cli, (char *)g_buff, sizeof(g_buff), &moreFlag))
               != HTTPCli_FIELD_ID_END)
    {

        if(id == 0)
        {
            UART_PRINT("Content length: %s\n\r", g_buff);
        }
        else if(id == 1)
        {
            if(!strncmp((const char *)g_buff, "chunked", sizeof("chunked")))
            {
                UART_PRINT("Chunked transfer encoding\n\r");
            }
        }
        else if(id == 2)
        {
            if(!strncmp((const char *)g_buff, "close", sizeof("close")))
            {
                ASSERT_ON_ERROR(FORMAT_NOT_SUPPORTED);
            }
        }

    }

    // Open file to save the downloaded file
    lRetVal = sl_FsOpen((_u8 *)FILE_NAME, FS_MODE_OPEN_WRITE, &Token, &fileHandle);
    if(lRetVal < 0)
    {
        // File Doesn't exit create a new of 40 KB file
        lRetVal = sl_FsOpen((unsigned char *)FILE_NAME, \
                           FS_MODE_OPEN_CREATE(SIZE_40K, \
                           _FS_FILE_OPEN_FLAG_COMMIT|_FS_FILE_PUBLIC_WRITE),
                           &Token, &fileHandle);

        ASSERT_ON_ERROR(lRetVal);

    }



    while(1)
    {
        len = HTTPCli_readResponseBody(cli, (char *)g_buff, sizeof(g_buff) - 1, &moreFlag);
        if(len < 0)
        {
            // Close file without saving
            lRetVal = sl_FsClose(fileHandle, 0, (unsigned char*) "A", 1);
            return lRetVal;
        }

        lRetVal = sl_FsWrite(fileHandle, bytesReceived,
                                (unsigned char *)g_buff, len);

        if(lRetVal < len)
        {
            UART_PRINT("Failed during writing the file, Error-code: %d\r\n", \
                         FILE_WRITE_ERROR);
            // Close file without saving
            lRetVal = sl_FsClose(fileHandle, 0, (unsigned char*) "A", 1);
            return lRetVal;
        }
        bytesReceived +=len;

        if ((len - 2) >= 0 && g_buff[len - 2] == '\r' && g_buff [len - 1] == '\n'){
            break;
        }

        if(!moreFlag)
        {
            break;
        }
    }

    //
    // If user file has checksum which can be used to verify the temporary
    // file then file should be verified
    // In case of invalid file (FILE_NAME) should be closed without saving to
    // recover the previous version of file
    //

    // Save and close file
    UART_PRINT("Total bytes received: %d\n\r", bytesReceived);
    lRetVal = sl_FsClose(fileHandle, 0, 0, 0);
    ASSERT_ON_ERROR(lRetVal);

    //se  tutto a posto prima cancello il vecchio file
    lRetVal=sl_FsDel("/sys/mcuimg2.bin",0);

    UART_PRINT("Eliminazione file: %d\n\r", lRetVal);
    bzero(stringa_da_scrivere,bytesReceived);

    lRetVal = sl_FsOpen((unsigned char *)IMMAGINE_SISTEMA, \
                             FS_MODE_OPEN_CREATE(SIZE_40K, \
                             _FS_FILE_OPEN_FLAG_COMMIT|_FS_FILE_PUBLIC_WRITE),
							 &Token, &fileHandle2);


    UART_PRINT("Apertura file in creazione %d\n\r",lRetVal);

    //ora per devo copiare il nuovo
    lRetVal = sl_FsOpen((_u8 *)FILE_NAME, FS_MODE_OPEN_READ, &Token, &fileHandle);
    UART_PRINT("Apertura file origine %d\n\r",lRetVal);

    lRetVal = sl_FsRead(fileHandle,0,stringa_da_scrivere,bytesReceived);
    UART_PRINT("Lettura file origine %d\n\r",lRetVal);
    lRetVal = sl_FsWrite(fileHandle2,0,stringa_da_scrivere,bytesReceived);
    UART_PRINT("Scrittura nuova immagine %d\n\r",lRetVal);

    lRetVal=sl_FsClose(fileHandle2,0,0,0);

    lRetVal=sl_FsClose(fileHandle,0,0,0);




    return SUCCESS;
}


//fine



//task che si occupa di controllare se ci sono nuovi
//aggiornamenti

int ServerFileDownload()
{
    long lRetVal = -1;
    struct sockaddr_in addr;
    HTTPCli_Struct cli;

    //
    // Following function configure the device to default state by cleaning
    // the persistent settings stored in NVMEM (viz. connection profiles &
    // policies, power policy etc)
    //
    // Applications may choose to skip this step if the developer is sure
    // that the device is in its desired state at start of applicaton
    //
    // Note that all profiles and persistent settings that were done on the
    // device will be lost
    //
    //lRetVal = ConfigureSimpleLinkToDefaultState();
//    if(lRetVal < 0)
//    {
//        if (DEVICE_NOT_IN_STATION_MODE == lRetVal)
//        {
//            UART_PRINT("Failed to configure the device in its default state, "
//                            "Error-code: %d\n\r", DEVICE_NOT_IN_STATION_MODE);
//        }
//
//        LOOP_FOREVER();
//    }
//
//    UART_PRINT("Device is configured in default state \n\r");

//    //
//    // Assumption is that the device is configured in station mode already
//    // and it is in its default state
//    //
//    lRetVal = sl_Start(0, 0, 0);
//    if (lRetVal < 0 || ROLE_STA != lRetVal)
//    {
//        ASSERT_ON_ERROR(DEVICE_START_FAILED);
//    }

    Network_IF_ResetMCUStateMachine();

    //
    // Start the driver
    //
    lRetVal = Network_IF_InitDriver(ROLE_STA);
    if(lRetVal < 0)
    {
    	UART_PRINT("Failed to start SimpleLink Device\n\r",lRetVal);
    	LOOP_FOREVER();
    }


        //provo ad aprire il file dell'ssid
        //gli passo 0 perch se non esiste non me lo deve creare
        //lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)WIFI_SSID_FILE,(unsigned char *)wifi_ssid,(unsigned char *)wifi_ssid_standard,0);

////
    UART_PRINT("Device started as STATION \n\r");
//
    //lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)WIFI_SSID_FILE,(unsigned char *)wifi_ssid,(unsigned char *)wifi_ssid_standard,0);

//if(lRetVal!=3){

    	//devo leggere dal file della password della wifi
    	//lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)WIFI_PASS_FILE,(unsigned char *)wifi_pass,(unsigned char *)wifi_ssid_standard,0);
//
//
//    	//configura la connessione alla wifi
        SecurityParams.Key = (signed char *)SECURITY_KEY;
        SecurityParams.KeyLen = strlen(SECURITY_KEY);
        SecurityParams.Type = SECURITY_TYPE;
//
//        //
//        // Connect to the Access Point
//        //
        //lRetVal = Network_IF_ConnectAP(SSID_NAME, SecurityParams);
        lRetVal = Network_IF_ConnectAP(SSID_NAME, SecurityParams);
        if(lRetVal < 0)
        {
           UART_PRINT("Connection to an AP failed\n\r");
           LOOP_FOREVER();
        }



    // Connecting to WLAN AP - Set with static parameters defined at the top
    // After this call we will be connected and have IP address
    //lRetVal = WlanConnect();
//
//    UART_PRINT("Connected to the AP: %s\r\n", SSID_NAME);



    lRetVal = sl_NetAppDnsGetHostByName((signed char *)HOST_NAME,
                                       strlen((const char *)HOST_NAME),
                                       &g_ulDestinationIP,SL_AF_INET);
    if(lRetVal < 0)
    {
        ASSERT_ON_ERROR(GET_HOST_IP_FAILED);
    }

    // Set up the input parameters for HTTP Connection
    addr.sin_family = AF_INET;
    addr.sin_port = htons(HOST_PORT);
    addr.sin_addr.s_addr = sl_Htonl(g_ulDestinationIP);

    // Testing HTTPCli open call: handle, address params only
    HTTPCli_construct(&cli);
    lRetVal = HTTPCli_connect(&cli, (struct sockaddr *)&addr, 0, NULL);
    if (lRetVal < 0)
    {
        UART_PRINT("Connection to server failed\n\r");
	    //ASSERT_ON_ERROR(SERVER_CONNECTION_FAILED);
    }
    else
    {
        UART_PRINT("Connection to server created successfully\r\n");
    }
    // Download the file, verify the file and replace the exiting file
    lRetVal = GetData(&cli);
    if(lRetVal < 0)
    {
        UART_PRINT("Device couldn't download the file from the server\n\r");
    }
    else
    {
    	UART_PRINT("TUTTO A POSTO\n\r");
    	RebootMCU();

    }

    HTTPCli_destruct(&cli);


return SUCCESS;
//}
//else{
//	return ERROR;
//}
}


//fine



//funzioni per la gestione del client HTTP per inviare la conferma di
//registrazione



//flush response

static int FlushHTTPResponse(HTTPCli_Handle httpClient)
{
    const char *ids[2] = {
                            HTTPCli_FIELD_NAME_CONNECTION, /* App will get connection header value. all others will skip by lib */
                            NULL
                         };
    char buf[128];
    int id;
    int len = 1;
    bool moreFlag = 0;
    char ** prevRespFilelds = NULL;


    /* Store previosly store array if any */
    prevRespFilelds = HTTPCli_setResponseFields(httpClient, ids);

    /* Read response headers */
    while ((id = HTTPCli_getResponseField(httpClient, buf, sizeof(buf), &moreFlag))
            != HTTPCli_FIELD_ID_END)
    {

        if(id == 0)
        {
            if(!strncmp(buf, "close", sizeof("close")))
            {
                UART_PRINT("Connection terminated by server\n\r");
            }
        }

    }

    /* Restore previosuly store array if any */
    HTTPCli_setResponseFields(httpClient, (const char **)prevRespFilelds);

    while(1)
    {
        /* Read response data/body */
        /* Note:
                moreFlag will be set to 1 by HTTPCli_readResponseBody() call, if more
                data is available Or in other words content length > length of buffer.
                The remaining data will be read in subsequent call to HTTPCli_readResponseBody().
                Please refer HTTP Client Libary API documenation @ref HTTPCli_readResponseBody
                for more information.
        */
        HTTPCli_readResponseBody(httpClient, buf, sizeof(buf) - 1, &moreFlag);
        ASSERT_ON_ERROR(len);

        if ((len - 2) >= 0 && buf[len - 2] == '\r' && buf [len - 1] == '\n'){
            break;
        }

        if(!moreFlag)
        {
            /* There no more data. break the loop. */
            break;
        }
    }
    return 0;
}


//


//funzione per la connessione al server


static int ConnectToHTTPServer(HTTPCli_Handle httpClient)
{
    long lRetVal = -1;
    struct sockaddr_in addr;


#ifdef USE_PROXY
    struct sockaddr_in paddr;
    paddr.sin_family = AF_INET;
    paddr.sin_port = htons(PROXY_PORT);
    paddr.sin_addr.s_addr = sl_Htonl(PROXY_IP);
    HTTPCli_setProxy((struct sockaddr *)&paddr);
#endif

    /* Resolve HOST NAME/IP */
    lRetVal = sl_NetAppDnsGetHostByName((signed char *)HOST_NAME,
                                          strlen((const char *)HOST_NAME),
                                          &g_ulDestinationIP,SL_AF_INET);
    if(lRetVal < 0)
    {
        ASSERT_ON_ERROR(GET_HOST_IP_FAILED);
    }

    /* Set up the input parameters for HTTP Connection */
    addr.sin_family = AF_INET;
    addr.sin_port = htons(HOST_PORT);
    addr.sin_addr.s_addr = sl_Htonl(g_ulDestinationIP);

    /* Testing HTTPCli open call: handle, address params only */
    HTTPCli_construct(httpClient);
    lRetVal = HTTPCli_connect(httpClient, (struct sockaddr *)&addr, 0, NULL);
    if (lRetVal < 0)
    {
        UART_PRINT("Connection to server failed. error(%d)\n\r", lRetVal);
        ASSERT_ON_ERROR(SERVER_CONNECTION_FAILED);
    }
    else
    {
        UART_PRINT("Connection to server created successfully\r\n");
    }

    return 0;
}




//fine






//funzione per il response

static int readResponse(HTTPCli_Handle httpClient)
{
	long lRetVal = 0;
	int bytesRead = 0;
	int id = 0;
	unsigned long len = 0;
	int json = 0;
	char *dataBuffer=NULL;
	bool moreFlags = 1;
	const char *ids[4] = {
	                        HTTPCli_FIELD_NAME_CONTENT_LENGTH,
			                HTTPCli_FIELD_NAME_CONNECTION,
			                HTTPCli_FIELD_NAME_CONTENT_TYPE,
			                NULL
	                     };

	/* Read HTTP POST request status code */
	lRetVal = HTTPCli_getResponseStatus(httpClient);
	if(lRetVal > 0)
	{
		switch(lRetVal)
		{
		case 500:{

			UART_PRINT("Errore 500!!!\n\rErrore del server\n\r");
			lRetVal=-1;

		}
		break;
		case 200:
		{
			UART_PRINT("HTTP Status 200\n\r");
			/*
                 Set response header fields to filter response headers. All
                  other than set by this call we be skipped by library.
			 */
			HTTPCli_setResponseFields(httpClient, (const char **)ids);

			/* Read filter response header and take appropriate action. */
			/* Note:
                    1. id will be same as index of fileds in filter array setted
                    in previous HTTPCli_setResponseFields() call.

                    2. moreFlags will be set to 1 by HTTPCli_getResponseField(), if  field
                    value could not be completely read. A subsequent call to
                    HTTPCli_getResponseField() will read remaining field value and will
                    return HTTPCli_FIELD_ID_DUMMY. Please refer HTTP Client Libary API
                    documenation @ref HTTPCli_getResponseField for more information.
			 */
			while((id = HTTPCli_getResponseField(httpClient, (char *)g_buff, sizeof(g_buff), &moreFlags))
					!= HTTPCli_FIELD_ID_END)
			{

				switch(id)
				{
				case 0: /* HTTPCli_FIELD_NAME_CONTENT_LENGTH */
				{
					len = strtoul((char *)g_buff, NULL, 0);
				}
				break;
				case 1: /* HTTPCli_FIELD_NAME_CONNECTION */
				{
				}
				break;
				case 2: /* HTTPCli_FIELD_NAME_CONTENT_TYPE */
				{
					if(!strncmp((const char *)g_buff, "application/json",
							sizeof("application/json")))
					{
						json = 1;
					}
					else
					{
						/* Note:
                                Developers are advised to use appropriate
                                content handler. In this example all content
                                type other than json are treated as plain text.
						 */
						json = 0;
					}
					UART_PRINT(HTTPCli_FIELD_NAME_CONTENT_TYPE);
					UART_PRINT(" : ");
					UART_PRINT("application/json\n\r");
				}
				break;
				default:
				{
					UART_PRINT("Wrong filter id\n\r");
					lRetVal = -1;
					goto end;
				}
				}
			}
			bytesRead = 0;
			if(len > sizeof(g_buff))
			{
				dataBuffer = (char *) malloc(len);
				if(dataBuffer)
				{
					UART_PRINT("Failed to allocate memory\n\r");
					lRetVal = -1;
					goto end;
				}
			}
			else
			{
				dataBuffer = (char *)g_buff;
			}

			/* Read response data/body */
			/* Note:
                    moreFlag will be set to 1 by HTTPCli_readResponseBody() call, if more
		            data is available Or in other words content length > length of buffer.
		            The remaining data will be read in subsequent call to HTTPCli_readResponseBody().
		            Please refer HTTP Client Libary API documenation @ref HTTPCli_readResponseBody
		            for more information

			 */
			bytesRead = HTTPCli_readResponseBody(httpClient, (char *)dataBuffer, len, &moreFlags);
			if(bytesRead < 0)
			{
				UART_PRINT("Failed to received response body\n\r");
				lRetVal = bytesRead;
				goto end;
			}
			else if( bytesRead < len || moreFlags)
			{
				UART_PRINT("Mismatch in content length and received data length\n\r");
				goto end;
			}
			dataBuffer[bytesRead] = '\0';

			if(json)
			{
				/* Parse JSON data */
				//lRetVal = ParseJSONData(dataBuffer);
				UART_PRINT("%s\n\r",dataBuffer);
				lRetVal=1;
				if(lRetVal < 0)
				{
					goto end;
				}
			}
			else
			{
				/* treating data as a plain text */
				UART_PRINT("%s\n\r",dataBuffer);

			}

			//mando un messaggio mqtt

			sprintf(pub_topic_sw2,"%s/subscribes/%02X:%02X:%02X:%02X:%02X:%02X",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
			//unsigned char trasmissione[BUF_SIZE];

			sprintf(data_sw2,dataBuffer);

			inviaResponso();

			//fine messaggio mqtt

		}
		break;

		case 404:
			UART_PRINT("File not found. \r\n");
			/* Handle response body as per requirement.
                  Note:
                    Developers are advised to take appopriate action for HTTP
                    return status code else flush the response body.
                    In this example we are flushing response body in default
                    case for all other than 200 HTTP Status code.
			 */
		default:
			/* Note:
              Need to flush received buffer explicitly as library will not do
              for next request.Apllication is responsible for reading all the
              data.
			 */
			FlushHTTPResponse(httpClient);
			break;
		}
	}
	else
	{
		UART_PRINT("Failed to receive data from server.\r\n");
		goto end;
	}

	lRetVal = 0;

end:
    if(len > sizeof(g_buff) && (dataBuffer != NULL))
	{
	    free(dataBuffer);
    }
    return lRetVal;
}

//fine response



//funzione per il post
static int HTTPPostMethod(HTTPCli_Handle httpClient)
{
    bool moreFlags = 1;
    bool lastFlag = 1;
    char tmpBuf[4];
    long lRetVal = 0;
    HTTPCli_Field fields[4] = {
                                {HTTPCli_FIELD_NAME_HOST, HOST_NAME},
                                {HTTPCli_FIELD_NAME_ACCEPT, "*/*"},
                                {HTTPCli_FIELD_NAME_CONTENT_TYPE, "application/json"},
                                {NULL, NULL}
                            };


    /* Set request header fields to be send for HTTP request. */
    HTTPCli_setRequestFields(httpClient, fields);

    /* Send POST method request. */
    /* Here we are setting moreFlags = 1 as there are some more header fields need to send
       other than setted in previous call HTTPCli_setRequestFields() at later stage.
       Please refer HTTP Library API documentaion @ref HTTPCli_sendRequest for more information.
    */
    moreFlags = 1;
    //http_request_uri al posto di POST_REQUEST_URI
    lRetVal = HTTPCli_sendRequest(httpClient, HTTPCli_METHOD_POST, http_request_uri, moreFlags);
    if(lRetVal < 0)
    {
        UART_PRINT("Failed to send HTTP POST request header.\n\r");
        return lRetVal;
    }


    sprintf((char *)tmpBuf, "%d", (sizeof(http_request_msg)-1));

    /* Here we are setting lastFlag = 1 as it is last header field.
       Please refer HTTP Library API documentaion @ref HTTPCli_sendField for more information.
    */
    lastFlag = 1;
    lRetVal = HTTPCli_sendField(httpClient, HTTPCli_FIELD_NAME_CONTENT_LENGTH, (const char *)tmpBuf, lastFlag);
    if(lRetVal < 0)
    {
        UART_PRINT("Failed to send HTTP POST request header.\n\r");
        return lRetVal;
    }


    /* Send POST data/body */
    lRetVal = HTTPCli_sendRequestBody(httpClient, http_request_msg, (sizeof(http_request_msg)-1));
    if(lRetVal < 0)
    {
        UART_PRINT("Failed to send HTTP POST request body.\n\r");
        return lRetVal;
    }


    lRetVal = readResponse(httpClient);

    return lRetVal;
}
//fine funzione per il post

//e riceverne un responso


//funzioni per la gestione dei timer in modalit dimming

void
Gestorcomandipwm3(void* pValue){

    osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
	osi_LockObjLock(&semaforo_timer2,OSI_WAIT_FOREVER);
	//UART_PRINT("passato timemilliseconds_main2\n\r");
	GPIO_IF_LedOn(MCU_RED_LED_GPIO);
	osi_LockObjUnlock(&semaforo_timer2);
    osi_LockObjUnlock(&semaforo_gestore_ka);

}

void
Gestorcomandipwm2(void* pValue){

    osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
	osi_LockObjLock(&semaforo_timer3,OSI_WAIT_FOREVER);
	//UART_PRINT("passato timemilliseconds_main\n\r");
	if(timeinmilliseconds_main!=timeinmilliseconds_main2){
	GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);}
	else{
		GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);
		GPIO_IF_LedOn(MCU_RED_LED_GPIO);
	}
	osi_LockObjUnlock(&semaforo_timer3);
    osi_LockObjUnlock(&semaforo_gestore_ka);

//
}

void
Gestorcomandipwm(void* pValue){

	//Semaphore_pend(sem,BIOS_WAIT_FOREVER);
	//aggiunta la gestione che se mi arriva zero non lo spengo
    osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
	osi_LockObjLock(&semaforo_timer,OSI_WAIT_FOREVER);
	if((tipo_gpio[0]==2)&&(timeinmilliseconds_main!=0)){
	GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);}
	//perch deve rimanere sempre acceso...se qualcosa non dovesse funzionare
	//eliminare la seconda condizione
	if((tipo_gpio[1]==2)&&(timeinmilliseconds_main2!=0)){
	GPIO_IF_LedOff(MCU_RED_LED_GPIO);}
	Button_IF_EnableInterrupt(SW3);


	osi_LockObjUnlock(&semaforo_timer);
    osi_LockObjUnlock(&semaforo_gestore_ka);

}
//fine fine


void
gestionepwm3(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA0_BASE, true);
	    MAP_TimerIntClear(TIMERA0_BASE, ulInts);

	    tPushButtonMsg sMsg;
		sMsg.ricevuto="PassZero";
	    	    sMsg.pEntry = &Gestorcomandipwm3;
	    	    sMsg.pValue = NULL;

	    	    //vecchia coda funzionante
	    	    osi_MsgQWrite(&coda_dimmer,&sMsg,OSI_NO_WAIT);
}


void
gestionepwm2(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA3_BASE, true);
	    MAP_TimerIntClear(TIMERA3_BASE, ulInts);

	    tPushButtonMsg sMsg;
		sMsg.ricevuto="PassZero";
	    	    sMsg.pEntry = &Gestorcomandipwm2;
	    	    sMsg.pValue = NULL;

	    	    //vecchia coda funzionante
	    	    osi_MsgQWrite(&coda_dimmer,&sMsg,OSI_NO_WAIT);
}


//handler gestione timer duty cycle
void
gestionepwm(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA2_BASE, true);
	    MAP_TimerIntClear(TIMERA2_BASE, ulInts);

	    tPushButtonMsg sMsg;
		sMsg.ricevuto="PassZero";
	    	    sMsg.pEntry = &Gestorcomandipwm;
	    	    sMsg.pValue = NULL;

	    	    //vecchia coda funzionante
	    	    osi_MsgQWrite(&coda_dimmer,&sMsg,OSI_NO_WAIT);
}
//fine

//fine



//funzione che viene chiamata al passaggio per lo zero
void Passaggiozero(){


int timeinmilliseconds;
int timeinmilliseconds2=timeinmilliseconds_temp;
int time_compare_17=MILLISECONDS_TO_TICKS(17);

osi_LockObjLock(&semaforo_timer,OSI_WAIT_FOREVER);
osi_LockObjLock(&semaforo_timer2,OSI_WAIT_FOREVER);
osi_LockObjLock(&semaforo_timer3,OSI_WAIT_FOREVER);


//da verificare se funziona
	if((tipo_gpio[0]==2)&&(timeinmilliseconds_main!=0)){
	GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);}


	if((tipo_gpio[1]==2)&&(timeinmilliseconds_main2!=0)){
		GPIO_IF_LedOff(MCU_RED_LED_GPIO);
	}



	if((tipo_gpio[0]==2)&&(timeinmilliseconds_main==0)){GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);}
	if((tipo_gpio[1]==2)&&(timeinmilliseconds_main2==0)){GPIO_IF_LedOn(MCU_RED_LED_GPIO);}


if(duty_cycle>max_duty_cycle){

						max_duty_cycle=duty_cycle;
						if(duty_cycle<10){
											timeinmilliseconds2=15;
											timeinmilliseconds_temp=15;
														}
						else{timeinmilliseconds2=duty_cycle+1;
						timeinmilliseconds_temp=timeinmilliseconds2;
						}

										}
		//timer per abilitare l'interrupt dopo 17 ms

	timeinmilliseconds=MILLISECONDS_TO_TICKS(timeinmilliseconds2);
		//timer che definisce il tempo di off


	g_ulBaseA2=TIMERA2_BASE;
	Timer_IF_Init(PRCM_TIMERA2, g_ulBaseA2, TIMER_CFG_ONE_SHOT, TIMER_A, 0);
	Timer_IF_IntSetup(g_ulBaseA2, TIMER_A, gestionepwm);
	Timer_IF_Start(g_ulBaseA2, TIMER_A, timeinmilliseconds);


	//funziona non conta se hai impostato 17 perch deve sempre rimanere spento
	if((tipo_gpio[0]==2)&&(timeinmilliseconds_main!=time_compare_17)){
	//Timer di accensione da recuperare dopo
	Timer_IF_Init(PRCM_TIMERA3, TIMERA3_BASE , TIMER_CFG_ONE_SHOT, TIMER_A, 0);
	Timer_IF_IntSetup(TIMERA3_BASE, TIMER_A, gestionepwm2);
	Timer_IF_Start(TIMERA3_BASE, TIMER_A, timeinmilliseconds_main);}




	//funziona non conta se hai impostato 17 perch deve sempre rimanere spento
	if((tipo_gpio[1]==2)&&(timeinmilliseconds_main2!=time_compare_17)&&(timeinmilliseconds_main2!=timeinmilliseconds_main)){
	//secondo timer per gestire anche eventualmente il secondo dimmer
	Timer_IF_Init(PRCM_TIMERA0, TIMERA0_BASE , TIMER_CFG_ONE_SHOT, TIMER_A, 0);
	Timer_IF_IntSetup(TIMERA0_BASE, TIMER_A, gestionepwm3);
	Timer_IF_Start(TIMERA0_BASE, TIMER_A, timeinmilliseconds_main2);
	}





	//Semaphore_post(sem);


	osi_LockObjUnlock(&semaforo_timer);
	osi_LockObjUnlock(&semaforo_timer2);
	osi_LockObjUnlock(&semaforo_timer3);

}

void gestiscipassaggiozero(){

	tPushButtonMsg sMsg;
		sMsg.ricevuto="PassZero";
	    sMsg.pEntry = &Passaggiozero;
	    sMsg.pValue = NULL;



	    //vecchia coda funzionante
	    //osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);

		osi_MsgQWrite(&coda_dimmer,&sMsg,OSI_NO_WAIT);


}

//fine funzioni gestione passaggio zero


//handler interrupt timeout

//gestore che viene richiamato quando si verifica l'overflow del contatore per
//la registrazione che viene fatto contare al massimo (53 secondi) dopodich somma il tempo
//di overflow al tempo fino ad ora registrato
void
Gestorenuovo(void* pValue){
//
	//Semaphore_pend(sem,BIOS_WAIT_FOREVER);
	//UART_PRINT("Verificata interruzione\n\r");
	tempo_registrato=tempo_registrato+53;

	//UART_PRINT("Lo stato raggiunto dalla registrazione fino ad ora: %d\n\r",tempo_registrato);
	//Semaphore_post(sem);
//
}
//sono stati tolti i semafori perch non servono per freertos
//ho bisogno per di capire se servir invece introdurre semafori
//per freertos come ho fatto per l'interrupt del dimmer


void
TimerBaseIntHandler(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA0_BASE, true);
	    MAP_TimerIntClear(TIMERA0_BASE, ulInts);

	    tPushButtonMsg sMsg;
	    	    sMsg.pEntry = &Gestorenuovo;
	    	    sMsg.pValue = NULL;


	    	    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);


}
//fine


//Handler di gestione semaforo upposition

void
Gestorcomandimaster(void* pValue){

	//incremento il tempo
	conteggio_interrupt=conteggio_interrupt+1;
	//devo incrementare anche la posizione
	//il valore dell'incremento, conoscendo il tempo del timer di un secondo
	// pari alla (distanza*il tempo di percorrenza di 1 secondo)/distanza da 100
	incremento=distanza/tempo_residuo;
	//UART_PRINT("Valore dell'incremento:%f\n\r",incremento);
	if(conteggio_interrupt<tempo_residuo){
		//incremento la posizione
		posizione=posizione+incremento;


		//aggiungo la parte relativa alla trasmissione della posizione

		sprintf(pub_topic_sw2,"%s/UP_POSITION/%02X:%02X:%02X:%02X:%02X:%02X/",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
		sprintf(data_sw2,"{\"POSIZIONE\":\"%f\"}",posizione);

		//metto nella coda la richiesta del messaggio

		inviaResponso();

		//fine



	}
	else{
		//spengo l'uscita per alzare la tapparella
		GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
		//devo fermare il timer
		Timer_IF_Stop(TIMERA1_BASE,TIMER_A);

		if(controllo_alza_tutto==1){
		posizione=100;
		controllo_alza_tutto=0;
		}

		sprintf(pub_topic_sw2,"%s/UP_POSITION/%02X:%02X:%02X:%02X:%02X:%02X/",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
		sprintf(data_sw2,"{\"POSIZIONE\":\"%f\"}",posizione);

		//metto nella coda la richiesta del messaggio

		inviaResponso();

		//fine




	}



}


void
Gestorcomandimaster2(void* pValue){

	//incremento il tempo
	conteggio_interrupt=conteggio_interrupt+1;
	//devo incrementare anche la posizione
	//il valore dell'incremento, conoscendo il tempo del timer di un secondo
	// pari alla (distanza*il tempo di percorrenza di 1 secondo)/distanza da 100
	incremento=distanza/tempo_residuo;

	if(conteggio_interrupt<tempo_residuo){
		//incremento la posizione
		posizione=posizione-incremento;

		//aggiungo la parte relativa alla trasmissione della posizione

		sprintf(pub_topic_sw2,"%s/DOWN_POSITION/%02X:%02X:%02X:%02X:%02X:%02X/",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
		sprintf(data_sw2,"{\"POSIZIONE\":\"%f\"}",posizione);

		//metto nella coda la richiesta del messaggio

		inviaResponso();

		//fine


	}
	else{
		//spengo l'uscita per alzare la tapparella
		GPIO_IF_LedOff(MCU_RED_LED_GPIO);
		//devo fermare il timer
		Timer_IF_Stop(TIMERA1_BASE,TIMER_A);

		if(controllo_abbassa_tutto==1){
		posizione=0;
		controllo_abbassa_tutto=0;
		}

		sprintf(pub_topic_sw2,"%s/DOWN_POSITION/%02X:%02X:%02X:%02X:%02X:%02X/",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
		sprintf(data_sw2,"{\"POSIZIONE\":\"%f\"}",posizione);

		//metto nella coda la richiesta del messaggio

		inviaResponso();

		//fine


	}



}



void
handlerpacchettidown(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA1_BASE, true);
	    MAP_TimerIntClear(TIMERA1_BASE, ulInts);

	    tPushButtonMsg sMsg;
	    	    sMsg.pEntry = &Gestorcomandimaster2;
	    	    sMsg.pValue = NULL;


	    	    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
}


void
handlerpacchettiup(void)
{unsigned long ulInts;
//ulisco gli interrupt
	ulInts = MAP_TimerIntStatus(TIMERA1_BASE, true);
	    MAP_TimerIntClear(TIMERA1_BASE, ulInts);

	    tPushButtonMsg sMsg;
	    	    sMsg.pEntry = &Gestorcomandimaster;
	    	    sMsg.pValue = NULL;


	    	    osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
}


//fine handler



//funzione che aggiorna un file

void aggiorna_file(unsigned long *ulToken, long *lFileHandle, unsigned char * USER_FILE_NAME ,unsigned char * valore_da_scrivere){
long lRetVal=-1;
int loopcount=0;
unsigned char gaucOldMacDonald[BUF_SIZE];
bzero(gaucOldMacDonald,BUF_SIZE);
sprintf(gaucOldMacDonald,valore_da_scrivere,sizeof(valore_da_scrivere));
UART_PRINT("Scrivo %s ed il valore di stato  %d\n\r",gaucOldMacDonald,stato);

	//impostiamo che tipo 1 mi aggiorna la lampada
	//tipo 2 mi aggiorna il ventilatore
//	lRetVal = sl_FsOpen((unsigned char *)USER_FILE_NAME,
//	                        FS_MODE_OPEN_WRITE,
//	                        ulToken,
//	                        lFileHandle);

lRetVal = sl_FsOpen(USER_FILE_NAME,
                FS_MODE_OPEN_CREATE(3584,
                          _FS_FILE_OPEN_FLAG_COMMIT|_FS_FILE_PUBLIC_WRITE),
                        ulToken,
                        lFileHandle);



	UART_PRINT("Apertura file in scrittura ha riportato: %d\n\r",lRetVal);

    lRetVal = sl_FsWrite(*lFileHandle,
	                    (unsigned int)(loopcount * sizeof(gaucOldMacDonald)),
	                    (unsigned char *)gaucOldMacDonald, sizeof(gaucOldMacDonald));

	UART_PRINT("Scrittura file ha riportato: %d\n\r",lRetVal);

    lRetVal = sl_FsClose(*lFileHandle, 0, 0, 0);

    UART_PRINT("La chiusura del file ha restituito %d\n\r",lRetVal);


}



//fine



//funzione che apre un file


int aprifile(unsigned long *ulToken, long *lFileHandle, unsigned char * USER_FILE_NAME, unsigned char * parametro_da_scrivere, unsigned char *valore_default, unsigned int creazione){

	long lRetVal = -1;
	int loopcount=0;
	int controllo=0;
	unsigned char gaucOldMacDonald[BUF_SIZE];
	unsigned char gaucOldMacDonald2[]="100";
	char subbuff[5]; //vale per pushlight, dimdom, heatdom, pushutter per lo stato
	char subbuff2[5];
	int stato_lampada;
	unsigned char gaucCmpBuf[BUF_SIZE];
	bzero(gaucOldMacDonald,sizeof(gaucOldMacDonald));
	sprintf(gaucOldMacDonald,valore_default,sizeof(valore_default));
	//unsigned char gaucCmpBuf2[BUF_SIZE];
	bzero(gaucCmpBuf,BUF_SIZE);
	UART_PRINT("Il parametro che mi hai passato: %s \n\r",USER_FILE_NAME);
	//UART_PRINT("Quello che devo scrivere nel file %s\n\r",valore_default);

UART_PRINT("Provo ad aprire il file\n\r");
	lRetVal = sl_FsOpen((unsigned char *)USER_FILE_NAME,
			    	                        FS_MODE_OPEN_READ,
			    	                        ulToken,
			    	                        lFileHandle);
//
//
	UART_PRINT("stato intermedio\n\r");
//
		if((lRetVal<0)&&(creazione==1)){
			UART_PRINT("Il file non esiste\n\r");
			UART_PRINT("Il valore di quello che scrivo nel file: %s\n\r",gaucOldMacDonald);

		lRetVal = sl_FsOpen(USER_FILE_NAME,
		                FS_MODE_OPEN_CREATE(3584,
		                          _FS_FILE_OPEN_FLAG_COMMIT|_FS_FILE_PUBLIC_WRITE),
		                        ulToken,
		                        lFileHandle);

		UART_PRINT("Esito operazione apertura %d\n\r",lRetVal);

		lRetVal = sl_FsWrite(*lFileHandle,
			                    (unsigned int)(loopcount * sizeof(gaucOldMacDonald)),
			                    (unsigned char *)gaucOldMacDonald, BUF_SIZE);

		UART_PRINT("Esito operazione scrittura %d\n\r",lRetVal);
		sprintf(gaucCmpBuf,gaucOldMacDonald, sizeof(gaucOldMacDonald));
		controllo=1;
		UART_PRINT("FILE_CREATO\n\r");

		}
else if(lRetVal>=0){
			UART_PRINT("File esistente\n\r");
//			//il file esiste gi
			lRetVal = sl_FsRead(*lFileHandle,
			(unsigned int)(loopcount * sizeof(gaucOldMacDonald)),
			 gaucCmpBuf, sizeof(gaucOldMacDonald));
			UART_PRINT("Lettura file completata\n\r Ho letto:%s\n\r", gaucCmpBuf);
			controllo=0;
		}
else if((lRetVal<0)&&(creazione==0)){controllo=3;}



		if(controllo!=3){
			lRetVal=sl_FsClose(*lFileHandle,0,0,0);
		bzero(parametro_da_scrivere,BUF_SIZE);
		sprintf(parametro_da_scrivere,gaucCmpBuf,sizeof(gaucCmpBuf));
	UART_PRINT("Ho settato il nome dispositivo come %s\n\r",parametro_da_scrivere);}

		UART_PRINT("USCITA\n\r");
		//return 0;
		return controllo;

}

//fine funzione



#if 0
void restituisci(jsmntok_t *tokens, unsigned char* prova,unsigned int indice_ciclo){

unsigned int valuelength;
			jsmntok_t keyvalue = tokens[indice_ciclo+1];
	        valuelength = keyvalue.end - keyvalue.start;
	        char *valueString[valuelength+1];
	        bzero(valueString,valuelength+1);
	        memcpy(&valueString, &finale[keyvalue.start], valuelength);
	        //UART_PRINT("La dimensione di quello che devo leggere: %d\n\r",valuelength);
	        sprintf(prova,"%s",valueString);
	        //UART_PRINT("PROVA RICEVUTA: %s\n\r",prova);

	        //return valueString;


}
#endif
static void RebootMCU()
{
UART_PRINT("Partenza routine riavvio scheda\n\r");
  //
  // Configure hibernate RTC wakeup
  //
  PRCMHibernateWakeupSourceEnable(PRCM_HIB_SLOW_CLK_CTR);

  //
  // Delay loop
  //
  MAP_UtilsDelay(8000000);

  //
  // Set wake up time
  //
  PRCMHibernateIntervalSet(330);


  //
  // Request hibernate
  //
  PRCMHibernateEnter();

  //
  // Control should never reach here
  //
  while(1)
  {

  }
}




int BsdTcpServer(unsigned short usPort)
{
    SlSockAddrIn_t  sAddr;
    SlSockAddrIn_t  sLocalAddr;
    int             iCounter;
    int             iAddrSize;
    int             iSockID;
    int             iStatus;
    int             iNewSockID;
    long            lLoopCount = 0;
    long            lNonBlocking = 1;
    int             iTestBufLen;
    unsigned int dimensione;
    unsigned char buf_buf[2];

    // filling the buffer
    for (iCounter=0 ; iCounter<BUF_SIZE ; iCounter++)
    {
        g_cBsdBuf[iCounter] = (char)(iCounter % 10);
    }

    iTestBufLen  = BUF_SIZE_SOCK;

    //filling the TCP server socket address
    sLocalAddr.sin_family = SL_AF_INET;
    sLocalAddr.sin_port = sl_Htons((unsigned short)usPort);
    sLocalAddr.sin_addr.s_addr = 0;

    // creating a TCP socket
    iSockID = sl_Socket(SL_AF_INET,SL_SOCK_STREAM, 0);
    if( iSockID < 0 )
    {
        // error
        ASSERT_ON_ERROR(SOCKET_CREATE_ERROR);
    }

    iAddrSize = sizeof(SlSockAddrIn_t);

    // binding the TCP socket to the TCP server address
    iStatus = sl_Bind(iSockID, (SlSockAddr_t *)&sLocalAddr, iAddrSize);
    if( iStatus < 0 )
    {
        // error
        sl_Close(iSockID);
        ASSERT_ON_ERROR(BIND_ERROR);
    }

    // putting the socket for listening to the incoming TCP connection
    iStatus = sl_Listen(iSockID, 0);
    if( iStatus < 0 )
    {
        sl_Close(iSockID);
        ASSERT_ON_ERROR(LISTEN_ERROR);
    }

    // setting socket option to make the socket as non blocking
    iStatus = sl_SetSockOpt(iSockID, SL_SOL_SOCKET, SL_SO_NONBLOCKING,
                            &lNonBlocking, sizeof(lNonBlocking));
    if( iStatus < 0 )
    {
        sl_Close(iSockID);
        ASSERT_ON_ERROR(SOCKET_OPT_ERROR);
    }
    iNewSockID = SL_EAGAIN;

    // waiting for an incoming TCP connection
    while( iNewSockID < 0 )
    {
        // accepts a connection form a TCP client, if there is any
        // otherwise returns SL_EAGAIN
        iNewSockID = sl_Accept(iSockID, ( struct SlSockAddr_t *)&sAddr,
                                (SlSocklen_t*)&iAddrSize);
        if( iNewSockID == SL_EAGAIN )
        {
           MAP_UtilsDelay(10000);
        }
        else if( iNewSockID < 0 )
        {
            // error
            sl_Close(iNewSockID);
            sl_Close(iSockID);
            ASSERT_ON_ERROR(ACCEPT_ERROR);
        }
    }

    // waits for 1000 packets from the connected TCP client
    while (lLoopCount < g_ulPacketCount)
    {
        iStatus = sl_Recv(iNewSockID, g_cBsdBuf, iTestBufLen, 0);
        if( iStatus <= 0 )
        {
          // error
          sl_Close(iNewSockID);
          sl_Close(iSockID);
          ASSERT_ON_ERROR(RECV_ERROR);
        }
        bzero(finale,BUF_SIZE);
        bzero(buf_buf,2);
        sprintf(buf_buf,"%c",g_cBsdBuf[0]);
        strcpy(finale,buf_buf);
        int i=0;
        for(i=1; i<=iStatus;i++){
            bzero(buf_buf,2);
            sprintf(buf_buf,"%c",g_cBsdBuf[i]);
        	strcat(finale,buf_buf);

        }

        //salvo l'indirizzo di chi mi ha mandato il messaggio di configurazione
        indirizzo_configuratore=sAddr.sin_addr.s_addr;


        //json
#if 0
        //creazione parser
            	jsmn_parser parser;
                jsmn_init(&parser);
                //creazione token
                unsigned int n = JSON_TOKENS;
                jsmntok_t *tokens = malloc(sizeof(jsmntok_t) * n);
                //free(tokens); //da eliminare se crea problemi
                log_null(tokens);
                //int ret = jsmn_parse(&parser, g_cBsdBuf, strlen(g_cBsdBuf),tokens, n);
                int ret = jsmn_parse(&parser, finale,strlen(finale),tokens, n);

                dimensione=tokens->size;


                //interpretazione risultato

                unsigned int indice_ciclo=0; unsigned short trovato=0; unsigned char prova[BUF_SIZE];

                indice_ciclo=0;
                trovato=0; unsigned int indicino=0;
                while((indice_ciclo<dimensione)&&(trovato==0)){
                	indicino=indice_ciclo+indice_ciclo;


                	restituisci(tokens, prova, indicino);

                	if(strcmp(prova,"TOPIC")==0){
                		bzero(parametro_scrittura1_file1,BUF_SIZE);
                		sprintf(parametro_scrittura1_file1,(unsigned char *)MQTT_USER_FILE,sizeof(MQTT_USER_FILE));

                	restituisci(tokens, prova,indicino+1);
                	sprintf(mqtt_username,"%s",prova);

                	}
                	else if(strcmp(prova,"TOPIC_PASSWORD")==0){
                		bzero(parametro_scrittura1_file1,BUF_SIZE);
                		sprintf(parametro_scrittura1_file1,(unsigned char *)MQTT_PASS_FILE,sizeof(MQTT_PASS_FILE));
                		restituisci(tokens, prova,indicino+1);
                		sprintf(mqtt_password,"%s",prova);
                	}
                	else if(strcmp(prova,"SSID")==0){
                		bzero(parametro_scrittura1_file1,BUF_SIZE);
                		sprintf(parametro_scrittura1_file1,(unsigned char *)WIFI_SSID_FILE,sizeof(WIFI_SSID_FILE));
                		restituisci(tokens, prova,indicino+1);
                		sprintf(wifi_ssid,"%s",prova);

                	}
                	else if(strcmp(prova,"WPA")==0){
                		bzero(parametro_scrittura1_file1,BUF_SIZE);
                		sprintf(parametro_scrittura1_file1,(unsigned char *)WIFI_PASS_FILE,sizeof(WIFI_PASS_FILE));
                		restituisci(tokens, prova, indicino+1);
                		sprintf(wifi_pass,"%s",prova);

                	}

                	bzero(parametro_scrittura1_file2,BUF_SIZE);
                	sprintf(parametro_scrittura1_file2,(unsigned char *)prova,sizeof(prova));

                	osi_SyncObjSignal(&semaforo_scritture);
                	bzero(prova,sizeof(prova));

                	indice_ciclo++;
                	UART_PRINT("Attendo il completamento della scrittura\n\r");
                    osi_SyncObjWait(&semaforo_esclusione,OSI_WAIT_FOREVER);

                }





                free(tokens);
#endif              //fine


        //fine json

        lLoopCount++;
    }

    Report("Recieved %u packets successfully\n\r",g_ulPacketCount);

    // close the connected socket after receiving from connected TCP client
    iStatus = sl_Close(iNewSockID);
    ASSERT_ON_ERROR(iStatus);
    // close the listening socket
    iStatus = sl_Close(iSockID);
    ASSERT_ON_ERROR(iStatus);

    return SUCCESS;
}





//*****************************************************************************
//
//Funzione che setta la data...Indispensabile per MQTT
//!
//*****************************************************************************

static int set_time()
{
    long retVal;

    g_time.tm_day = DATE;
    g_time.tm_mon = MONTH;
    g_time.tm_year = YEAR;
    g_time.tm_sec = HOUR;
    g_time.tm_hour = MINUTE;
    g_time.tm_min = SECOND;

    retVal = sl_DevSet(SL_DEVICE_GENERAL_CONFIGURATION,
                          SL_DEVICE_GENERAL_CONFIGURATION_DATE_TIME,
                          sizeof(SlDateTime),(unsigned char *)(&g_time));

    ASSERT_ON_ERROR(retVal);
    return SUCCESS;
}



//****************************************************************************
//
//									FINE
//
//****************************************************************************


void BoardInit(void)
{
    /* In case of TI-RTOS vector table is initialize by OS itself */
    #ifndef USE_TIRTOS
    //
    // Set vector table base
    //
    #if defined(ccs)
        IntVTableBaseSet((unsigned long)&g_pfnVectors[0]);
    #endif
    #if defined(ewarm)
        IntVTableBaseSet((unsigned long)&__vector_table);
    #endif
    #endif
    //
    // Enable Processor
    //
    MAP_IntMasterEnable();
    MAP_IntEnable(FAULT_SYSTICK);

    PRCMCC3200MCUInit();
}


static void
DisplayBanner(char * AppName)
{

    UART_PRINT("\n\n\n\r");
    UART_PRINT("\t\t *************************************************\n\r");
    UART_PRINT("\t\t    CC3200 %s Application       \n\r", AppName);
    UART_PRINT("\t\t *************************************************\n\r");
    UART_PRINT("\n\n\n\r");
}

//*****************************************************************************
//
//! Task implementing MQTT client communication to other web client through
//!    a broker
//!
//! \param  none
//!
//! This function
//!    1. Initializes network driver and connects to the default AP
//!    2. Initializes the mqtt library and set up MQTT connection configurations
//!    3. set up the button events and their callbacks(for publishing)
//!    4. handles the callback signals
//!
//! \return None
//!
//*****************************************************************************
void MqttClient(void *pvParameters)
{

    long lRetVal = -1;
    //int iCount = 0;
    int iNumBroker = 0;
    int iConnBroker = 0;
    int esito_risposta=-1;
    int rc=0;
    unsigned char buf[100];
        unsigned char readbuf[100];
    //osi_messages RecvQue;
        tPushButtonMsg RecvQue;

        //diventa globale
    connect_config *local_con_conf = (connect_config *)app_hndl;
    //se qualcosa non dovesse andare nell'invio probabilmente  dovuto a questo
    //*globale_connessione=*local_con_conf;



    //
    // Configure LED
    //
    GPIO_IF_LedConfigure(LED1|LED2|LED3);

    GPIO_IF_LedOff(MCU_RED_LED_GPIO);
    GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);

    //
    // Reset The state of the machine
    //
    Network_IF_ResetMCUStateMachine();

    //
    // Start the driver
    //
    lRetVal = Network_IF_InitDriver(ROLE_STA);
    if(lRetVal < 0)
    {
       UART_PRINT("Failed to start SimpleLink Device\n\r",lRetVal);
       LOOP_FOREVER();
    }


    //provo ad aprire il file dell'ssid
    //gli passo 0 perch se non esiste non me lo deve creare
    lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)WIFI_SSID_FILE,(unsigned char *)wifi_ssid,(unsigned char *)wifi_ssid_standard,0);


    if(lRetVal==3){
    UART_PRINT("Da gestire non esiste il file\n\r");

    //devo terminare modalit standard ed avviare la modalit access point
    lRetVal=Network_IF_DeInitDriver();


    //devo mettere lo slave in modalit access point
    lRetVal = Network_IF_InitDriver(ROLE_AP);
        if(lRetVal < 0)
        {
           UART_PRINT("Failed to start SimpleLink Device\n\r",lRetVal);
           LOOP_FOREVER();
        }

        //devo quindi aprire una socket server per ricevere le informazioni
        lRetVal=BsdTcpServer(PORT_NUM);


        	lRetVal=Network_IF_DeInitDriver();


            //devo mettere lo slave in modalit access point
            lRetVal = Network_IF_InitDriver(ROLE_STA);
                if(lRetVal < 0)
                {
                   UART_PRINT("Failed to start SimpleLink Device\n\r",lRetVal);
                   LOOP_FOREVER();
                }

                UART_PRINT("Provo a connettermi alla rete\n\r");

                SecurityParams.Key = (signed char *)wifi_pass;
                SecurityParams.KeyLen = strlen(wifi_pass);
                SecurityParams.Type = SECURITY_TYPE;

                //
                // Connect to the Access Point
                //
                //lRetVal = Network_IF_ConnectAP(SSID_NAME, SecurityParams);
                lRetVal = Network_IF_ConnectAP(wifi_ssid, SecurityParams);
                if(lRetVal < 0)
                {
                   //abbiamo deciso che se la connessione non va a buon fine semplicemente cancello i file

                                   sl_FsDel("wifi_ssid.txt",0);

                }


                //una volta configurata, che sia con successo o meno la schedina si riavvia
                RebootMCU();





    }
    else{


        sl_NetCfgGet(SL_MAC_ADDRESS_GET,NULL,&macAddressLen,(_u8 *)macAddressVal);
        UART_PRINT("Sono qui ed il mio indirizzo MAC : %02X:%02X:%02X:%02X:%02X:%02X\n\r",macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);


        //aggiunta importante
        bzero(fts_standard,BUF_SIZE);
        sprintf(fts_standard,"0");

    	lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)WIFI_PASS_FILE,(unsigned char *)wifi_pass,(unsigned char *)wifi_ssid_standard,0);
    	lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)MQTT_USER_FILE,(unsigned char *)mqtt_username,(unsigned char *)wifi_ssid_standard,0);
    	lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)MQTT_PASS_FILE,(unsigned char *)mqtt_password,(unsigned char *)wifi_ssid_standard,0);
    	//l'ultimo file riguarda il controllo per la prima configurazione
    	//se questo file non esiste bisogna crearlo
    	lRetVal=aprifile(&ulToken,&lFileHandle,(unsigned char *)FIRST_START_FILE,(unsigned char *)first_time_start,(unsigned char *)fts_standard,1);

    	//UART_PRINT("La password della wifi selezionata: %s\n\r",wifi_pass);
    	//UART_PRINT("Username mqtt:%s\n\r",mqtt_username);
    	//UART_PRINT("Password connessione mqtt: %s\n\r",mqtt_password);

    	sprintf(topic_set,"%s/%02X:%02X:%02X:%02X:%02X:%02X/SET/#",mqtt_username, macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
    	sprintf(topic_get,"%s/%02X:%02X:%02X:%02X:%02X:%02X/GET/#",mqtt_username, macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
    	sprintf(topic_setup,"%s/%02X:%02X:%02X:%02X:%02X:%02X/SETUP/#",mqtt_username, macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
    	sprintf(topic_reboot,"%s/%02X:%02X:%02X:%02X:%02X:%02X/REBOOT/#",mqtt_username, macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
    }

    // switch on Green LED to indicate Simplelink is properly up
    GPIO_IF_LedOn(MCU_ON_IND);


    // Initialize AP security params
    SecurityParams.Key = (signed char *)wifi_pass;
    SecurityParams.KeyLen = strlen(wifi_pass);
    SecurityParams.Type = SECURITY_TYPE;

    //
    // Connect to the Access Point
    //
    //lRetVal = Network_IF_ConnectAP(SSID_NAME, SecurityParams);
    lRetVal = Network_IF_ConnectAP(wifi_ssid, SecurityParams);
    if(lRetVal < 0)
    {
       UART_PRINT("Connection to an AP failed\n\r");
       LOOP_FOREVER();
    }

    //lRetVal=ServerFileDownload();


    //
    // Switch ON RED LED to indicate that Device acquired an IP
    //
    GPIO_IF_LedOn(MCU_IP_ALLOC_IND);

    //UtilsDelay(20000000);

    GPIO_IF_LedOff(MCU_RED_LED_GPIO);

    GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);

    UART_PRINT("Tutto a posto\n\r");

    //
    // Register Push Button Handlers
    //

    Button_IF_Init(pushButtonInterruptHandler2,gestiscipassaggiozero);

    //inizializzazione dimmer
    unsigned int indice_dispositivi=0;
    for(indice_dispositivi=0; indice_dispositivi<2; indice_dispositivi++){

    	if(tipo_gpio[indice_dispositivi]==2){

    		//sono in fase di avvio ed il dispositivo
    		//deve settare il duty cycle dei due dimmer a 17
    		duty_cycle=17;
    		//indico quale dei due settare a 17
    		da_modificare=indice_dispositivi+1;
    		//devo mandare il comando per settarlo a 17
    		osi_SyncObjSignal(&semaforo_reset_interrupt);
    		//devo implementare un attesa
    		MAP_UtilsDelay(8000);


    	}


    }

        lRetVal = set_time();

        UART_PRINT("Provo ad inizializzare il client mqtt\n\r");


    //
    // Initialze MQTT client lib
    //
    lRetVal = sl_ExtLib_MqttClientInit(&Mqtt_Client);
    if(lRetVal != 0)
    {
        // lib initialization failed
        UART_PRINT("MQTT Client lib initialization failed\n\r");
        LOOP_FOREVER();
    }

    /******************* connection to the broker ***************************/
    iNumBroker = sizeof(usr_connect_config)/sizeof(connect_config);
    if(iNumBroker > MAX_BROKER_CONN)
    {
        UART_PRINT("Num of brokers are more then max num of brokers\n\r");
        LOOP_FOREVER();
    }

    while(iCount < iNumBroker)
    {
        //create client context
        local_con_conf[iCount].clt_ctx =
        sl_ExtLib_MqttClientCtxCreate(&local_con_conf[iCount].broker_config,
                                      &local_con_conf[iCount].CallBAcks,
                                      &(local_con_conf[iCount]));

        //
        // Set Client ID
        //
        sl_ExtLib_MqttClientSet((void*)local_con_conf[iCount].clt_ctx,
                            SL_MQTT_PARAM_CLIENT_ID,
                            local_con_conf[iCount].client_id,
                            strlen((char*)(local_con_conf[iCount].client_id)));

        //
        // Set will Params
        //
        if(local_con_conf[iCount].will_params.will_topic != NULL)
        {
            sl_ExtLib_MqttClientSet((void*)local_con_conf[iCount].clt_ctx,
                                    SL_MQTT_PARAM_WILL_PARAM,
                                    &(local_con_conf[iCount].will_params),
                                    sizeof(SlMqttWill_t));
        }

        //
        // setting username and password
        //
        if(local_con_conf[iCount].usr_name != NULL)
        {
            sl_ExtLib_MqttClientSet((void*)local_con_conf[iCount].clt_ctx,
                                SL_MQTT_PARAM_USER_NAME,
                                local_con_conf[iCount].usr_name,
                                strlen((char*)local_con_conf[iCount].usr_name));

            if(local_con_conf[iCount].usr_pwd != NULL)
            {
                sl_ExtLib_MqttClientSet((void*)local_con_conf[iCount].clt_ctx,
                                SL_MQTT_PARAM_PASS_WORD,
                                local_con_conf[iCount].usr_pwd,
                                strlen((char*)local_con_conf[iCount].usr_pwd));
            }
        }

        //
        // connectin to the broker
        //
        if((sl_ExtLib_MqttClientConnect((void*)local_con_conf[iCount].clt_ctx,
                            local_con_conf[iCount].is_clean,
                            local_con_conf[iCount].keep_alive_time) & 0xFF) != 0)
        {
            UART_PRINT("\n\rBroker connect fail for conn no. %d \n\r",iCount+1);

            //delete the context for this connection
            sl_ExtLib_MqttClientCtxDelete(local_con_conf[iCount].clt_ctx);

            break;
        }
        else
        {
            UART_PRINT("\n\rSuccess: conn to Broker no. %d\n\r ", iCount+1);
            local_con_conf[iCount].is_connected = true;
            iConnBroker++;


            //devo controllare se  il primo avvio
            if(strcmp(first_time_start,"0")==0){
            	// il primo avvio e quindi devo mandare la richiesta

            //faccio la richiesta al server per aggiornare il database
           lRetVal = ConnectToHTTPServer(&httpClient);

            if(lRetVal<0){
            	UART_PRINT("Errore nella connessione al server\n\r");

            }
            UART_PRINT("HTTP Post Begin:\n\r");

            //setto la richiesta da mandare tramite post


            bzero(http_request_msg,BUF_SIZE);
            sprintf(http_request_msg,POST_DATA,mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);

            //setto il file su cui fare POST
            bzero(http_request_uri,BUF_SIZE);
            sprintf(http_request_uri,POST_REQUEST_URI);
            lRetVal = HTTPPostMethod(&httpClient);

            if(lRetVal<0){
            	UART_PRINT("Errore nel post\n\r");
            }

            //devo poter scrivere nel file
            //inserimento istruzioni relative scrittura su file

            //settaggio nome del file su cui scrivere
			bzero(parametro_scrittura1_file1,BUF_SIZE);
    		sprintf(parametro_scrittura1_file1,(unsigned char *)FIRST_START_FILE,sizeof(FIRST_START_FILE));
    		//settaggio della variabile a 1
			bzero(first_time_start,sizeof(first_time_start));
			sprintf(first_time_start,"1");
			//settaggio della seconda variabile da scrivere su file
			bzero(parametro_scrittura1_file2,BUF_SIZE);
			sprintf(parametro_scrittura1_file2,(unsigned char *)first_time_start,sizeof(first_time_start));

			//sblocco del semaforo
			osi_SyncObjSignal(&semaforo_scritture);

            //fine operazione di scrittura su file

            }
            //fine controllo primo avvio
            //se non  il primo avvio non devo fare nulla


        }

        //
        // Subscribe to topics
        //

        if(sl_ExtLib_MqttClientSub((void*)local_con_conf[iCount].clt_ctx,
                                   local_con_conf[iCount].topic,
                                   local_con_conf[iCount].qos, TOPIC_COUNT) < 0)
        {
            UART_PRINT("\n\r Subscription Error for conn no. %d\n\r", iCount+1);
            UART_PRINT("Disconnecting from the broker\r\n");
            sl_ExtLib_MqttClientDisconnect(local_con_conf[iCount].clt_ctx);
            local_con_conf[iCount].is_connected = false;

            //delete the context for this connection
            sl_ExtLib_MqttClientCtxDelete(local_con_conf[iCount].clt_ctx);
            iConnBroker--;
            break;
        }
        else
        {
            int iSub;
            UART_PRINT("Client subscribed on following topics:\n\r");


            for(iSub = 0; iSub < local_con_conf[iCount].num_topics; iSub++)
            {
                UART_PRINT("%s\n\r", local_con_conf[iCount].topic[iSub]);
            }
        }
        iCount++;
    }

    if(iConnBroker < 1)
    {
        //
        // no succesful connection to broker
        //
        goto end;
    }

    iCount = 0;

    for(;;)
    {
        osi_MsgQRead( &g_PBQueue, &RecvQue, OSI_WAIT_FOREVER);

        if(PUSH_BUTTON_SW2_PRESSED == RecvQue.ricevuto)
        {
            Button_IF_EnableInterrupt(SW2);

            if(g_commandregister!=1){
            //
            // send publish message
            //


            	//primo input
            	if(tipo_gpio[0]==1){
            		//semplice pulsante
            		//la pressione del tasto fisico fa il toggle
            		//dello stato del pulsante
            		if(stato_luce_1==1){
            			GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
            			stato_luce_1=0;
            		}
            		else if(stato_luce_1==0){
            			GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);
            			stato_luce_1=1;
            		}


            	}
            	else if(tipo_gpio[0]==2){
            		//Dimmer


            		//devo controllare il valore del duty_cycle

            		da_modificare=1;


	  		  		switch(duty_cycle){

	  		  		case 0:{
	  		  			//duty cycle= 0
	  		  			duty_cycle=5;


	  		  			break;
	  		  					}
	  		  		case 5:{
	  		  			//duty cycle= 5
	  		  			duty_cycle=10;


	  		  			break;
	  		  					}
	  		  		case 10:{
	  		  			//duty cycle= 10
	  		  			duty_cycle=15;

	  		  			break;
	  		  					}
	  		  		case 15:{
	  		  			//duty cycle= 15
	  		  			duty_cycle=17;

	  		  			break;
	  		  					}
	  		  		case 17:{
	  		  			//duty cycle= 17
	  		  			duty_cycle=0;


	  		  			break;
	  		  					}

	  		  		}


	  		  		osi_SyncObjSignal(&semaforo_reset_interrupt);


            		//ed avviare la modifica

            	}
            	else if(tipo_gpio[0]==3){
            		//shutter

            		//non sono in registrazione ma  come se fosse un alza
            		//tutto

            		//codice copiato da alza tutto
            		if(fine_corsa!=0){
            			//posso calcolare la distanza
            			conteggio_interrupt=0;
            			distanza=100-posizione;
            			//UART_PRINT("La distanza da 100: %f\n\r",distanza);
            			if(distanza>0){
            				//significa che la tapparella pu partire
            				//se il tempo per percorrere la distanza tra 0 e 100  pari a fine_corsa
            				//vuol dire che il tempo di percorrenza della restante parte di tapparella
            				//che va dalla posizione a 100 si calcola come
            				//((t0-100)*(dx-100))/(d0-100)
            				//ovvero ((tempo per arrivare da 0 a 100)*(distanza da posizione a 100))/(distanza 0 - 100)
            				controllo_alza_tutto=1;


            				//metto l'elemento nella coda delle interrupt
            				tPushButtonMsg sMsg;

            				osi_messages var = UP_POSITION;

            				sMsg.ricevuto=var;

            				osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
            			}
            		}
            		//fine


            	}



            } //shutter
            else if((g_commandregister==1)&&(tipo_gpio[1]==3)){
            	//controllo tipo_gpio inutile ma lo faccio lo stesso
            	if((pressione_tasto_2==0)&&(counter_fronti_2==0)){
            		//significa che non sto registrando il secondo
            		//per cui posso eseguire il codice di registrazione del primo
            		//devo per prima controllare se non sta gi registrando il primo
            		pressione_tasto_1=1; //da controllare anche se quest'assegnazione abbia senso
            		if(counter_fronti_1==0){
            			//allora non  ancora iniziata la registrazione
            			//posso quindi iniziare a registrare
            			//ma prima impedisco che possa essere premuto l'altro pulsante
            			counter_fronti_1=1;
            			//accendo il led che fa alzare la tapparella
            			GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);
            			//e faccio partire il timer

            			//codice inserito per il contatore preso da project2
            			Timer_IF_Init(PRCM_TIMERA0, TIMERA0_BASE, TIMER_CFG_PERIODIC_UP, TIMER_A, 0);
            			//definisco handler interrupt
            			Timer_IF_IntSetup(TIMERA0_BASE, TIMER_A, TimerBaseIntHandler);
            			//faccio partire contatore
            			Timer_IF_Start(TIMERA0_BASE, TIMER_A, 4294967295);
            			//fine

            			//il timer  lo stesso in entrambi i casi

            		}
            		else if(counter_fronti_1==1){
            			//rimetto counter fronti a 0
            			counter_fronti_1=0;
            			//allora devo spegnere il led che mette a uno il gpio
            			GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
            			//devo mandare il segnale di stop al timer
            			Timer_IF_Stop(TIMERA0_BASE,TIMER_A);
            			//e vado a gettarmi il valore
            			unsigned long valore2=Timer_IF_GetCount(TIMERA0_BASE,TIMER_A);
            			//lo converto in secondi dividendolo per il clock dell MCU
            			valore2=valore2/80000000;
            			//e lo sommo al tempo registrato fino ad ora
            			tempo_registrato=tempo_registrato+valore2;
            			//UART_PRINT("Tempo registrato fino ad ora: %d\n\r",tempo_registrato);
            		}

            	}

            }
        }
        else if(PUSH_BUTTON_SW3_PRESSED == RecvQue.ricevuto)
        {
            Button_IF_EnableInterrupt(SW3);

            if(g_commandregister!=1){
            	//questi rappresentano gli interrupt in tutti gli altri casi
            	//che non riguardano tapparelle
            	//quindi  superfluo fare il controllo su tipo_gpio
            //
            // send publish message
            //
//            sl_ExtLib_MqttClientSend((void*)local_con_conf[iCount].clt_ctx,
//                    pub_topic_sw3,data_sw3,strlen((char*)data_sw3),QOS2,RETAIN);
//            UART_PRINT("\n\r CC3200 Publishes the following message \n\r");
//            UART_PRINT("Topic: %s\n\r",pub_topic_sw3);
//            UART_PRINT("Data: %s\n\r",data_sw3);

            	//secondo input quindi devo controllare gpio[1]
            	//command registre per gli altri slave non ha senso di esistere
            	//per cui per gli altri slave si andr a finire direttamente qua
            	//devo solo distinguere il tipo_gpio
            	if(tipo_gpio[1]==1){
            		//semplice pulsante
            		//la pressione del tasto fisico fa il toggle
            		//dello stato del pulsante
            		if(stato_luce_2==1){
            			GPIO_IF_LedOff(MCU_RED_LED_GPIO);
            			stato_luce_2=0;
            		}
            		else if(stato_luce_2==0){
            			GPIO_IF_LedOn(MCU_RED_LED_GPIO);
            			stato_luce_2=1;
            		}


            	}
            	else if(tipo_gpio[1]==2){
            		//Dimmer
            		//devo distinguere il valore del duty cycle
            		da_modificare=2;


	  		  		switch(duty_cycle){

	  		  		case 0:{
	  		  			//duty cycle= 0
	  		  			duty_cycle=5;


	  		  			break;
	  		  					}
	  		  		case 5:{
	  		  			//duty cycle= 5
	  		  			duty_cycle=10;


	  		  			break;
	  		  					}
	  		  		case 10:{
	  		  			//duty cycle= 10
	  		  			duty_cycle=15;

	  		  			break;
	  		  					}
	  		  		case 15:{
	  		  			//duty cycle= 15
	  		  			duty_cycle=17;

	  		  			break;
	  		  					}
	  		  		case 17:{
	  		  			//duty cycle= 17
	  		  			duty_cycle=0;


	  		  			break;
	  		  					}

	  		  		}


	  		  		osi_SyncObjSignal(&semaforo_reset_interrupt);


            		//fine

            	}
            	else if(tipo_gpio[1]==3){
            		//shutter

            		//questo comando  una sorta di abbassa tutto
            		//quindi tutto quello che deve fare  postare nella coda il messaggio
            		//giusto--> da testare l'effettiva funzionalit del codice


            		//codice copiato da abbassa tutto
					if(fine_corsa!=0){
							//necessario altrimenti si ferma subito
							conteggio_interrupt=0;
							//posso calcolare la distanza
							distanza=posizione;
							//UART_PRINT("La distanza da 0: %f\n\r",distanza);
							if(distanza>0){
								//significa che la tapparella pu partire
								//se il tempo per percorrere la distanza tra 0 e 100  pari a fine_corsa
								//vuol dire che il tempo di percorrenza della restante parte di tapparella
								//che va dalla posizione a 100 si calcola come
								//((t0-100)*(dx-100))/(d0-100)
								//ovvero ((tempo per arrivare da 0 a 100)*(distanza da posizione a 100))/(distanza 0 - 100)
								controllo_abbassa_tutto=1;


								//metto l'elemento nella coda delle interrupt
								tPushButtonMsg sMsg;

								osi_messages var = DOWN_POSITION;

								sMsg.ricevuto=var;

								osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
							}
					}

            		//fine

            	}

            }
            else if((g_commandregister==1)&&(tipo_gpio[0]==3)){
            	//pulsante2
            	//anche qua il controllo  superfluo ma ce l'abbiamo messo lo stesso
            	//mi  arrivata l'interruzione dal pulsante che mi dice di andare in alto
            	//significa che devo settare l'uscita alta
            	//devo per distinguere se  stato premuto un altro pulsante
            	//se  in corso un'altra registrazione con questo pulsante
            	//o se il pulsante sw3  gi stato premuto e la registrazione  in corso
            	//shutter
            	if((pressione_tasto_1==0)&&(counter_fronti_1==0)){
            		//significa che non sto registrando il primo per cui
            		//posso entrare nella registrazione del secondo
            		//controllo quindi se  la prima pressione del pulsante due per
            		pressione_tasto_2=1; //in dubbio se questa assegnazione serva a qualcosa
            		if(counter_fronti_2==0){
            			//devo avviare la registrazione
            			//ma prima setto counter_fronti_2=1
            			counter_fronti_2=1;
            			//alzo il bit sul comando di abbassa tapparella
            			GPIO_IF_LedOn(MCU_RED_LED_GPIO);
            			//devo far partire un contatore


            			//codice inserito per il contatore preso da project2
            			Timer_IF_Init(PRCM_TIMERA0, TIMERA0_BASE, TIMER_CFG_PERIODIC_UP, TIMER_A, 0);
            			//definisco handler interrupt
            			Timer_IF_IntSetup(TIMERA0_BASE, TIMER_A, TimerBaseIntHandler);
            			//faccio partire contatore
            			Timer_IF_Start(TIMERA0_BASE, TIMER_A, 4294967295);
            			//fine


            		}
            		else if(counter_fronti_2==1){

            			//significa allora che gi stavo registrando due
            			//per cui devo smettere di registrare
            			counter_fronti_2=0;
            			//spengo il led che sta facendo abbassare la tapparella
            			GPIO_IF_LedOff(MCU_RED_LED_GPIO);
            			//stop del timer
            			Timer_IF_Stop(TIMERA0_BASE,TIMER_A);
            			//e prendo il valore del timer
            			unsigned long valore2=Timer_IF_GetCount(TIMERA0_BASE,TIMER_A);
            			//lo calcolo in secondi dividendo per la frequenza del processore
            			valore2=valore2/80000000;
            			//sommo l'ultimo conteggio al tempo che ho precedentemente registrato
            			tempo_registrato=tempo_registrato+valore2;
            			//sono arrivato qua
            			//UART_PRINT("Tempo registrato fino ad ora: %d\n\r",tempo_registrato);

            		}

            	}

            }
        }
        else if(BROKER_DISCONNECTION == RecvQue.ricevuto)
        {
            iConnBroker--;
            if(iConnBroker < 1)
            {
            	UART_PRINT("sono arrivato disconnection\n\r");
                //
                // device not connected to any broker
                //
                //goto end;
            }
        }
        else if(REGISTRATION_RESPONSE == RecvQue.ricevuto){

        	sl_ExtLib_MqttClientSend((void*)local_con_conf[iCount].clt_ctx,
        	    							  pub_topic_sw2,data_sw2,strlen((char*)data_sw2),QOS2,RETAIN);

        }
        else if(UP_POSITION == RecvQue.ricevuto){
        	//UART_PRINT("La distanza dal 100: %f\n\r",distanza);
        	tempo_residuo=(fine_corsa*(int)distanza)/100;
        	//UART_PRINT("Il tempo residuo: %d\n\r",tempo_residuo);
        	//adesso dovrei far partire il timer
        	//per alza_tutto/abbassa_tutto potrei fare in modo
        	//che parta un contatore fino a tempo_in_ticks
        	//facilmente interrompibile con un timer_if_stop
        	//ed ogni tot secondi che passano in un while manda un messaggio
        	//sul broker per sincronizzarsi con la posizione
        	//inizializzo il timer che dovrebbe anche resettare lo stesso timer se
        	//sta contando
        	//mi dichiaro un contatore periodico
        	Timer_IF_Init(PRCM_TIMERA1, TIMERA1_BASE, TIMER_CFG_PERIODIC_UP, TIMER_A, 0);
        	//setto interrupt timer -- quando finisce in overflow
        	Timer_IF_IntSetup(TIMERA1_BASE, TIMER_A, handlerpacchettiup);
        	//faccio partire il timer che deve contare un secondo
        	Timer_IF_Start(TIMERA1_BASE,TIMER_A,80000000);
        	//questo  un contatore periodico, per cui ad ogni ciclo di interrupt dovr verificare
        	//che una variabile conteggio interrupt sia minore di tempo
        	//spengo il GPIO di discesa
        	GPIO_IF_LedOff(MCU_RED_LED_GPIO);
        	//accendo il GPIO
        	GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);
        	//ovviamente devo anche modificare il controllo abbassa tutto che deve diventare 0
        	controllo_abbassa_tutto=0;


        }
        else if(DOWN_POSITION == RecvQue.ricevuto){
        	//UART_PRINT("La distanza dallo 0: %f\n\r",distanza);
        	tempo_residuo=(fine_corsa*(int)distanza)/100;
        	//UART_PRINT("Il tempo residuo: %d\n\r",tempo_residuo);
        	//adesso dovrei far partire il timer
        	//per alza_tutto/abbassa_tutto potrei fare in modo
        	//che parta un contatore fino a tempo_in_ticks
        	//facilmente interrompibile con un timer_if_stop
        	//ed ogni tot secondi che passano in un while manda un messaggio
        	//sul broker per sincronizzarsi con la posizione
        	//inizializzo il timer che dovrebbe anche resettare lo stesso timer se
        	//sta contando
        	//mi dichiaro un contatore periodico
        	Timer_IF_Init(PRCM_TIMERA1, TIMERA1_BASE, TIMER_CFG_PERIODIC_UP, TIMER_A, 0);
        	//setto interrupt timer -- quando finisce in overflow
        	Timer_IF_IntSetup(TIMERA1_BASE, TIMER_A, handlerpacchettidown);
        	//faccio partire il timer che deve contare un secondo
        	Timer_IF_Start(TIMERA1_BASE,TIMER_A,80000000);
        	//questo  un contatore periodico, per cui ad ogni ciclo di interrupt dovr verificare
        	//che una variabile conteggio interrupt sia minore di tempo
        	//spengo il GPIO di salita
        	GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
        	//accendo il GPIO
        	GPIO_IF_LedOn(MCU_RED_LED_GPIO);
        	//ovviamente devo modificare anche il controllo alza tutto che deve diventare 0
        	controllo_alza_tutto=0;


        }
        else if(STOP_TIMER == RecvQue.ricevuto){

        	//devo semplicemente fermare il timer
        	Timer_IF_Stop(TIMERA1_BASE,TIMER_A);

        	//devo spegnere entrambe le uscite
        	GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
        	GPIO_IF_LedOff(MCU_RED_LED_GPIO);


        	//creo il messaggio da mandare con la posizione aggiornata
        	sprintf(pub_topic_sw2,"%s/POSITION/%02X:%02X:%02X:%02X:%02X:%02X/",mqtt_username,macAddressVal[0],macAddressVal[1],macAddressVal[2],macAddressVal[3],macAddressVal[4],macAddressVal[5]);
   			sprintf(data_sw2,"{\"POSIZIONE\":\"%f\"}",posizione);

        	//e mandare il messaggio con la posizione
        	sl_ExtLib_MqttClientSend((void*)local_con_conf[iCount].clt_ctx,
        	        	    							  pub_topic_sw2,data_sw2,strlen((char*)data_sw2),QOS2,RETAIN);

        }
        else if(UPDATE_FIRMWARE == RecvQue.ricevuto){

        	osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
        	//lRetVal=ServerFileDownload();
        	lRetVal=ConnectToHTTPServer(&httpClient_update);
        	UART_PRINT("Esito connessione server: %d\n\r",lRetVal);

        	lRetVal = GetData(&httpClient_update);
        	UART_PRINT("Esito download: %d\n\r",lRetVal);


        	osi_LockObjUnlock(&semaforo_gestore_ka);


        }
        else{

        	RecvQue.pEntry(RecvQue.pValue);
        }
    }
end:
    //
    // Deinitializating the client library
    //
    sl_ExtLib_MqttClientExit();
    UART_PRINT("\n\r Exiting the Application\n\r");

    LOOP_FOREVER();
}


//da completare gestione up position
//void gestioneUpPosition(void *pvParameters){


//}

//servizio che ogni tot aggiorna l'ora
//aggiunta mia
void SETTA_DATA_SISTEMA(void *pvParameters){
//timeinmilliseconds
	int time_compare_17=MILLISECONDS_TO_TICKS(17);
	//UtilsDelay(800000000);
	while(1){
		osi_SyncObjWait(&semaforo_reset_interrupt,OSI_WAIT_FOREVER);
		//UART_PRINT("SONO STATO SBLOCCATO\n\r");
		osi_LockObjLock(&semaforo_timer,OSI_WAIT_FOREVER);
		osi_LockObjLock(&semaforo_timer2,OSI_WAIT_FOREVER);
		osi_LockObjLock(&semaforo_timer3,OSI_WAIT_FOREVER);
		//UART_PRINT("E' il mio turno\n\r");
		Button_IF_DisableInterrupt(SW3);
		Timer_IF_Stop(g_ulBaseA2, TIMER_A);
		Timer_IF_Stop(TIMERA3_BASE, TIMER_A);
		if((timeinmilliseconds_main!=timeinmilliseconds_main2)&&(timeinmilliseconds_main2!=time_compare_17)){
		Timer_IF_Stop(TIMERA0_BASE, TIMER_A);}

		if(da_modificare==1){
			timeinmilliseconds_main=MILLISECONDS_TO_TICKS(duty_cycle);
		}
		else if(da_modificare==2){
			timeinmilliseconds_main2=MILLISECONDS_TO_TICKS(duty_cycle);
		}
		da_modificare=0;
		Button_IF_EnableInterrupt(SW3);
		osi_LockObjUnlock(&semaforo_timer3);
		osi_LockObjUnlock(&semaforo_timer2);
		osi_LockObjUnlock(&semaforo_timer);

	}

}

void TASK_AGGIORNA_FILE(void *pvParameters){


	while(1){
		UART_PRINT("Attendo il responso del semaforo\n\r");
		osi_SyncObjWait(&semaforo_scritture,OSI_WAIT_FOREVER);
		UART_PRINT("Responso ricevuto\n\r");
		aggiorna_file(&ulToken,&lFileHandle,(unsigned char *)parametro_scrittura1_file1,(unsigned char *)parametro_scrittura1_file2);
		UART_PRINT("Do il permesso di avviare la successiva ricerca\n\r");
		osi_SyncObjSignal(&semaforo_esclusione);
		//UtilsDelay(80000000);
		//setta_ora();


	}

}


void AGGIORNA_SISTEMA(void *pvParameters){

	int valore_ritorno=0;
	int lRetVal=-1;
	while(1){
		//ogni volta attendo per controllare che ci sia un UPDATE
		//MAP_UtilsDelay(800000000);
		//tPushButtonMsg sMsg;
		//osi_messages var = UPDATE_FIRMWARE;

		//sMsg.ricevuto=var;
		//
		// write message indicating exit from sending loop
		//
		//osi_MsgQWrite(&g_PBQueue,&var,OSI_NO_WAIT);
		//osi_MsgQWrite(&g_PBQueue,&sMsg,OSI_NO_WAIT);
		MAP_UtilsDelay(800000000);
		osi_LockObjLock(&semaforo_gestore_ka,OSI_WAIT_FOREVER);
		lRetVal=ServerFileDownload();
		//lRetVal=ConnectToHTTPServer(&httpClient_update);
		//UART_PRINT("Esito connessione server: %d\n\r",lRetVal);

		//lRetVal = GetData(&httpClient_update);
		//UART_PRINT("Esito download: %d\n\r",lRetVal);


		osi_LockObjUnlock(&semaforo_gestore_ka);


	}



}



//gestore pulsanti...speriamo non dia problemi

void GestorePulsanti(){

	UART_PRINT("Prova nuova");
	tPushButtonMsg Msg;
	    int ret=0;

	    for(;;)
	    {
	        ret = osi_MsgQRead( &coda_dimmer, &Msg, OSI_WAIT_FOREVER );
	        if(OSI_OK==ret)
	        {
	            Msg.pEntry(Msg.pValue);
	        }
	    }





}
//fine




//*****************************************************************************
//
//! Main
//!
//! \param  none
//!
//! This function
//!    1. Invokes the SLHost task
//!    2. Invokes the MqttClient
//!
//! \return None
//!
//*****************************************************************************
void main()
{

    long lRetVal = -1;

    osi_SyncObjCreate(&semaforo_scritture);
    osi_SyncObjCreate(&semaforo_esclusione);
    osi_SyncObjCreate(&semaforo_reset_interrupt);

    //semaforo tapparelle
    //osi_SyncObjCreate(&semaforo_down_position);

    //mi creo il semaforo per
    osi_LockObjCreate(&semaforo_timer);

    osi_LockObjCreate(&semaforo_timer2);
    osi_LockObjCreate(&semaforo_timer3);

    osi_LockObjCreate(&semaforo_gestore_ka);

    tipo_gpio[0]=2;
    tipo_gpio[1]=2;



    //
    // Initialize the board configurations
    //
    BoardInit();

    //
    // Pinmux for UART
    //
    PinMuxConfig();


    //configuro dma...necessario per OTA
    //UDMAInit();



    //
    // Configuring UART
    //
    InitTerm();

    //
    // Display Application Banner
    //
    DisplayBanner("MQTT_Client");

    //faccio il check degli aggiornamenti
    //lRetVal = ConfigureSimpleLinkToDefaultState();

    //UART_PRINT("Controllo aggiornamenti\n\r");
    //lRetVal=ServerFileDownload();

    //
    // Start the SimpleLink Host
    //
    lRetVal = VStartSimpleLinkSpawnTask(SPAWN_TASK_PRIORITY);
    if(lRetVal < 0)
    {
        ERR_PRINT(lRetVal);
        LOOP_FOREVER();
    }

    //UART_PRINT("Controllo aggiornamenti\n\r");
    //lRetVal=ServerFileDownload();


    //Inizializzo OTA
    //pvOtaApp = sl_extLib_OtaInit(RUN_MODE_NONE_OS | RUN_MODE_BLOCKING,0);

    //
    // Start the MQTT Client task
    //
//    osi_MsgQCreate(&g_PBQueue,"PBQueue",sizeof(osi_messages),10);
    lRetVal = osi_MsgQCreate(&g_PBQueue,"PBQueue",sizeof(tPushButtonMsg),1);

    lRetVal = osi_MsgQCreate(&coda_dimmer,"PBQueue",sizeof(tPushButtonMsg),1);

   // lRetVal = osi_TaskCreate(MqttClient,
    //                        (const signed char *)"Mqtt Client App",
     //                       OSI_STACK_SIZE, NULL, 2, NULL );

    if(lRetVal < 0)
    {
        ERR_PRINT(lRetVal);
        LOOP_FOREVER();
    }

//    lRetVal = osi_TaskCreate(TASK_AGGIORNA_FILE,
//                            (const signed char *)"Aggiorna file",
//                            OSI_STACK_SIZE, NULL, 2, NULL );

//    lRetVal = osi_TaskCreate(GestorePulsanti,
//                            (const signed char *)"Risettaggio Interrupt",
//                            OSI_STACK_SIZE, NULL, 2, NULL );


//    lRetVal = osi_TaskCreate(SETTA_DATA_SISTEMA,
//                                (const signed char *)"GESTIONE TIMER IF",
//                                OSI_STACK_SIZE, NULL, 2, NULL );

    //task per aggiornamento OTA
    osi_TaskCreate(AGGIORNA_SISTEMA,
                    (const signed char *)"OTA Update",
                    OSI_STACK_SIZE,
                    NULL,
                    2,
                    NULL );



    if(lRetVal < 0)
    {
        ERR_PRINT(lRetVal);
        LOOP_FOREVER();
    }



    //
    // Start the task scheduler
    //
    osi_start();



}

