/*
 *  ======== Board.h ========
 *  Configured TI-Drivers module declarations
 *
 *  DO NOT EDIT - This file is generated for the CC3220SF_LAUNCHXL
 *  by the SysConfig tool.
 */
#ifndef Board_h
#define Board_h

#define Board_SYSCONFIG_PREVIEW

#define Board_CC3220SF_LAUNCHXL

/* Temporary define for backwards compatibility!!! */
#define __CC3220SF_LAUNCHXL_BOARD_H__

#ifndef DeviceFamily_CC3220
#define DeviceFamily_CC3220
#endif

#include <stdint.h>

/* support C++ sources */
#ifdef __cplusplus
extern "C" {
#endif


/*
 *  ======== GPIO ========
 */

#define Board_GPIO_BUTTON1          0
#define Board_GPIO_LED0             1

/* LEDs are active high */
#define Board_GPIO_LED_ON  (1)
#define Board_GPIO_LED_OFF (0)

#define Board_LED_ON  (Board_GPIO_LED_ON)
#define Board_LED_OFF (Board_GPIO_LED_OFF)


/*
 *  ======== I2C ========
 */

#define Board_I2C_TMP               0

/* ======== I2C Addresses and Speeds ======== */
#include <ti/drivers/I2C.h>

/* ---- Board_I2C_TMP I2C bus components ---- */

/* BMA222E address and max speed */
#define Board_I2C_TMP_BMA222E_ADDR     (0x18)
#define Board_I2C_TMP_BMA222E_MAXSPEED (400U) /* Kbps */

/* TMP006 address and max speed */
#define Board_I2C_TMP_TMP006_ADDR     (0x41)
#define Board_I2C_TMP_TMP006_MAXSPEED (3400U) /* Kbps */

/* BOOSTXL_BASSENSORS/TMP116 address and max speed */
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_TMP116_ADDR     (0x48)
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_TMP116_MAXSPEED (400U) /* Kbps */

/* BOOSTXL_BASSENSORS/OPT3001 address and max speed */
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_OPT3001_ADDR     (0x44)
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_OPT3001_MAXSPEED (2600U) /* Kbps */

/* BOOSTXL_BASSENSORS/HDC2010 address and max speed */
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_HDC2010_ADDR     (0x40)
#define Board_I2C_TMP_BOOSTXL_BASSENSORS_HDC2010_MAXSPEED (400U) /* Kbps */

/* Board_I2C_TMP max speed (supported by all components) */
#define Board_I2C_TMP_MAXSPEED   (400U) /* Kbps */
#define Board_I2C_TMP_MAXBITRATE ((I2C_BitRate)I2C_400kHz)


/*
 *  ======== UART ========
 */

#define Board_UART0                 0


/*
 *  ======== Board_init ========
 *  Perform all required TI-Drivers initialization
 *
 *  This function should be called once at a point before any use of
 *  TI-Drivers.
 */
extern void Board_init(void);

/*
 *  ======== Board_initGeneral ========
 *  (deprecated)
 *
 *  Board_initGeneral() is defined purely for backward compatibility.
 *
 *  All new code should use Board_init() to do any required TI-Drivers
 *  initialization _and_ use <Driver>_init() for only where specific drivers
 *  are explicitly referenced by the application.  <Driver>_init() functions
 *  are idempotent.
 */
#define Board_initGeneral Board_init

#ifdef __cplusplus
}
#endif

#endif /* include guard */
