/*-----------------------------------------------------------------------------
 * Copyright(c)2016 Allegion PLC as an unpublished work.
 *
 * The information contained herein is confidential property of Allegion PLC.
 * All rights reserved.  Reproduction, adaptation, or translation without the
 * express written consent of Allegion PLC is prohibited, except as allowed
 * under the copyright laws.
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * File Name:       wifiplatformconfig.h
 * Purpose of File: Includes all configurations to interface wifi platform
 *                  Copy this file to an area in the project source code
 *                  and rename it as wifiplatformconfig.h
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * Module             :   WiFi Platform                       <wifiplatform>
 * Feature Abstraction:   Config                              <config>
 *---------------------------------------------------------------------------*/

#ifndef WIFI_PLATFORM_CONFIG_H_
#define WIFI_PLATFORM_CONFIG_H_

/* INTERFACE CONFIGURATION DEFINITIONS */
#if (0)
#define WIFI_IF_TYPE_UART
#else
#define WIFI_IF_TYPE_SPI
#endif

/* FEATURE CONFIGUARTION DEFINITIONS */
/*  0 - Exclude Feature 
    1 - Include Feature */
#define WIFI_PLATFORM_FEATURE_ENABLE_WEP   (0) /* DANGER!! THIS IS AN UNSECURE PROTOCOL
                                                * TELL PRODUCT THAT WE ARE A SECURITY COMPANY
                                                * AND SHOULD NOT INCLUDE UNSECURE PROTOCOLS
                                                * IN OUR PRODUCTS */

// switch for inline definition
#if (0)
#define INLINE     inline
#else
#define INLINE
#endif

/* GENERAL CONFIGURATIONS */
#define WIFI_USE_MULTITHREADING                          (1) // 0 = NO, 1 = YES
#define WIFI_OS                                          (1) // 0 = NO OS, 1 = FreeRTOS, 2 = MQX
#define WIFI_PLATFORM_BLOCKING                           (0) // 0 = NO, 1 = YES
#define WIFI_PLATFORM_TIMESTAMP_TICKS_IN_10_MILLISECONDS (uint32_t)(327)
#define WIFI_PLATFORM_START_TIMEOUT                      (60000)
#define WIFI_SL_SPAWN_TASK_STACK_SIZE                    (1024)  // Make sure update the size in VStartSimpleLinkSpawnTask() if host driver gets updated                 

/* WLAN CONFIGURATIONS */
#define WIFI_PLATFORM_WLANMAX_WEP_KEY_SIZE               (13)
#define WIFI_PLATFORM_WLAN_CONNECT_TIMEOUT               (0xFFFF)
#define WIFI_PLATFORM_WLAN_SLEEP_POLICY                  (1)
#define WIFI_PLATFORM_WLAN_SLEEP_INTERVAL                (600)

/* NET CONFIGURATIONS */
#define WIFI_PLATFORM_TLS_VERSION                        SL_SO_SEC_METHOD_TLSV1_2
#define WIFI_PLATFORM_TLS_CIPHER_SUITE                   SL_SEC_MASK_SECURE_ALLEGION_GUIDELINES
#define WIFI_PLATFORM_TLS_ALLOW_DATE_VALIDATION_FAILURE  (0)

#endif /* END WIFI_PLATFORM_CONFIG_H_ */
