/*
 * ALSA SoC Bluetooth driver
 *
 * Based on sound/soc/codecs/pcm5102a.c
 *                    by Florian Meier <florian.meier@koalo.de>
 *                    and Eyal Reizer <eyalr@ti.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/platform_device.h>

#include <sound/soc.h>

#define DRV_NAME "wilink8_bt"

#define RATES		(SNDRV_PCM_RATE_8000 | SNDRV_PCM_RATE_16000 | SNDRV_PCM_RATE_48000)
#define FORMATS		SNDRV_PCM_FMTBIT_S16_LE

static struct snd_soc_dai_driver wilink8_bt_dai = {
	.name		= "wilink8_bt-hifi",
	.playback = {
		.stream_name	= "Playback",
		.channels_min	= 1,
		.channels_max	= 2,
		.rates		= RATES,
		.formats	= FORMATS,
	},
	.capture = {
		.stream_name	= "Capture",
		.channels_min	= 1,
		.channels_max	= 2,
		.rates		= RATES,
		.formats	= FORMATS,
	},
};

static struct snd_soc_component_driver soc_component_dev_wilink8_bt = {
	.idle_bias_on		= 1,
	.use_pmdown_time	= 1,
	.endianness		= 1,
	.non_legacy_dai_naming	= 1,
};

static int wilink8_bt_probe(struct platform_device *pdev)
{
	return devm_snd_soc_register_component(&pdev->dev,
			&soc_component_dev_wilink8_bt,
			&wilink8_bt_dai, 1);
}

static const struct of_device_id wilink8_bt_of_match[] = {
	{ .compatible = "ti,wilink8_bt", },
	{ }
};
MODULE_DEVICE_TABLE(of, wilink8_bt_of_match);

static struct platform_driver wilink8_bt_driver = {
	.probe		= wilink8_bt_probe,
	.driver		= {
		.name	= DRV_NAME,
		.of_match_table = wilink8_bt_of_match,
	},
};

module_platform_driver(wilink8_bt_driver);

MODULE_DESCRIPTION("WILINK8_BT dummy codec driver");
MODULE_AUTHOR("Eyal Reizer <eyalr@ti.com>");
MODULE_LICENSE("GPL v2");
