import glob
import math
import os
import struct
import sys

"""
File translation tool to translate one TI file format to another.

Translate .cfg files from GDE to aic script files usable in
wireless configurator.	In particular the later doesn't support
the ">" continuation character.

Author:	 Marc Lindahl <marc@bowery.com
WWW:	 http://engineering.bowery.com
License: GNU General Public License
Version: 1.0 (9/3/14)

"""

def argfiles(args, onlyFiles=False):
	"""Expand arguments (globs and non-globs). Return a flat list."""
	files = []
	for arg in args:
		if ('*' in arg) or ('?' in arg):
			files.extend(glob.glob(arg))
		else:
			files.append(arg)
	if onlyFiles:
		files = filter(os.path.isfile, files)
	return files


def main(args):
	if not args:
		print 'Usage: %s <input> <output>' % sys.argv[0]
		return
		
	files = argfiles(args)
	if not files:
		print 'No matching files found.'
		return
	
	if (not os.path.exists(files[0])) or (not os.path.isfile(files[0])):
		print 'Could not find %s' % files[0] 
		return

	try:
		# We use open instead of file for backwards compability
		infile = open(files[0], 'r')
	except IOError:
		print 'Could not open %s' % files[0] 
		return

	try:
		# We use open instead of file for backwards compability
		outfile = open(files[1], 'w')
	except IOError:
		print 'Could not open %s' % files[1] 
		return
		
	waddr = 0	# last write address
	wcmd = []	# last write command
	
	for line in infile:
		if line[0] == "w":
			waddr = int( line.split()[2], 16)
			wcmd = line.split()[0:2]
			outfile.write(line)
			print line
		elif line[0] == ">":
			waddr += 1
			outcmd = ' '.join(wcmd) + (" %02x " % waddr) + line.split()[1] + "\n"
			outfile.write(outcmd)
			print outcmd
#		elif line[0] == "#":
#			pass
		else:
			outfile.write(line)
			print line
	outfile.close()
	infile.close()

		

if __name__=='__main__':
	main(sys.argv[1:])
