ࡱ                >  	                                          '`	               eG   bjbjLULU                  	 .t  .? .? e?                                                                                                                   n    m      m      m      m  L   6n  d   "      k     n    dr      dr      dr      dr      dr  >   r  $   r                                          $   a  h  ɥ  `                              r                      dr      dr      r      r                                dr              dr      %                          r  	        dr            dr                                                                           r                                                                                                                     dr      n     Px7U        m      |  N                       ;  0   k             )      ΃     )                                                                                "   )                    "    r      r             r      r                                      r      r      r                                                                                       r      r      r      k      r      r      r      r              "      "      "  d)  D  d)  "      "      "      D        t      J   j                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                uart2.c
 HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" Go to the documentation of this file.
00001 /*! \file uart2.c \brief Dual UART driver with buffer support. */
00002 //*****************************************************************************//
//  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c-source.html" https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c-source.html //
00003 //
00004 // File Name    : 'uart2.c'
00005 // Title        : Dual UART driver with buffer support
00006 // Author       : Pascal Stang - Copyright (C) 2000-2003
00007 // Created      : 11/20/2000
00008 // Revised      : 06/09/2003
00009 // Version      : 1.0
00010 // Target MCU   : ATMEL AVR Series
00011 // Editor Tabs  : 4
00012 //
00013 // Description  : This is a UART driver for AVR-series processors with two
00014 //      hardware UARTs such as the mega161 and mega128 
00015 //
00016 // This code is distributed under the GNU Public License
00017 //      which can be found at http://www.gnu.org/licenses/gpl.txt
00018 //
00019 //*****************************************************************************
00020 
00021 #include <avr/io.h>
00022 #include <avr/interrupt.h>
00023 #include <avr/signal.h>
00024 
00025 #include " HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8h.html" buffer.h"
00026 #include " HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" uart2.h"
00027 
00028 // UART global variables
00029 // flag variables
 HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" 00030 volatile u08    HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[2];
00031 volatile u08   uartBufferedTx[2];
00032 // receive and transmit buffers
00033 cBuffer uartRxBuffer[2];
00034 cBuffer uartTxBuffer[2];
00035 unsigned short uartRxOverflow[2];
00036 #ifndef UART_BUFFERS_EXTERNAL_RAM
00037     // using internal ram,
00038     // automatically allocate space in ram for each buffer
00039     static char uart0RxData[ HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a3" UART0_RX_BUFFER_SIZE];
00040     static char uart0TxData[ HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a2" UART0_TX_BUFFER_SIZE];
00041     static char uart1RxData[ HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a5" UART1_RX_BUFFER_SIZE];
00042     static char uart1TxData[ HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a4" UART1_TX_BUFFER_SIZE];
00043 #endif
00044 
00045 typedef void (*voidFuncPtru08)(unsigned char);
00046 volatile static voidFuncPtru08 UartRxFunc[2];
00047 
 HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a11" 00048 void  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a9" uartInit(void)
00049 {
00050     // initialize the buffers
00051      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a10" uartInitBuffers();
00052     // initialize user receive handlers
00053     UartRxFunc[0] = 0;
00054     UartRxFunc[1] = 0;
00055 
00056     // enable RxD/TxD and interrupts
00057     #ifdef UCR
00058         // this line for AT90S8515,8535,ATmega103,etc
00059         outb(UCR, BV(RXCIE)|BV(TXCIE)|BV(RXEN)|BV(TXEN));
00060     #endif
00061     #ifdef UCSRB
00062         // this line for the Mega163
00063         outb(UCSRB, BV(RXCIE)|BV(TXCIE)|BV(RXEN)|BV(TXEN));
00064     #endif
00065     #ifdef UCSR0B
00066         // this line for the Mega161/128
00067         outb(UCSR0B, BV(RXCIE)|BV(TXCIE)|BV(RXEN)|BV(TXEN));
00068         outb(UCSR1B, BV(RXCIE)|BV(TXCIE)|BV(RXEN)|BV(TXEN));
00069     #endif
00070 
00071     // set default baud rate
00072     uartSetBaudRate(0, UART0_DEFAULT_BAUD_RATE); 
00073     uartSetBaudRate(1, UART1_DEFAULT_BAUD_RATE);
00074     // initialize states
00075      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[0] = TRUE;
00076      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[1] = TRUE;
00077     uartBufferedTx[0] = FALSE;
00078     uartBufferedTx[1] = FALSE;
00079     // clear overflow count
00080     uartRxOverflow[0] = 0;
00081     uartRxOverflow[1] = 0;
00082     // enable interrupts
00083     sei();
00084 }
00085 
 HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a12" 00086 void  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a10" uartInitBuffers(void)
00087 {
00088     #ifndef UART_BUFFERS_EXTERNAL_RAM
00089         // initialize the UART0 buffers
00090          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartRxBuffer[0], uart0RxData,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a3" UART0_RX_BUFFER_SIZE);
00091          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartTxBuffer[0], uart0TxData,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a2" UART0_TX_BUFFER_SIZE);
00092         // initialize the UART1 buffers
00093          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartRxBuffer[1], uart1RxData,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a5" UART1_RX_BUFFER_SIZE);
00094          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartTxBuffer[1], uart1TxData,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a4" UART1_TX_BUFFER_SIZE);
00095     #else
00096         // initialize the UART0 buffers
00097          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartRxBuffer[0], (u08*) UART0_RX_BUFFER_ADDR,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a3" UART0_RX_BUFFER_SIZE);
00098          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartTxBuffer[0], (u08*) UART0_TX_BUFFER_ADDR,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a2" UART0_TX_BUFFER_SIZE);
00099         // initialize the UART1 buffers
00100          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartRxBuffer[1], (u08*) UART1_RX_BUFFER_ADDR,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a5" UART1_RX_BUFFER_SIZE);
00101          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a0" bufferInit(&uartTxBuffer[1], (u08*) UART1_TX_BUFFER_ADDR,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8h.html" \l "a4" UART1_TX_BUFFER_SIZE);
00102     #endif
00103 }
00104 
00105 void uartSetRxHandler(u08 nUart, void (*rx_func)(unsigned char c))
00106 {
00107     // make sure the uart number is within bounds
00108     if(nUart < 2)
00109     {
00110         // set the receive interrupt to run the supplied user function
00111         UartRxFunc[nUart] = rx_func;
00112     }
00113 }
00114 
00115 void uartSetBaudRate(u08 nUart, u32 baudrate)
00116 {
00117     // calculate division factor for requested baud rate, and set it
00118     u08 baudrateDiv;
00119     baudrateDiv = (u08)((F_CPU+(baudrate*8L))/(baudrate*16L)-1);
00120     if(nUart)
00121         outb(UBRR1L, baudrateDiv);
00122     else
00123         outb(UBRR0L, baudrateDiv);
00124 }
00125 
00126 cBuffer*  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a13" uartGetRxBuffer(u08 nUart)
00127 {
00128     // return rx buffer pointer
00129     return &uartRxBuffer[nUart];
00130 }
00131 
00132 cBuffer*  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a14" uartGetTxBuffer(u08 nUart)
00133 {
00134     // return tx buffer pointer
00135     return &uartTxBuffer[nUart];
00136 }
00137 
00138 void uartSendByte(u08 nUart, u08 txData)
00139 {
00140     // wait for the transmitter to be ready
00141     while(! HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[nUart]);
00142     // send byte
00143     if(nUart)
00144         outb(UDR1, txData);
00145     else
00146         outb(UDR0, txData);
00147     // set ready state to FALSE
00148      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[nUart] = FALSE;
00149 }
00150 
00151 void uart0SendByte(u08 data)
00152 {
00153     // send byte on UART0
00154     uartSendByte(0, data);
00155 }
00156 
00157 void uart1SendByte(u08 data)
00158 {
00159     // send byte on UART1
00160     uartSendByte(1, data);
00161 }
00162 
00163 u08 uartReceiveByte(u08 nUart, u08* rxData)
00164 {
00165     // make sure we have a receive buffer
00166     if(uartRxBuffer[nUart].size)
00167     {
00168         // make sure we have data
00169         if(uartRxBuffer[nUart].datalength)
00170         {
00171             // get byte from beginning of buffer
00172             *rxData =  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a1" bufferGetFromFront(&uartRxBuffer[nUart]);
00173             return TRUE;
00174         }
00175         else
00176             return FALSE;           // no data
00177     }
00178     else
00179         return FALSE;               // no buffer
00180 }
00181 
00182 void  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a17" uartFlushReceiveBuffer(u08 nUart)
00183 {
00184     // flush all data from receive buffer
00185      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a6" bufferFlush(&uartRxBuffer[nUart]);
00186 }
00187 
00188 u08  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a18" uartReceiveBufferIsEmpty(u08 nUart)
00189 {
00190     return (uartRxBuffer[nUart].datalength == 0);
00191 }
00192 
 HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a23" 00193 void  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a23" uartAddToTxBuffer(u08 nUart, u08 data)
00194 {
00195     // add data byte to the end of the tx buffer
00196      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a4" bufferAddToEnd(&uartTxBuffer[nUart], data);
00197 }
00198 
00199 void uart0AddToTxBuffer(u08 data)
00200 {
00201      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a23" uartAddToTxBuffer(0,data);
00202 }
00203 
00204 void uart1AddToTxBuffer(u08 data)
00205 {
00206      HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a23" uartAddToTxBuffer(1,data);
00207 }
00208 
00209 void  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart_8c.html" \l "a20" uartSendTxBuffer(u08 nUart)
00210 {
00211     // turn on buffered transmit
00212     uartBufferedTx[nUart] = TRUE;
00213     // send the first byte to get things going by interrupts
00214     uartSendByte(nUart,  HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a1" bufferGetFromFront(&uartTxBuffer[nUart]));
00215 }
00216 
00217 u08 uartSendBuffer(u08 nUart, char *buffer, u16 nBytes)
00218 {
00219     register u08 first;
00220     register u16 i;
00221 
00222     // check if there's space (and that we have any bytes to send at all)
00223     if((uartTxBuffer[nUart].datalength + nBytes < uartTxBuffer[nUart].size) && nBytes)
00224     {
00225         // grab first character
00226         first = *buffer++;
00227         // copy user buffer to uart transmit buffer
00228         for(i = 0; i < nBytes-1; i++)
00229         {
00230             // put data bytes at end of buffer
00231              HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a4" bufferAddToEnd(&uartTxBuffer[nUart], *buffer++);
00232         }
00233 
00234         // send the first byte to get things going by interrupts
00235         uartBufferedTx[nUart] = TRUE;
00236         uartSendByte(nUart, first);
00237         // return success
00238         return TRUE;
00239     }
00240     else
00241     {
00242         // return failure
00243         return FALSE;
00244     }
00245 }
00246 
00247 // UART Transmit Complete Interrupt Function
00248 void uartTransmitService(u08 nUart)
00249 {
00250     // check if buffered tx is enabled
00251     if(uartBufferedTx[nUart])
00252     {
00253         // check if there's data left in the buffer
00254         if(uartTxBuffer[nUart].datalength)
00255         {
00256             // send byte from top of buffer
00257             outb(UDR0,   HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a1" bufferGetFromFront(&uartTxBuffer[nUart]) );
00258         }
00259         else
00260         {
00261             // no data left
00262             uartBufferedTx[nUart] = FALSE;
00263             // return to ready state
00264              HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[nUart] = TRUE;
00265         }
00266     }
00267     else
00268     {
00269         // we're using single-byte tx mode
00270         // indicate transmit complete, back to ready
00271          HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/uart2_8c.html" \l "a0" uartReadyTx[nUart] = TRUE;
00272     }
00273 }
00274 
00275 // UART Receive Complete Interrupt Function
00276 void uartReceiveService(u08 nUart)
00277 {
00278     u08 c;
00279     // get received char
00280     if(nUart)
00281         c = inb(UDR1);
00282     else
00283         c = inb(UDR0);
00284 
00285     // if there's a user function to handle this receive event
00286     if(UartRxFunc[nUart])
00287     {
00288         // call it and pass the received data
00289         UartRxFunc[nUart](c);
00290     }
00291     else
00292     {
00293         // otherwise do default processing
00294         // put received char in buffer
00295         // check if there's space
00296         if( ! HYPERLINK "https://ccrma.stanford.edu/courses/250a-fall-2003/docs/avrlib-new/buffer_8c.html" \l "a4" bufferAddToEnd(&uartRxBuffer[nUart], c) )
00297         {
00298             // no space in buffer
00299             // count overflow
00300             uartRxOverflow[nUart]++;
00301         }
00302     }
00303 }
00304 
00305 UART_INTERRUPT_HANDLER(SIG_UART0_TRANS)      
00306 {
00307     // service UART0 transmit interrupt
00308     uartTransmitService(0);
00309 }
00310 
00311 UART_INTERRUPT_HANDLER(SIG_UART1_TRANS)      
00312 {
00313     // service UART1 transmit interrupt
00314     uartTransmitService(1);
00315 }
00316 
00317 UART_INTERRUPT_HANDLER(SIG_UART0_RECV)      
00318 {
00319     // service UART0 receive interrupt
00320     uartReceiveService(0);
00321 }
00322 
00323 UART_INTERRUPT_HANDLER(SIG_UART1_RECV)      
00324 {
00325     // service UART1 receive interrupt
00326     uartReceiveService(1);
00327 }

                                                                                                                                                                	  f  g            1	  2	  >	  	  	  	  	  	  	  	  	  	  	  
  
  $
  Z
  a
  
  
  
  
  
  
  
    $  +  >  E  G  N                %  f  m  o  v          
  
  %
  3
  =
  >
  
  
  
  
  
  
  
  j    hfj 0J U
hfj 0J  h+)) hfj 0J  j    hfj Uhfj hfj 0J  j    hfj 0J U
hfj 0J  
hfj 0J  j    hfj Uhfj F         .	  	  	  
  [
  
  
  
  
  %  ?  H          g  p        
  &
  -
  
                                                                                                                                                                                                                                                                                                                                                    gdfj    gdfj   gdfj     eG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
  
             .  F  M  ^  _  `                  B  C  N  O  Z  b                /  :  P  [                    /  0  =  C  D  H  U  V                      \  ]  q  r                        "    
hfj 0J  
hfj 0J  j    hfj U
hfj 0J  hfj  
hfj 0J  
hfj 0J  j    hfj 0J U P
  !  (  G  _  T  |          0  Q    3    u    #  *  _            5  c                                                                                                                                                                                                                                                                                                                                                                       gdfj  "  0  7  O  W  X  \  e  m  n  t              	  
      s  t  |  }  ~               !  0  1  ?  b              f  p  w                ,  L        
            
      /  0              f  z            	  
        
hfj 0J  
hfj 0J  
hfj 0J  j    hfj U
hfj 0J  
hfj 0J  hfj T           `  q            M            F  }    %          ;  \  {                                                                                                                                                                                                                                                                                                                                                                     gdfj                  /  ]  }           "  ;#  i#  $  %  %  %  %  2&  :&  r&  &  &  &  '  '                                                                                                                                                                                                                                                                                                                                                                   gdfj        u  v                      d  e  o  p                                  +  ,  =  \  k  l              d  e  y  z                                                  P!  Q!  [!  \!  !  !  !  !  "  "  "  "  "  "  "  "  "  "  "#   
hfj 0J  
hfj 0J  
hfj 0J  
hfj 0J  j    hfj Uhfj W"#  ##  7#  8#  I#  h#  w#  x#  #  #  #  #  $  $  $  $  $  $  $  $  %  %  %  %  J%  K%  %  %  %  %  %  %  %  %  &  &   &  (&  )&  -&  D&  q&  |&  ~&  &  &  /'  3'  o'  '  (  (  Y(  ](  (  (  )  )  )  )  :)  U)  `)  f)  )  )  *  *  *  *  0*  K*  V*  \*  *  *  *  *  *  *  *  *  b+  c+  n+    
hfj 0J  
hfj 0J  
hfj 0J  
hfj 0J  hfj  
hfj 0J  j    hfj U T'  "'  )'  ]'  e'  '  '  (  &(  O(  ^(  (  (  (  ()  0)  V)  })  )  )  *  &*  L*  s*  {*  *  *  *  *  y+                                                                                                                                                                                                                                                                                                                                                                   gdfj  n+  o+  +  +  +  +  +  +  ,  ,  ',  (,  ,  ,  ,  ,  ,  ,  ,  -  ;-  ?-  j-  -  -  .  $.  &.  [.  t.  .  .  .  .  	/  
/  p/  q/  /  /  /  /  /  /  /  /  0  0  )0  -0  <0  B0  X0  d0  z0  ~0  0  0  0  0  0  0  1  @1  K1  L1  1  1  1  1  1  1  V2  W2  o2  p2  2  2  2  2  23  33  83  93  :3  >3  ?3      
hfj 0J  
hfj 0J  
hfj 0J  
hfj 0J  hfj  j    hfj U Vy+  +  +  +  +  +  ,  ,  ,  ,  ,  ,  -  &-  .-  5-  X-  `-  -  -  -  -  -  -  .  A.  M.  u.  .  .                                                                                                                                                                                                                                                                                                                                                                   gdfj  .  .  /  /  /  /  0  0  .0  e0  m0  t0  	1  1  A1  1  1  1  |2  2  2  2  2  3  3  4  4  4  4  4                                                                                                                                                                                                                                                                                                                                                                   gdfj  ?3  @3  3  3  3  3  3  
4  4  4  4  4  4  4  4  4  4  4  ]5  ^5  o5  p5  5  5  5  5  *6  +6  <6  =6  \6  `6  a6  b6  6  6  6  6  6  7  F7  ~7  7  7  8  8  8  8  d8  h8  8  8  8  8  8  9  9  !9  9  9  9  9  
:  :  M:  o:  :  :  :  :  :  :  A;  y;  ;  ;  ;  <  !<  %<  @<  Q<  `<  f<  <    
hfj 0J  
hfj 0J  
hfj 0J  
hfj 0J  
hfj 0J  hfj  j    hfj U T4  4  z5  5  5  5  5  G6  O6  V6  6  6  7  <7  7  18  98  @8  ~8  8  8  8  8  9  r9  ~9  9  9  9  +:                                                                                                                                                                                                                                                                                                                                                                   gdfj  +:  ;:  p:  ;  ,;  3;  z;  ;  ;  ;  <  <  &<  2<  R<  n<  z<  <  <  <  <  <  =  ?=  K=  =  =  =  =  >                                                                                                                                                                                                                                                                                                                                                                   gdfj  <  <  <  <  <  =  %=  '=  Y=  =  =  =  =  =  >  >  }>  ~>  >  >  >  >  >  >  C?  [?  n?  o?  ?  ?  ?  ?  @  @  6@  X@  g@  @  @  @  A  	A  A  A  FA  qA  xA  |A  A  A  A  A  B  B  AB  {B  B  B  B  B  C  C  5C  WC  fC  C  C  C  C  C  C  C  'D  (D  6D  7D  uD  D  D  D  KE  nE  E  	F  F  F  G  :G   
hfj 0J  j    hfj U
hfj 0J  
hfj 0J  hfj  
hfj 0J W>  >  >  >   ?  1?  \?  ?  @  
@  @  (@  Y@  @  %A  1A  9A  @A  rA  A  A  A  A  A  B  B  0B  7B  |B  B                                                                                                                                                                                                                                                                                                                                                                   gdfj  B  B  B   C  C  C  'C  XC  C  C  SD  cD  D  D  D  D  D  D  E  9E  AE  oE  E  E  E  E  E  
F  ,F  4F                                                                                                                                                                                                                                                                                                                                                                   gdfj  4F  ;F  nF  vF  F  F  F  F  G  G  ;G  \G  dG  eG                                                                                                                                                                                                                                                                                                                                                                                                                                                  gdfj  
:G  dG  eG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    hs4  hfj , 1h/ =!"#$%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      D                                                                y  K      W   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c - s o u r c e . h t m l   y  K   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c - s o u r c e . h t m l                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @  @ @          N o r m a l       CJ _HaJ mH	sH	tH	R `  R    fj   	 H e a d i n g   1     d d @& [$\$  5CJ0 KH$ \aJ0                 D A@ D          D e f a u l t   P a r a g r a p h   F o n t     R i@ R          T a b l e   N o r m a l      4 
l 4   a      ( k@ (           N o   L i s t          4 U`  4    fj   	 H y p e r l i n k   	 >*ph     e`     fj    H T M L   P r e f o r m a t t e d   7  
2 (
Px4 #\'*.25@9                  CJ OJ QJ ^J aJ & o &    fj    c o m m e n t     0 o !0    fj    p r e p r o c e s s o r     & o 1&    fj    k e y w o r d     . o A.    fj    k e y w o r d t y p e     . o Q.    fj    k e y w o r d f l o w         e?    t          z          z         z          z         z          z         z         _    $  -  6  4>  e?    4    0                                        .        [          %  ?  H          g  p          &  -    !  (  G  _  T  |          0  Q    3	  	  u
    #  *  _            5
  c
  
  
  
  
  
     `  q            M            F  }    %          ;  \  {                  /  ]  }          ;  i            2  :  r            "  )  ]  e         &   O   ^            (!  0!  V!  }!  !  !  "  &"  L"  s"  {"  "  "  "  "  y#  #  #  #  #  #  $  $  $  $  $  $  %  &%  .%  5%  X%  `%  %  %  %  %  %  %  &  A&  M&  u&  &  &  &  '  '  '  '  (  (  .(  e(  m(  t(  	)  )  A)  )  )  )  |*  *  *  *  *  +  +  ,  ,  ,  ,  ,  ,  z-  -  -  -  -  G.  O.  V.  .  .  /  </  /  10  90  @0  ~0  0  0  0  0  1  r1  ~1  1  1  1  +2  ;2  p2  3  ,3  33  z3  3  3  3  4  4  &4  24  R4  n4  z4  4  4  4  4  4  5  ?5  K5  5  5  5  5  6  6  6  6   7  17  \7  7  8  
8  8  (8  Y8  8  %9  19  99  @9  r9  9  9  9  9  9  :  :  0:  7:  |:  :  :  :   ;  ;  ;  ';  X;  ;  ;  S<  c<  <  <  <  <  <  <  =  9=  A=  o=  =  =  =  =  =  
>  ,>  4>  ;>  n>  v>  >  >  >  >  ?  ?  ;?  \?  d?  g?     !  Y    !      !  1    !  1   !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !  1    !                .        [          %  ?  H          g  p          &  -    !  (  G  _  T  |          0  Q    3	  	  u
    #  *  _            5
  c
  
  
  
  
  
     `  q            M            F  }    %          ;  \  {                  /  ]  }          ;  i            2  :  r            "  )  ]  e         &   O   ^            (!  0!  V!  }!  !  !  "  &"  L"  s"  {"  "  "  "  "  y#  #  #  #  #  #  $  $  $  $  $  $  %  &%  .%  5%  X%  `%  %  %  %  %  %  %  &  A&  M&  u&  &  &  &  '  '  '  '  (  (  .(  e(  m(  t(  	)  )  A)  )  )  )  |*  *  *  *  *  +  +  ,  ,  ,  ,  ,  ,  z-  -  -  -  -  G.  O.  V.  .  .  /  </  /  10  90  @0  ~0  0  0  0  0  1  r1  ~1  1  1  1  +2  ;2  p2  3  ,3  33  z3  3  3  3  4  4  &4  24  R4  n4  z4  4  4  4  4  4  5  ?5  K5  5  5  5  5  6  6  6  6   7  17  \7  7  8  
8  8  (8  Y8  8  %9  19  99  @9  r9  9  9  9  9  9  :  :  0:  7:  |:  :  :  :   ;  ;  ;  ';  X;  ;  ;  S<  c<  <  <  <  <  <  <  =  9=  A=  o=  =  =  =  =  =  
>  ,>  4>  ;>  n>  v>  >  >  >  >  ?  ?  ;?  \?  d?  g?     0                        0                        0                        0                        0                      0                        0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                       0                        0                                 .        [          %  ?  H          g  p          &  -    !  (  G  _  T  |          0  Q    3	  	  u
    #  *  _            5
  c
  
  
  
  
  
     `  q            M            F  }    %          ;  \  {                  /  ]  }          ;  i            2  :  r            "  )  ]  e         &   O   ^            (!  0!  V!  }!  !  !  "  &"  L"  s"  {"  "  "  "  "  y#  #  #  #  #  #  $  $  $  $  $  $  %  &%  .%  5%  X%  `%  %  %  %  %  %  %  &  A&  M&  u&  &  &  &  '  '  '  '  (  (  .(  e(  m(  t(  	)  )  A)  )  )  )  |*  *  *  *  *  +  +  ,  ,  ,  ,  ,  ,  z-  -  -  -  -  G.  O.  V.  .  .  /  </  /  10  90  @0  ~0  0  0  0  0  1  r1  ~1  1  1  1  +2  ;2  p2  3  ,3  33  z3  3  3  3  4  4  &4  24  R4  n4  z4  4  4  4  4  4  5  ?5  K5  5  5  5  5  6  6  6  6   7  17  \7  7  8  
8  8  (8  Y8  8  %9  19  99  @9  r9  9  9  9  9  9  :  :  0:  7:  |:  :  :  :   ;  ;  ;  ';  X;  ;  ;  S<  c<  <  <  <  <  <  <  =  9=  A=  o=  =  =  =  =  =  
>  ,>  4>  ;>  n>  v>  >  >  >  >  ?  ?  ;?  \?  d?  g?  @   0             0    @   0             0    @   0             0     00         H        @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0    @   0             0        0               8        
  "    "#  n+  ?3  <  :G  eG  $   '   )   ,   -   /   2   5   9      
      '  y+  .  4  +:  >  B  4F  eG  %   (   *   +   .   0   1   3   4   6   7   8      eG  &      f      1      =            _        B  N    	  /	  U	  	  	  	  \
  q
  
  
            s  |     
  0
        /              u      d  o                  +  k        d  y                P  [                "  7  w                  J         !  !  !  "  "  "  b#  n#  '$  $  $  	'  p'  '  (  (  (  K)  )  )  )  V*  o*  *  2+  8+  ?+  +  +  ,  ,  ,  ,  ]-  o-  -  *.  <.  a.  .  .  /  0  0  2  2  2  6  }6  6  n7  7  7  8  9  9  ;  '<  6<  e?  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX    l 0 0 0 3 0  l 0 0 0 4 8  l 0 0 0 8 6  l 0 0 1 9 3 _      *  g?               _      *  g?          z                  $      C  N  i  w                            "  0  7      t  |  !
  0
  m
  w
  
  
  
  
  
  
  .  2  k  p  |                 [  _            '  P  _  
                $  2  E  S      v        e  o  r  ~                           Q  [  ^  j                        (          	        U  Y                  4  C  H  M  S  [                        $   4   8   A   L   l   p   y            !  !  !!  &!  D!  F!  h!  t!  u!  z!  !  !  "  "  "  "  :"  <"  ^"  j"  k"  p"  "  "  "  "  "  "  c#  n#  p#  u#  #  #  #  #  #  #  #  #  #  #  $  $  $  $  %  %  %  %  %  %  %  %  %  %  '&  3&  4&  9&  &  &  &  &  &  &   '  '  q'  '  '  '  '  '  (  (  )  )  )  )  )  )  )  )  W*  o*  u*  z*  *  *  *  *  *  *  +  +  +  +  ,  ,  ,  ,  ,  ,  ,  ,  ^-  o-  +.  <.  .  .  .  .  /  ,/  -/  2/  /  /  /  /  0  0  0  &0  '0  ,0  J0  X0  ]0  b0  v0  |0  0  0  #1  /1  01  51  71  A1  D1  J1  M1  Y1  Z1  _1  j1  p1  1  1  2  2  2  2  &2  '2  2  2  2  3  3  
3  3  3  3  3  3  3  3  3  4  4  4  4  
5  5  (5  65  75  <5  5  5  5  5  5  5  
6  6  ~6  6  6  6  6  6  7   7  !7  &7  7  7  7  7  Q8  S8  	9  9  9  9  }9  9  9  9  9  9  9  9  %:  (:  :  :  :  :  :  :  :  :  (<  6<  9<  E<  F<  K<  <  <  <  <  y=  =  >  '>  >  >  E?  W?  g?                                                                                                                                                                                                                                                                                                                                                                                                                                             .          #  [  `                  5  <  Q  _      C  N  i  x                  I	  U	  	  	  
  
  M  O      t  |  !
  0
  m
  x
  
  
      .  3      [  `        (  P  `  
                $  3  E  T          v    e  o              Q  [                      |          !  4  D                4   9   l   q         !  !  D!  F!  h!  u!  }!  !  "  "  :"  <"  ^"  k"  s"  z"  "  "  "  "  c#  n#  #  #  #  #  #  #  $  $  $  $  $  $  %  %  &%  -%  @%  N%  %  %  %  %  %  %  $&  '&  &  &  q'  '  '  '  e(  l(  (  (  )  )  )  )  W*  o*  *  *  *  *  +  +  ,  ,  ,  ,  ,  ,  ,  ,  ^-  o-  z-  -  -  -  +.  <.  G.  N.  .  .  /  -/  /  /  10  80  J0  Y0  0  0  1  "1  
2  2  2  2  3  3  3  3  3  3  R4  W4  z4  4  4  4  
5  5  %5  (5  5  5  
6  6  7  !7  7  7  Q8  S8  	9  9  19  89  }9  9  9  9  9  9  9  9  %:  ):  :  :  :  :  ;  ;  (<  6<  <  <  <  <  =  "=  y=  =  =  =  =  =  >  (>  ,>  3>  P>  X>  >  >  >  >  >  >  E?  X?  \?  c?  g?   :  :    :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :  :      +    d?  g?              g?      )#ur      ur           l               k  c  :  H  M  O  Y  n_  Ya  z  M R$ 8 0K zk Vq }   6  ` J0 1 Q [ "l 5 Z7 JQ IZ Cm  t     E- E kO bU s_ o p z  ; T ?c /w  Q" [( M .i j | -    ' 
4 yR u  V $ G6 O P cb 	 *	 ;>	 @	 C	 H	 `	 c	 +d	 k	 z	  
 V
 
 K
 ],
 @
 i
 k
 l
 
 H  Z5 M8 ` tg `   L& ) - Z 7_ d h ]n q} x
 
 $
 )
 G>
 B
 K
 LL
 dY
 .  j$ 
. E V e l     % C' -) * >+ = @ +D ^ c d 2 
 f  F  9# ( . . Z5 6 A N R oS ,	 6 C _i ~   x	  $ 5 6 _ f Hy [| 6 S 7e 6 E J J \ j j L   D #R S [ 9   3 G T i ) 1- - F. 3Y z E, (T Z 3    " $> MJ J    . s7 9j !q   F
 F  " M UW [ ^ s_ r S| j 8 Q@ F R OT t  51 o2 >    C 3 G iH K X Ft Ry  * mA ,F Q W n  !  !  B  B  H  m  {  A! -L! Tf! w! ,z! Q" XD" G" Q" W8# LJ# l# p# t# $ #$ n$ $ q-$ 8$ U$ ^$ h$ % % ?% &A% K% \% {%  & >& ?& A& RD& dD& l& 9' O' PS' m' m' C1( mX( [( c( dz( |( }( x( ) ) )) L.) #/) 1) 1) 5) <) Y) &]) 2(* /* D7* :* ?* r^* p* zz* QG+ Z+ m+ -, 6, 9, N, 1c, c, - #- L- l- #. '. 4. lP. @/ / / -!/ L(/ )/ A/ XO/ k/ {/ 0 P0 f0 n0 |1 M1 ?1  [1 c1 w1  2 (2 J.2 72 (@2 ,Q2 Q2 Y2 _2 b2 k2 l2 N"3 13 I3 N3 R3 n3 j4 4 $4 *(4 C4 oH4 [4 a4 q4 s4 u4 5 J5 475 7M5 #p5 n6 )16 556 ?6 oa6 Yn6 q6 |6 7 B7 DZ7 _7 8 +8 .8 yO8 lh8 |8 > 9 9 (9 >9 >9 C9 N9 =O9 
: : C[: c: f: +n: p: ; A; ; U!; I1; 7; \:; B; g; 7j; 6q; s; [< C%< (8< $@< B< K< T< Vb< e< < = 5= 7= F= Ql= Cn= >  -> *3> 5> 
7> @> I> @X> of> ? ? ? `;? QT? [? l? w? 5$@ `3@ 57@ =@ n@ }s@ A A 1A &;A =A MA `A =A B =
B B FB @[B ~^B #`B .`B aB tB s~B fC C &2C hC xC !lD arD wD E LE RE fE {E F &F ,F .F ?F YF jF G +G :G cG ;wG H H H "H $H c.H {=H CH LH ZH RdH jH  I I  I 9I J ,J XJ kmJ NwJ !7K %hK iK L L L  L . L 9.L BL \L &bL dL lL cmL zL KM M M M NM NM 	N JN N N 'N HZN cO O #O O '4O ;O =@O CO ?GO d-P PDP FP SSP WP m[P ^P cP m Q 
Q Q Q b]Q _Q `Q @nQ R R 
R R ~R NR =R CR PR `SR 3UR ^WR bR eR lR DtR uR }S ,S p*S 3S 6AS RcS {eS T 1T 
 T \T ngT 3"U h,U /U iU V 
V V %V QV llV NvV zV *W #W 7SW ^oW ,X X !X #X .X ;X pyX ~X 	Y tY 0Y 9Y AY KDY -HY UY ZY uY PvY @Z  eZ jeZ rZ a{Z R[ [ [ Z%[ %M[ S[ ^[ \ b\ \ 0)\ U\ ] ] !] .] 	6] 4v] V~] *	^ 0^ ?^ 8Q^ _ 	:_ p;_ nQ_ Z_ b_ d_ ` ` ,)` ^0` ak` p` y` a a 4a "a x%a (a )a >a Eda Aa H
b ;b .Jb 5c 8c ec oc 9d }d d Ud G#d U*d Ud Ud  Wd ^d dyd #e (e e (e 2e Ne #We _e te f 
-f 3f Z:f Bf Kf Sf ~}f 1g 3g 6Rg Xg 7`g jg Nh i5h Oh AVh t[h ah i i Ti !i *i N7i @i mIi )ji j ]j j j 3j K;j <@j fj jj mj quj k `%k /k /k Lk eVk Yk Zk ISl [vl Pm m !m 3m ;m um zm 7n n Ln n 8n H<n QQn Yn ncn gn jn pn  )p =p @p bp cp dp gp *lp op xp q Uq *q I/q 2q :q a<q Jq 2\q Ibq r r Y;r @r Lr XNr \r _r s  s d%s 7s bs cs $t T-t t u ]u eu u Du ru Qu ju ou   v v 	!v _Av Iw Sw w 
w Sw "w @w Sw Tw eWw ]w aw gw x x 8x 7"x +x 0x ePx Wx A`x y h1y My oxy zy ez z V2z 6z Dz YEz 
Yz lz 
{ { { &{ ;{ @{ G{ ,O{ 8_{ | | 7J| U| j| `} C} 9} \"} #} O&} -} 2} }~} j~ '~ |~ ~ 2~ Q~ a~ 3 > A E p Eu x e h  @ s | r  gD G T HX p u  X& 2 ; L TR Z V
   
4 4 T< X $e + 0 \D #O $O wR 4X 
   5 G I Jd 6| | % 4( 
+ + I= B x   # + |    O  # a3 : GO \ ^ & . C1 1 `D F m p  - . $0 R2 pE ,X X P  d 9  X  2 r[ l w 3 6 _= <A  K Y     6 A H GK P MX g l vz  
   r( ". /8 < t     : A <P W b r  ) * G`  c n 
 u& C gF P [ p  & w( cO ` Oa k #   - 7. @   B TK Q ?T =| ?# S: C \  n  5 /? ~  ( > F   w. )Y TY ] m`  R z   * 1 ? sH  {9 = L  & ' 3 7 7p t 	    O! [ l` QV c i z  	  > {* 3 < d aj i[ ^l /u z  
 " {, Y V  #7 = I N j _s    o  2 "3 5 <P T V xb `e j dz  7 *7 = B W c r t , 1  q "  8 mc /d v  
5 5 UG U *[ <i   5M b w|     '+ > @ D JO ] g l n u z |  > 
  " X# s    % ,Y Y o t ; 
  '& 5 U Z d
  z * 0 Y p A K  2 : @ T \ y  L . I k   i# / RF bN  H Q ]T E M S {n o v  , / 2 7 <I ] )h j Pk ~ K 
 \   o ; ? X Gc 
 P ! & + 2D Zj k dn 6 .9 /H BH Y lc u u k \< I kK k m  ~   {# * . 2 C5 U |` d t 
{ p  % % N d l El n b{ A   . d( A I m^ j | # < &C q` e p [ 9 !D ^Q 0t } S % k6 6 = \ h s { 
 S# ' < YK aK T d x   ) 6 R= X Z Z\ Hr { ! C p_ } x '
  A 	U a g z r  ` # -4 z= ? g V  r  1$ ]% 9 @ J dX m o ax    [ jz M  9 ; ? R 
   h t  6 < k 5n w !y ( 6* {  2 )  , 11 >H <K AT e i p *w K} F f* t. . D Wi  r s v    I Q R r Q) . 7 <F J W lp z l} g d  p Y; |O %_ b  E& . ; | } ~~ m 
 7 , $2 B dD E ZR f ?z   
 !' ( x4 :: = F G ` k -
  ;- ~4 cL P vQ &\ f s    2 F H "i q \  n  w8 < lh Vv 0 40 P F\ c s ax   ; D {L R QW @[ b "v  # 3  n '" #6 @ k q w S. Y/ L M h x `   % l( 0 a; 0M YX _ z | c 
  T &
 l
 
  c    8 = A O V o 3q r (t % 
6 n8 M .d f n u W~  ! . 2 F 	M ] Oa %K P b j l f # - . . 4 5 ie F  ^	 ; ? B P k  $ @% F 4^ M^ ` u |  c  < > X g h |   i% "; O> G Q S AY 	 P 3@ ] b p 		 E t q N& YA C F \Q R W _ cl m    E I bS c y  4 M m v { 6~   ^G Z h[ =d  ' 27 B 7M e } ~ +  a- W 0h [  ! " B4 i (! o# sC R U CY m  
  S & . 6 ? [ 
` _  	5 9 sN S U Y _ j 5
  U " A_ n Ts t } W 
 
 4 U Dk k  3 G4 = N ] u p >    4 = 4C mG Gy  ) xJ f 3E 2U Q 
 p ' ? WD M .[ u  	
    5 D <K |d "e t O j] ] Su 	 h K [W l   pA J GN S i o G~     & 35 l  8 : i j   " + - g l |s s W{ '  ? y  
 7 @ WD 5R qU b b = Q s @     DJ%                     e?     @      U n k n o w n                                   G  z                  T i m e s   N e w   R o m a n   5                       S y m b o l   3&  z                  A r i a l   ?5  	:                    C o u r i e r   N e w   "  1   h    #F#F        v	  5        s   v	  5       s       $                                                                                                                                                                                                                                                                                                                           4    d      E?  E?                                                                        2Q                               HX    	 ?    fj     2                         u a r t 2        J o e   F o c k l e r  J o e   F o c k l e r                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Oh +'0   x                                                     	          
   4     @  
   L     X     `     h     p             uart2                   Joe Fockler                           Normal.dot        Joe Fockler       1         Microsoft Office Word   @    F#    @    U@    ݳU         v	     5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ՜. +,D   ՜. +,@           h      p                                                   
                       Texas Instruments      s             E?     '                                     uart2            Title       D-                8      @            _PID_HLINKS      A   ,  >      s                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 4         4                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0         4                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0         v                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 1         s                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 4         v                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 1        b                        O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 2 0       6                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 2 3       6                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 2 3       s                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 4         6    ~                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 2 3       6    {                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 2 3      b     x                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 8       q    u                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 6        b     r                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 7       v    o                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 1         4    l                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0         4    i                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0        b     f                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 4      b     c                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 3       ;    `                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 4         w    ]                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         :    Z                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 5         w    W                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         =    T                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 2         w    Q                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         <    N                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 3         w    K                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         ;    H                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 4         w    E                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         :    B                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 5         w    ?                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         =    <                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 2         w    9                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0         <    6                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 3         w    3                   Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 c . h t m l           a 0        b     0                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 0       5    -                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 1 2       4    *                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0         4    '                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0        b     $                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 1 0      b 
    !                   O   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t _ 8 c . h t m l           a 9         5                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 1 1       ;                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 4         :                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 5         =                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 2         <                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l         a 3         4                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0         4                       P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l         a 0        j     	                   P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 h . h t m l               n G                       Q   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / b u f f e r _ 8 h . h t m l                 ` R                       W   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c - s o u r c e . h t m l                 j                         P   h t t p s : / / c c r m a . s t a n f o r d . e d u / c o u r s e s / 2 5 0 a - f a l l - 2 0 0 3 / d o c s / a v r l i b - n e w / u a r t 2 _ 8 c . h t m l                                                                                                                                                                                                                                                                                                                                                                                                                                	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   <   =   >   ?   @   A   B   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                        R o o t   E n t r y                                                 	           F            0EU          D a t a                                                         
                                     ;          1 T a b l e                                                                                                C   )      W o r d D o c u m e n t                                                                                        .t       S u m m a r y I n f o r m a t i o n                           (                                                D o c u m e n t S u m m a r y I n f o r m a t i o n           8                                           .       C o m p O b j                                                                                           q                                                                                                                               
  	           F   Microsoft Office Word Document 
   MSWordDoc    Word.Document.8 9q                                                                                                                                                                                                                                                                                                                                                                                                                           