#ifndef __EMULATOR_H__
#define __EMULATOR_H__

typedef struct
{
  unsigned int c        :1;
  unsigned int z        :1;
  unsigned int n        :1;
  unsigned int gie      :1;
  unsigned int cpu_off  :1;
  unsigned int osc_off  :1;
  unsigned int scg0     :1;
  unsigned int scg1     :1;
  unsigned int v        :1;
  unsigned int reserved :7;
} status_reg;

typedef struct
{
  unsigned int PC;
  unsigned int SP;
  union
  {
    unsigned int SR;
    status_reg   sr;
  };
  unsigned int R3;
  unsigned int R4;
  unsigned int R5;
  unsigned int R6;
  unsigned int R7;
  unsigned int R8;
  unsigned int R9;
  unsigned int R10;
  unsigned int R11;
  unsigned int R12;
  unsigned int R13;
  unsigned int R14;
  unsigned int R15;
} regs;

regs *emulator(void (*start_address)(), unsigned int *break_point);

#endif