/****************************************************************
*
* Copyright (C) 1999-2000 Texas Instruments, Inc.
* Author: Volker Rzehak
*
*----------------------------------------------------------------
* All software and related documentation is provided "AS IS" and 
* without warranty or support of any kind and Texas Instruments 
* expressly disclaims all other warranties, express or implied, 
* including, but not limited to, the implied warranties of 
* merchantability and fitness for a particular purpose. Under no 
* circumstances shall Texas Instruments be liable for any 
* incidental, special or consequential damages that result from 
* the use or inability to use the software or related 
* documentation, even if Texas Instruments has been advised of 
* the liability.
*
* Unless otherwise stated, software written and copyrighted by 
* Texas Instruments is distributed as "freeware". You may use 
* and modify this software without any charge or restriction. 
* You may distribute to others, as long as the original author 
* is acknowledged.
*----------------------------------------------------------------
* 08/01 FRGR Implemented function comChangeBaudrate()
****************************************************************/

#ifndef SSP__H
#define SSP__H

#include <windows.h>

#define MODE_SSP 0
#define MODE_BSL 1

/* Error Codes:
 */
/* No Error:                   */
#define ERR_NONE               0

/* Unspecific error:           */
#define ERR_COM                1
/* OpenComm failed:            */
#define ERR_OPEN_COMM          2
/* SetCommState failed:        */
#define ERR_SET_COMM_STATE     3 
/* Synchronisation failed:     */
#define ERR_SYNC_FAILED        4 
/* Unspecific error concerning transmission of command: */
#define ERR_SEND_COMMAND       5
/* Timeout while receiving header": */
#define ERR_RX_HDR_TIMEOUT     6 
/* NAK received:               */
#define ERR_RX_NAK             7
/* Command did not send ACK: indicates that it didn't complete correctly: */
#define ERR_CMD_NOT_COMPLETED  8 
/* Command failed, is not defined or is not allowed: */
#define ERR_CMD_FAILED         9
/* CloseComm failed:           */
#define ERR_CLOSE_COMM        10

/* Header Definitions: */
#define CMD_FAILED       0x70
#define DATA_FRAME       0x80
#define DATA_ACK         0x90
#define DATA_NAK         0xA0

#define QUERY_POLL       0xB0
#define QUERY_RESPONSE   0x50

#define OPEN_CONNECTION  0xC0
#define ACK_CONNECTION   0x40

#define DEFAULT_TIMEOUT 300
#define DEFAULT_PROLONG  10
#define MAX_FRAME_SIZE 256
#define MAX_DATA_BYTES 250
#define MAX_DATA_WORDS 125

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------
 * Support Subroutines:
 *---------------------------------------------------------------
 */

/*-------------------------------------------------------------*/
extern DWORD calcTimeout(DWORD startTime);
/* Calculates the difference between startTime and the acutal
 * windows time (in milliseconds).
 */
/*-------------------------------------------------------------*/
extern void delay(DWORD time);
/* Delays the execution by a given time in ms.
 */
/*-------------------------------------------------------------*/
extern int comWaitForData(int count, DWORD timeout);
/* Waits until a given number (count) of bytes was received or a
 * given time (timeout) has passed.
 */

extern void comTxHeader(const BYTE txHeader);

/*---------------------------------------------------------------
 * Communication Subroutines:
 *---------------------------------------------------------------
 */

extern int comGetLastError();
/* Returns the error code generated by the last function call to 
 * a SERCOMM-Function.  If this function returned without errors, 
 * comGetLastError will return zero (errNoError) as well.
 */

/*-------------------------------------------------------------*/
#ifdef __cplusplus
extern int comInit(LPCSTR lpszDevice    = "COM1", 
                   DWORD  aTimeout      = DEFAULT_TIMEOUT, 
                   int    aProlongFactor= DEFAULT_PROLONG);
#else
extern int comInit(LPCSTR lpszDevice,
                   DWORD aTimeout, int aProlongFactor);
#endif
/* Tries to open the serial port given in 'lpszDevice' and
 * initialises the port and global variables.
 * The timeout and the number of allowed errors is multiplied by
 * 'aProlongFactor' after transmission of a command to give
 * plenty of time to the micro controller to finish the command.
 * Returns zero if the function is successful.
 */

/*-------------------------------------------------------------*/
extern DWORD comGetBaudrate();
/* Returns Baudrate of the used serial port
 */
extern int comChangeBaudrate(DWORD Baud);
/* Changes Baudrate of the used serial port
 */
extern int comDone();
/* Closes the used serial port. 
 * This function must be called at the end of a program,
 * otherwise the serial port might not be released and can not be
 * used in other programs.
 * Returns zero if the function is successful.
 */


#ifdef __cplusplus
}
#endif

#endif

/* EOF */