/* 
  For reference:
  .bss    = global variables.
  .ebss   = far global variable.
  .data   = constant
  .cinit  = initialised C variables - coped from ROM to RAM.
*/

MEMORY
{
PAGE 0 :          /* Program Space */
  PRAMM0M1        : origin = 0x000000, length = 0x000010

  PRAML0123       : origin = 0x008000, length = 0x004000  /* On chip ram */

  /* Flash Section H-C */
  APP_BEGIN       : origin = 0x300000, length = 0x000008, fill=0x0000   /* Application - Branch instruction */
  APP_HEADER      : origin = 0x300008, length = 0x0000F8, fill=0x0000   /* Application - Header information */
  APP_CODE        : origin = 0x300100, length = 0x02FC00  /* fill=0xFFFF */  /* FIXME: fill is removed to speed up JTAG for development */ /* Application - Code area */  
  /*APP_CODE        : origin = 0x300100, length = 0x01FE00*/
  
  
  FLASH_COUNT     : origin = 0x32FE00, length = 0x000001, fill=0x0000
  RESERVED        : origin = 0x32FE01, length = 0x0001FF, fill=0x0000

  /* Flash Section B */
  BL_BEGIN        : origin = 0x330000, length = 0x000008  /* BootLoader - Branch instruction */
  BL_HEADER       : origin = 0x330008, length = 0x0001F8  /* BootLoader - Header information */

  /* Flash Section A */
  CSM_RSVD        : origin = 0x33FF80, length = 0x000076, fill=0x0000   /* Program with all 0x0000 when CSM is in use. */
  CSM_PWL         : origin = 0x33FFF8, length = 0x000008                /* CSM password location */

  /* Located in Boot ROM */
  IQTABLES (R)    : origin = 0x3FE000, length = 0x000b50
  IQTABLES2 (R)   : origin = 0x3FEB50, length = 0x00008c
  FPUTABLES       : origin = 0x3FEBDC, length = 0x0006A0  
  RESET           : origin = 0x3FFFC0, length = 0x000002  
  VECTORS         : origin = 0x3FFFC2, length = 0x00003E  
           
PAGE 1 :          /* Data Space */
  RAMM0M1         : origin = 0x000010, length = 0x0007F0
  FPGA            : origin = 0x004000, length = 0x001000  /* Zone 0 - FPGA*/
  RAML4567        : origin = 0x00C000, length = 0x004000
  ESC             : origin = 0x100000, length = 0x100000  /* Zone 6 - ET1100 */
  RAMBLA          : origin = 0x200000, length = 0x000100  /* allocate shared RAM between app and BL */
  RAMX            : origin = 0x200100, length = 0x03FFC0  /* Zone 7 - 4Mbit ram*/
}

SECTIONS
{
	/* Main entry points - must be in correct location*/
  codestart_flash : > APP_BEGIN       PAGE = 0 /* This will need to be removed when bootloader is present */
  .app_header     : > APP_HEADER      PAGE = 0

  .bl_jump        : > BL_BEGIN,       PAGE = 0, TYPE = NOLOAD
  .bl_header      : > BL_HEADER,      PAGE = 0, TYPE = NOLOAD


  /* These should probably be fixed in flash at the same location
     for all builds */
  IQmathTables    : load = IQTABLES, type = NOLOAD, PAGE = 0
  IQmathTables2   > IQTABLES2, type = NOLOAD, PAGE = 0
                  {
                    IQmath.lib<IQNexpTable.obj>(IQmathTablesRam)
                  }
  IQmathTablesRam : load = RAMX,     PAGE = 1
  FPUmathTables   : > FPUTABLES, PAGE = 0, TYPE = NOLOAD 


  /* These items may go into RAM or Flash */
  codestart       : > APP_CODE      PAGE = 0
  .const          : > APP_CODE      PAGE = 0
  .econst         : > APP_CODE      PAGE = 0
  .switch         : > APP_CODE      PAGE = 0

  UAPP_HEADER     : > APP_CODE      PAGE = 0,
                    LOAD_START(_HWLINK_u16UAPP_HEADER_SECT)

  temp_prog       : > APP_CODE      PAGE = 0
  .reset          : > RESET,        PAGE = 0, TYPE = DSECT /* not used, */

  /* Allocate program areas: */
  .text           : > APP_CODE      PAGE = 0
  .cinit          : > APP_CODE      PAGE = 0
  .pinit          : > APP_CODE      PAGE = 0

  Prog_Fast       :   LOAD = APP_CODE,
                      RUN = PRAML0123,
                      {
                        IQmath.lib(.text)
                        *(IQmath)
                        *(Prog_Fast)
                      }
                      LOAD_START(_HWLINK_u16RTPROG_LoadStart),
                      LOAD_END(_HWLINK_u16RTPROG_LoadEnd),
                      RUN_START(_HWLINK_u16RTPROG_RunStart),
                      PAGE = 0

  csmpasswds      : > CSM_PWL     PAGE = 0 , TYPE = NOLOAD
  csm_rsvd        : > CSM_RSVD    PAGE = 0 , TYPE = NOLOAD
   
  /* Allocate uninitalized data sections: */
  .stack          : LOAD = RAMM0M1, 
                    RUN_START(_HWLINK_u16StackStart), 
                    RUN_END(_HWLINK_u16StackEnd), 
                    PAGE = 1 

  .bss            : > RAMM0M1     PAGE = 1
  .ebss           : > RAML4567,   PAGE = 1
  .ebssX          : {
                      rts2800_ml.lib(.ebss)
                    }
                    > RAMX,       PAGE = 1

  Data_Params_Temp    : > RAMX,         PAGE = 1						
  Data_Signals_Temp   : > RAMX,         PAGE = 1						
  Data_Fast_Signal    : > RAML4567,     PAGE = 1  
  Data_Slow_Signal    : > RAMX,         PAGE = 1
  Data_External       : > RAMX,         PAGE = 1
  /* FIXME: Initialised data inside Data_External does not work.... don't know why.
      Maybe it doesn't correctly generate the cinit tables?
      Possibly the cinit tables don't handle far data correctly.  Not sure why. */

  bootloader_ram_data      : LOAD > RAMBLA
  

  /* Allocate initialised data sections */
  Data_Fast_Param     :   RUN   = RAMM0M1     PAGE 1,
                          LOAD  = APP_CODE    PAGE 0,
                          LOAD_START(_HWLINK_u16PARM_LoadStart),
                          LOAD_END(_HWLINK_u16PARM_LoadEnd),
                          RUN_START(_HWLINK_u16PARM_RunStart)

  UnusedAllocation    : > ESC,
                        LOAD_START(_HWLINK_u16ESC)
                        
  DATA_FPGA           : > FPGA
                        

}

