//###########################################################################
// FILE:   Lab5_C28.c
//###########################################################################
//

#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include <string.h>

#define C28_FREQ    100         //C28 CPU frequency in MHz

extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadSize;
extern Uint16 RamfuncsRunStart;
interrupt void adc1_isr(void);
unsigned long kaka = 0;
Uint16 ConversionCount = 0;
Uint16 Voltage_C28[100]= {0};
Uint16 GPIO70_count;
#pragma DATA_SECTION(LatestADCResult,"CtoM")
Uint16 LatestADCResult;

void main(void)
{
   InitSysCtrl();							// Init C28 core
   EALLOW;
   GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;	// GPIO0 = ePWM1A
   GpioG1CtrlRegs.GPCDIR.bit.GPIO70 = 1; 	// GPIO70 as output
   EDIS;
   GpioG1DataRegs.GPCDAT.bit.GPIO70 = 1;	// turn off LED
// Copy time critical code and Flash setup code to RAM
// This includes the following functions: InitFlash();
// The  RamfuncsLoadStart, RamfuncsLoadSize and RamfuncsRunStart
// symbols are created by the linker. Refer to the device .cmd file.
   memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize); 
   
// Call Flash Initialization to setup flash waitstates
// This function must reside in RAM
    InitFlash();

	EPwm1Regs.TBCTL.all = 0; 			// clear all bits in TBCTL
	EPwm1Regs.TBCTL.bit.CLKDIV = 0;  	// CLKDIV = div by 1;
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0; 	// HSPCLKDIV = div by 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 2;  	// count mode = up-down mode
	EPwm1Regs.AQCTLA.all = 0x0006; 		// ZRO=set; PRD=clear
	EPwm1Regs.TBPRD = 50000;    		// 1 kHz PWM frequency
	// TBPRD = fcpu / (2* fpwm * CLKDIV * HSPCLKDIV)
	// TBPRB = 100 MHz / (2 * 1 kHz *  1 * 1)

	InitPieCtrl();
	InitPieVectTable();
	EALLOW; // This is needed to write to EALLOW protected registers
	PieVectTable.ADCINT1  = &adc1_isr;
	EDIS;
	InitCpuTimers();
	ConfigCpuTimer(&CpuTimer0, C28_FREQ, 20);
	PieCtrlRegs.PIEIER1.bit.INTx1 = 1;
	IER |= 1;
	EINT;  // Enable Global interrupt INTM
	ERTM;  // Enable Global realtime interrupt DBGM





	InitAdc1();



	GpioG1DataRegs.GPCDAT.bit.GPIO70 = 0;	// This turns C28 LED ON
	while (kaka++ <10000000);				// It's a long pause for me



	EALLOW;
	Adc1Regs.ADCCTL2.bit.ADCNONOVERLAP = 1;	// Enable non-overlap mode i.e.
											// conversion and future sampling
											// events dont overlap
	Adc1Regs.ADCCTL1.bit.INTPULSEPOS   = 1; // ADCINT1 trips after AdcResults latch
	Adc1Regs.INTSEL1N2.bit.INT1E       = 1;	// Enabled ADCINT1
	Adc1Regs.INTSEL1N2.bit.INT1CONT    = 0;	// Disable ADCINT1 Continuous mode
	Adc1Regs.INTSEL1N2.bit.INT1SEL     = 0;	// setup EOC0 to trigger ADCINT1 to fire
	Adc1Regs.ADCSOC0CTL.bit.CHSEL      = 0;	// set SOC0 channel select to ADC1in_A0
	AnalogSysctrlRegs.TRIG1SEL.all     = 1;	// Assigning TINT0 to ADC-TRIGGER 1
	Adc1Regs.ADCSOC0CTL.bit.TRIGSEL    = 5;	// Set SOC0 start trigger to
											// ADC Trigger 1 of the ADC
	Adc1Regs.ADCSOC0CTL.bit.ACQPS      = 6;	// set SOC0 S/H Window to 7 ADC
											// Clock Cycles, (6 ACQPS + 1)
	EDIS;

	CpuTimer0Regs.TCR.bit.TSS = 0;	// start T0
	while(1);
}

interrupt void adc1_isr(void)
{
	Voltage_C28[ConversionCount] = Adc1Result.ADCRESULT0;
	LatestADCResult = Voltage_C28[ConversionCount]; // load value into CtoM
	CtoMIpcRegs.CTOMIPCSET.bit.IPC1 = 1;		// signal IPC1 to M3
	if(ConversionCount == 100) ConversionCount = 0;
		else ConversionCount++;
	if(GPIO70_count++ > 2500)
	{
		GpioG1DataRegs.GPCDAT.bit.GPIO70 ^= 1;
		GPIO70_count = 0;
	}
	Adc1Regs.ADCINTFLGCLR.bit.ADCINT1 = 1;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}





