//###########################################################################
// FILE:   Lab5_M3.c
//###########################################################################
//

#include <string.h>

#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_gpio.h"
#include "inc/hw_types.h"
#include "inc/hw_sysctl.h"
#include "driverlib/debug.h"
#include "driverlib/flash.h"
#include "driverlib/ipc.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/timer.h"				// new in Lab2_M3
#include "inc/hw_ipc.h"						// new in Lab5_M3

extern unsigned long RamfuncsLoadStart;
extern unsigned long RamfuncsRunStart;
extern unsigned long RamfuncsLoadSize;

unsigned int Voltage_M3[100];
unsigned int i = 0;
#pragma DATA_SECTION(AdcValue,"CtoM")
unsigned int AdcValue;

//*****************************************************************************
// The interrupt handler for timer0 interrupt.
//*****************************************************************************
void Timer0IntHandler(void)
{
	static unsigned int toggle = 0;
	// Clear the timer interrupt.
    TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
    if(toggle == 0)
    {
    	GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_7, 0);	// LD3 ON
    	toggle = 1;
    }
    else
    {
    	GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_7, ~0);	// LD3 OFF
    	toggle = 0;
    }
}

//*****************************************************************************
// Blink LED LD3
//*****************************************************************************
void main(void)
{
    // Disable Protection
    HWREG(SYSCTL_MWRALLOW) =  0xA5A5A5A5;

    // Sets up PLL, M3 running at 100MHz and C28 running at 100MHz
    SysCtlClockConfigSet(SYSCTL_USE_PLL | (SYSCTL_SPLLIMULT_M & 0xA) |
                         SYSCTL_SYSDIV_1 | SYSCTL_M3SSDIV_1 |
                         SYSCTL_XCLKDIV_4);

// Copy time critical code and Flash setup code to RAM
// This includes the following functions:  InitFlash();
// The  RamfuncsLoadStart, RamfuncsLoadSize, and RamfuncsRunStart
// symbols are created by the linker. Refer to the device .cmd file.
    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize);
    
// Call Flash Initialization to setup flash waitstates
// This function must reside in RAM
    FlashInit();                         

    // Enable timer 0 used by this example.
    SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);
    // Configure the timer0 as 32-bit periodic timer.
	TimerConfigure(TIMER0_BASE, TIMER_CFG_32_BIT_PER);
	TimerLoadSet(TIMER0_BASE, TIMER_A, SysCtlClockGet(SYSTEM_CLOCK_SPEED)/5);

    //  Send boot command to allow the C28 application to begin execution


    // Enable clock supply for GPIOC
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
    
    // Give C28 control of Port C pin 6
    GPIOPinConfigureCoreSelect(GPIO_PORTC_BASE, 0x40, GPIO_PIN_C_CORE_SELECT);

    // Enable Clock Supply for GPIOA
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    // Give C28 control of Port A pin 0
    GPIOPinConfigureCoreSelect(GPIO_PORTA_BASE, GPIO_PIN_0, GPIO_PIN_C_CORE_SELECT);

    // Disable clock supply for the watchdog modules
    SysCtlPeripheralDisable(SYSCTL_PERIPH_WDOG1);
    SysCtlPeripheralDisable(SYSCTL_PERIPH_WDOG0);
    
    // Setup the interrupts for the timer timeouts.
    IntEnable(INT_TIMER0A);
    TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
    IntRegister(INT_TIMER0A, Timer0IntHandler);

    // Enable the timers.
    TimerEnable(TIMER0_BASE, TIMER_A);

    // Enable processor interrupts.
    IntMasterEnable();

    // Set up the Pin for LED LD3
    GPIOPinTypeGPIOOutput(GPIO_PORTC_BASE, GPIO_PIN_7);
    GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_7, ~0);
    IPCMtoCBootControlSystem(CBROM_MTOC_BOOTMODE_BOOT_FROM_FLASH);
    
    while(1)
        {
       	while(IPCCtoMFlagBusy(IPC_CTOMIPCSTS_IPC1)==0); // wait for IPC1
        	Voltage_M3[i]= AdcValue; // read and store result from CtoM  Ram
        	IPCCtoMFlagAcknowledge (IPC_CTOMIPCACK_IPC1);   // clear IPC1-flag
        	if(i++ >= 100)i=0;
        }
}



