Void initialiseEDMAForFPGA( Void )
{
	EDMA3_DRV_Result result = EDMA3_DRV_SOK;
	UInt uChannel=0;
    CPTErrorHandler& rEH( CPTErrorHandler::Instance() );
    rEH.InitErrorBlock();

    // Get memory for the fifo buffer
    g_au32FPGAData = (uint32_t*) Memory_alloc( NULL, sizeof( uint32_t ) * U_FIFO_BUFFER_SIZE,
                                               EDMA3_CACHE_LINE_SIZE_IN_BYTES,
                                               rEH.GetErrorBlockPtr());
    rEH.SysRaise( CPTErrorHandler::DEC_MALLOC_FAILED, 0, "Memory_alloc failed", 0);

	if( !g_hEdma  )
	{
		g_hEdma = edma3init(0, &result);
		Assert_isTrue( g_hEdma != NULL, NULL );
		Assert_isTrue( result == EDMA3_DRV_SOK, NULL );
	}

    /* Setup for Channel 1*/
    g_sFPGAChannel.tcc  = EDMA3_DRV_TCC_ANY;
    g_sFPGAChannel.chId = EDMA3_DRV_QDMA_CHANNEL_ANY;

    /* Request any DMA channel and any TCC */
	result = EDMA3_DRV_requestChannel (g_hEdma,
									   &g_sFPGAChannel.chId,
									   &g_sFPGAChannel.tcc,
									   (EDMA3_RM_EventQueue)0,
									   &EDMAFinished, 0 );

    if (result == EDMA3_DRV_SOK)
    {
        /* Set QDMA Trigger Word as Destination Address */
        result =  EDMA3_DRV_setQdmaTrigWord (g_hEdma, g_sFPGAChannel.chId, EDMA3_RM_QDMA_TRIG_DST);
    }

    if (result == EDMA3_DRV_SOK)
    {
        // don't advance source in any index. We always read from the same adress
        result = EDMA3_DRV_setSrcIndex (g_hEdma, g_sFPGAChannel.chId, 0, 0);
    }

    if (result == EDMA3_DRV_SOK)
    {
        // Advance destination by one float
        result =  EDMA3_DRV_setDestIndex (g_hEdma, g_sFPGAChannel.chId, 4, 0);
    }

    if (result == EDMA3_DRV_SOK)
    {
        /* Enable Transfer Completion Interrupt */
        result = EDMA3_DRV_setOptField (g_hEdma, g_sFPGAChannel.chId,
                                        EDMA3_DRV_OPT_FIELD_TCINTEN, 1u);
    }

    if (result == EDMA3_DRV_SOK)
    {
        /* Enable Intermediate Transfer Completion Interrupt */
        result = EDMA3_DRV_setOptField (g_hEdma, g_sFPGAChannel.chId,
                                        EDMA3_DRV_OPT_FIELD_ITCINTEN, 1u);
    }

    if (result == EDMA3_DRV_SOK)
    {
        /* Set Source Transfer Mode as Increment Mode, as opposed to FIFO. */
        result = EDMA3_DRV_setOptField (g_hEdma, g_sFPGAChannel.chId, EDMA3_DRV_OPT_FIELD_SAM,
                                        EDMA3_DRV_ADDR_MODE_INCR);
    }

    if (result == EDMA3_DRV_SOK)
    {
        /* Set Destination Transfer Mode as Increment Mode. */
        result = EDMA3_DRV_setOptField (g_hEdma, g_sFPGAChannel.chId, EDMA3_DRV_OPT_FIELD_DAM,
                                        EDMA3_DRV_ADDR_MODE_INCR);
    }

    if( result == EDMA3_DRV_SOK  )
    {
        /* Set PaRAM to static mode. "A value of 1 should be used for isolated QDMA transfers"  */
        result = EDMA3_DRV_setOptField (g_hEdma, g_sFPGAChannel.chId, EDMA3_DRV_OPT_FIELD_STATIC,
                                        EDMA3_DRV_STATIC_EN );
    }

    if( result != EDMA3_DRV_SOK  )
    {
        CPTErrorHandler::Instance().Raise( CPTErrorHandler::DEC_DMA_SETUP, result,
                                           "Error while setting up DMA: %d", result );
    }
} // END initialiseEDMAForFPGA
