#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <getopt.h>
#include <errno.h>

#include "i2c-dev.h"

#define I2C_DEVICE "/dev/i2c/0"
#define I2C_DEV_ADDR 0x38


int init_i2c(void)
{
    int fd;

    fd = open(I2C_DEVICE, O_RDWR);

    if (fd < 0) {
       printf("Error while opening i2c device %s\n", I2C_DEVICE);
        return fd;
    }

    if (ioctl(fd, I2C_SLAVE, I2C_DEV_ADDR) == -1) {
        printf("Failed to set I2C_SLAVE %#x\n", I2C_DEV_ADDR);
        return -1;
    }

    return fd;
}

int main(int argc, char **argv)
{
    int     i2cfd;
    int     i;  // loop counter
    __u8    buf[1];
    
    i2cfd = init_i2c();

    buf[0] = 0x0F;  //turn on DS1 thru DS4 LEDs
    if(write(i2cfd, buf, 1) != 1)
      printf("Write Error Address = 0x1b\n");
    
    close(i2cfd);

    exit(EXIT_SUCCESS);
}
