/*
 * display.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2009
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _DISPLAY_H
#define _DISPLAY_H

#include <xdc/std.h>

#include <ti/sdo/dmai/Fifo.h>
#include <ti/sdo/dmai/Pause.h>
#include <ti/sdo/dmai/Display.h>
#include <ti/sdo/dmai/Rendezvous.h>

/* Environment passed when creating the thread */
typedef struct DisplayEnv {
    Display_Output          displayOutput;
    VideoStd_Type           videoStd;
    Rendezvous_Handle       hRendezvousInit;
    Rendezvous_Handle       hRendezvousCleanup;
    Pause_Handle            hPauseProcess;
    Pause_Handle            hPausePrime;
    Fifo_Handle             hOutFifo;
    Fifo_Handle             hInFifo;
    Int                     osd;
} DisplayEnv;

/* Thread function prototype */
extern Void *displayThrFxn(Void *arg);

#endif /* _DISPLAY_H */
