/*
 * loader.c
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2009
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#include <xdc/std.h>

#include <ti/sdo/dmai/Loader.h>

#include "loader.h"
#include "../demo.h"

/******************************************************************************
 * loaderThrFxn
 ******************************************************************************/
Void *loaderThrFxn(Void *arg)
{
    LoaderEnv              *envp        = (LoaderEnv *) arg;
    Void                   *status      = THREAD_SUCCESS;
    Int                     ret;

    /* Meet up with other threads before cleaning up */
    Rendezvous_meet(envp->hRendezvousInit);

    if (envp->hLoader == NULL) {
        cleanup(THREAD_FAILURE);
    }

    while (1) {
        /* Load a new frame from the file system */
        ret = Loader_readData(envp->hLoader);

        if (ret < 0) {
            ERR("Failed to load data from video file\n");
            cleanup(THREAD_FAILURE);
        }

        /* Was the end of file encountered */
        if (ret == Dmai_EEOF) {
            if (!envp->loop) {
                break;
            }
        }
        else if (ret == Dmai_EFLUSH) {
            break;
        }
    }

cleanup:
    /* Meet up with other threads before cleaning up */
    Rendezvous_meet(envp->hRendezvousCleanup);

    return status;
}

