/*
 * video.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2009
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _VIDEO_H
#define _VIDEO_H

#include <xdc/std.h>

#include <ti/sdo/dmai/Fifo.h>
#include <ti/sdo/dmai/Pause.h>
#include <ti/sdo/dmai/Loader.h>
#include <ti/sdo/dmai/Rendezvous.h>

/* Environment passed when creating the thread */
typedef struct VideoEnv {
    Rendezvous_Handle       hRendezvousInit;
    Rendezvous_Handle       hRendezvousCleanup;
    Rendezvous_Handle       hRendezvousLoop;
    Rendezvous_Handle       hRendezvousLoader;
    Pause_Handle            hPauseProcess;
    Pause_Handle            hPausePrime;
    Fifo_Handle             hDisplayInFifo;
    Fifo_Handle             hDisplayOutFifo;
    Loader_Handle           hLoader;
    Char                   *videoDecoder;
    Char                   *videoFile;
    Char                   *engineName;
    Void                   *params;
    Void                   *dynParams;
    Int                     loop;
    VideoStd_Type           videoStd;
} VideoEnv;

/* Thread function prototype */
extern Void *videoThrFxn(Void *arg);

#endif /* _VIDEO_H */
