/*=============================================================================*\ 
 * Copyright 2008, Delphi Technologies, Inc., All Rights Reserved. 
 * Delphi Confidential
 * 
 * Module Name:     linker_ti.cmd
 * Created By:      zzw378
 * Created Date:    Thu Mar 20 08:36:52 2008
 * %version:        tcb_css2#DBC800 %
 * %cvtype:         ascii %
 * %instance:       tcb_css_1 %
 * %derived_by:     zxw378 %
 * %date_modified:  Tuesday, March 06, 2012 2:07:42 PM % 
\*=============================================================================*/   

/*******************************************************************************\
 *
 * File Description:
 *
 *   This file contains the Linker Command File for TI Compiler to 
 *   build dbc packages.
 *   Traces to: None.
 *
 *   Deviations from software standards: NA
 *
 *   Note :
 *       This file to be used for both Boot Image as well as Application
 *       Image build process.
 *       This file should be the only file containing Linker MEMORY {} command
 *       definitions for Boot Image as well as Application Image area, which
 *       encompasses all the FLASH, RAM and Register.
 *
 *       All the Symbols required for communication of information between
 *       Boot Image and Application Image must be created within the
 *       Linker SECTION{} command definition using the INPUT Section
 *       and OUTPUT Section paragraphs.
 *
 *       Few INPUT Sections which cannot be in this file because of 
 *       name clash between Boot Image and Application Image must be 
 *       moved to linkers_ti.cmd file.
 *       The linkers_ti.cmd file is not shared between Boot Image and
 *       Application Image build process.
 *       There will be one linkers_ti.cmd file within Layer2 Sub-Project,
 *       which will be used only by Layer2 Test_Stub Application build
 *       process.
 *
 *       During the ECU System Application Build process, we need to create
 *       a new linkers_ti.cmd file depending upon the requirements.
 *       Similar conditions apply during the Boot Image build process.
 *
 *       The magic number 0x2FFF have been used in this file to define 12KB of
 *       RAM size as existing in this device.
 *       The magic number 0x0C have been used in this file to define the
 *       Boot Header block size.
 *
\*******************************************************************************/

-c                                      /* Link using c conventions */



--retain=cpu_vec_start

--retain=os_reset_addr
--retain=os_vec_start

--retain=_svc_stack
--retain=software_header_psa
--retain=cal_header_psa
--retain=Boot_Saved_Exception_Status
--retain=Boot_Saved_Exception_PC

/*----------------------------------------------------------------------
# Memory Map  for TMS470R1VF3382 device
#
# Type of Memory      Start          End            Comment
# ---------------   -----------  -----------    ---------------------------
# INTERNAL FLASH    0x0000 0000  0x0003 FFFF    Divided in 14 sectors,
#                                               as shown below:
#            8Kb    0x0000 0000  0x0000 1FFF    Sector 0, for Bootloader
#            8Kb    0x0000 2000  0x0000 3FFF    Sector 1, for Bootloader
#            8Kb    0x0000 4000  0x0000 5FFF    Sector 2, for Application
#            8Kb    0x0000 6000  0x0000 7FFF    Sector 3, for Application
#           32Kb    0x0000 8000  0x0000 FFFF    Sector 4, for Application
#           32Kb    0x0001 0000  0x0001 7FFF    Sector 5, for Application
#           32Kb    0x0001 8000  0x0001 FFFF    Sector 6, for Application
#           32Kb    0x0002 0000  0x0002 7FFF    Sector 7, for Application
#           32Kb    0x0002 8000  0x0002 FFFF    Sector 8, for Application
#           32Kb    0x0003 0000  0x0003 7FFF    Sector 9, for Application
#            8Kb    0x0003 8000  0x0003 9FFF    Sector 10, for Application
#            8Kb    0x0003 A000  0x0003 BFFF    Sector 11, for Application
#            8Kb    0x0003 C000  0x0003 DFFF    Sector 12, for Application
#            8Kb    0x0003 E000  0x0003 FFFF    Sector 13, for Calibration 
#
# INTERNAL RAM      0x0010 0000  0x0010 2FFF    General purpose RAM (12Kb)
#
# HET RAM           0x0080 0000  0x0080 0400    HET Program RAM (1Kb)
#
# REGISTERS         0xFFE8 8000  0xFFFF FFFF    Internal Registers
#-----------------------------------------------------------------------*/



/*----------------------------------------
 | Define address ranges for memory areas
 +---------------------------------------- */
MEMORY
{
   /* Flash Section Names */
   /* Refer to bstartup.asm module */
   
   /* Name      Type      Start                 Length            Description              */
   
   VECTORS        (X)   : origin = 0x00000000  len = 0x00000040  /* TMS470 Interrupt vectors*/
   BOOT_PSA       (R)   : origin = 0x00000040  len = 0x00000010  /* BOOT and INTERRUPT PSA  */   
   SWHDR          (R)   : origin = 0x00000050  len = 0x0000000C  /* Reserved for Boot       */
   ROM_BOOT       (RX)  : origin = 0x0000005C  len = 0x0000FF70  /* Reserved for Boot       */
   FBL_HDR        (R)   : origin = 0x0000FFCC  len = 0x00000034  /* App to Boot Jump Area   */
   APP_HEADER     (R)   : origin = 0x00010000  len = 0x00000058  /* App Header for Boot     */

   APP_BLOCK1     (RX)  : origin = 0x00010058  len = 0x00007FA8  /* Application Code Area   */

   CAL_HEADER     (R)   : origin = 0x00018000  len = 0x00000058  /* CAL Header for Boot     */
   CUST_CAL       (R)   : origin = 0x00018058  len = 0x00000100  /* NVM Customer default CAL*/   
   CAL_BLOCK      (R)   : origin = 0x00018158  len = 0x00003EA4  /* CAL Data Area           */
   CAL_FOOTER     (R)   : origin = 0x0001BFFC  len = 0x00000004  /* CAL Fo0ter for Boot     */
   APP_BLOCK2     (RX)  : origin = 0x0001C000  len = 0x000A3F00  /* Application Code Area   */
   APP_VECTORS    (RX)  : origin = 0x000BFF00  len = 0x000000F0  /* App Interrupt Table     */ 
   APP_FOOTER_TEMP(R)   : origin = 0x000BFFF0  len = 0x0000000C  /* App Temp Footer         */    
   APP_FOOTER     (R)   : origin = 0x000BFFFC  len = 0x00000004  /* App Footer for Boot     */

   BOOT_PARITY    (RX)  : origin = 0x00400000  len = 0x00008000  /* Boot Parity Block       */ 
   APP1_PARITY    (RX)  : origin = 0x00408000  len = 0x00004000  /* APP Block 1 Parity      */ 
   CAL_PARITY     (RX)  : origin = 0x0040C000  len = 0x00002000  /* CAL Parity Block        */ 
   APP2_PARITY    (RX)  : origin = 0x0040E000  len = 0x00052000  /* APP Block 2 Parity      */ 

   
   /* RAM Section Names */
   /* Refer to bstartup.asm module */
   
   SYSERR_DATA    (RWI) : origin = 0x08000000  len = 0x00000100  /* Reset Trail Data        */
   RESET_NOINIT   (RWI) : origin = 0x08000100  len = 0x0000000c  /* Reset Trail Error       */
   CSP_IP         (RWI) : origin = 0x0800010c  len = 0x00000004  /* Reset Exception IP      */
   MANAGED_RAM    (RWI) : origin = 0x08000110  len = 0x000000F0  /* Application Managed RAM */ 
   STACKS         (RWI) : origin = 0x08000200  len = 0x00000B00  /* Stack Area              */
   NVM_RAM        (RW)  : origin = 0x08000D00  len = 0x00000600  /* NVM RAM Area            */
   MANUF_RAM      (R)   : origin = 0x08001300  len = 0x00000080  /* Manufacturing RAM Area  */
   FREE_NVM_BUF   (RWI) : origin = 0x08001380  len = 0x00000100  /* FREE NVM RAM Buffer     */
   RAM1           (RWI) : origin = 0x08001480  len = 0x00000080  /* Application RAM Area    */
   RAM            (RWI) : origin = 0x08001500  len = 0x0000AB00  /* Application RAM Area    */

   ECC_RAM        (RWI) : origin = 0x08400000  len = 0x0000C000  /* ECC RAM Area            */
   
   HET_RAM        (RW)  : origin = 0xFF460000  len = 0x4000      /* HET Program RAM Area    */


	RAM_DOWNLOAD                (RX) : origin=0x00300E00   length=0x00002000
	

	
	UNUSED_SYMBOL_INCLUDE       (R) : origin=0x00900000   length=0x000007C0
	TEMP_WORK_AROUND       (RW) : origin=0x00A00000   length=0x000007C0
   

   /* Peripheral Register Area Names */
   /* Refer to Corresponding Device Data Sheet */

   CRC            (RW)   : origin = 0xFE000000  len = 0x0C0      /* CRC Peripheral          */
   
/* SPI1_TX_RAM    (RW)   : origin = 0xFF0E0000  len = 0x200 */   /* SPI1 Peripheral TX RAM  */
/* SPI1_RX_RAM    (R)    : origin = 0xFF0E0200  len = 0x200 */   /* SPI1 Peripheral RX RAM  */
   SPI1_RAM       (RW)   : origin = 0xFF0E0000  len = 0x400      /* SPI1 Peripheral TX RAM  */
   
   ADC_RAM        (RW)   : origin = 0xFF3E0000  len = 0x100      /* ADC Peripheral RAM      */
   RTP_RAM        (RW)   : origin = 0xFFF83000  len = 0x100      /* RTP Peripheral RAM      */
   DCAN2          (RW)   : origin = 0xFFF7DE00  len = 0x200      /* DCAN2 CAN Peripheral    */   
   SCC            (RW)   : origin = 0xFFF7DC00  len = 0x200      /* SCC CAN Peripheral      */
   GIO            (RW)   : origin = 0xFFF7BC00  len = 0x100      /* GIO Peripheral          */
   ADC            (RW)   : origin = 0xFFF7C000  len = 0x188      /* ADC Peripheral          */
   SCILIN1        (RW)   : origin = 0xFFF7E400  len = 0x94       /* UART Peripheral         */
   SPI1           (RW)   : origin = 0xFFF7F400  len = 0x134      /* MibSPI Peripheral       */
   HET            (RW)   : origin = 0xFFF7B800  len = 0x98       /* HET Peripheral          */
   SPI2           (RW)   : origin = 0xFFF7F600  len = 0x200      /* SPI Peripheral          */
   SPI3           (RW)   : origin = 0xFFF7F800  len = 0x200      /* SPI Peripheral          */




   DMA_PRAM       (RW)   : origin = 0xFFF80000  len = 0x200      /* DMA Peripheral RAM      */
   DMA_WRAM       (RW)   : origin = 0xFFF80800  len = 0x100      /* DMA Peripheral RAM      */
   VIM_RAM        (RW)   : origin = 0xFFF82000  len = 0x400      /* VIM Interrupt Table     */
   VIM_PAR_RAM    (RW)   : origin = 0xFFF82400  len = 0x400      /* VIM Interrupt Table     */
   FLASH          (RW)   : origin = 0xFFF87000  len = 0x80       /* Flash Block Registers   */
   RAMECC         (RW)   : origin = 0xFFFFF900  len = 0x100      /* RAMECC module registers */   
   PCR            (RW)   : origin = 0xFFFFE000  len = 0x100      /* PCR module registers    */   
   PBIST          (RW)   : origin = 0xFFFFE400  len = 0x1D0      /* PBIST module registers  */   
   ESM            (RW)   : origin = 0xFFFFF500  len = 0x040      /* ESM module registers    */   
   CCM7           (RW)   : origin = 0xFFFFF600  len = 0x008      /* CCM7 module registers   */   
   RTP            (RW)   : origin = 0xFFFFFA00  len = 0x100      /* RTP module registers    */   
   RTI            (RW)   : origin = 0xFFFFFC00  len = 0x100      /* RTI module registers    */   
   VIM_PAR        (RW)   : origin = 0xFFFFFDEC  len = 0x014      /* VIMPAR module registers */   
   VIM            (RW)   : origin = 0xFFFFFE00  len = 0x100      /* VIM module registers    */   
   DMA            (RW)   : origin = 0xFFFFF000  len = 0x1D8      /* DMA module registers    */
   SYS            (RW)   : origin = 0xFFFFFF00  len = 0x100      /* SYS module registers    */
   HTU            (RW)   : origin = 0xFFF7A400  len = 0x100      /* HTU module registers    */
}



/*---------------------------------------
 | Define Linker Output Sections to be created from *.obj  Sections
 +--------------------------------------- */
SECTIONS
{
    .vectors          : SIZE(VECTOR_TABLE_END)
                        {
                          _flash_start_location = .;       /* CPU Interrupt Vector Table   */
                        } > VECTORS        		    /* Resides in hhvect.asm file   */
    GROUP {
    .os_reset_addr    :
                        {
                          _APP_ISR_RESET_VECTOR_START = .;                        
                        }
    .os_intvec        : 
                        {				    /* Resides in osgen.asm file    */

                        }
           }              > APP_VECTORS                     /* Redirected Interrupt Vectors */    
                        
    .SW_Header        : 
                        {
                          _BOOT_SW_HEADER_ADDRESS     = .;
                          BOOT_HEADER_START_LOCATION = .;

                          * (.BOOT_SW_HEADER_ADDRESS)
                          . = . + (0x0c - .);               /* Reserve the remaining space  */                          
                          BOOT_HEADER_END_LOCATION = _BOOT_SW_HEADER_ADDRESS + 0x0C;
                        } > SWHDR                           /* Boot Area Header             */

    .boot             : START(_BOOT_BLOCK_START_ADDRESS)
                        {
                          * (.boot_text_below_FLASH_Key)
                          * (.boot_text_above_FLASH_Key:dbcBootCAN_A.lno)
                          * (.boot_start)
/*                          ..\Boot_Gen\lno\Weak_Symbol_Library.lib (.text)*/
                        } > ROM_BOOT /*| ROM_BOOT1*/           /* Boot Application Code Area   */

    .boot_const       : 
                        {

                        } >  ROM_BOOT                       /* Boot Application Const Area  */

    .boot_cinit       : 
                        {

                        } >  ROM_BOOT                       /* Boot Init Data Table Area    */
    

    .boot_data        : 
                        {

                        } > RAM, type=NOLOAD                /* Boot Application Data Area   */

    .os_pur           : 
                        {
                        
                        } (NOLOAD) > RAM1                   /* RTA-OSEK zeroed variables, 
                                                             * must be NOLOAD */

    .os_pir           : 
                        {
                        
                        } (NOLOAD) > RAM1    /* RTA initisalised variables, must be NOLOAD 
                                                 * as these are labels only until after StartOS. 
                                                 * On reset the internal RAM does not exist so 
                                                 * cannot be loaded */

    .text             : 
                        {
                          * (.text)
                        } > APP_BLOCK1 | APP_BLOCK2          /* Application Code Area        */
                            
    .os_pird          : 
                        {
                        
                        } > APP_BLOCK1 | APP_BLOCK2          /* Initialized DATA for RTA variables */    


    .const            : 
                        {
                          * (.const)    
                        } >> CAL_BLOCK                       /* Calibration Constant Area    */
    

    .os_pid           : 
                        {
                        
                        } > APP_BLOCK1 | APP_BLOCK2          /* RTA constant data            */

    .boot_parity           : START(BOOT_BLOCK_PARITY_START_ADDRESS)
                        {
                           BOOT_BLOCK_PARITY_END_ADDRESS = BOOT_BLOCK_PARITY_START_ADDRESS + 0x4000;
                        } > BOOT_PARITY                      /* Boot Parity data            */

    .app1_parity           : START(APP1_BLOCK_PARITY_START_ADDRESS)
                        {
                           APP1_BLOCK_PARITY_END_ADDRESS = APP1_BLOCK_PARITY_START_ADDRESS + 0x8000;
                        
                        } > APP1_PARITY                      /* App Block 1 Parity data            */

    .cal_parity           : START(CAL_BLOCK_PARITY_START_ADDRESS)
                        {
                           CAL_BLOCK_PARITY_END_ADDRESS = CAL_BLOCK_PARITY_START_ADDRESS + 0x2000;
                        
                        } > CAL_PARITY                      /* CAL Block Parity data            */

    .app2_parity           : START(APP2_BLOCK_PARITY_START_ADDRESS)
                        {
                           APP2_BLOCK_PARITY_END_ADDRESS = APP2_BLOCK_PARITY_START_ADDRESS + 0x52000;
                        
                        } > APP2_PARITY                      /* App Block 2 Parity data            */

    .Reset_Status_Saved : 
                        {
                        
                        } > RESET_NOINIT, type=NOINIT, type=DSECT       /* Saved Exception Status Register */
    
    .Reset_PC_Saved : 
                        {
                        
                        } > CSP_IP, type=NOINIT, type=DSECT       /* Saved Exception Status Register */


    .Reset_Trail_Data : SIZE(_RESET_TRAIL_RAM_SECTION_LENGTH)
                        { _ram_start_location = .;
                          CCP_Flash_Driver = .;
                          Flash_Routine_Start_Addr = .;

                          Flash_Erase_Sector_B =Flash_Routine_Start_Addr+FLASH_ERASE_SECTOR_OFFSET;
/*                          Flash_Compact_B =Flash_Routine_Start_Addr+FLASH_COMPACT_OFFSET; */
                          Flash_Prog_B =Flash_Routine_Start_Addr+FLASH_PROG_OFFSET;
/*                          Flash_Verify_B =Flash_Routine_Start_Addr+FLASH_VERIFY_OFFSET; */
                          Flash_API_Version_U16 =Flash_Routine_Start_Addr+FLASH_LIB_VERSION_OFFSET;
                          Initialize_Flash_Driver_Routines =Flash_Routine_Start_Addr+FLASH_DRV_INITIALIZE_OFFSET;
                        
                          Dnld_Data_Buffer  = . + _TOTAL_SIZE_OF_FLASH_DRV_DOWNLOAD+_TOTAL_SIZE_OF_FLASH_DRV_BSS;  /* Buffer for Flash Driver */

                          IRAM_BOTTOM = .;
                          _ram_end_location =  _ram_start_location + 0xBFFF;  /* 48KB RAM */
                          RAM_START_ADDRESS = _ram_start_location;
                          _RAM_END_ADDRESS = _ram_end_location;
                          IRAM_TOP = _ram_end_location;
                          * (.Reset_Trail_Data) { SIZE(_RESET_TRAIL_RAM_DATA_LENGTH) }
                          . = . + (0x100 - .);              /* Reserve the remaining space  */
                        } > SYSERR_DATA, type=NOINIT        /* Reset Exception Saved Data   */

       
    .stack            : SIZE(_TOTAL_STACK_LENGTH)
                        { 
                           StackSVC_Low = .;
                           RAM_Stack_Top_Key = . + 0x40;
                           .= . + 0x0500;                   /* Reserve the space            */
                           StackSVC_High= .;
                           _os_stack_top_svc= .;
                           
                           . = . + 0x04;
                           RAM_Stack_Bottom_Key = .;
                           StackIRQ_Low = .;                           
                           RAM_Stack_IRQ_Top_Key = . + 0x18;
                           .= . + 0x1FC;
                           StackIRQ_High= .;

                           . = . + 0x04;
                           RAM_Stack_IRQ_Bottom_Key = .;
                           StackFIQ_Low = .;                           
                           .= . + 0x13C;
                           StackFIQ_High= .;

                           .  = . + 0x04;
                           StackABORT_Low  = .;                           
                           . = . + 0x3C;
                           StackABORT_High = .;

                           .  = . + 0x04;
                           StackUNDEF_Low  = .;                           
                           .  = .  + 0x3C;
                           StackUNDEF_High  = .;                           

                        } (NOLOAD) > STACKS                 /* Stack Area                   */

    .Saved_Reset      : SIZE(RESET_NO_INIT_SECTION_LENGTH), START(RESET_NO_INIT_SECTION_START)
                        {
                           * (.Saved_Reset)
                           * (.Boot_Reset_Saved)                           
                           . = . + (0x0C - .);              /* Reserve the remaining space   */                        
                        } > RESET_NOINIT, type=NOLOAD, type=NOINIT       /* Saved Exception IP value     */

    .Saved_PC         : SIZE(SAVED_PC_SECTION_LENGTH), START(SAVED_PC_SECTION_START)
                        {
                           * (.Saved_PC)
                           . = . + (0x04 - .);              /* Reserve the remaining space   */                        
                        } > CSP_IP, type=NOINIT             /* Saved Exception IP value     */



    .FREE_NVM_BUFFER_SECTION  : 
                        {
                                   /* FREE NVM Buffer Section for NVM Write */
                                   ram_free_block_bot = .;
                                   . = . + 0x100;           /* Reserve the remaining space   */
                                   _ram_free_block_top = .;                                   
                        } load = FREE_NVM_BUF, type=NOLOAD  /* NVM Write RAM Buffer Area    */


    .MANUF_RAM_BLOCK  : SIZE (_MANUF_RAM_BLOCK_SIZE)
                        {
                           RAM_Const_Manuf_Block_V = .;
                           ram_manuf_block_bot = .;
                           _s_Cust_Flash_Manuf_1 = .;
                           MANUF_DATA_BOT = .;
                           * (.MANUF_SECTION)  { SIZE (_MANUF_RAM_BLOCK_DATA_SIZE) }
                           MANUF_DATA_START_LOCATION = ram_manuf_block_bot + 0x08;
                           . = . + (0x80 - .);              /* Reserve the remaining space   */
                        } > MANUF_RAM, type=NOINIT, type=NOLOAD   /* Manufacturing RAM Area       */
/*
    .opswpsa : 
                        {
                           
                        } type=DSECT, load = 0x00010030  */    /* Alternate 32-Bit Array PSA Image */
/*
    .calpsa : 
                        {
                           
                        } type=DSECT, load = 0x00018030  */    /* Alternate 32-Bit Array PSA Image */

/*---------------------------------------
 | Define Device Dependent Peripheral Registers Locations in Memory Space
 +--------------------------------------- */

    /* Register Address assignments */
    
    .ADC_Registers       : {} > ADC,      type=NOLOAD, type=NOINIT
    .ADC_RAM             : {
                             ADC_RAM_START_ADDRESS= .;
                            
                            } > ADC_RAM,  type=NOLOAD, type=NOINIT        
    .FLASH_Registers     : {
                            _FLASH_CONTROL_ADDRESS= .;
                            } > FLASH,    type=NOLOAD, type=NOINIT
    .GIO_Registers       : {} > GIO,      type=NOLOAD, type=NOINIT
    .HET_Registers       : {} > HET,      type=NOLOAD, type=NOINIT
    .SCC_Registers       : {} > SCC,      type=NOLOAD, type=NOINIT
    .DCAN2_Registers     : {} > DCAN2,    type=NOLOAD, type=NOINIT




    .SCILIN1_Registers   : {} > SCILIN1,  type=NOLOAD, type=NOINIT
    .SPI1_Registers      : {} > SPI1,     type=NOLOAD, type=NOINIT
/*    .SPI1_RAM            : {} > SPI1_RAM, type=NOLOAD, type=NOINIT            */
    .SPI2_Registers      : {} > SPI2,     type=NOLOAD, type=NOINIT
    .SPI3_Registers      : {} > SPI3,     type=NOLOAD, type=NOINIT    
    .PCR_Registers       : {} > PCR,      type=NOLOAD, type=NOINIT
    .VIM_Parity_Registers       : {} > VIM_PAR,      type=NOLOAD, type=NOINIT    
    .VIM_Registers       : {} > VIM,      type=NOLOAD, type=NOINIT    
    .VIM_RAM             : {} > VIM_RAM,  type=NOLOAD, type=NOINIT
    .VIM_PAR_RAM         : {} > VIM_PAR_RAM,  type=NOLOAD, type=NOINIT            
    .SYS_Registers       : {} > SYS,      type=NOLOAD, type=NOINIT
    .RTI_Registers       : {} > RTI,      type=NOLOAD, type=NOINIT    
    .PBIST_Registers     : {} > PBIST,    type=NOLOAD, type=NOINIT    
    .CCM7_Registers      : {} > CCM7,     type=NOLOAD, type=NOINIT        
    .DMA_Registers       : {} > DMA,      type=NOLOAD, type=NOINIT            
    .RTP_Registers       : {} > RTP,      type=NOLOAD, type=NOINIT            
    .CRC_Registers       : {} > CRC,      type=NOLOAD, type=NOINIT            

    .DMA_PRAM            : {} > DMA_PRAM, type=NOLOAD, type=NOINIT            
    .DMA_WRAM            : {} > DMA_WRAM, type=NOLOAD, type=NOINIT                
    .RAM_ECC_Registers   : {} > RAMECC,   type=NOLOAD, type=NOINIT    
    .HETCODE             : {
                            _HET_ram_start_location = .;
                            e_HETPROGRAM1_UN = .;
                           }  > HET_RAM,  type=NOLOAD, type=NOINIT

    .ESM_Registers       : {} > ESM,      type=NOLOAD, type=NOINIT
    .HTU_Registers       : {} > HTU,      type=NOLOAD, type=NOINIT

    .SPI1_RAM : START(SPI1_RAM_START) SIZE(SPI1_RAM_LENGTH)
                        {
                           * (.SPI1_RAM)
                           . = . + (0x400 - .);              /* Reserve the remaining space   */
                        } load = SPI1_RAM, type=NOLOAD, type=NOINIT



    .SPI1_TX_RAM : START(SPI1_TX_RAM_START) SIZE(SPI1_TX_RAM_LENGTH)
                        {
                           . = . + (0x200 - .);           
                        } load = SPI1_RAM, type=NOLOAD, type=NOINIT, type=DSECT

/*
    .SPI1_RX_RAM : START(SPI1_RX_RAM_START) SIZE(SPI1_RX_RAM_LENGTH)
                        {
                           . = . + (0x200 - .);          
                        } load = SPI1_RX_RAM, type=NOLOAD, type=NOINIT
*/

    .ECC_RAM : START(ECC_RAM_START) SIZE(ECC_RAM_LENGTH)
                        {
                           * (.ECC_RAM)
                           . = . + (0xC000 - .);              /* Reserve the remaining space   */
                        } load = ECC_RAM, type=NOLOAD, type=NOINIT

}

/*=============================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *==============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 03/11/08   P. Roy
 *   Created an initial version of Linker Command File for 78_08C01 Release.
 * 
 * 03/25/08   P. Roy
 *   Removed temporary CAL_BLOCK1 as used for temporary build.
 *   Without an SCR for DBC_Layer2/78_08C02 Release.
 *
 * 04/02/08   P. Roy   SCR tcb_css#2855 for release DBC7p8_App/01_Harley_SCJ
 *   Added Managed RAM Area.
 *   With a SCR tcb_css#2855 for DBC_Layer2/78_08C01a Release Building Block.
 *
 * 04/07/08   P. Roy   SCR tcb_css#2855 for release DBC7p8_App/01_Harley_SCJ
 *   Removed NOLOAD for bss section as i695x.exe will not generate smb file.
 *   Retained NOLOAD for section for which we don't need ATI/CCP ASAP2 Measurement
 *   symbols.
 *
 * 04/20/08   P. Roy   SCR tcb_css#2975 for release DBC_Layer2/78_08C03
 *   Removed .cinit section for DBC_Layer2/78_08C03 Release.
 *   Readjusted BootLoader Area header sizes.
 *   Boot Code section contains Flash Key. Hence it was broken into 2 separate
 *   entities as Linker won't distribute it otherwise.
 *   
 * 06/11/08   P. Roy   SCR tcb_css#2975 for release DBC_Layer2/78_08C03
 *   Removed .flashcode section for DBC_Layer2/78_08C03 Release.
 *   Peer Review fixes.
 *   Added comments.
 *   Readjusted all the MEMORY commands START/END addresses.
 *   Added _IRAM_BOTTOM and _IRAM_TOP symbols.
 *
 * 08/25/08   P. Roy   SCR tcb_css#3071 for release DBC_Layer2/78_08C04
 *   Removed FLASH_DLD_RAM section for DBC_Layer2/78_08C04 Release.
 *
 * 02/09/08   P. Roy   SCR tcb_css#3071 for release DBC_Layer2/78_08C04
 *   Renamed .boot_text to .boot because of i6lgen and COFF Section Name Length
 *
 * 09/21/08   P. Roy   SCR tcb_css#3071 for release DBC_Layer2/78_08C04
 *   Readjusted the addresses so that Application CAL/APP Header fits.
 *
 * 09/26/08   P. Roy   SCR tcb_css#3071 for release DBC_Layer2/78_08C04
 *   Modified .NVM_RAM_BLOCK section.
 *
 * 10/18/08   P. Roy   SCR tcb_css#3190 for release DBC_Layer2/78_08C04a
 *   Modified to use Boot Image properly.
 *
 * 10/29/08   P. Roy   SCR tcb_css#3190 for release DBC_Layer2/78_08C04a
 *   Modified to create different symbols properly.
 *
 * 11/02/08   P. Roy   SCR tcb_css#3190 for release DBC_Layer2/78_08C04a
 *   Modified to allocate footer and header always either in Boot or in App.
 *
 * 03/07/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC06
 *   Modified to allocate Bootloader Downloaded RAM area.
 *
 * 04/03/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC06
 *   Modified to allocate Bootloader Downloaded RAM area and 24K Boot.
 * 
 * 04/15/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC06
 *   Modified to allocate SCR 3466 related changes.
 *
 * 04/23/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC06
 *   Modified to remove all module header symbols.
 *
 * 06/05/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC07
 *   Modified to include new Flash Library Driver.
 *
 * 06/16/09   P. Roy   SCR tcb_css#XXXX for release DBC_Layer2/78_08KC07
 *   Removed Managed_RAM_Area to linkers_ti.cmd file
 *
 * 10/10/09   P. Roy  SCR tcb_css#XXX for release DBC_Layer2/78_08KC09
 *   Clean up of unused symbols
 *  
 * 11/24/09 Nandu SCR tcb_css#3984 for release DBC_Layer2/78_08KC09.
 *   Added RAM_Stack_Top_Key & RAM_Stack_Bottom_Key ,RAM_Stack_IRQ_Bottom_Key
 *   RAM_Stack_IRQ_Top_Key for Stack Underflow/Overflow test 
 *  
 * 12/21/09 P. Roy SCR tcb_css#3930 for release DBC7p8_Boot/06_BOOT_SCC.
 *   Added Initialize_Flash_Driver_Routines offset
 *   Modified Dnld_Data_Buffer length
 *
 * 01/25/10 R. O'Dea SCR tcb_css#4102 for release DBC_Layer2/78_GEN02.
 *   Changed name of Cust_Flash_Manuf_Block_V to RAM_Const_Manuf_Block_V.
 *
 * 02/21/10 P. Roy SCR tcb_css#4159 for release DBC_Layer2/78_GEN02.
 *   Created a new Linker Symbol called _e_HETPROGRAM1_UN for HET VSS.
 *
 * 11/08/10 P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_12KC13
 *   Created a new 12V CPU Memory Map
 *
 * 01/10/11 P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_12KC14
 *   Added Parity and CRC
 * 
 * 03/07/11 P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_12KC15
 *   Increased STACK Size for 12V
 *
 * 03/16/11 P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_12KC15
 *   Added Weak_Symbol_Library.lno for Boot
 *
 * 05/11/11 P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   First version for 12V ECU with CAN ISO Boot and 64K Memory
 *
 * 05/20/11 P. Roy Cradle SCR 249 for release DBC7p8_Boot/10_BOOT_12C
 *   Tested with corresponding Test Stub
 *
 * 05/22/11 P. Roy Cradle SCR 249 for release DBC7p8_Boot/10_BOOT_12C
 *   Corrected Boot Parity size
 *
 * 05/25/11 P. Roy Cradle SCR 249 for release DBC7p8_Boot/10_BOOT_12C
 *   Corrected Duplicate Module Header PSA location for 64K
 *  
 * 05/26/11 Nayana Cradle_SCR#234 for release DBC_Layer2/78_12KC16
 *   Added HTU module address
 *
 * 07/07/11 P. Roy Cradle_SCR#XXX for release DBC_Layer2/78_12KC17
 *   Added ECC RAM address
 *
 * 08/22/11 P. Roy Cradle_SCR 424 for release DBC_Layer2/78_12KC17a
 *   Added VIM Parity Area
 *   Added Managed RAM Exception Save Area as DSECT for ATI
 *
 * 12/09/11 P. Roy SCR 522 for release DBC_Layer2/78_12KC20
 *   -Added DynDat_EXP1 and DynDat_EXP2 NVM Blocks
 *
 * 12/20/11 P. Roy SCR 522 for release DBC_Layer2/78_12KC20
 *   -Corrected RAM End Boundary
 *             
\*=============================================================================*/
