/*=============================================================================*\ 
 * Copyright 2008, Delphi Technologies, Inc., All Rights Reserved. 
 * Delphi Confidential
 * 
 * Module Name:     linkers_ti.cmd
 * Created By:      zzw378
 * Created Date:    Mon Jun  2 13:10:37 2008
 * %version:        tcb_css2#21.1.1 %
 * %cvtype:         ascii %
 * %instance:       tcb_css_2 %
 * %derived_by:     zxw378 %
 * %date_modified:  Wednesday, March 07, 2012 1:12:36 PM %  
\*=============================================================================*/   

/*******************************************************************************\
 *
 * File Description:
 *
 *   This file contains the Linker Command File for TI Compiler to 
 *   build dbc packages.
 *   Traces to: None.
 *
 *   Deviations from software standards: NA
 *
\*******************************************************************************/

--retain=CCP_BOOT
--retain=Jump_App_To_Boot
--retain=Flash_Block_1
--retain=Flash_Block_2
--retain=NVM_cust_block_id

MEMORY
{
   /* Flash Section Names */
   FLASH_DLD_RAM1  (R)   : origin = 0x00C00E00  len = 0x00000800  /* CCP Flash Routine Area  */
    
}

/* -- From Flash_Hex_Array.map

.flashvecs 
*          0    00100e18    0000004c     
                  00100e18    00000010     flash_erase_vector.obj (.text)
                  00100e28    00000010     flash_compact_vector.obj (.text)
                  00100e38    00000014     flash_prog_vector.obj (.text)
                  00100e4c    00000010     flash_verify_vector.obj (.text)
                  00100e5c    00000008     flash_match_key_vector.obj (.text)

00000504   FLASH_COMPACT_OFFSET
00000484   FLASH_ERASE_SECTOR_OFFSET
00000374   FLASH_MATCH_KEY_OFFSET
00000594   FLASH_PROG_OFFSET
00000000   FLASH_SIGNATURE_OFFSET
000005b4   FLASH_VERIFY_OFFSET

FLASH_MATCH_KEY_OFFSET=0x00000374;
FLASH_ERASE_SECTOR_OFFSET=0x00000484;
FLASH_COMPACT_OFFSET=0x00000504;
FLASH_PROG_OFFSET=0x00000594;
FLASH_VERIFY_OFFSET=0x000005b4;

*/

DELETE_FLAG_FOR_ALL_ROM = 0x900000;


SECTIONS
{

    .dummies       : 
                        {

                        } > APP_BLOCK1, type=NOLOAD      /* Application Code Area        */

    .cinit : 
                        {

                        }  > ROM_BOOT              

    
    .flashcode        : SIZE(ROM_FLASH_CODE)
                        {
                           Start_of_ROM_Flash_Code = .;
                           
                        } > ROM_BOOT                    /* CCP Flash Code in ROM                 */

    .Managed_RAM_Area : SIZE(MANAGED_RAM_DATA_LENGTH)
                        {
                           MANAGED_RAM_START_LOCATION = .;
                           * (.Managed_RAM_Area) { SIZE(_MANAGED_RAM_CONTENT_LENGTH) }
/*..\dbc_gen\Test_Stub\htmanram.obj (.bss) */
                           
                           . = . + (0xF0 - .);              /* Reserve the remaining space   */
                        } > MANAGED_RAM                     /* Managed RAM Application Area  */

    .opswhdr          : SIZE(_OP_SW_ACTUAL_HEADER_SIZE)
                        {
                          _APP_ROM_START = .;
                          START_OF_APP_ROM = .;
                          _OP_SW_HEADER_ADDRESS=.;
                          _OP_SW_HEADER_END_LOCATION = _OP_SW_HEADER_ADDRESS + _OP_SW_ACTUAL_HEADER_SIZE;
                        } > APP_HEADER                       /* App Header for Boot Usage    */


    .calhdr           : SIZE(_CAL_HEADER_ACTUAL_SIZE)
                        {
                          START_OF_CAL_ROM= .;
                          END_OF_APP_ROM = .;
                          _CALIB_HEADER_ADDRESS = .;
                          _CAL_HEADER_END_LOCATION = _CALIB_HEADER_ADDRESS + _CAL_HEADER_ACTUAL_SIZE;
                        } > CAL_HEADER                      /* CAL Header for Boot Usage    */

    .calftr           : START(CAL_FOOTER_START), SIZE(_CAL_FOOTER_DATA_LENGTH), END(END_OF_CAL_ROM)
                        {
                          Last_Byte_CE_Cals_Not_Programmed_Flag = . + 0x03;
                          * (.calftr)

                          . = . + (0x004 - .);              /* Reserve the remaining space  */
                          SIZE_OF_CAL_BLOCK=. - START_OF_CAL_ROM;
                        } > CAL_FOOTER                      /* CAL Footer for Boot Usage    */

    .opswftr          : START(APP_FOOTER_START), SIZE(_APP_FOOTER_DATA_LENGTH), END(END_OF_APP_ROM2)
                        {

                          Last_Byte_CE_Op_Sw_Not_Programmed_Flag = . + 0x03;
                          * (.opswftr)
/*..\dbc_gen\asw\gbswmftr.obj (.const) */

                          . = . + (0x004 - .);              /* Reserve the remaining space  */
                          SIZE_OF_APP_BLOCK= . - START_OF_APP_ROM - SIZE_OF_CAL_BLOCK;
                        } > APP_FOOTER                      /* App Footer for Boot Usage    */ 

    .fblheader        :  END(BOOT_END_ADDRESS)
                        {
                          FBL_HEADER_START = .;
                          * (.fblheader)
/*..\dbc_gen\Test_Stub\h2botjmp.obj (.const)   */
                          CCP_BOOT_HEADER_START = .;                          
                          * (.CCP_BOOT)
                        } > FBL_HDR                         /* App to Boot Jump Info Table  */     

    
         GROUP          : START(START_OF_BSS_RAM)          
                        {
.ccp_payload          :   /*fill=0x00*/
                          {
                          * (.ccp_payload) {START(_START_OF_CCP_PAYLOAD) SIZE(SIZE_OF_CCP_PAYLOAD)}                          
                          } type=NOLOAD, type=NOINIT

.ccp_parity_payload          :   /*fill=0x00*/
                          {
                          * (.ccp_parity_payload) {START(_START_OF_CCP_PARITY_PAYLOAD) SIZE(SIZE_OF_CCP_PARITY_PAYLOAD)}                          
                          } type=NOLOAD, type=NOINIT
                     
.ccp_ram              :   /*fill=0x00*/
                          {                         
			
                          * (.ccp_ram) {START(_START_OF_CCP_RAM) SIZE(_SIZE_OF_CCP_RAM)}
                          } type=NOINIT
.bss              :   /*fill=0x00*/
                        {                         
                         /* * (.bss) {START(_START_OF_DATA) SIZE(_SIZE_OF_DATA)} */
                           START_OF_DATA = .;
                          _REPROGRAMMING_PAYLOAD_BUFFER_LENGTH = START_OF_BSS_RAM - Dnld_Data_Buffer;

                          } align(256), type=NOINIT   
                          
.data              :   
                        {                         

                          } align(256)   

.TestECC              :  START(START_OF_TEST_ECC_RAM)   
                        {                         

                          } align(256)   
                        
                        } > RAM (HIGH)                    /* DATA and BSS Area            */    

                          
                        


    .NVM_RAM_BLOCK    : /*fill=0x00*/
                        {


                        _ram_dyn_dat_low_bot = .;

                        * (.Low_ID_RAM)
                        * (.Low_NVM_RAM)
                        * (.Dynamic_Data_Low_RAM_Area)                        
                        . = . + ((0x100 - 0x08) - .);       /* Checksum area                         */
                        * (.Low_Cksum_RAM)


                        _ram_dyn_dat_med_bot = .;

                        * (.Med_ID_RAM)
                        * (.Med_NVM_RAM)
                        * (.Dynamic_Data_Med_RAM_Area)                        
                        . = . + ((0x200 - 0x08) - .);       /* Checksum area                         */
                        * (.Med_Cksum_RAM)


                        _ram_dyn_dat_high_bot = .;

                        * (.High_ID_RAM)
                        * (.High_NVM_RAM)
                        * (.Dynamic_Data_High_RAM_Area)                        
                        . = . + ((0x300 - 0x08) - .);       /* Checksum area                         */
                        * (.High_Cksum_RAM)


                        ram_cust_cal_ID_bot = .;           /* hisvnvm.c uses this symbol for write  */

                        * (.Cust_ID_RAM)
.\nvm_custid.obj   (.data)                        
                        . = . + 0x02;                       /* 4-byte alignment because of init.asm  */
                        ram_cust_cal_bot = .;              /* init.asm uses this symbol for default */          
                        * (.Cust_NVM_RAM)  { SIZE(Size_Of_CUST_RAM) }
.\custdata.obj (.bss) { SIZE(Size_Of_CUSTDATA) }
                        . = . + ((0x400 - 0x08) - .);       /* Checksum area                         */
                        * (.Cust_Cksum_RAM)
                        
                        _NVMRAM_TOP = .;






                        } > NVM_RAM, type=NOLOAD, type=NOINIT                         /* Dynamic NVM RAM Area         */

    .BLOCK1 : START(TEST_PSA_CAL_BLOCK_START)  END(TEST_PSA_CAL_BLOCK_END)
                        {
/*..\Boot_Gen\test\test_cal_image.obj (.BLOCK1) */
                        } load = (CAL_BLOCK align(8)) (HIGH)       /* DBC_Layer2 project's CONSTANT Data [No CALDEF] */

    .BLOCK2 : START(TEST_PSA_APP_BLOCK_START)  END(TEST_PSA_APP_BLOCK_END)
                        {
/*..\dbc_gen\Test_Stub\test_psa_image.obj (.BLOCK2)*/
                        } load = (APP_BLOCK2 align(8)) (HIGH)       /* DBC_Layer2 project's CONSTANT Data [No CALDEF] */

    .ROM_PAR : START(TEST_ROM_PARITY_BLOCK_START)  END(TEST_ROM_PARITY_BLOCK_END)
                        {
.\dbcBootCAN.lno (.ROM_PAR)
                        } load = (APP_BLOCK2 align(8)) (HIGH)

    .BOOT_PSA :
                        {
.\dbcBootCAN.lno (.BOOT_PSA)
                        } load = (BOOT_PSA align(8))

}

/*=============================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *==============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 06/02/08   P. Roy   SCR tcb_css#XXXX for release DBC7p8_Boot/GMLAN_2
 *   Created an initial version of Linker Command File.
 *
 * 11/03/08   P. Roy   SCR tcb_css#XXXX for release DBC7p8_Boot/00_Baseline_JCKA
 *   Added .bss.
 *
 * 03/07/09   P. Roy   SCR tcb_css#XXXX for release DBC7p8_Boot/01_Baseline_JCKA
 *   Added modifications for Download RAM area
 *
 * 05/20/09   P. Roy   SCR tcb_css#XXXX for release DBC7p8_Boot/01_Baseline_JCKA
 *   Added _DELETE_FLAG_FOR_ALL_ROM
 *
 * 10/07/09   Sunil   SCR tcb_css#3835 for release DBC7p8_Boot/05_BOOT_08K
 *   Added .dummies section.
 *
 * 10/10/09   P. Roy  SCR tcb_css#3835 for release DBC7p8_Boot/05_BOOT_08K
 *   Added removed sections of linker_ti.cmd
 *
 * 12/21/09   P. Roy  SCR tcb_css#XXXX for release DBC7p8_Boot/06_BOOT_SCC
 *   Relocated dummies section outside Boot Image
 *
 * 08/11/10   P. Roy  SCR tcb_css#4448 for release DBC7p8_Boot/08_BOOT_08K
 *   Added NVM related items for Customer Data Block as it contains MEC
 *
 * 09/13/10   P. Roy  SCR tcb_css#4478 for release DBC7p8_Boot/08_BOOT_08K
 *   Created linker symbol REPROGRAMMING_PAYLOAD_BUFFER_LENGTH
 *   to determine if download buffer area is overflowing or not.
 *
 * 03/09/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/09_BOOT_12C
 *   First version for 12V ECU
 *
 * 05/11/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Corrceted for ELF Mode of Compiler
 *
 * 05/25/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Added BOOT_PSA section
 *   Created Symbols for APP and CAL Footer sections
 *
 * 06/10/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Corrected SIZE_OF_APP_BLOCK
 *
 * 06/27/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Added Test_ECC
 *     
 * 09/27/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Added NOINIT in order to remove the AUTO_INIT Tables
 *
 * 09/27/11   P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/10_BOOT_12C
 *   Removed unnecessary FILL option
 *
 * 12/13/11   P. Roy SCR 628 for release DBC7p8_Boot/11_BOOT_12C
 *   Corrceted MEC location within Customer Data Block NVM
 *       
\*=============================================================================*/
