#ifndef CHIPREG_H
#define CHIPREG_H
/*===========================================================================*\
* Module Name:     chipreg.h
* Created By:      zzw378
* Created Date:    Sat Sep 11 16:25:05 2010
* %version:        tcb_css2#13 %
* %cvtype:         incl %
* %instance:       tcbtut64_1 %
* %derived_by:     zxw378 %
* %date_modified:  Monday, November 21, 2011 12:38:54 PM %
\*===========================================================================*/
/*=============================================================================*\
* Copyright 2011, BWI Group, North America, All Rights Reserved.
* BWI Confidential
*------------------------------------------------------------------------------
*
* File Description:
*   This module contains the header information for the DBC7.8 Layer 2 low side drive
*   software.
*
* Traces to:  DCBC7.8 Layer 2 I_O.doc
*
* Applicable standards:
*    Developed according to BWI C Coding Standards
*
* History Log is at the end of this file.
*
****************************************************************************/
/******************************
* Includes
*******************************/
#if 0
#include "adcreg.h"
#include "c2sireg.h"
#include "flashreg.h"
#include "gioreg.h"
#include "hetreg.h"
#include "i2creg.h"
#include "sccreg.h"
#include "scireg.h"
#include "spireg.h"
#endif

#include "sysreg.h"

//#include "crcreg.h"
//#include "systype.h"


/******************************
* Defines
*******************************/

#define RAM_CLEAR_ADDRESS_OFFSET   (0x100000U)   /* Scale is (unsigned8_T *) */
#define RAM_SET_ADDRESS_OFFSET     (0x080000U)   /* Scale is (unsigned8_T *) */

/******************************
* Macros
*******************************/

#define Update_Real_Time_Clock_Counter_For_Next_Tick(next_tick)
#define Clear_Real_Time_Clock_Tick_Interrupt_Request_Flag()           CLEAR_RTI_PERIPHERAL_INTERRUPT_FLAGS(RTI_INT0)
#define Clear_EOL_Real_Time_Clock_Tick_Interrupt_Request_Flag()       CLEAR_RTI_PERIPHERAL_INTERRUPT_FLAGS(RTI_INT1)

/******************************
* Types
*******************************/

/* None                       */

/******************************
* Calibrations
*******************************/

/* None                       */

/******************************
* Global Variables
*******************************/
#if 0
extern  volatile ADCREG_T     ADC;
extern  volatile unsigned32_T ADCRAM[];
extern  volatile C2SIREG_T    C2SI;
extern  volatile FLASHREG_T   FLASH;
extern  volatile GIOREG_T     GIO;
extern  volatile HETREG_T     HET;
extern  volatile I2CREG_T     I2C;
extern  volatile DCANREG_T    DCAN1;
extern  volatile DCANREG_T    DCAN2;

extern  volatile SCILINREG_T  SCILIN1;

extern  volatile SCILINREG_T  SCILIN2;
extern  volatile SCILINREG_T  SCILIN3;

extern  volatile SPIREG_T     SPI1;

extern  volatile SPIREG_T     SPI2;
extern  volatile SPIREG_T     SPI3;

extern  volatile PCRREG_T     PCR;
#endif

extern  volatile SYSREG_T     SYS;
extern  volatile VIMREG_T     VIM;
extern  volatile VIMPARREG_T  VIM_PAR;
extern  volatile VIMRAM_T     VIMRAM;
extern  volatile VIMRAM_T     VIMPARRAM;
extern  volatile RAMECCREG_T  RAMECCREG;
extern  volatile RTIREG_T     RTI;
extern  volatile PBISTREG_T   PBIST;
extern  volatile CCM7REG_T    CCM7;
extern  volatile DMAREG_T     DMA;
extern  volatile RTPREG_T     RTP;
//extern  volatile CRCREG_T     CRC;
extern  volatile DMA_PRIMARY_CONTROL_PACKET_T DMA_PRIMARY_CONTROL_PACKET;
extern  volatile DMA_WORKING_CONTROL_PACKET_T const DMA_WORKING_CONTROL_PACKET;

//extern  SPI_MULTIBUFFER_T  SPI1_MULTIBUFFER;

extern  volatile ESMREG_T     ESM;

//extern  volatile HTUREG_T     HTU;

extern  volatile VIMPARREG_T  VIM_PAR;

/*******************************
* Interface Declarations
*******************************/

/*   None                     */

/******************************
* Function Prototypes
*******************************/

/*   None                     */

/*===========================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 11/08/10  P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_12KC13
 *  Initial version with History Log
 *
 * 01/20/11  P. Roy SCR tcb_css#XXXX for release TMS470_Registers/12V_1.48
 *  Added CRC Register
 *
 * 05/03/11   Nayana  Cradle_SCR#234 for release DBC_Layer2/78_12KC16.
 *  Added HTU and VIM_PAR registers
 *  Header is changed according to BWI standard
 *
 * 05/18/11  Nandu Cradle SCR 233 for release TMS470_Registers/12V_1.49
 *  Added VIM_PAR
 *
 * 12/09/11  P. Roy Cradle SCR 522 for release TMS470_Registers/12V_1.55
 *  Added RAM SET and CLEAR Space
 *
\*===========================================================================*/

#endif


