#ifndef HHCPUCHK_H
#define HHCPUCHK_H
/*=============================================================================*\
 * Module Name:     hhcpuchk.h
 * Created By:      wz788h
 * Created Date:    Fri Apr  4 13:12:55 2008
 * %version:        tcb_css2#11 %
 * %cvtype:         incl %
 * %instance:       tci_css3_1 %
 * %derived_by:     jxw3er %
 * %date_modified:  Wednesday, May 30, 2012 12:22:52 AM %
\*=============================================================================*/
 /*=============================================================================*\
 * Copyright 2011, BWI Group, North America, All Rights Reserved.
 * BWI Confidential
 *------------------------------------------------------------------------------
 *
 * Description:
 *   This module contains the implementation of the DBC7.8 Layer 2
 *   CPU Check related software.
 *
 * Traces to: DBC7_8_ECU_Failsafe.doc
 *
 *
 * Applicable standards:
 *    Developed according to BWI C Coding Standards
 *
 * History Log is at the end of this file.
 *
\*=============================================================================*/

#include "systype.h"


/******************************
* Defines
*******************************/

/*   none                     */

/******************************
* Macros
*******************************/

/*   none                     */

/******************************
* Types
*******************************/

typedef enum{
   MU_STATE_DATA_SIZE_0,
   MU_STATE_DATA_SIZE_1,
   MU_STATE_DATA_SIZE_2,
   MU_STATE_DATA_SIZE
   }buff_siz_T;


/******************************
* Calibrations
*******************************/

/*   none                     */

/******************************
* Global Variables
*******************************/

/*   none                     */
/*************************
* Interface Declarations
*************************/

typedef union {
     unsigned16_T  fault_word;
     struct {

            bit_field16_T   : 1;
            bit_field16_T   het_tu_memory_protection_error : 1;
            bit_field16_T   dma_transaction_error : 1;
            bit_field16_T   dma_memory_protection_error : 1;
            bit_field16_T   mcu_illegal_transaction : 1;
            bit_field16_T   mcu_precise_cpu_transaction_err : 1;
            bit_field16_T   mcu_cpu_data_bus_parity_failed : 1;
            bit_field16_T   mcu_cpu_compare_failed  : 1;
            bit_field16_T   mcu_program_flow_monitoring_failed : 1;
            bit_field16_T   mcu_test_case_failed : 1;
            bit_field16_T   mcu_sol_sply_mc_disable_fail_b: 1;
            bit_field16_T   mcu_invalid_code_branch : 1;
            bit_field16_T   mcu_mu_swref_failed : 1;
            bit_field16_T   mcu_sol_sply_mc_disable_fail : 1;
            bit_field16_T   mcu_flash_crosscheck_by_mu_failed : 1;
            bit_field16_T   mcu_mc_communication_error : 1;
     } mcu_cpu_state;
} mcu_cpu_state_T;

typedef union {
     unsigned16_T  fault_word;
     struct {
            bit_field_T   mcu_startup_test_failed:1;
            bit_field_T   mcu_mu_init_test_failed:1;
            bit_field_T   mcu_mu_over_temperature:1;
            bit_field_T   mcu_mu_overvoltage_detected:1;
            bit_field_T   mcu_mu_undervoltage_detected:1;
            bit_field_T   mcu_sol_supply_test_failed_off_b : 1;
            bit_field_T   mcu_sol_supply_test_failed_off : 1;
            bit_field_T   mcu_sol_supply_test_aborted_b : 1;
            bit_field_T   mcu_sol_sply_mu_disable_fail_b: 1;
            bit_field_T   mcu_sol_supply_test_aborted: 1;
            bit_field_T   mcu_mu_ram_failed : 1;
            bit_field_T   mcu_mu_flash_failed : 1;
            bit_field_T   mcu_mu_rev_level_failed : 1;
            bit_field_T   mcu_sol_sply_mu_disable_fail : 1;
            bit_field_T   mcu_flash_crosscheck_by_mc_failed:1;
            bit_field_T   mcu_mu_communication_error:1;
     } mcu_cpu_failsafe_state;
} mcu_cpu_failsafe_state_T;

#ifdef L2_ERR_PIN_CTRL_CHECK_INTF
#if COMPILE_BITFIELD_LSB_FIRST
typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   high_state_test_bypassed:1;
      bit_field8_T   err_pin_stuck_low:1;
      bit_field8_T   sysout_en_failed_low:1;
      bit_field8_T   sysout_en_failed_high:1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
   } error_pin_ctrl_test_result_bits;
} error_pin_ctrl_test_result_T;

#else

typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   sysout_en_failed_high:1;
      bit_field8_T   sysout_en_failed_low:1;
      bit_field8_T   err_pin_stuck_low:1;
      bit_field8_T   high_state_test_bypassed:1;
   } error_pin_ctrl_test_result_bits;
} error_pin_ctrl_test_result_T;

#endif

typedef struct
{
   error_pin_ctrl_test_result_T   Error_Pin_Ctrl_Test_Result;
}L2_Error_Pin_Ctrl_Test_Intf_T;

extern L2_Error_Pin_Ctrl_Test_Intf_T   L2_Error_Pin_Ctrl_Test_Intf;

#define Get_Error_Pin_Ctrl_Test_Result() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.fault_byte)
#define Update_Error_Pin_Ctrl_Test_Result(value) \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.fault_byte = (value))

#define Get_High_State_Test_Bypassed() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.high_state_test_bypassed)
#define Set_High_State_Test_Bypassed() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.high_state_test_bypassed = TRUE)
#define Clear_High_State_Test_Bypassed() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.high_state_test_bypassed = FALSE)

#define Get_Err_Pin_Stuck_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.err_pin_stuck_low)
#define Set_Err_Pin_Stuck_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.err_pin_stuck_low= TRUE)
#define Clear_Err_Pin_Stuck_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.err_pin_stuck_low = FALSE)

#define Get_Sysout_En_Failed_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_low)
#define Set_Sysout_En_Failed_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_low = TRUE)
#define Clear_Sysout_En_Failed_Low() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_low = FALSE)

#define Get_Sysout_En_Failed_High() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_high)
#define Set_Sysout_En_Failed_High() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_high = TRUE)
#define Clear_Sysout_En_Failed_High() \
           (L2_Error_Pin_Ctrl_Test_Intf.Error_Pin_Ctrl_Test_Result.error_pin_ctrl_test_result_bits.sysout_en_failed_high = FALSE)

#endif

#ifdef L2_CCM_SELF_TEST_INTF
#if COMPILE_BITFIELD_LSB_FIRST
typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   compare_test_passed:1;
      bit_field8_T   error_forcing_passed:1;
      bit_field8_T   initial_state_failed:1;
      bit_field8_T   test_did_not_complete:1;
      bit_field8_T   compare_error_present:1;
      bit_field8_T   compare_match_failed:1;
      bit_field8_T   compare_mismatch_failed:1;
      bit_field8_T   lock_step_return_failed:1;
   } cpu_compare_self_test_state_bits;
} cpu_compare_self_test_state_T;

#else

typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   lock_step_return_failed:1;
      bit_field8_T   compare_mismatch_failed:1;
      bit_field8_T   compare_match_failed:1;
      bit_field8_T   compare_error_present:1;
      bit_field8_T   test_did_not_complete:1;
      bit_field8_T   initial_state_failed:1;
      bit_field8_T   error_forcing_passed:1;
      bit_field8_T   compare_test_passed:1;
   } cpu_compare_self_test_state_bits;
} cpu_compare_self_test_state_T;

#endif

typedef struct
{
   cpu_compare_self_test_state_T   CPU_Compare_Self_Test_State;
}L2_CPU_Compare_Self_Test_Intf_T;

extern L2_CPU_Compare_Self_Test_Intf_T   L2_CPU_Compare_Self_Test_Intf;

#define Get_CPU_Compare_Self_Test_State() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.fault_byte)
#define Update_CPU_Compare_Self_Test_State(value) \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.fault_byte = (value))

#define Get_Initial_State_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.initial_state_failed)
#define Set_Initial_State_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.initial_state_failed = TRUE)
#define Clear_Initial_State_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.initial_state_failed = FALSE)

#define Get_Compare_Mismatch_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_mismatch_failed)
#define Set_Compare_Mismatch_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_mismatch_failed = TRUE)
#define Clear_Compare_Mismatch_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_mismatch_failed = FALSE)

#define Get_Compare_Match_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_match_failed)
#define Set_Compare_Match_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_match_failed = TRUE)
#define Clear_Compare_Match_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_match_failed = FALSE)

#define Get_Compare_Error_Present() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_error_present)
#define Set_Compare_Error_Present() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_error_present = TRUE)
#define Clear_Compare_Error_Present() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_error_present = FALSE)

#define Get_Test_Did_Not_Complete() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.test_did_not_complete)
#define Set_Test_Did_Not_Complete() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.test_did_not_complete = TRUE)
#define Clear_Test_Did_Not_Complete() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.test_did_not_complete = FALSE)

#define Get_Compare_Test_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_test_passed)
#define Set_Compare_Test_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_test_passed = TRUE)
#define Clear_Compare_Test_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.compare_test_passed = FALSE)

#define Get_Lock_Step_Return_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.lock_step_return_failed)
#define Set_Lock_Step_Return_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.lock_step_return_failed = TRUE)
#define Clear_Lock_Step_Return_Failed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.lock_step_return_failed = FALSE)

#define Get_Error_Forcing_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.error_forcing_passed)
#define Set_Error_Forcing_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.error_forcing_passed = TRUE)
#define Clear_Error_Forcing_Passed() \
           (L2_CPU_Compare_Self_Test_Intf.CPU_Compare_Self_Test_State.cpu_compare_self_test_state_bits.error_forcing_passed = FALSE)

#endif

#ifdef L2_RAM_ECC_SELF_TEST_INTF
#if COMPILE_BITFIELD_LSB_FIRST
typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   ecc_self_check_passed:1;
      bit_field8_T   single_bit_correction_failed:1;
      bit_field8_T   single_bit_detection_failed:1;
      bit_field8_T   error_state_not_cleared:1;
      bit_field8_T   double_bit_detection_failed:1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
   } ram_ecc_self_test_state_bits;
} ram_ecc_self_test_state_T;

#else

typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   double_bit_detection_failed:1;
      bit_field8_T   error_state_not_cleared:1;
      bit_field8_T   single_bit_detection_failed:1;
      bit_field8_T   single_bit_correction_failed:1;
      bit_field8_T   ecc_self_check_passed:1;
   } ram_ecc_self_test_state_bits;
} ram_ecc_self_test_state_T;

#endif

typedef struct
{
   ram_ecc_self_test_state_T   Ram_Ecc_Self_Test_State;
}L2_Ram_Ecc_Self_Test_Intf_T;

extern L2_Ram_Ecc_Self_Test_Intf_T   L2_Ram_Ecc_Self_Test_Intf;

#define Get_Ram_Ecc_Self_Test_State() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.fault_byte)
#define Update_Ram_Ecc_Self_Test_State(value) \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.fault_byte = (value))

#define Get_Single_Bit_Correction_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_correction_failed)
#define Set_Single_Bit_Correction_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_correction_failed = TRUE)
#define Clear_Single_Bit_Correction_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_correction_failed = FALSE)

#define Get_Ecc_Self_Check_Passed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.ecc_self_check_passed)
#define Set_Ecc_Self_Check_Passed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.ecc_self_check_passed = TRUE)
#define Clear_Ecc_Self_Check_Passed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.ecc_self_check_passed = FALSE)

#define Get_Double_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.double_bit_detection_failed)
#define Set_Double_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.double_bit_detection_failed = TRUE)
#define Clear_Double_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.double_bit_detection_failed = FALSE)

#define Get_Error_State_Not_Cleared() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.error_state_not_cleared)
#define Set_Error_State_Not_Cleared() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.error_state_not_cleared = TRUE)
#define Clear_Error_State_Not_Cleared() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.error_state_not_cleared = FALSE)

#define Get_Single_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_detection_failed)
#define Set_Single_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_detection_failed = TRUE)
#define Clear_Single_Bit_Detection_Failed() \
           (L2_Ram_Ecc_Self_Test_Intf.Ram_Ecc_Self_Test_State.ram_ecc_self_test_state_bits.single_bit_detection_failed = FALSE)

#endif

#ifdef L2_HET_PARITY_SELF_TEST_INTF
#if COMPILE_BITFIELD_LSB_FIRST
typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   forced_parity_err_passed:1;
      bit_field8_T   parity_err_detection_failed:1;
      bit_field8_T   parity_data_restore_failed:1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
   } ram_het_parity_self_test_state_bits;
} ram_het_parity_self_test_state_T;

#else
typedef union {
   unsigned8_T  fault_byte;
   struct {
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   :1;
      bit_field8_T   parity_data_restore_failed:1;
      bit_field8_T   parity_err_detection_failed:1;
      bit_field8_T   forced_parity_err_passed:1;
   } ram_het_parity_self_test_state_bits;
} ram_het_parity_self_test_state_T;

#endif

typedef struct
{
   ram_het_parity_self_test_state_T   Ram_Het_Parity_Self_Test_State;
}L2_Ram_Het_Parity_Self_Test_Intf_T;

extern L2_Ram_Het_Parity_Self_Test_Intf_T   L2_Ram_Het_Parity_Self_Test_Intf;

#define Get_Ram_Het_Parity_Self_Test_State() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.fault_byte)
#define Update_Ram_Het_Parity_Self_Test_State(value) \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.fault_byte = (value))

#define Get_Forced_Parity_Err_Passed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.forced_parity_err_passed)
#define Set_Forced_Parity_Err_Passed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.forced_parity_err_passed = TRUE)
#define Clear_Forced_Parity_Err_Passed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.forced_parity_err_passed = FALSE)

#define Get_Parity_Err_Detection_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_err_detection_failed)
#define Set_Parity_Err_Detection_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_err_detection_failed = TRUE)
#define Clear_Parity_Err_Detection_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_err_detection_failed = FALSE)

#define Get_Parity_Data_Restore_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_data_restore_failed)
#define Set_Parity_Data_Restore_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_data_restore_failed = TRUE)
#define Clear_Parity_Data_Restore_Failed() \
           (L2_Ram_Het_Parity_Self_Test_Intf.Ram_Het_Parity_Self_Test_State.ram_het_parity_self_test_state_bits.parity_data_restore_failed = FALSE)

#endif

extern boolean_T   MCU_CPU_Comp_Self_Test_Failed;

#define Get_MCU_CPU_Comp_Self_Test_Failed() \
           (MCU_CPU_Comp_Self_Test_Failed)
#define Set_MCU_CPU_Comp_Self_Test_Failed() \
           (MCU_CPU_Comp_Self_Test_Failed = TRUE)
#define Clear_MCU_CPU_Comp_Self_Test_Failed() \
           (MCU_CPU_Comp_Self_Test_Failed = FALSE)

/******************************
* Function Prototypes
*******************************/

extern unsigned16_T Update_MCU_CPU_State(void);
extern unsigned16_T Update_MCU_CPU_Failsafe_State(void);
extern void Update_MCU_MU_State_Data(unsigned8_T size, unsigned8_T *buffer_val);

/*===========================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 04/05/08 Abhishek SCR tcb_css#2887 for release DBC_Layer2/78_08C02.
 *   Created the initial version.
 *
 * 04/10/08 Abhishek SCR tcb_css#2887 for release DBC_Layer2/78_08C02.
 *   Fixed PR findings.
 *
 * 11/06/08 Abhishek SCR tcb_css#3209 for release DBC_Layer2/78_08C05.
 *  Added the new elements to mcu_cpu_failsafe_state_T structure.
 *
 * 10/27/09 P. Roy SCR tcb_css#3895 for release DBC_Layer2/78_08KC09.
 * Corrected compiler warnings -- corrected last newline
 *
 * 11/30/09 Chetan SCR tcb_css#4005 for release DBC_Layer2/78_08KC09.
 *   Implemented DSC Specific Changes as per LI Spec 1.05 Section 8.5.2.2.1
 *
 * 12/04/09 Chetan SCR tcb_css#4005 for release DBC_Layer2/78_08KC09.
 *   Implemented peer review comments
 *
 * 06/15/11 Sagar Pattnaik Cradle_SCR#235 for release DBC_Layer2/78_12KC17.
 *   Updated new element in mcu_cpu_state_T structure.
 *
 * 07/29/11 Sagar scr.424 for release DBC_Layer2/78_12KC17a.
 *   Updated fault_byte to fault_word.
 *   Updated return type of Update_MCU_CPU_State.
 *
 * 05/21/12 Sunil Naik scr.888 for release DBC_Layer2/78_12KC21
 *  Added mcu_startup_test_failed to mcu_cpu_failsafe_state_T structure.
 *  Added new interfaces variables
 *
 * 05/25/12 Sunil Naik scr.888 for release DBC_Layer2/78_12KC21
 *  Fixed the review findings.
 *
\*===========================================================================*/
#endif /*HHCPUCHK_H*/
