#ifndef HNSVROM_H
#define HNSVROM_H
/*=============================================================================*\
 * Module Name:     hnsvrom.h
 * Created By:      xzgq01
 * Created Date:    Tue Mar 09 10:31:35 2010
 * version:         1
 * cvtype:          incl
 * instance:        tcb_css_1
 * derived_by:      xzgq01
 * date_modified:   Tue Mar 09 10:31:35 2010
\*=============================================================================*/
 /*=============================================================================*\
 * Copyright 2011, BWI Group, North America, All Rights Reserved.
 * BWI Confidential
 *------------------------------------------------------------------------------
 *
 * Description:
 *   This module contains Background Task written variables like
 *   MC_Flash_Cross_Check_Background_Write
 *
 * Traces to: DCBC7.8 Layer 2 Logical Interface.doc
 *
 *
 * Applicable standards:
 *    Developed according to BWI C Coding Standards
 *
 * History Log is at the end of this file.
 *
\*=============================================================================*/

/******************************
* Includes
*******************************/
#include "systype.h"
/******************************
* Defines
*******************************/

  /* None */

/******************************
* Types
*******************************/
#if COMPILE_BITFIELD_LSB_FIRST
typedef union{
     struct{
             bit_field16_T ram_address_test_failed:1;            /* LSB */
             bit_field16_T ram_integrity_test_failed:1;
             bit_field16_T ram_integrity_copy_failed :1;
             bit_field16_T flash_opsw_test_failed:1;
             bit_field16_T flash_cal_test_failed :1;
             bit_field16_T mc_flash_test_complete:1;
             bit_field16_T flash_irq_table_test_failed : 1;
             bit_field16_T flash_parity_error : 1;
             bit_field16_T ram_parity_error :1;
             bit_field16_T ram_sec_error:1;
             bit_field16_T ram_ecc_double_error:1;
             bit_field16_T dma_bus_error:1;
             bit_field16_T :4;         /* MSB */
           }run_time_mem_test_result_bits;
           unsigned16_T run_time_mem_test_result_byte;
        }run_time_mem_test_result_T;

#else
typedef union{
     struct{
             bit_field16_T: 4; /* MSB */
             bit_field16_T dma_bus_error: 1;
             bit_field16_T ram_ecc_double_error: 1;
             bit_field16_T ram_sec_error: 1;
             bit_field16_T ram_parity_error: 1;
             bit_field16_T flash_parity_error : 1;
             bit_field16_T flash_irq_table_test_failed : 1;
             bit_field16_T mc_flash_test_complete:1;
             bit_field16_T flash_cal_test_failed :1;
             bit_field16_T flash_opsw_test_failed:1;
             bit_field16_T ram_integrity_copy_failed :1;
             bit_field16_T ram_integrity_test_failed:1;
             bit_field16_T ram_address_test_failed:1;            /* LSB */
           }run_time_mem_test_result_bits;
           unsigned16_T run_time_mem_test_result_byte;
        }run_time_mem_test_result_T;
#endif

/******************************
* Macros
*******************************/
/* Give access to fault byte */
#define Get_Run_Time_Mem_Test_Result_Byte() \
    ( Run_Time_Mem_Test_Result.run_time_mem_test_result_byte )

/* Check the state of desired bit */
#define Get_Ram_Address_Test_State( state ) \
    ( Run_Time_Mem_Test_Result.run_time_mem_test_result_byte & BACKGROUND_##state )

/* Sets the desired state bit without affecting the others */
#define Set_Ram_Address_Test_State( state ) \
    ( Run_Time_Mem_Test_Result.run_time_mem_test_result_byte |= BACKGROUND_##state )

/* Clears the desired state bit without affecting the others */
#define Clear_Ram_Address_Test_State( state ) \
    ( Run_Time_Mem_Test_Result.run_time_mem_test_result_byte &= ~( BACKGROUND_##state ) )

#define Get_Ram_Address_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_address_test_failed)
#define Set_Ram_Address_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_address_test_failed=TRUE)
#define Clear_Ram_Address_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_address_test_failed=FALSE)

#define Get_Ram_Integrity_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_test_failed)
#define Set_Ram_Integrity_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_test_failed=TRUE)
#define Clear_Ram_Integrity_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_test_failed=FALSE)

#define Get_Ram_Integrity_Copy_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_copy_failed)
#define Set_Ram_Integrity_Copy_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_copy_failed=TRUE)
#define Clear_Ram_Integrity_Copy_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_integrity_copy_failed=FALSE)

#define Get_Flash_Opsw_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_opsw_test_failed)
#define Set_Flash_Opsw_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_opsw_test_failed=TRUE)
#define Clear_Flash_Opsw_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_opsw_test_failed=FALSE)

#define Get_Flash_Cal_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_cal_test_failed)
#define Set_Flash_Cal_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_cal_test_failed=TRUE)
#define Clear_Flash_Cal_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_cal_test_failed=FALSE)

#define Get_Mc_Flash_Test_Complete()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.mc_flash_test_complete)
#define Set_Mc_Flash_Test_Complete()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.mc_flash_test_complete=TRUE)
#define Clear_Mc_Flash_Test_Complete()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.mc_flash_test_complete=FALSE)

#define Get_Ram_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_parity_error)
#define Set_Ram_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_parity_error=TRUE)
#define Clear_Ram_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_parity_error=FALSE)

#define Get_Flash_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_parity_error)
#define Set_Flash_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_parity_error=TRUE)
#define Clear_Flash_Parity_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_parity_error=FALSE)

#define Get_Flash_IRQ_Table_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_irq_table_test_failed)
#define Set_Flash_IRQ_Table_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_irq_table_test_failed=TRUE)
#define Clear_Flash_IRQ_Table_Test_Failed()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.flash_irq_table_test_failed=FALSE)

#define Get_Ram_ECC_Double_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_ecc_double_error)
#define Set_Ram_ECC_Double_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_ecc_double_error=TRUE)
#define Clear_Ram_ECC_Double_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_ecc_double_error=FALSE)

#define Get_Dma_Bus_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.dma_bus_error)
#define Set_Dma_Bus_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.dma_bus_error=TRUE)
#define Clear_Dma_Bus_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.dma_bus_error=FALSE)

#define Get_Ram_Sec_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_sec_error)
#define Set_Ram_Sec_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_sec_error=TRUE)
#define Clear_Ram_Sec_Error()  \
      (Run_Time_Mem_Test_Result.run_time_mem_test_result_bits.ram_sec_error=FALSE)

#define Get_MC_Flash_Cross_Check_Background_Write()          (MC_Flash_Cross_Check_Background_Write)
#define Update_MC_Flash_Cross_Check_Background_Write(value)  (MC_Flash_Cross_Check_Background_Write = (value))

/******************************
* Global Variables
*******************************/
extern run_time_mem_test_result_T Run_Time_Mem_Test_Result;
extern unsigned16_T MC_Flash_Cross_Check_Background_Write;

/*************************
* Interface Declarations
*************************/

/*   None                     */

/*************************
* Function Prototypes
*************************/
 /* None */
/*===========================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 03/08/10   Aftabkhan SCR tcb_css#4149 for release DBC_Layer2/78_GEN03.
 *   Created the intial version for Background ROM Testing error correction.
 *  contains Background Task written variables like MC_Flash_Cross_Check_Background_Write
 *
 * 06/15/11 Sagar Pattnaik Cradle_SCR#235 for release DBC_Layer2/78_12KC17.
 *   Updated structure run_time_mem_test_result_T and its macros.
 *
 * 08/01/11 Sagar Pattnaik scr.424 for release DBC_Layer2/78_12KC17a.
 *   Updated the bit_field_T to bit_field16_T.
 *
\*===========================================================================*/
#endif/*HNSVROM_H*/
