/*=============================================================================*\
* Module Name:     ramchk.c
* Created By:      sunil naik
* Created Date:    Wed May  02 10:00:00 2012
* %version:        4xx %
* %cvtype:         csrc %
* %instance:       tcb_css2_2 %
* %derived_by:     zxw378 %
* %date_modified:  Thursday, May 31, 2012 3:17:33 PM %
\*=============================================================================*/
/*=============================================================================*\
* Copyright 2011, BWI Group, North America, All Rights Reserved.
* BWI Confidential
*-----------------------------------------------------------------------------------------------------
*
* File Description:
*  This file contains the procedures for RAM_ECC_Functional_Chk
*
* Traces to:  RAM_ECC_Functional_Chk
*
* Applicable standards:
*    Developed according to BWI C Coding Standards
*
* History block is located at the end of this file.
\*=============================================================================*/
/*******************************
* Interface Defines
*******************************/
#define L2_CPU_FAILSAFE_DATA_INTF
#define INCLUDE_L2_MEM_ERROR_DETAILS_INTF
#define L2_ERR_PIN_CTRL_CHECK_INTF
#define L2_HET_PARITY_SELF_TEST_INTF
#define L2_RAM_ECC_SELF_TEST_INTF
#define L2_CCM_SELF_TEST_INTF

/*******************************
* Includes
*******************************/
#include "systype.h"
#include "sysreg.h"
#include "chipreg.h"
#include "hnsvrom.h"
#include "hhcpuchk.h"

extern unsigned8_T ECC_TEST_VAR_OFFSET[];
extern unsigned8_T ECC_RAM_START[];

/**************************
* Defines
**************************/

#define RAM_ECC_START_VAL   (0xA55AF00F00000000ULL) /* 0xF3 = ECC */

                                                    /* ECC is 0xFC for Initialized ZERO value */

#define RAM_ECC_COR_VAL     (0xA5DAF00F00000000ULL) /* Bit 55 of 64-Bit data is changed -- Syndrome column value is 0x1C */
                                                    /* N.B.: Syndrome Table in TRM is in Intel Format, So, Bit 55 is Bit 23 in Syndrome Table */
                                                    /* 0xEF = ECC */

#define RAM_ECC_FORCE_DBL_ERR (0xFFU)  /* No column in Syndrome Table contains this ECC Value, Hence double error */
#define RAM_ECC_FORCE_COR     (0x1CU)  /* Syndrome Table Column 23 value - Single Bit Error Syndrome for Bit 23 */


/*******************************
* Macros
*******************************/

/*   None                     */

/******************************
* Types
*******************************/

typedef union
{
  unsigned64_T ecc_cell_data;
  unsigned32_T ecc_cell_word[2];
  unsigned8_T ecc_cell_bytes[8];
} ecc_cell_array_T;

/******************************
* Variable Exports
*******************************/



/******************************
* Function Prototypes
*******************************/

/*   None                     */

/******************************
* File Scope Variables
*******************************/

VAR_IN_SECTION(ram_test_var, .ECC_TEST_VAR)
unsigned64_T volatile ram_test_var;

void memset_local(ecc_cell_array_T volatile *destination, unsigned8_T data);
void Empty_Function(void);

/*******************************
* Function Definitions
*******************************/
/*.**************************************************************************
*. Name: RAM_ECC_Functional_Chk
*.
*. Description:
*.   This component verifies that the ECC logic is functioning properly
*.   and will detect RAM errors and trigger the required interrupts.
*.
*. Parameters: none.
*.
*. Return Value: none.
*.
*. Shared Variables: none.
*.
*. Assumptions/Preconditions: none.
*.
*. Design Information:
*.    LI2.12.doc
*.
****************************************************************************/
void RAM_ECC_Functional_Chk(void)
{
   boolean_T      initial_ram_integrity_state;

   unsigned8_T    ram_test_var_ecc_data;
   boolean_T      initial_error_pin_state;
   boolean_T      volatile align_dummy_byte;
   unsigned64_T   *ram_test_var_ecc_data_ptr;
   ecc_cell_array_T  volatile  ecc_cell_array;
   unsigned32_T   current_time;

   Update_Ram_Ecc_Self_Test_State(0x00);  /* Initialize with UNDETERMINED State */

   if (GET_ESM_ERROR_PIN_STATE())
   {
   ram_test_var = RAM_ECC_START_VAL;  /* Update the ECC Area also using 64-Bit write */



   ram_test_var_ecc_data_ptr = (unsigned64_T *)(ECC_RAM_START + (unsigned32_T)ECC_TEST_VAR_OFFSET);
   align_dummy_byte = ram_test_var_ecc_data = *ram_test_var_ecc_data_ptr;

   initial_ram_integrity_state = Get_Ram_Integrity_Test_Failed();

   if(FALSE == Get_Ram_Sec_Error())
   {

      ecc_cell_array.ecc_cell_bytes[5] =
      ecc_cell_array.ecc_cell_bytes[6] =
      ecc_cell_array.ecc_cell_bytes[4] =
      ecc_cell_array.ecc_cell_bytes[1] =
      ecc_cell_array.ecc_cell_bytes[0] =
      ecc_cell_array.ecc_cell_bytes[2] =
      ecc_cell_array.ecc_cell_bytes[7] =
      ecc_cell_array.ecc_cell_bytes[3] = ram_test_var_ecc_data ^ RAM_ECC_FORCE_COR;


      if(RAM_ECC_COR_VAL != ecc_cell_array.ecc_cell_data )
      {
          asm("   NOP");
          asm("   NOP");

          asm("   NOP");
          asm("   NOP");

          asm("   NOP");
          asm("   NOP");

          asm("   NOP");
          asm("   NOP");

      }
      else
      {
         /* Do nothing */
      }


      ENABLE_SRAM_ECC_WRITE();
      *ram_test_var_ecc_data_ptr = ecc_cell_array.ecc_cell_data;
      DISABLE_SRAM_ECC_WRITE();

      if(RAM_ECC_COR_VAL != ram_test_var )
      {
          asm("   NOP");
          asm("   NOP");
      }
      else
      {
         /* Do nothing */
      }

      if(RAM_ECC_COR_VAL != ram_test_var )
      {
         Set_Single_Bit_Correction_Failed();
      }
      else
      {
         /* Do nothing */
      }

      if( (TRUE == Get_Ram_Sec_Error()) && ((Get_Ram_Ecc_Sec_Address() * 8) == (unsigned32_T)ECC_TEST_VAR_OFFSET ) )
      {
         if(FALSE == Get_Single_Bit_Correction_Failed())
         {
            Set_Ecc_Self_Check_Passed();
         }
         else
         {
            /* Do nothing */
         }

         Clear_Ram_Sec_Error();

         Empty_Function();

         if (initial_ram_integrity_state)
         {
            Set_Ram_Integrity_Test_Failed();
         }
         else
         {
            Clear_Ram_Integrity_Test_Failed();
         }

         Update_Ram_Ecc_Sec_Address(0);
         Update_Ram_Ecc_Sec_Detail(0);
         Update_Ram_Ecc_Sec_Count(0);
         CLEAR_ECC_ERROR_OCCURRENCE_COUNTER();
      }
      else
      {
         Set_Single_Bit_Correction_Failed();
      }

   }
   else
   {
      /* Do nothing */
   }


   /* RMW Cycle for ARM7TDMI -- Hence, ECC must be corrected, else ESM Interrupt */

      /* ecc_cell_array.ecc_cell_bytes[3] is the actual WRITE operation -- Intel Format LSB */
//      memset((void *)ecc_cell_array.ecc_cell_bytes, ram_test_var_ecc_data, sizeof(ecc_cell_array));
      memset_local(&ecc_cell_array, ram_test_var_ecc_data);
//      ecc_cell_array.ecc_cell_bytes[3] = ram_test_var_ecc_data;
   ENABLE_SRAM_ECC_WRITE();
      *ram_test_var_ecc_data_ptr = ecc_cell_array.ecc_cell_data;
   DISABLE_SRAM_ECC_WRITE();


   ram_test_var = RAM_ECC_START_VAL;  /* RMW Cycle for ARM7TDMI -- Hence, ECC must be corrected, else ESM Interrupt */

   if(FALSE == Get_Ram_ECC_Double_Error())
   {

      initial_error_pin_state = GET_ESM_ERROR_PIN_STATE();


      /* ecc_cell_array.ecc_cell_bytes[3] is the actual WRITE operation -- Intel Format LSB */
//      memset((void *)ecc_cell_array.ecc_cell_bytes, (ram_test_var_ecc_data ^ RAM_ECC_FORCE_DBL_ERR), sizeof(ecc_cell_array));
      memset_local(&ecc_cell_array, ram_test_var_ecc_data ^ RAM_ECC_FORCE_DBL_ERR);
//      ecc_cell_array.ecc_cell_bytes[3] = ram_test_var_ecc_data ^ RAM_ECC_FORCE_DBL_ERR;
   ENABLE_SRAM_ECC_WRITE();
      *ram_test_var_ecc_data_ptr = ecc_cell_array.ecc_cell_data;
   DISABLE_SRAM_ECC_WRITE();


      if(RAM_ECC_START_VAL != ram_test_var )
      {
          asm("   NOP");
          asm("   NOP");
      }
      else
      {
//          Empty_Function();
      }

      /* Wait 2 CPU clock (one VCLK) cycles to be sure that interrupt has occurred */
      asm("   NOP");
      asm("   NOP");


      if( (TRUE == Get_Ram_ECC_Double_Error()) && ((Get_Ram_Ecc_Ded_Address() * 8) == (unsigned32_T)ECC_TEST_VAR_OFFSET )
          &&
          (FALSE == GET_ESM_ERROR_PIN_STATE())  )
      {
         Clear_Ram_ECC_Double_Error();

         if (initial_ram_integrity_state)
         {
            Set_Ram_Integrity_Test_Failed();
         }
         else
         {
            Clear_Ram_Integrity_Test_Failed();
         }

         Update_Ram_Ecc_Ded_Address(0);
         CLEAR_DOUBLE_ERROR();


      /* ecc_cell_array.ecc_cell_bytes[3] is the actual WRITE operation -- Intel Format LSB */
//      memset((void *)ecc_cell_array.ecc_cell_bytes, ram_test_var_ecc_data, sizeof(ecc_cell_array));
      memset_local(&ecc_cell_array, ram_test_var_ecc_data);
//      ecc_cell_array.ecc_cell_bytes[3] = ram_test_var_ecc_data;
   ENABLE_SRAM_ECC_WRITE();
      *ram_test_var_ecc_data_ptr = ecc_cell_array.ecc_cell_data;
   DISABLE_SRAM_ECC_WRITE();

         ram_test_var = RAM_ECC_START_VAL;
         if(RAM_ECC_START_VAL != ram_test_var )
         {
            asm("   NOP");
            asm("   NOP");
         }
         else
         {
           /* Do nothing */
         }

         /* Wait 2 CPU clock (one VCLK) cycles to be sure that interrupt has occurred */
         asm("   NOP");
         asm("   NOP");

         if ( (RAM_ECC_START_VAL == ram_test_var )
              &&
              initial_error_pin_state
              &&
              (FALSE == GET_MEMORY_FAULT_DETECT_STATUS())
            )
         {
            ESM_ERROR_KEY_ERROR_RESET_MODE();
            GET_ESM_ERROR_KEY_STATE();  /* In case in the debugger we want to observe */

            Clear_CPU_Failsafe_Reaction_Active();
                  current_time = 0;
                  do {
                     if (Boot_Timer_Get())
                     {
                        Clear_Real_Time_Clock_Tick_Interrupt_Request_Flag(); /*Timer_Reload();*/
                        current_time++;
                     }
                  } while (
                            (current_time < 2)
                            &&
                            (FALSE == GET_ESM_ERROR_PIN_STATE())
                          );

         }
         else
         {
            Clear_Ecc_Self_Check_Passed();
            Set_Error_State_Not_Cleared();
         }
      }
      else
      {
         Clear_Ecc_Self_Check_Passed();
         Set_Double_Bit_Detection_Failed();
      }
   }
   else
   {
      /* Do nothing */
   }

   }
}



/*===========================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *============================================================================
 *   Date       By     (Description on following lines)
 * --------  --------
 * 05/21/12   Sunil Naik scr.888 for release DBC_Layer2/78_12KC21.
 *  Initial version: Added function RAM_ECC_Functional_Chk().
 *
 * 05/25/12   Sunil Naik scr.888 for release DBC_Layer2/78_12KC21.
 *  Fixed the review findings.
 *
\*===========================================================================*/
