#ifndef SYSTYPE_H
#define SYSTYPE_H

/*=============================================================================*\
* Copyright 2002, Delphi Technologies, Inc., All Rights Reserved.
* Delphi Confidential
*
* Module Name:     systype.h
* Created By:      pproy
* Created Date:    Fri Oct 18 14:45:10 2002
* %version:        tcb_css2#29x %
* %cvtype:         incl %
* %instance:       tcb_css_29 %
* %derived_by:     zxw378 %
* %date_modified:  Friday, February 17, 2012 10:51:00 AM %
\*=============================================================================*/
/******************************************************************************
*
* File Description:  This file contains all system level types.
*
* Traces To: NA
*
* Deviations from software standards:
*    Developed according to the following software standards:
*      Delco Electronics Systems C Coding Standards(SW REF 264.15D 23-Dec-2001)
*
* Additional information contained in procedure header blocks:
*    Header blocks have the grep key of *. for design related
*     information. ( not including update information.)
*
* History Log is at the end of this file.
*
*********************************************************************************/

/* This file can not #include any other file! */


#define CE_LOOPTIME    10                     /* Number of ms per os cycle */
#define CE_LOOPTIME_S  ( 1000 / CE_LOOPTIME ) /* Number of Looptimes per second. */

#define FALSE     ( 0 )
#define TRUE      ( !FALSE )

#define FAST_LT      (0.0078125)
#define MED_LT       (0.03125)
#define SLOW_LT      (0.125)
#define TIMER_4s_RES (4)


#define ALL_BITS_SET_LONGWORD   (0xFFFFFFFF)
#define ALL_BITS_SET_WORD       (0xFFFF)
#define ALL_BITS_SET_BYTE       (0xFF)

#ifndef NULL
#define NULL      ((void*) 0x0000)
#endif


/************************************
* Pre-defined Standard Types
************************************/
typedef  void (*function_ptr_T)(void);      /* Pointer to a function */

typedef unsigned char  unsigned8_T;
#if DEVICE_32_BIT_PROCESSOR == 1
typedef unsigned short int unsigned16_T;
#elif DEVICE_16_BIT_PROCESSOR == 1
typedef unsigned int   unsigned16_T;
#else
#error "Problem"
#endif
typedef unsigned long  unsigned32_T;
typedef unsigned long long unsigned64_T;

typedef signed char    signed8_T;
typedef signed short   signed16_T;
typedef signed long    signed32_T;
typedef signed long long    signed64_T;

typedef unsigned8_T bit_field8_T;
typedef unsigned16_T bit_field16_T;

/* To be used for all bit fields of a byte variable. */
/*typedef unsigned char  bit_field_T;      */
typedef unsigned int  bit_field_T;

/* To be used for all bit fields of a word variable. */
/*typedef unsigned short   bit_field_16_T; */
typedef unsigned16_T   bit_field_16_T;

typedef struct
{
   bit_field_T Bit7  :1;
   bit_field_T Bit6  :1;
   bit_field_T Bit5  :1;
   bit_field_T Bit4  :1;
   bit_field_T Bit3  :1;
   bit_field_T Bit2  :1;
   bit_field_T Bit1  :1;
   bit_field_T Bit0  :1;
}  bits8_T;



/* byte/8 bits union (variant record) type definition */
typedef union
{
   bits8_T       bits;
   unsigned8_T   byte;
}  mixed_byte_T;

typedef struct
{
   unsigned8_T MSbyte;
   unsigned8_T LSbyte;
}  split_word_T;

/* split a long into bytes */
typedef struct
{
   unsigned8_T b1;
   unsigned8_T b2;
   unsigned8_T b3;
   unsigned8_T b4;
}  split_longb_T;

/* split a long into words */
typedef struct
{
   unsigned16_T  w1;
   unsigned16_T  w2;
}  split_longw_T;


/* word/byte union (variant record) type definition */
typedef union
{
   unsigned16_T word;
   split_word_T bytes;
}  mixed_word_T;

typedef struct
{
   bit_field_T Bit31 :1;
   bit_field_T Bit30 :1;
   bit_field_T Bit29 :1;
   bit_field_T Bit28 :1;
   bit_field_T Bit27 :1;
   bit_field_T Bit26 :1;
   bit_field_T Bit25 :1;
   bit_field_T Bit24 :1;
   bit_field_T Bit23 :1;
   bit_field_T Bit22 :1;
   bit_field_T Bit21 :1;
   bit_field_T Bit20 :1;
   bit_field_T Bit19 :1;
   bit_field_T Bit18 :1;
   bit_field_T Bit17 :1;
   bit_field_T Bit16 :1;
   bit_field_T Bit15 :1;
   bit_field_T Bit14 :1;
   bit_field_T Bit13 :1;
   bit_field_T Bit12 :1;
   bit_field_T Bit11 :1;
   bit_field_T Bit10 :1;
   bit_field_T Bit9  :1;
   bit_field_T Bit8  :1;
   bit_field_T Bit7  :1;
   bit_field_T Bit6  :1;
   bit_field_T Bit5  :1;
   bit_field_T Bit4  :1;
   bit_field_T Bit3  :1;
   bit_field_T Bit2  :1;
   bit_field_T Bit1  :1;
   bit_field_T Bit0  :1;
}  bits32_T;

/* long/word union (variant record) type definition */
typedef union
{
   unsigned32_T   long_word;
   split_longw_T  words;
   split_longb_T  bytes;
   bits32_T       bits;
}  mixed_long_T;

typedef struct {
 bit_field_T bit15:1;  /* MSB */
 bit_field_T bit14:1;
 bit_field_T bit13:1;
 bit_field_T bit12:1;
 bit_field_T bit11:1;
 bit_field_T bit10:1;
 bit_field_T bit9:1;
 bit_field_T bit8:1;
 bit_field_T bit7:1;
 bit_field_T bit6:1;
 bit_field_T bit5:1;
 bit_field_T bit4:1;
 bit_field_T bit3:1;
 bit_field_T bit2:1;
 bit_field_T bit1:1;
 bit_field_T bit0:1;  /* LSB */
}T_BITFLD16;

/* Carrier of 32 bits */
typedef struct {
 unsigned int bit31:1;
 unsigned int bit30:1;
 unsigned int bit29:1;
 unsigned int bit28:1;
 unsigned int bit27:1;
 unsigned int bit26:1;
 unsigned int bit25:1;
 unsigned int bit24:1;
 unsigned int bit23:1;
 unsigned int bit22:1;
 unsigned int bit21:1;
 unsigned int bit20:1;
 unsigned int bit19:1;
 unsigned int bit18:1;
 unsigned int bit17:1;
 unsigned int bit16:1;
 unsigned int bit15:1;  /* MSB */
 unsigned int bit14:1;
 unsigned int bit13:1;
 unsigned int bit12:1;
 unsigned int bit11:1;
 unsigned int bit10:1;
 unsigned int bit9:1;
 unsigned int bit8:1;
 unsigned int bit7:1;
 unsigned int bit6:1;
 unsigned int bit5:1;
 unsigned int bit4:1;
 unsigned int bit3:1;
 unsigned int bit2:1;
 unsigned int bit1:1;
 unsigned int bit0:1;  /* LSB */
}T_BITFLD32;


/* Word with msb and lsb handling */
typedef union{
 struct{
  unsigned8_T msb;
  unsigned8_T lsb;
  }by;
 unsigned16_T wo;
}T_BYTEFLD;

/* Word with msb and lsb handling */
typedef union{
 struct{
  unsigned8_T msb;
  unsigned8_T msb0;
  unsigned8_T lsb1;
  unsigned8_T lsb;
  }by;
 unsigned32_T wo;
}T_4BYTEFLD;


/* Carrier of 16 bits with word or byte (msb & lsb) carrier handling */
typedef union {
 T_BITFLD16 bi;
 T_BYTEFLD cr;
}T_FLAG16;

/* Carrier of 16 bits with word or byte (msb & lsb) carrier handling */
typedef union {
 T_BITFLD32 bi;
 T_4BYTEFLD cr;
}T_FLAG32;



#ifdef TASKING
/* The type _bita is specific type supported by Tasking compiler */

#define BITA _bita
#define ABBITA _bita
#define DGBITA _bita
#define IFBITA _bita
#define OCBITA _bita
#else
#define BITA
#define ABBITA
#define DGBITA
#define IFBITA
#define OCBITA
#endif

typedef const struct {
       signed32_T          min_val;
       signed32_T          max_val;
       unsigned8_T         loop_time;
} rate_of_change_T;

typedef  unsigned32_T (*swi_exception_function_ptr_T)(unsigned32_T param1, unsigned32_T param2);

/****************************************************************
* Generic fixed point types for fixed point passing parameters
****************************************************************/
typedef unsigned8_T    u8_fixed_point_T;
typedef unsigned16_T   u16_fixed_point_T;
typedef unsigned32_T   u32_fixed_point_T;

typedef signed8_T      s8_fixed_point_T;
typedef signed16_T     s16_fixed_point_T;
typedef signed32_T     s32_fixed_point_T;
typedef signed64_T     s64_fixed_point_T;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* boolean_T
*
* Rules for using boolean_T (to be checked at code reviews):
*
* 1) boolean_T declared variables shall be named such that a state is
*    conveyed. Examples: lamp_is_on,  test_passed,  pin_is_high.  So
*    that if( lamp_is_on ) is unambiguous.
*
* 2) boolean_T variables shall only be compared by themselves.
*    Never do this:  if( TRUE==lamp_is_on)  Do this: if( lamp_is_on )
*
* 3) boolean_T variables shall not be compared to each other.
*    Never do this:  if ( lamp_is_on == time_for_light )
*
* 4) boolean_T variables can be assigned TRUE or FALSE
*    Can do this:  lamp_is_on = TRUE;
*
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
typedef unsigned8_T boolean_T;
/*typedef unsigned16_T boolean_T;*/

#ifndef FALSE
#define FALSE ( 0 )
#define TRUE  ( !FALSE )
#endif
#define BOOLEAN_STATES 2

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Defines for Portability
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/* Return types MUST STILL BE SPECIFIED when using the following
 * modifiers that relate to functions!
 */

#ifndef FAR
#define FAR
#endif

#ifdef TASKING
/* Define a far pointer to access the memory beyond 16k */
#define CSFAR   far
#else
#define CSFAR
#endif

/*************************************************************************
*========================================================================*
* Common MACROS
*========================================================================*
*************************************************************************/



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Name: Min, Max MACRO
*  Macro to return the Min or Max of 2 values.
*  The types of these must be the same or the result is nonsense.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define Min( x,y )  (( (x) < (y)) ? (x) : (y) )
#define Max( x,y )  (( (x) > (y)) ? (x) : (y) )

/* COSMIC 68HC12 Library has these functions */
#define min( x,y )  (( (x) < (y)) ? (x) : (y) )
#define max( x,y )  (( (x) > (y)) ? (x) : (y) )


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Name: Define_MRAM MACRO
*  Macro to declare MRAM variable "var" of type "var_type" as
*  uninitialized data. Third parameter is not used (for 7.2 purpose only).
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define Define_MRAM( var_type, var, init) var_type  var;



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Name: COMPILER_ASSERT MACRO
*  Macro to use as compile time assertion
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define COMPILER_ASSERT(condition, message) \
   typedef char message[(condition) ? 1 : -1]

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Name: offsetof MACRO
*  Macro to use as offsetof()
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#if defined(__TI_COMPILER_VERSION__)
/* TI Compiler Specific */
#ifndef _SIZE_T
#define _SIZE_T
typedef  __SIZE_T_TYPE__ _Sizet;
typedef _Sizet size_t;
#endif
  #define _CSTD
  #define offsetof(T, member) ((_Sizet)__INTADDR__(&(((T *)0)->member)))
#else

#endif

/*========================================================================
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*------------------------------------------------------------------------
*                 ALL DBC 7.2 SPECIFIC ITEMS FOLLOW
*------------------------------------------------------------------------
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
*========================================================================*/

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Common Base 2 Fixed point types.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/* Note: This voltage type is to be used for anything previously scaled
 * as 17.2/256 or 32/65536. System voltage and ignition voltage use this.
 */
typedef unsigned16_T voltage_u6p10_T;
#define BPP_voltage_u6p10_T 10
#define SIGNED_voltage_u6p10_T FALSE

/* Note: This voltage type is used for input voltage sensor with
 * a maximum value of 5.0 volts.
 */
typedef unsigned16_T voltage_u4p12_T;
#define BPP_voltage_u4p12_T 12
#define SIGNED_voltage_u4p12_T FALSE

/* The period of PWM duty cycle commanded to the solenoid.
 * Actual Range: 0-2.047msec. Res: 8usec.
 */
typedef unsigned8_T pwm_period_u11pm3_T;        /*  bbbbbbbb___. */
#define BPP_pwm_period_u11pm3_T -3
#define SIGNED_pwm_period_u11pm3_T FALSE


/*************************************************************************
*========================================================================*
* Common Simple Type Definitions for the Entire Application.
* ---------------------------------------------------------
*   ( Used across subsystems. If a typedef is used only in one
*     subsystem or file then it doesn't belong in this file. )
*========================================================================*
*************************************************************************/

/* TODO: This belongs in abapply, not here. */
#define  REAR_ADJUST_NONE 4

/* Used in abrroad.c "Raw_Brake_Mode_(wheel) > BRAKE_MODE_HOLD", so check
   that module if enum is modified. */

typedef enum {       /* Only used in ABS Subsystem? */
   HIGH_APPLY = 1,
   MEDIUM_APPLY,
   LOW_APPLY,
   BRAKE_MODE_HOLD,
   LOW_RELEASE,
   MEDIUM_RELEASE,
   HIGH_RELEASE,
   NUMBER_OF_BRAKE_MODES_7
} brake_mode_T;

typedef enum {
   PRESSURE_CONTROL_MODE_APPLY,
   PRESSURE_CONTROL_MODE_HOLD,
   PRESSURE_CONTROL_MODE_RELEASE
} pressure_control_mode_T;

typedef enum {
   PUMP_ENABLE_CMD_OFF,
   PUMP_ENABLE_CMD_ON
} pump_enable_cmd_T;

typedef enum {
    GEAR_INVALID,
    GEAR_FIRST,
    GEAR_SECOND,
    GEAR_THIRD,
    GEAR_FOURTH,
    GEAR_FIFTH,
    GEAR_SIXTH,
    GEAR_NEUTRAL,
    GEAR_REVERSE,
    GEAR_PARK
} gear_index_T;

typedef enum {
  FIRST_MC_SENSOR=0,
  SECOND_MC_SENSOR=1,
  TOTAL_MC_SENSORS=2
} num_mc_pressure_sensors_T;

typedef enum {OFF, ON} enum_off_on_T ;




/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Max and Min Constants for types.
* You can use these for limiting to the max, min value of a type.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/* You can use these for limiting to the max, min value of a type. */

#define U8_MAX    0xFF
#define U8_MIN    0

#define U9_MAX    (0x1FFU)

#define U16_MAX   0xFFFF
#define U16_MIN   0
#define U32_MAX   0xFFFFFFFF
#define U32_MIN   0

#define S8_MAX (127)
#define S8_MIN (-127)
#define S16_MAX   (32767)
#define S16_MIN   (-32767)
#define S32_MAX   (2147483647)
#define S32_MIN_VAL   (-2147483647)

#define S24_MAX    (8388607)
#define S24_MIN    (-S24_MAX - 1)

#define U24_MAX    (16777216)
#define U24_MIN    (0)


extern signed long const S32_MIN;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* These #define represent the element position within an array for the
* stages per profile <1>, <2>, and <3>
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define STAGE_ONE      0
#define STAGE_TWO      1
#define STAGE_THREE    2

/*************************************************************************
*========================================================================*
* Common Complex Type Definitions.
* --------------------------------
*   The following are complex typedefs for use with ARRAYS and BIT
*   PACKING.
*========================================================================*
*************************************************************************/


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Array Allocation Defines
*   These #defines represent the number of bytes to allocate for
*   arrays of any type variable which must have an array element
*   for multiple modifiers. Ex: my_variable[ CONTROL_CHANNELS ],
*
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
                               /*   Modifiers         Index Type     */
                               /* -----------------  --------------- */
#define CONTROL_CHANNELS    3  /*<LF>,<RF>,<RA>      channel_index_T */
#define WHEEL_VARIABLES     4  /*<LF>,<RF>,<LR>,<RR> wheel_index_T   */
#define FRONT_REAR_CHANNELS 2  /*<FRONT>, <REAR>     front_rear_wheels_index_T*/
#define PRI_SEC_VARIABLES   2  /*<PRI>,<SEC>         pri_sec_index_T  */
#define STAGES_PER_PROFILE  3  /*<1> <2> <3>         Up to 3 stages per profile*/
#define DRIVEN_WHEELS       2  /*<LD> <RD>           left_right_driven_index_T */
#define FRONT_REAR_WHEELS       2  /*<FRONT>, <REAR>     front_rear_wheels_index_T*/


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: front_rear_wheels_index_T
*   This type is used for declaring index variables.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/* Use to index cals with front and rear modifiers */
typedef enum {
   FRONT_WHEELS,
   FRONT = 0,
   REAR_WHEELS,
   REAR = 1,
   MAX_AXLE_INDEX
} front_rear_wheels_index_T;


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: control_channels_index_T
*   This type is used for declaring index variables.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/* Use to index cals with front,rear and front_and_rear modifiers */
typedef enum {
   FRONT_CH,
   REAR_CH,
   FRONT_AND_REAR_CH,
   CONTROL_CHANNELS_INDEX_SIZE
} control_channels_index_T;


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: wheel_index_T, channel_index_T
*   These types are used for declaring index variables, typically for use
*   within for(;;) loops for indexing through all four wheels.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define NUMBER_OF_REAR_WHEELS  2
#define NUMBER_OF_FRONT_WHEELS 2
typedef enum {
   LF = 0,           /* Left front wheel index number. */
   RF = 1,           /* Right front wheel index number. */
   LR = 2,           /* Left rear wheel index number. */
   RR = 3,           /* Right rear wheel index number. */
   RA = 2        /* Rear axle index number. */
} wheel_index_T, channel_index_T;




/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: wheel_T, control_channel_T
*   These types are used for declaring PACKED BIT variables in which
*   the BIT represents a true/false state of the object identified
*   by the enum element. These masks are matched with the wheel_index_T,
*   channel_index_T types. The wheel_index_T, channel_index_T enums can
*   be converted to these flag masks via the whl_masks[] and
*   channel_masks[] arrays.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/* List of masks used with wheel_T & control_channel_T.        */
#define LF_M    0x01       /* Left front wheel flag bit mask.  */
#define RF_M    0x02       /* Right front wheel flag bit mask. */
#define LR_M    0x04       /* Left rear wheel flag bit mask.   */
#define RR_M    0x08       /* Right rear wheel flag bit mask.  */
#define RA_M    0x04       /* Rear axle flag bit mask.         */
#define FRONT_M 0x03       /* Both front wheels flag bit mask. */
#define REAR_M  0x0C       /* Both rear wheels flag bit mask.  */
typedef unsigned8_T wheel_T;
typedef unsigned8_T control_channel_T;

/* List of masks used with fault_code_byte_T.        */
#define CODE1_M    0x01       /* Bit 0 bit mask.  */
#define CODE2_M    0x02       /* Bit 1 bit mask.  */
#define CODE3_M    0x04       /* Bit 2 bit mask.  */
#define CODE4_M    0x08       /* Bit 3 bit mask.  */
#define CODE5_M    0x10       /* Bit 4 bit mask.  */
#define CODE6_M    0x20       /* Bit 5 bit mask.  */
#define CODE7_M    0x40       /* Bit 6 bit mask.  */
#define CODE8_M    0x80       /* Bit 7 bit mask.  */


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: pri_sec_index_T
*   This type is used for declaring index variables.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
typedef enum {
   PRI,
   SEC
} pri_sec_index_T;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: pri_sec_T
*   This types is used for declaring PACKED BIT variables in which
*   the BIT represents a true/false state of the object identified
*   by the enum element. These masks are matched with the pri_sec_index_T
*   type. The pri_sec_index_T enums can be converted to these flag
*   masks via the pri_sec_masks[].
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define PRI_M  0x01
#define SEC_M  0x02
typedef unsigned8_T pri_sec_T;


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: left_right_driven_index_T
*   This type is used for declaring index variables.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
typedef enum {
   LD,
   RD
} left_right_driven_index_T;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Type: ld_rd_T
*   This types is used for declaring PACKED BIT variables in which
*   the BIT represents a true/false state of the object identified
*   by the enum element. These masks are matched with the
*   left_right_driven_index_T type. The left_right_driven_index_T
*   enums can be converted to these flag masks via the ld_rd_masks[].
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
#define LD_M  0x01
#define RD_M  0x02
typedef unsigned8_T ld_rd_T;



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Index to Mask Conversion Arrays:
*   whl_masks[], channel_masks[], pri_sec_masks[], ld_rd_mask[]
*
*   Used for converting wheel_index_T, channel_index_T variables
*   to wheel_T, control_channel_T flag bit masks.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
extern   const unsigned8_T whl_masks[];      /* {LF_M, RF_M, LR_M, RR_M} */
extern   const unsigned8_T channel_masks[];  /* {LF_M, RF_M, RA_M}       */
extern   const unsigned8_T pri_sec_masks[];  /* {PRI_M, SEC_M}           */
extern   const unsigned8_T ld_rd_masks[];    /* {LD_M, RD_M}             */


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Define two types to hold hex numbers for fault codes as par the
* customers' requirements. They are used both by enhanced diagnostics
* and communication.
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
typedef struct{
     unsigned8_T    high_byte;
     unsigned8_T    mid_byte;
     unsigned8_T    low_byte;
}three_byte_customer_fault_code_T;    /* GMLan */

typedef struct{
     unsigned8_T    high_byte;
     unsigned8_T    low_byte;
}two_byte_customer_fault_code_T;    /* Class2 */


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Gets physical apply and release coils to the LF,RF,LR and RR
* logical solenoid outputs
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define COLUMN_DIVIDE_FACTOR    (5U)
#define Get_Column_Index(column)   ( (sol_column_T)(  (2 == ((column) / COLUMN_DIVIDE_FACTOR)) \
                                                      ? \
                                                      ((column) % COLUMN_DIVIDE_FACTOR) \
                                                      : \
                                                      UNUSED_SOL_COLUMN ) )


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Gets physical cc apply and iso prime coils to the LF,RF,LR and RR
* logical solenoid outputs
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define CC_COLUMN_DIVIDE_FACTOR    (10U)
#define Get_CC_Column_Index(column)   ( (  (1 == ((column) / CC_COLUMN_DIVIDE_FACTOR)) \
                                                      ? \
                                                      (cc_sol_column_T)((column) % CC_COLUMN_DIVIDE_FACTOR) \
                                                      : \
                                                      UNUSED_CC_SOL_COLUMN ) )

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Gets physical test mode apply and iso prime coils to the LF,RF,LR and RR
* logical solenoid outputs
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define TM_COLUMN_DIVIDE_FACTOR    (10U)
#define Get_TM_Column_Index(column)   ( (column_type_T)(  (1 == ((column) / TM_COLUMN_DIVIDE_FACTOR)) \
                                                      ? \
                                                      ((column) % TM_COLUMN_DIVIDE_FACTOR) \
                                                      : \
                                                      UNUSED_SOL_COLUMN ) )

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
* Gets physical iso and prime coils to the LF,RF,LR and RR
* logical solenoid outputs
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define ISO_PRIME_COLUMN_DIVIDE_FACTOR    (10U)
#define Get_Isolation_Prime_Column_Index(column)   ( (cc_sol_column_T)(  (1 == ((column) / ISO_PRIME_COLUMN_DIVIDE_FACTOR)) \
                                                      ? \
                                                      ((column) % ISO_PRIME_COLUMN_DIVIDE_FACTOR) \
                                                      : \
                                                      UNUSED_CC_SOL_COLUMN ) )




/******************************************************
*  The following #define's are used to indicate if  *
*  the calibration variables in a desired subsystem *
*  are defined as constant objects or variables.    *
******************************************************/
/******************************************************
* For cals in FLASH use these defines
******************************************************/

#define ABCALCONST volatile const
#define ACCALCONST volatile const
#define APCALCONST volatile const
#define CFCALCONST volatile const
#define CSCALCONST volatile const
#define DBCALCONST volatile const
#define DCCALCONST volatile const
#define DGCALCONST volatile const
#define H2CALCONST volatile const
#define HFCALCONST volatile const
#define HSCALCONST volatile const
#define HWCALCONST volatile const
#define IFCALCONST volatile const
#define INCALCONST volatile const
#define MCCALCONST volatile const
#define OCCALCONST volatile const
#define SMCALCONST volatile const
#define TCCALCONST volatile const
#define VSCALCONST volatile const
#define TMCALCONST volatile const
#define VECALCONST volatile const
#define BACALCONST volatile const
#define ESCALCONST volatile const
#define VACALCONST volatile const
#define PDCALCONST volatile const

/******************************************************
* For cals in RAM use these defines
******************************************************/
/*
#define ABCALCONST
#define ACCALCONST
#define APCALCONST
#define CSCALCONST
#define CFCALCONST
#define DBCALCONST
#define DCCALCONST
#define DGCALCONST
#define H2CALCONST
#define HFCALCONST
#define HSCALCONST
#define HWCALCONST
#define IFCALCONST
#define INCALCONST
#define MCCALCONST
#define OCCALCONST
#define SMCALCONST
#define TCCALCONST
#define VSCALCONST
#define TMCALCONST
#define VECALCONST
#define BACALCONST
#define PDCALCONST
*/

/******************************************************
*  The following #define's is used to round up to  *
*  next integer                                    *
******************************************************/
#define CEILING( x )                                ( x > (unsigned16_T)x ? \
                                                      (unsigned16_T)(x + 1) : \
                                                      (unsigned16_T)(x) \
                                                    )

/******************************************************
*  The following #define's is used to create       *
*  required 64 Bit MOV64 HET Write                 *
*  For DJZ Instruction based MOV64 update, we      *
*  use direct call to the function pointer.        *
*  For Hardware based MOV64 64-Bit Write, we       *
*  use SSI Interrupt to the function pointer.      *
*  For 12V ECU with TMS470PSF764 device we don't   *
*  use SSI Interrupt as DJZ is there.              *
*  For 8V ECU with TMS470R1VF338 device we use     *
*  SSI Interrupt as we dom't have HET RAM Space    *
*  HET Access need to be contiguous during         *
*  hardware based MOV64 64-Bit Write and hence     *
*  all Interrupts are blocked using SSI            *
******************************************************/
#define WRITE_64_BIT_TIMER_DATA_ATOMICALLY(var) \
do { \
  /*generate_SSIF_FIQ_IRQ(ISR_PUMP_HET_64_WRITE);*/ \
  System_Software_Interrupt_Vector[(var)](); \
} while(0)

/******************************************************
*  The following #define's is used to create       *
*  required sections                               *
******************************************************/
#define VAR_IN_SECTION_ABS12_APP_CAL(var)          VAR_IN_SECTION(var, .ABS12_APP_CAL)
#define VAR_IN_SECTION_ABS_APP_CAL(var)            VAR_IN_SECTION(var, .ABS_APP_CAL)
#define VAR_IN_SECTION_VSE_APP_CAL(var)            VAR_IN_SECTION(var, .VSE_APP_CAL)
#define VAR_IN_SECTION_TCS_APP_CAL(var)            VAR_IN_SECTION(var, .TCS_APP_CAL)
#define VAR_IN_SECTION_ESYS_APP_CAL(var)           VAR_IN_SECTION(var, .ESYS_APP_CAL)
#define VAR_IN_SECTION_DIAG_CORE_CAL(var)          VAR_IN_SECTION(var, .DIAG_CORE_CAL)
#define VAR_IN_SECTION_VSE_CORE_CAL(var)           VAR_IN_SECTION(var, .VSE_CORE_CAL)
#define VAR_IN_SECTION_ABS_CORE_CAL(var)           VAR_IN_SECTION(var, .ABS_CORE_CAL)
#define VAR_IN_SECTION_BRAKE_ASSIST_APP_CAL(var)   VAR_IN_SECTION(var, .BRAKE_ASSIST_APP_CAL)
#define VAR_IN_SECTION_BRAKE_ASSIST_CORE_CAL(var)  VAR_IN_SECTION(var, .BRAKE_ASSIST_CORE_CAL)
#define VAR_IN_SECTION_COMM_APP_CAL(var)           VAR_IN_SECTION(var, .COMM_APP_CAL)
#define VAR_IN_SECTION_COMM_CORE_CAL(var)          VAR_IN_SECTION(var, .COMM_CORE_CAL)
#define VAR_IN_SECTION_DIAG_APP_CAL(var)           VAR_IN_SECTION(var, .DIAG_APP_CAL)
#define VAR_IN_SECTION_ESYS_CORE_CAL(var)          VAR_IN_SECTION(var, .ESYS_CORE_CAL)
#define VAR_IN_SECTION_EXT_BRK_CMD_APP_CAL(var)    VAR_IN_SECTION(var, .EXT_BRK_CMD_APP_CAL)
#define VAR_IN_SECTION_EXT_BRK_CMD_CORE_CAL(var)   VAR_IN_SECTION(var, .EXT_BRK_CMD_CORE_CAL)
#define VAR_IN_SECTION_HSA_CAL(var)                VAR_IN_SECTION(var, .HSA_CAL)
#define VAR_IN_SECTION_SENS_APP_CAL(var)           VAR_IN_SECTION(var, .SENS_APP_CAL)
#define VAR_IN_SECTION_SENS_CORE_CAL(var)          VAR_IN_SECTION(var, .SENS_CORE_CAL)
#define VAR_IN_SECTION_TCS_CORE_CAL(var)           VAR_IN_SECTION(var, .TCS_CORE_CAL)
#define VAR_IN_SECTION_SW_AND_MFG_CFG_CAL(var)     VAR_IN_SECTION(var, .SW_AND_MFG_CFG_CAL)

#define VAR_IN_SECTION_END(var)
#define VAR_IN_SECTION_BLOCK1(var)  VAR_IN_SECTION(var, .BLOCK1)
#define VAR_ALIGNMENT_16_BIT(var)  VAR_ALIGNMENT(var, 2)
#define VAR_ALIGNMENT_32_BIT(var)  VAR_ALIGNMENT(var, 4)
#define VAR_ALIGNMENT_64_BIT(var)  VAR_ALIGNMENT(var, 8)

/******************************************************
*  The following #define's is used to hide compiler   *
*  specific #pragma                                   *
******************************************************/

#ifdef __TI_COMPILER_VERSION__
   #define PRAGMA(x) _Pragma(#x)

   #define WEAK_SYMBOL_INFO(weak_symbol) \
      PRAGMA(WEAK(weak_symbol))

   #define LOOP_COUNT_INFO(min, multiple) \
      PRAGMA(MUST_ITERATE(min,,multiple))
   #define VAR_IN_SECTION(var, section) \
      PRAGMA(DATA_SECTION(var, #section))
   #define PTR_IS_ALIGNED(ptr, pow2) \
      _nassert(((unsigned int) (ptr) & (pow2)-1) == 0);
   #define VAR_ALIGNMENT(var, alignment_bytes) \
      PRAGMA(DATA_ALIGN(var, alignment_bytes))
#elif defined(_C166) && defined(_CPUTYPE) && defined(_MODEL)
   #define PRAGMA(x) _Pragma(#x)
   #define LOOP_COUNT_INFO(min, multiple) \
      PRAGMA(MUST_ITERATE(min,,multiple))
   #define CONST_IN_SECTION(section) \
      PRAGMA(class nc=#section))
   #define PTR_IS_ALIGNED(ptr, pow2) \
      _nassert(((unsigned int) (ptr) & (pow2)-1) == 0);
#else
   #define LOOP_COUNT_INFO(min, multiple)
   #define VAR_IN_SECTION(var, section)
   #define PTR_IS_ALIGNED(ptr, pow2)
#endif

/******************************************************
*  The following #define's is used to round up to  *
*  next integer                                    *
*  where 'x' is a pointer and 'n' is the           *
* (power of two) alignment that I need.            *
******************************************************/

#define PTR_OFF(x) ((unsigned long)(x))
#define ALIGN_OFFSET(x,n) (PTR_OFF(x) & ((n) - 1))
#define ALIGN_FLOOR(x,n) ((unsigned char*)(x) - ( PTR_OFF(x) & ((n) - 1)))
#define ALIGN_CEIL(x,n) ((unsigned char*)(x) + (-PTR_OFF(x) & ((n) - 1)))


/*
 *  Module Header Structure to be parsed by Bootloader
 *  for any Mode 36 Download.
 */

#if 0
/* CALDEF doesn't support UNION */
typedef union
{
//   unsigned8_T      bytes[4];
   unsigned32_T PMA_address;
   struct {
     unsigned8_T    PMA_MSB;     /* Product Memory Address     */
     unsigned8_T    PMA_MIDH;    /* Product Memory Address     */
     unsigned8_T    PMA_MIDL;    /* Product Memory Address     */
     unsigned8_T    PMA_LSB;     /* Product Memory Address     */
   }              PMA_bytes;
   unsigned32_T   PMA_word;      /* Product Memory Address     */
} pma_T;
#else
typedef struct
{
   unsigned32_T PMA_address;
} pma_T;
#endif
COMPILER_ASSERT(4==sizeof(pma_T), PMA_Must_be_4_Bytes);

typedef struct flash_code_header_TAG
{
   unsigned8_T    CS[2];      /* Module Checksum            */
   unsigned8_T    MID[2];     /* Module ID                  */
   unsigned8_T    HFI[1];     /* Header Format Identifier   */
   unsigned8_T    SWMI[4];    /* SoftWare Module Identifier */
   unsigned8_T    DLS[2];     /* Design Level Suffix        */
   unsigned8_T    NOAR[1];    /* Number Of Address Regions  */
   pma_T          PMA;        /* Product Memory Address     */
                              /* unsigned8_T    PMA[4]      */
   unsigned8_T    NOB[4];     /* Number Of Bytes            */

/* It's built into the hexarray.c
   unsigned8_T flashcode_CPU_type;
   unsigned8_T flashcode_mask_type;
   unsigned8_T flashcode_code3;
   unsigned8_T flashcode_version;
*/
} flash_code_header_T;
COMPILER_ASSERT(0x14==sizeof(flash_code_header_T), flash_code_header_T_Must_be_4_Bytes);

/*============================================================================*\
 * File Revision History (top to bottom: first revision to last revision)
 *============================================================================
 *
 *   Date       By     (Description on following lines)
 * --------  --------
 * 09/24/02  T.Helm   Initial version.
 *
 * 10/19/02  Partha Roy  Added type definition of MC_Pressure_Voltage()
 *
 * 11/08/02   G. Crane - SCR tcb_css#331 for release d7x_003
 *   Added CFCALCONST type for use in config files.
 *
 * 03/25/03 rkiran  SCR tcb_css#484 for release d74_003g.
 *   Added MACRO Define_MRAM to be used for MRAM declaration.
 *
 * 09/10/03 gbhat SCR tcb_css#690 for release d74_004f
 *    Added the #define BITA to _bita.
 *
 * 10/07/03 G. Crane - SCR tcb_css#938 for release d74_04f2
 *    Added the #define(s) ABBITA to _bita, DGBITA to _bita,
 *    IFBITA to _bita, and OCBITA to _bita.
 *
 * 11/03/03 Srivatsav SCR tcb_css#972 for release d74_005b.
 *   Removed the typedef for pump_voltage_cmd_T.
 *
 * 11/20/03 Srivatsav SCR tcb_css#519 for release d7x_006.
 *   Moved some macros to lbfuncs.h
 *
 * 11/20/03 gbhat SCR tcb_css#540 for release d7x_006
 *    Removed the macro's  Safe_Abs_S8, Safe_Abs_S16, Safe_Neg_S8
 *    and Safe_Neg_S16.
 *
 * 02/19/04 S.Su SCR tcb_css#1111 for release d74_007a
 *   Added #define CSFAR  far.
 * 02/23/04 Ethi SCR tcb_css#1037 for release d74_005f_china
 *   Added #define CSFAR  far.
 *
 * 03/20/08   Ananth SCR tcb_css#2873 for release  DBC_Layer2/78_SCJ02
 *   Added actuator_pwr_index_T
 *
 * 05/07/08   P. Roy SCR tcb_css#2877 for release  DBC_Layer2/78_08C02
 *   Added COMPILER_ASSERT macro
 *
 * 07/25/08   P. Roy SCR tcb_css#3009 for release  DBC_Layer2/78_08C04
 *   Added volatile for all CAL declaration.
 *
 * 08/18/08  P. Roy   SCR tcb_css#3071 for release DBC_Layer2/78_08C04.
 *   Removed duplicate NULL macro.
 *
 * 09/04/08 Kishore SCR tcb_css#3112 for release DBC_Layer2/78_SCJ04.
 *   Added CEILING() macro.
 *
 * 10/30/08 Kishore SCR tcb_css#3201 for release DBC_Layer2/78_08C05.
 *   modified front_rear_wheels_index_T enum
 *
 * 10/29/08   P. Roy SCR tcb_css#3190 for release DBC_Layer2/78_08C04a
 *   Added  offsetof() macro.
 *
 * 04/15/09   P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_08KC06
 *   Added MAX_AXLE_INDEX.
 *   Removed actuator_pwr_index_T.
 *
 * 07/16/09   P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_08KC07
 *   Added swi_exception_function_ptr_T
 *
 * 11/02/09   P. Roy SCR tcb_css#3846 for release DBC_Layer2/78_08KC09
 *   Added T_FLAG32
 *   Corrected compiler warnings
 *
 * 01/29/10   Gouri  SCR tcb_css#4111 for release DBC_Layer2/78_GEN01.
 * Added Get_Column_Index macro.
 *
 * 06/21/10  A. Inchal SCR tcb_css#4311 for release DBC_Layer2/78_GEN06.
 * Modified Get_Column_Index macro.
 *
 * 07/27/10  P. Roy SCR tcb_css#XXXX for release DBC7p8_Boot/07_BOOT_SCC.
 *  Added VAR_IN_SECTION() and flash_code_header_T
 *
 * 09/01/10  P. Roy SCR tcb_css#4370 for release DBC7p8_Boot/07a_BOOT_SCC.
 *  Added Compiler Defined MACROS in order to portable for Tasking
 *  compiler.
 *
 * 09/07/10  Sunil SCR tcb_css#4496 for release DBC_Layer2/78_GEN07.
 *  Cheked out for Converting to Generic Version
 *
 * 11/16/10  Nandu SCR tcb_css#4547 for release DBC_Layer2/78_GEN07.
 *  Added Get_Isolation_Prime_Column_Index()
 *
 * 01/16/11  P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_GEN08.
 *  Added 64-Bit data type
 *  Added 8-Bit wide bit_field type
 *
 * 02/03/11  P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_GEN08.
 *  Added PDCALCONST
 *
 * 03/16/11  P. Roy SCR tcb_css#XXXX for release DBC_Layer2/78_GEN08.
 *  Added VAR_ALIGNMENT macro
 *
 * 04/30/11 P. Roy Cradle SCR 273 for release DBC_Layer2/12_KC16
 *   Added S32_MIN as a CONST
 *   Added S32_MIN_VAL in order to avoid compiler optimization
 *
 * 05/13/11  Nandu Cradle SCR.251 for release DBC_Layer2/78_GEN08.
 *  Added CC_Column_Divide factor
 *
 * 06/01/11  P. Roy Cradle SCR.350 for release DBC_Layer2/78_GEN10.
 *  Corrected bit_field_16_T for 16-Bit data
 *
 * 08/30/11  P. Roy Cradle SCR.424 for release DBC_Layer2/78_12KC17a
 *  Added all the Section Names related to CAL
 *
 * 09/14/11  P. Roy Cradle SCR.434 for release DBC_Layer2/78_12KC18
 *  Added WRITE_64_BIT_TIMER_DATA_ATOMICALLY() macro
 *  Added S24_MIN
 *
 * 10/13/11 Sunil scr.494  for release DBC7p8_Layer2/78_12KC18.
 *   Add new section names to systype.h.
 *
 * 01/17/12   P. Roy Cradle SCR XXX for release DBC7p8_Boot/11_BOOT_12C
 *  Corrected Compiler Warning
 *
\*============================================================================*/

#endif /* SYSTYPE_H */
