/******************************************************************************
 *
 * Alpha_FLASH.cmd - CCS linker configuration file for the Alpha Boot Loader.
 *
 *
 *****************************************************************************/

--retain=g_pfnVectors

/* The following command line options are set as part of the CCS project.    */
/* If you are building using the command line, or for some reason want to    */
/* define them here, you can uncomment and modify these lines as needed.     */
/* If you are using CCS for building, it is probably better to make any such */
/* modifications in your CCS project and leave this file alone.              */
/*                                                                           */
/* --heap_size=4096                                                             *
/* --stack_size=4096                                                          */
/* --library=rtsv7M3_T_le_eabi.lib                                           */

/* The starting address of the application.  Normally the interrupt vectors  */
/* must be located at the beginning of the application.                      */

#define APP_BASE 0x00000000

/* System memory map */

MEMORY
{
    /* Application stored in and executes from internal flash */
    /* Only allow for 16K */
    FLASH (RX) : origin = 0x00000000, length = 0x4000
    
    /* Application uses internal RAM for data */
    /* 96K - 512 - 64  = 0x18000 - 0x200 - 0x40 = 0x17DC0
 		reserve 512 bytes at beginning of internal SRAM for the loaded app's vector table
    	reserve 64 bytes at the end of internel SRAM to pass data between Alpha and Beta boot loaders
    */
    SRAM (RWX) : origin = 0x20000200, length = 0x00017DC0
}

/* Section allocation in memory */

SECTIONS
{
//    .intvecs:   > APP_BASE
    .intvecs:   > 0x00000000
    .text   :   > FLASH
    .const  :   > FLASH
    .cinit  :   > FLASH
    .pinit  :   > FLASH

    .vtable :   > SRAM
    .data   :   > SRAM
    .bss    :   > SRAM
    .sysmem :   > SRAM
    .stack  :   > SRAM(HIGH)
}

__STACK_TOP = __stack + 4096;
