/** 
 * @getArgs.js - DSS Generic TI Loader include file that contains functions
 * used by main.js to get and parse arguments from the command-line.
 */

// Loadti environment.
testEnv = {};

/**
 * Get arguments from command-line.
 */
function getArgs()
{
    var argCt = 0;
    var argvNum = 1;

    arguments = this.arguments;

    testEnv.timeoutValue = -1;   // set default script timeout to infinite
	
	testEnv.initBss = false;
	testEnv.initBssValue = 0;

    testEnv.quietMode = false;
    testEnv.resetTarget = false;
    testEnv.verboseMode = false;

    testEnv.cioFile = null;
    testEnv.dssPath = "";
    testEnv.loadtiPath = "";
    testEnv.noProfile = true;
    testEnv.logFile = null;
    testEnv.outFiles = null;    
	testEnv.loadDat = [];
    testEnv.loadRaw = [];
    testEnv.saveDat = [];
    testEnv.saveRaw = [];

	testEnv.loadDat1 = [];
    testEnv.loadRaw1 = [];
	testEnv.loadDat2 = [];
    testEnv.loadRaw2 = []; 
    testEnv.saveDat1 = [];
    testEnv.saveRaw1 = [];
    testEnv.saveDat2 = [];
    testEnv.saveRaw2 = [];
    testEnv.setupCfgFile = null;
	// new var added for regression tests
	testEnv.ca9_0_on = false;
	testEnv.ca9_1_on  = false;
	testEnv.cm3_0_on  = false;
	testEnv.cm3_1_on  = false;
	testEnv.c64_on  = false;
	
    testEnv.test_entry_function = "";
    testEnv.test_innerloop1_end = "";
	testEnv.test_id_name = "";
	testEnv.test_id = "";
	testEnv.test_gel_init = "";
	testEnv.test_reg_res = "";
	testEnv.gel_file = "";


    testEnv.test_async_load_1 = "";
    testEnv.test_async_load_2 = "";
    testEnv.test_async_save_1 = "";
    testEnv.test_async_save_2 = "";
		
	testEnv.dual_core = false;
    // pull all the ARGV arguments off command line
    testEnv.argvArgs = [];

	// If no arguments were passed to the script, then print help and exit.
    if (arguments.length == 0)
    {
		exitWithHelp();
	}
	
	// Split arguments containing '=' into multiple arguments. This is needed because on Windows the arguments array
	// is already broken up in this manner, but on Linux it is not.
	var args2 = [];
	for (var i = 0; i < arguments.length; ++i)
	{
		splitArgs = arguments[i].split("=");
		args2 = args2.concat(splitArgs);
	}
	arguments = args2;
	
	// If any option files have been provided, then parse and insert their contents into "arguments".
	for (var i = 0; i < arguments.length; ++i)
	{
		if (arguments[i] == "-@" || arguments[i] == "--options-file" || arguments[i] == "--options_file")
		{
			// Open the options file.
			var fr;
			var reader;
			try
			{
				fr = new java.io.FileReader(arguments[i+1]);
			}
			catch(ex)
			{
				errCode = getErrorCode(ex);
	            dssScriptEnv.traceWrite("Error code #" + errCode + ", Could not open Input parameter file");
	            quit(errCode != 0 ? errCode : 1);
			}
			reader = new java.io.BufferedReader(fr);
			// Remove the option file argument from "arguments"
			arguments.splice(i, 2);
		
			// Create and setup the parser.
			var st = new java.io.StreamTokenizer(reader);
			st.ordinaryChars(33, 33); // "!"
			st.wordChars(33, 33);
			st.ordinaryChars(35, 38); // "#" -> "&"
			st.wordChars(35, 38);
			st.ordinaryChars(40, 60); // "(" -> "<"
			st.wordChars(40, 60);
			st.ordinaryChars(62, 64); // ">" -> "@"
			st.wordChars(62, 64);
			st.ordinaryChars(91, 96); // "[" -> "`"
			st.wordChars(91, 96);
			st.ordinaryChars(123, 126); // "{" -> "~"
			st.wordChars(123, 126);

			// Parse and insert the option file's contents into "arguments".
			var ttype;
			var j = i;
			while ((ttype = st.nextToken()) != java.io.StreamTokenizer.TT_EOF)
			{
				if (ttype == java.io.StreamTokenizer.TT_WORD || ttype == 34 || ttype == 39)
				{
					var s = st.sval;
					arguments.splice(j++, 0, s);
				}
			}

			reader.close();
			--i;
		}
	}
	
	var usingOutfileOption = false;

    // Parse arguments passed to script.
	while (argCt < arguments.length)
	{
		// if an option, get the option
		if (arguments[argCt].match(/^-(.*)/))
		{
			++argCt;
			
			switch(RegExp.$1)
			{
				case "c":
				case "-cfg-file":
				case "-cfg_file":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.setupCfgFile = arguments[argCt++];
					break;
				case "h":
				case "-help":
					exitWithHelp();
					break;
				case "mlr":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadRaw[testEnv.loadRaw.length] = arguments[argCt++];
					break;
				case "mlr1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadRaw1[testEnv.loadRaw1.length] = arguments[argCt++];
					break;
				case "mlr2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadRaw2[testEnv.loadRaw2.length] = arguments[argCt++];
					break;
				case "mld":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadDat[testEnv.loadDat.length] = arguments[argCt++];
					break;
				case "mld1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadDat1[testEnv.loadDat1.length] = arguments[argCt++];
					break;
				case "mld2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.loadDat2[testEnv.loadDat2.length] = arguments[argCt++];
					break;

				case "msr":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveRaw[testEnv.saveRaw.length] = arguments[argCt++];
					break;
				case "msr1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveRaw1[testEnv.saveRaw1.length] = arguments[argCt++];
					break;
				case "msr2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveRaw2[testEnv.saveRaw2.length] = arguments[argCt++];
					break;	
				case "msd":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveDat[testEnv.saveDat.length] = arguments[argCt++];
					break;
				case "msd1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveDat1[testEnv.saveDat1.length] = arguments[argCt++];
					break;
				case "msd2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.saveDat2[testEnv.saveDat2.length] = arguments[argCt++];
					break;			
				case "o":
				case "-out-file":
				case "-out_file":
				case "-out-files":
				case "-out_files":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.outFiles = arguments[argCt++];
					usingOutfileOption = true;
                    break;
				case "q":
				case "-quiet":
					testEnv.quietMode = true;
					break;
				case "r":
				case "-reset":
					testEnv.resetTarget = true;
					break;
				case "s":
				case "-stdout-file":
				case "-stdout_file":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.cioFile = arguments[argCt++];
					break;
				case "t":
				case "-timeout":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.timeoutValue = parseInt(arguments[argCt++]);
					break;
				case "v":
				case "-verbose":
					testEnv.verboseMode = true;
					break;
				case "x":
				case "-xml-log":
				case "-xml_log":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.logFile = arguments[argCt++];
					break;
				// Modif CM 2010/05/25
				// select target CPU
				case "ca9_0":
					testEnv.ca9_0_on  = true;
					break;
				case "ca9_1":
					testEnv.ca9_1_on  = true;
					break;
				case "cm3_0":
					testEnv.cm3_0_on  = true;
					break;
				case "cm3_1":
					testEnv.cm3_1_on  = true;
					break;
				case "c64":
					testEnv.c64_on  = true;
					break;
				case "bkp_te": // initial breakpoint in test entry function
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_entry_function = arguments[argCt++];
					break;
				case "bkp_ile1": //  breakpoint in test iner loop level 1 end(i.e. loop on stream)
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_innerloop1_end = arguments[argCt++];
					break;
				case "bkp_as_l1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_async_load_1 = arguments[argCt++];
                    break;				
				case "bkp_as_l2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_async_load_2 = arguments[argCt++];
                    break;				
				case "bkp_as_s1":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_async_save_1 = arguments[argCt++];
					testEnv.async_sav_1 = true;
                    break;				
				case "bkp_as_s2":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_async_save_2 = arguments[argCt++];
                    break;
				case "tid_expr": //  global var containing test identifier
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_id_name= arguments[argCt++];
					// tes id in necessarly the next argument..if syntax is -test_exprr test_reg=test_id
					testEnv.test_idx = parseInt(arguments[argCt++]);
					break;
				case "tid_gel": // test gel init function value GEL must be loaded at setup
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					else {
						testEnv.test_gel_init = arguments[argCt++];
						//print("GEL file function: " + testEnv.test_gel_init);
					}
					break;
            
				case "res": //  global var containing test result (PASS/ FAIL)
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.test_reg_res = arguments[argCt++];
					break;
					// GEL load from script not supported up to known...
				case "load_gel":
					if (argCt == arguments.length || arguments[argCt].substr(0, 1) == "-")
					{
						exitWithArgError("Invalid use of option `" + arguments[argCt-1] + "', argument expected");
					}
					testEnv.gel_file = arguments[argCt++];
					break;
				case "dual_core":
					testEnv.dual_core  = true;
					// automatically enable cortex a9 1 session
					testEnv.ca9_1_on  = true;
					break;
				
				default:
					exitWithArgError("Unrecognized option `" + arguments[argCt-1] + "'");
					break;
			}
		}
		else
		{
			if (usingOutfileOption)
			{
				// it is a argument to be passed to main
				testEnv.argvArgs[argvNum++] = arguments[argCt++];
			}
			else
			{
				// it is the outfile list, and all arguments that follow it are arguments to be passed to main
				
				testEnv.outFiles = arguments[argCt++];
				
				while (argCt < arguments.length)
				{
					testEnv.argvArgs[argvNum++] = arguments[argCt++];
				}

				break;
			}
		}
	}
	// checl if at least one core is specified 
	if ( ( testEnv.ca9_0_on == false) && ( testEnv.ca9_1_on == false) && ( testEnv.cm3_0_on == false) && 
	     ( testEnv.cm3_1_on == false) && ( testEnv.c64_on == false))
	{
		exitWithArgError("you need to specify at leat one core");
	}
}

/**
 * Print command-line argument error along with correct usage and exit.
 */
function exitWithArgError(message)
{
	print("ERROR: " + message);
	print();

	printHelp();

    delete testEnv;
    java.lang.System.exit(1);
}

/**
 * Print help and exit.
 */
function exitWithHelp()
{
	printHelp();

    delete testEnv;
    java.lang.System.exit(0);
}

/**
 * Print help to console.
 */
function printHelp()
{
	print(
		"Usage: loadti [OPTION]... [OUT_FILE1[+OUT_FILE2]...] [ARGUMENT]...\n" +
		"Load OUT_FILE executable(s) to TI target and run, passing ARGUMENT(s) to main.\n" +
		"\n" +
		"Mandatory arguments to long options are mandatory for short options too.\n" +
		"Options:\n" +
        "  -c,   --cfg-file=CONFIG_FILE\n" +
        "  -h,   --help\n" +
        "  -mlr, -mlr1,-mlr2 =\"PAGE,ADDR,FILE,TYPE_SIZE,BYTE_SWAP\"\n" +
        "  -mld, -mld1, -mld2 =\"PAGE,ADDR,FILE,LEN\"\n" +
        "  -msr, -msr1, -mssr2 =\"PAGE,ADDR,FILE,LEN,TYPE_SIZE,BYTE_SWAP\"\n" +
        "  -msd, -msd1, -msd2 =\"PAGE,ADDR,FILE,LEN,IO_FORMAT,APPEND\"\n" +
        "  -q,   --quiet\n" +
        "  -r,   --reset\n" +
        "  -s,   --stdout-file=FILE\n" +
        "  -t,   --timeout=VALUE\n" +
        "  -v,   --verbose\n" +
        "  -x,   --xml-log=FILE\n" +
		"-ca9_0, Use of CortexA9_0 core, MANDATORY\n" +
		"-ca9_1, Use of CortexA9_0 core, OPTIONNAL\n" +
		"-cm3_0, Use of CortexM3_0 core, OPTIONNAL\n" +
		"-cm3_1, Use of CortexM3_1 core, OPTIONNAL\n" +
		"-c64, Use of C64 core, OPTIONNAL\n" +
		" -bkp_te, Entry test function, OPTIONNAL\n" +
		" -bkp_ile1, Inner loop level 1 end(loop on test pattern), OPTIONNAL \n" +
		" -bkp_as_l1/ bkp_as_l2 , asynchronous memory load function \n" +
		" -bkp_as_s1/ bkp_as_s2 , asynchronous memory save function \n" +
		"-tid_expr, Expression to evaluate prior to start test, OPTIONNAL\n" +
		"-tid_gel, Gel function to execute prior to start test, OPTIONNAL\n" +
	   " -res, Test result structure to display\n, MANDATORY" +
		"  -@,   --options-file=FILE\n");
}
