/**
 * @main.js - This script mimics Texas Instruments' load6x stand-alone
 * simulator base functionality but will work with any TI target (HW or
 * Simulator) that is supported by Debug Server Scripting.
 */
// omap genric registers
var debugServer = null;
var isDebugServer = false;
var isDbgSession = false;
var DbgSession = null;

var OMAP4_DEVICE_TYPE_ADDR = "0x4A0022C4";
var OMAP4_REVISION_NUMBER_ADDR = "0x4A002204";

 // define global variable for breakpoint
// values are assigned in a user file EnvBkp.js
var C4_BREAKS = java.lang.System.getenv("C4_BREAKS");

var TestNormalEndFunction = "";
var TestAbnormalEndFunction = "";
var TestPrefectchAbortFunction = "";
var TestDataAbortFunction = "";

var NbMemLoad1 = 0;
var NbMemLoad2 = 0;
var NbMemSave1 = 0;
var NbMemSave2 = 0;

// var debugServer = null;
// var isDebugServer = false;
// var	DbgSession = false;

// Run loadti.
testEnv = {};
run();

/**
 * Send message to the console and log (if logging is enabled)
 * @param {String} The string to output to the console/log.
 */
function printTrace(string)
{
    if (!testEnv.quietMode)
	{
        dssScriptEnv.traceWrite(string);
    }
}

/**
 * Get error code from the given exception.
 * @param {exception} The exception from which to get the error code.
 */
function getErrorCode(exception)
{
	var ex2 = exception.javaException;
	if (ex2 instanceof Packages.com.ti.ccstudio.scripting.environment.ScriptingException) {
		return ex2.getErrorID();
	}
	return 0;
}

/**
 * This function is called to perform some clean up before exiting (or
 * aborting) the script. It assumes that the the scripting environment and
 * debug and profile servers have been created.
 */
function quit(retVal)
{

     if (isDbgSession == true)
	{
	    // remove all breakpoints
		DbgSession.breakpoint.removeAll();
        // Close debug session.
        DbgSession.terminate();
    }

    if (isDebugServer == true)
	{
		debugServer.stop();
    }

    date = new Date();
    printTrace("\nEND: " + date.toTimeString());

    if (testEnv.logFile != null)
	{
        // Close log.
		dssScriptEnv.traceEnd();
    }

	printTrace("Deleting Test environement data..");
    delete testEnv;

    // Terminate JVM and return main return value.
    java.lang.System.exit(retVal);
}


/*
 * Main function.
 */
function run()
{
    var inst;

    var errCode = 0;
    var retVal = 0;
    var date = 0;
    var defaultTimeout = -1;
	var exit_test=0;
	var a9_reg , PC_a9;
	var nb_runs = 0;
	
	isDebugServer = false;
	// isDbgSession = false;
   DbgSession_a9_0 = false;
    DbgSession_a9_1 = false;
   DbgSession_m3_0 = false;
    DbgSession_m3_1 = false;
    DbgSession_c64  = false;
	
   load( java.lang.System.getenv("SCRIPT_DIR") +"/dss/getArgs.js");
   load(java.lang.System.getenv("SCRIPT_DIR") + "/dss/memXfer.js");
   // Load the breakpoint defintion
   // done in an external file since dependent of the OS / Test framework
   load( java.lang.System.getenv("SCRIPT_DIR") + "/dss/EnvBkp.js");
    load( java.lang.System.getenv("SCRIPT_DIR") + "/dss/SetBkp.js");
  
   getArgs();

    // Create base scripting environment.
    dssScriptEnv = Packages.com.ti.ccstudio.scripting.environment.ScriptingEnvironment.instance();

    // Set overall script timeout value.
    dssScriptEnv.setScriptTimeout(defaultTimeout);

    // Enable logging to a file if specified.
    if (testEnv.logFile != null)
    {
        // NOTE: Log output folder must already exist.
        try
		{
            dssScriptEnv.traceBegin(testEnv.logFile, java.lang.System.getenv("LOADTI_PATH").replace("\\", "/") +
					"/DefaultStylesheet.xsl");
            dssScriptEnv.traceSetFileLevel(Packages.com.ti.ccstudio.scripting.environment.TraceLevel.FINE);
        }
		catch (ex)
		{
			errCode = getErrorCode(ex);
            dssScriptEnv.traceWrite("Error code #" + errCode + ", failed to enable logging for " + testEnv.logFile +
					"\nLogging disabled!");
            testEnv.logFile = null;
        }
    }

    // Set console verbosity.
    if (testEnv.verboseMode)
	{
        dssScriptEnv.traceSetConsoleLevel(Packages.com.ti.ccstudio.scripting.environment.TraceLevel.ALL);
    }

    printTrace("\n***** DSS Generic Loader *****\n");

    date = new Date();
    printTrace("START: " + date.toTimeString() + "\n");

    // Configure the Debug Server.
    if (testEnv.setupCfgFile != null)
    {
        printTrace("Configuring Debug Server for specified target...");

        load(java.lang.System.getenv("SCRIPT_DIR") +"/dss/dsSetup.js");

        errCode = configureDebugServer(testEnv.setupCfgFile, dssScriptEnv);
        if (errCode != 0)
        {
			printTrace("Error while configuring CCS...");
            quit(errCode);
        }

 		// There's no more to do if no outfiles have been provided.
		if (testEnv.outFiles == null)
		{
			printTrace("No executable file to load, abort");
			quit(2);
		}
    }
	else
	{
        if (java.lang.System.getProperty("os.name").contains("Linux"))
        {
            dssScriptEnv.traceWrite("No target setup configuration file specified. Aborting!");
            quit(3);
        }

        printTrace("No target setup configuration file specified. Using existing setup");
    }

    // Open Debug Server session.
	if  ((testEnv.ca9_0_on == true)  && (isDebugServer == true))
	{
		dssScriptEnv.traceWrite("Open Cortex a9 CPU0 session");
		DbgSession_a9_0 = debugServer.openSession("Emulator_0/CortexA9_0");
		//DbgSession_a9_0 = debugServer.openSession("*","*");
        isDbgSession = true;
		printTrace("TARGET: " + DbgSession_a9_0.getBoardName());
	}
	else
	{
		dssScriptEnv.traceWrite("Fatal Error No CPU specified or Server id not OK");
		quit(4);
	}

	// Run the StartUp() GEL function, not called by DSS, why?
	//DbgSession_a9_0.expression.evaluate("StartUp()");
	
    printTrace("Connecting to target...");

    // Connect to target. If target is simulator or already connected, a warning will be reported.
    try
	{
        DbgSession_a9_0.target.connect();
    }
	catch (ex)
	{
		errCode = getErrorCode(ex);
        dssScriptEnv.traceWrite("Error code #" + errCode + ", could not connect to target!\nAborting!");
        quit(errCode != 0 ? errCode : 1);
    }
    //  add gel eval : gle not called automatically?
	//DbgSessiona9_0.expression.evaluate("opp_default_config_board_OPP100_ES1()");
    // open only one session at a time for now...
    DbgSession = DbgSession_a9_0;
	
	// done after a9_0 is connected
	if  (testEnv.ca9_1_on == true) {
	    // cortexa9_1 is under reset. should be released which function?
		// DbgSession.expression.evaluate("reset_ducati_cortexM3_RTOS_board");
		DbgSession_a9_1 = debugServer.openSession("Emulator_0/CortexA9_1");
        isDbgSession = true;
		printTrace("TARGET: " + DbgSession_a9_1.getBoardName());
	}
	if  (testEnv.cm3_0_on == true) {
		 // cortexm3_0 is under reset. should be released
		DbgSession_a9_0.expression.evaluate("reset_ducati_cortexM3_RTOS_board()");
		DbgSession_m3_0 = debugServer.openSession("Emulator_0/Cortex_M3_0");
        isDbgSession= true;
		printTrace("TARGET: " + DbgSession_m3_0.getBoardName());
	}
	if  (testEnv.cm3_1_on == true) {
		DbgSession_a9_0.expression.evaluate("reset_ducati_cortexM3_SIMCOP_board()");
		DbgSession_m3_1 = debugServer.openSession("Emulator_0/Cortex_M3_1");
        isDbgSession = true;
		printTrace("TARGET: " + DbgSession_m3_1.getBoardName());
	}
	if  (testEnv.c64_on == true) {
		DbgSession_a9_0.expression.evaluate("reset_tesla_C64_board()");
		DbgSession_c64 = debugServer.openSession("Emulator_0/C646X");
        isDbgSession = true;
		printTrace("TARGET: " + DbgSession_c64.getBoardName());
	}
	
	if (testEnv.cioFile != null)
	{
		// Begin CIO logging.
		DbgSession.beginCIOLogging(testEnv.cioFile);
	}
			
	// Options.
	DbgSession.options.setBoolean("AddCIOBreakpointAfterLoad", false);
	DbgSession.options.setBoolean("AutoRunToLabelOnRestart", false);
	DbgSession.options.setBoolean("EnableInstalledBreakpoint", false);
	//DbgSession.options.printOptions(".*");
	DbgSession.options.setString("VerifyAfterProgramLoad","No verification");
	
	// load GEL file here, but how to do that? Foe now the gel mustbe part of the standard startup GEL file
	// Sol: add one gel wrapper function in the existing gel laoded at startup
	// this wrapper just cal GEL_LoadGel() function with an index as an input argument since GEL functions accept only integer
	// the file DSS_gel_wrapper.gel must be modified by user evry time a new gel file is to be added
	if (testEnv.gel_file != "")
	{
		printTrace("load User GEL file");
		try
		{
			DbgSession.expression.evaluate("DSS_GEL_LoadGel(" + testEnv.gel_file + ")" );
		}
		catch(ex)
		{
				dssScriptEnv.traceWrite("Erorr: unable to load user gel " + testEnv.gel_file);
				errCode = getErrorCode(ex);
				quit(errCode);
		}
	}
	else
	{
		printTrace("No User GEL file loaded");
	}

   printTrace("Set the breakpoints...");
   SetEnvBkp();
   
	// Load and run each program provided.
	//java.lang.System.out.println("testEnv.outFiles: " + testEnv.outFiles);
	var st = new java.util.StringTokenizer(testEnv.outFiles, "+");
	while (st.hasMoreTokens())
	{
	    if (testEnv.resetTarget)
	    {
	        printTrace("Resetting target...");

	        // Reset target.
	        try
			{
	            DbgSession.target.reset();
	        }
			catch (ex)
			{
				errCode = getErrorCode(ex);
	            dssScriptEnv.traceWrite("Error code #" + errCode + ", could reset target!\nAborting!");
	            quit(errCode != 0 ? errCode : 1);
	        }
	    }

		var outFile = st.nextToken();
	
		var filePath = new java.io.File(outFile);
		var outFileName = filePath.getName();
		testEnv.argvArgs[0] = outFileName;
	
		printTrace("Loading " + outFile);

	    // Load program and pass arguments to main (if applicable).
		var nb_load_exe=0;
	    do
		{
			try
			{
				DbgSession.memory.loadProgram(outFile);
				break;
		    }
			
			catch (ex)
			{
				errCode = getErrorCode(ex);
				if (nb_load_exe < 3)
				{
					printTrace("Error code #" + errCode + ", " + outFile + " load failed!\nRetry!");		
				}
				else
				{
			        printTrace("Error code #" + errCode + ", " + outFile + " load failed!\nAborting!");
				}
		    }
		}
		while (++nb_load_exe <3);
		if ( nb_load_exe <3)
			printTrace("Programm loading done");
		else
			quit(errCode != 0 ? errCode : 1);
			

		// first retrieve general information on the chip
		a9_reg= (DbgSession.memory.readData(0,OMAP4_DEVICE_TYPE_ADDR,32) & 0x300)>>8;
		if ( a9_reg == 0)
			dssScriptEnv.traceWrite("OMAP device type: TEST " );
		else if ( a9_reg == 1)
			dssScriptEnv.traceWrite("OMAP device type: EMU " );
		else if ( a9_reg == 2)
			dssScriptEnv.traceWrite("OMAP device type: HS " );
		else if ( a9_reg == 3)
			dssScriptEnv.traceWrite("OMAP device type: GP " );

		a9_reg= DbgSession.memory.readData(0,OMAP4_REVISION_NUMBER_ADDR,32);
		if ((a9_reg & 0xf0000000) == 0)
			dssScriptEnv.traceWrite("OMAP4 revision ES1.0");
		else if ((a9_reg & 0xF0000000) == 0x10000000)
			dssScriptEnv.traceWrite("OMAP4 revision ES2.0");
		else if ((a9_reg  & 0xF0000000) == 0x30000000) 
			dssScriptEnv.traceWrite("OMAP4 revision ES2.1");
		else if ((a9_reg  & 0xF0000000) == 0x40000000) 
			dssScriptEnv.traceWrite("OMAP4 revision ES2.2");
		else if ((a9_reg  & 0xF0000000) == 0x50000000) // TBC
			dssScriptEnv.traceWrite("OMAP4 revision ES2.3");
		else
			dssScriptEnv.traceWrite("OMAP4 revision number unknown");			

	    printTrace("Add Breakpoints");

		SetBkp();
		// add specific stuff for Vmin search
		if (testEnv.dual_core == true)
		{
		   // add breakpoint in IPC function to modify A9 cpu1 PC after reset
		   DbgSession.breakpoint.add("MSG_Read");
	  	   // run till there and rthen open cortex a9 1 session
		   DbgSession.target.run();
		   DbgSession_a9_1.target.connect();
		   dssScriptEnv.traceWrite("Connect CPU_A9_1 Done!");

		   // Change CPU_A9_1 Program Counter PC value
		   a9_reg = DbgSession_a9_1.expression.evaluate("PC="+0x81800000);
		   dssScriptEnv.traceWrite("PC = " + a9_reg);

		   // Start CPU_A9_1
		   dssScriptEnv.traceWrite("Restart CPU_A9_1 program...");
		   DbgSession_a9_1.target.disconnect();	// Can not use 'target.run' because we stay in a loop in this function
												//	and consequently we could not restart CPU_0 
		   // Restart CPU_A9_0 program
		   dssScriptEnv.traceWrite("Restart CPU_A9_0 program...");
		   DbgSession.target.run();

		}
		
		if (testEnv.test_entry_function != "")
		{
			// re run till test entry point
			a9_reg = DbgSession.expression.evaluate("PC");
			dssScriptEnv.traceWrite("PC = " + a9_reg);
			dssScriptEnv.traceWrite("re run till test entry point");
			try
			{
				DbgSession.target.run();
			}
		
			catch (ex)
			{
				errCode = getErrorCode(ex);	
				dssScriptEnv.traceWrite("Get exec error: " +errcode);
				quit(errCode);
			}			
			a9_reg = DbgSession.expression.evaluate("PC");
			dssScriptEnv.traceWrite("PC = " + a9_reg);
			if (DbgSession.expression.evaluate("PC=="+testEnv.test_entry_function))
			{
				dssScriptEnv.traceWrite("Stopped at test entry function");
				
				// 1st method to give test idenfifier:
				// if only one variable need to be modified
				// Script will evaluate  <test_var> = <test_id>
				if (testEnv.test_id_name != "")
				{ // set test identifier
					DbgSession.expression.evaluate(testEnv.test_id_name  + "=" + testEnv.test_idx );
					if (DbgSession.expression.evaluate(testEnv.test_id_name  + "==" + testEnv.test_idx ))
						dssScriptEnv.traceWrite("Set test identifier correctly");
				}
				if (testEnv.test_gel_init  != "")
				{ // set test identifier
					dssScriptEnv.traceWrite("Evaluate gel function: " + testEnv.test_gel_init );
					try
					{
						DbgSession.expression.evaluate(testEnv.test_gel_init );
						dssScriptEnv.traceWrite("correctly ecxecute gel function");
					}
					catch(ex)
					{
						dssScriptEnv.traceWrite("Debugger can not execute gel function");
						errCode = getErrorCode(ex);	
						quit(errCode);
					}

				}

				// Load data from the host to target memory (if applicable).
			    if ((testEnv.loadRaw.length > 0) || (testEnv.loadDat.length > 0))
			    {
					dssScriptEnv.traceWrite("Loading data to target memory...");
					// Last param set to -1 to force synchronous load mode: multiple data sets can be laoded at the same time
					errCode = memLoad(dssScriptEnv, DbgSession, testEnv.loadRaw, testEnv.loadDat,-1);

					if (errCode != 0)
					{
						dssScriptEnv.traceWrite("Memory load failed with errCode: " + errCode);
						quit(errCode);
					}
					else
					{
						dssScriptEnv.traceWrite("Memory load Done");
					}
			    }

			}	
		}

		nb_runs = 0;
	    do { // loop in different bkp set: take action according to the PC value

			printTrace("Target running...");

			// Set script timeout value for run API.
			dssScriptEnv.setScriptTimeout(testEnv.timeoutValue);

			// Run to end of program (or timeout) and return total cycles unless asynch run.
			try
			{
				printTrace("Interrupt to abort . . .");

				if (!testEnv.noProfile)
				{
					printTrace("Run with profiling ON. . .");
					var cycles = DbgSession.clock.runBenchmark();
				}
				else
				{
					printTrace("Synchronous Run target. . .");
					DbgSession.target.run();				
				}
			}
			catch (ex)
			{
				errCode = getErrorCode(ex);
				if (errCode == 1001)
				{
					printTrace(">> OVERALL TIMED OUT");
					DbgSession.target.halt();
				}
				else
				{
					dssScriptEnv.traceWrite("Error code #" + errCode +
							", error encountered during program execution!\nAborting!");
					quit(errCode != 0 ? errCode : 1);
				}
			}

			// Set script timeout value to default.
			dssScriptEnv.setScriptTimeout(defaultTimeout);

			if ( !testEnv.noProfile)
			{
				// Print cycle counts unless script timout occured on program execution.
				if (errCode != 1001)
				{
					printTrace("NORMAL COMPLETION: " + cycles + " cycles");
				}
			}
		

			if ((testEnv.test_innerloop1_end != "" ) && (DbgSession.expression.evaluate("PC==" + testEnv.test_innerloop1_end)))			{
				dssScriptEnv.traceWrite("Stopped at " + testEnv.test_innerloop1_end);
				if (testEnv.test_reg_res != "")
				{
				    // the result structure must contains mandatory fields such as:
					// error: indicate error code, 0 for test OK
					// board_type: TEB/ PAD/ EVM
					// Omap_type: EMU / GP / HS
					// Omap Rev Number (ES1 / ES2.0 / ES2.1 )
					// periph_used: (Camera- SD- MMC - eMMC - SDRAM,..)
					// nb_elem: number of extra element to output on top of the above ones  (all are 32 bit-wide) Use save data for array
					try
					{
						a9_reg = DbgSession.expression.evaluate(testEnv.test_reg_res + ".error");	
					}
					catch (ex)
					{
						errCode = getErrorCode(ex);
						dssScriptEnv.traceWrite("\r\nWarning: Test result structure does not have error field");

					}
					if ( a9_reg==0)
					{
						var res,nb_param,idx;
						dssScriptEnv.traceWrite("Test Pass");
						// get more data					
						res= DbgSession.expression.evaluate(testEnv.test_reg_res + ".periph_used");
						dssScriptEnv.traceWrite("Peripherals used by test:");
						if (res & 0x1)
							dssScriptEnv.traceWrite("EMMC_CARD_USED");
						if (res & 0x2)
							dssScriptEnv.traceWrite("MMC_CARD_USED");
						if (res & 0x4)
							dssScriptEnv.traceWrite("SD_CARD_USED");
						if (res & 0x8)
							dssScriptEnv.traceWrite("SDRAM_CARD_USED");
						if (res & 0x10)
							dssScriptEnv.traceWrite("HDMI_OUT_USED");
						
						nb_param= DbgSession.expression.evaluate(testEnv.test_reg_res + ".nb_elem");
						for (idx =0; idx < nb_param;idx++)
						{
							res= DbgSession.expression.evaluate(testEnv.test_reg_res + ".OutParam[" +idx +"]");
							dssScriptEnv.traceWrite("Test Output Param[" + idx + "]:"+res);
						}

					}
					else{
						dssScriptEnv.traceWrite("Test Fail! error code: " + a9_reg);
						errCode = a9_reg;
					}
					// Save data from target memory to a file on the host (if applicable).
					if ((testEnv.saveRaw.length > 0) || (testEnv.saveDat.length > 0))
					{
						dssScriptEnv.traceWrite("Saving data to file...");
						errCode = memSave(dssScriptEnv, DbgSession, testEnv.saveRaw, testEnv.saveDat, -1);
						if (errCode != 0)
						{
							printTrace("Memory save failed with errCode: " + errCode);
							quit(errCode);
						}
						else
						{
							printTrace("Memory save Done");
						}
					}
					nb_runs++; 
				}
			    dssScriptEnv.traceWrite("Test execution complete! ...");
			}
			else if ((testEnv.test_async_load_1 != "" ) && (DbgSession.expression.evaluate("PC==" + testEnv.test_async_load_1)))
			{
				dssScriptEnv.traceWrite("Stopped at " + testEnv.test_async_load_1);
				// Load data from the host to target memory (if applicable).
			    if ((testEnv.loadRaw1.length > 0) || (testEnv.loadDat1.length > 0))
			    {
			        if ( ((testEnv.loadRaw1.length > 0) && (NbMemLoad1 < testEnv.loadRaw1.length ))  || ((testEnv.loadDat1.length > 0) && (NbMemLoad1 < testEnv.loadDat1.length )))
					{
				        printTrace("Loading data to target memory..."+ NbMemLoad1);
				        printTrace(testEnv.loadRaw1[NbMemLoad1]);
						// nb data to load is not always known when starting the test
				        errCode = memLoad(dssScriptEnv, DbgSession, testEnv.loadRaw1, testEnv.loadDat1,NbMemLoad1);
						NbMemLoad1++;

				        if (errCode != 0)
				        {
				            printTrace("Memory load failed with errCode: " + errCode);
				        }
						else
						{
				            printTrace("Memory load Done");
				        }
					}
					else
					{
						dssScriptEnv.traceWrite("Error: no more input file available!");
						quit(6);
					}
				}
			}
			else if ((testEnv.test_async_load_2 != "" ) && (DbgSession.expression.evaluate("PC==" + testEnv.test_async_load_2)))
			{
				dssScriptEnv.traceWrite("Stopped at " + testEnv.test_async_load_2);
				// Load data from the host to target memory (if applicable).
			    if ((testEnv.loadRaw2.length > 0) || (testEnv.loadDat2.length > 0))
			    {
			        if ( ((testEnv.loadRaw2.length > 0) && (NbMemLoad2 < testEnv.loadRaw2.length ))  || ((testEnv.loadDat2.length > 0) && (NbMemLoad2 < testEnv.loadDat2.length )))
					{
				        printTrace("Loading data to target memory...");
						// nb data to load is not always known when starting the test
				        errCode = memLoad(dssScriptEnv, DbgSession, testEnv.loadRaw2, testEnv.loadDat2,NbMemLoad2);
						NbMemLoad2++;

				        if (errCode != 0)
				        {
				            printTrace("Memory load failed with errCode: " + errCode);
							quit(errCode);	
						}
						else
						{
				            printTrace("Memory load Done");
				        }
					}
					else
					{
						dssScriptEnv.traceWrite("Error: no more input file available!");
						quit(6);
					}
				}
			}
			else if ((testEnv.test_async_save_1 != "" ) && (DbgSession.expression.evaluate("PC==" + testEnv.test_async_save_1)))
			{
				dssScriptEnv.traceWrite("Stopped at " + testEnvtest_async_save_1);
				// Load data from the host to target memory (if applicable).
			    if ((testEnv.saveRaw1.length > 0) || (testEnv.saveDat1.length > 0))
			    {
					 if ( ((testEnv.saveRaw1.length > 0) && (NbMemSave1 < testEnv.saveRaw1.length ))  || ((testEnv.saveDat1.length > 0) && (NbMemSave1 < testEnv.saveDat1.length )))
					{
				        printTrace("Loading data to target memory...");
						// nb data to load is not always known when starting the test
				        errCode = memSave(dssScriptEnv, DbgSession, testEnv.saveRaw1, testEnv.saveDat1,NbMemSave1);
						NbMemSave1++;

				        if (errCode != 0)
				        {
				            printTrace("Memory load failed with errCode: " + errCode);
							quit (errCode);
				        }
						else
						{
				            printTrace("Memory load Done");
				        }
					}
					else
					{
						dssScriptEnv.traceWrite("Error: no more output file available!");
						quit(7);
					}
				}
			}
			else if ((testEnv.test_async_save_2 != "" ) && (DbgSession.expression.evaluate("PC==" + testEnv.test_async_save_2)))
			{
				dssScriptEnv.traceWrite("Stopped at " + test_async_save_2);
				// Load data from the host to target memory (if applicable).
			    if ((testEnv.saveRaw2.length > 0) || (testEnv.saveDat2.length > 0))
			    {
			        if ( ((testEnv.saveRaw2.length > 0) && (NbMemSave2 < testEnv.saveRaw2.length ))  || ((testEnv.saveDat2.length > 0) && (NbMemSave2 < testEnv.saveDat2.length )))
					{
				        printTrace("Loading data to target memory...");
						// nb data to load is not always known when starting the test
				        errCode = memSave(dssScriptEnv, DbgSession, testEnv.saveRaw2, testEnv.saveDat2,NbMemSave2);
						NbMemSave2++;

				        if (errCode != 0)
				        {
				            printTrace("Memory load failed with errCode: " + errCode);
							quit (errCode);
				        }
						else
						{
				            printTrace("Memory load Done");
				        }
					}
					else
					{
						dssScriptEnv.traceWrite("Error: no more output file available!");
						quit(7);
					}
			    }
			}
			else if (DbgSession.expression.evaluate("PC=="+ TestNormalEndFunction))
			{
				dssScriptEnv.traceWrite("Stopped at " + TestNormalEndFunction);
				//errCode = 0;
				exit_test=1;
			}
			else if (DbgSession.expression.evaluate("PC=="+ TestAbnormalEndFunction))
			{
				dssScriptEnv.traceWrite("Stopped at "+ TestAbnormalEndFunction + " Test Fail");
				errCode = 10;
				exit_test=1;
			}
			else if (DbgSession.expression.evaluate("PC=="+ TestPrefectchAbortFunction))
			{
				dssScriptEnv.traceWrite("Stopped at "+ TestPrefectchAbortFunction+ "Test Fail");
				errCode = 11;
				exit_test=1;
			}
			else if (DbgSession.expression.evaluate("PC==" + TestDataAbortFunction))
			{
				dssScriptEnv.traceWrite("Stopped at " + TestDataAbortFunction + " Test Fail");
				errCode = 12;
				exit_test=1;
			}
			else{
				dssScriptEnv.traceWrite("Abnormal termination, exit..!");
				errCode = 15;
				exit_test=1;
			}
		} while (exit_test==0);


	} // end loop on exec load 
	
	if (testEnv.cioFile != null )
	{
		// Stop CIO logging.
		DbgSession.endCIOLogging();
	}
	// End automation.
    quit(errCode);
}
