/*----------------------------------------------------------------------------*/
/* lld_types.h                                              05/30/05 17:07:43 */
/*                                                                            */
/* (c) Texas Instruments 2003-2005, All rights reserved.                      */
/*                                                                            */
/* Versions:                                                                  */
/* HALCOGEN         2.02.000                                                  */
/* TMS470R3x        1.00.001                                                  */
/* TICGEN           1.04.000                                                  */
/*                                                                            */


#ifndef __lld_types_h__
#define __lld_types_h__

/*----------------------------------------------------------------------------*/
/* Standard Types                                                             */

typedef signed char T_S8;
#define MAX_S8 (127)
#define MIN_S8 (-128)

typedef unsigned char T_U8;
#define MAX_U8 (255)
#define MIN_U8 (0)

typedef signed short T_S16;
#define MAX_S16 (32767)
#define MIN_S16 (-32767-1)

typedef unsigned short T_U16;
#define MAX_U16 (0xFFFFU)
#define MIN_U16 (0)

typedef signed int T_S32;
#define MAX_S32 (2147483647L)
#define MIN_S32 (-2147483647L-1)

typedef unsigned int T_U32;
#define MAX_U32 (0xFFFFFFFFU)
#define MIN_U32 (0)

typedef float T_F32;
#define MAX_F32 (3.39e+38)
#define MIN_F32 (1.18e-38)

typedef double T_F64;
#define MAX_F64 (1.79e+308)
#define MIN_F64 (2.23e-308)


#endif
/*----------------------------------------------------------------------------*/

