/*----------------------------------------------------------------------------*/
/* startupPTB5BAPGF.c                                       05/30/05 17:07:43 */
/*                                                                            */
/* (c) Texas Instruments 2003-2005, All rights reserved.                      */
/*                                                                            */
/* Versions:                                                                  */
/* HALCOGEN         2.02.000                                                  */
/* TMS470R3x        1.00.001                                                  */
/* TICGEN           1.04.000                                                  */
/*                                                                            */


#include "lld_types.h"
#include "TMS470Wega.h"
/*----------------------------------------------------------------------------*/

/* USER CODE BEGIN (0) */
/* USER CODE END */

void auto_initialize();
typedef void (*handler_fptr)(const unsigned char *in,
unsigned char *out);
#define HANDLER_TABLE __TI_Handler_Table_Base
#pragma WEAK(HANDLER_TABLE)
extern unsigned int HANDLER_TABLE;
extern unsigned char *__TI_CINIT_Base;
extern unsigned char *__TI_CINIT_Limit;
extern unsigned int __TI_Handler_Table_Limit;                                                


/*----------------------------------------------------------------------------*/
/* system registers                                                           */

typedef struct
{
    unsigned int SYSPC1;
    unsigned int SYSPC2;
    unsigned int SYSPC3;
    unsigned int SYSPC4;
    unsigned int SYSPC5;
    unsigned int SYSPC6;
    unsigned int SYSPC7;
    unsigned int SYSPC8;
    unsigned int SYSPC9;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int CSDIS;
    unsigned int CSDISSET;
    unsigned int CSDISCLR;
    unsigned int CDDIS;
    unsigned int CDDISSET;
    unsigned int CDDISCLR;
    unsigned int GHVSRC;
    unsigned int VCLKASRC;
    unsigned int RCLKSRC;
    unsigned int CSVSTAT;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PLLCTL1;
    unsigned int PLLCTL2;
    unsigned int UERFLAG;
    unsigned int DIEIDL;
    unsigned int DIEIDH;
    unsigned int VRCTL;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int IAHBILLADDR;
    unsigned int DAHBILLADDR;
    unsigned int PILLADDR;
    unsigned int EMIFERRADDR;
    unsigned int SSISR2;
    unsigned int SSISR3;
    unsigned int SSISR4;
    unsigned int : 32;
    unsigned int BMMCR1;
    unsigned int BMMCR2;
    unsigned int MMUGCR;
    unsigned int CLKCNTL;
    unsigned int ECPCNTLR;
    unsigned int DSPGCR;
    unsigned int : 32;
    unsigned int SYSECR;
    unsigned int SYSESR;
    unsigned int ITIFLAG;
    unsigned int GBLSTAT;
    unsigned int DEV;
    unsigned int SSIVEC;
    unsigned int SSIF;
    unsigned int SSIR1;
} T_SYSTEM;

#define SYSTEM ((T_SYSTEM *)0xFFFFFF00)

/*----------------------------------------------------------------------------*/
/* pcr registers                                                              */

typedef struct
{
    unsigned int PMPROTSET0;
    unsigned int PMPROTSET1;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PMPROTCLR0;
    unsigned int PMPROTCLR1;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PPROTSET0;
    unsigned int PPROTSET1;
    unsigned int PPROTSET2;
    unsigned int PPROTSET3;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PPROTCLR0;
    unsigned int PPROTCLR1;
    unsigned int PPROTCLR2;
    unsigned int PPROTCLR3;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PCSPWRDWNSET0;
    unsigned int PCSPWRDWNSET1;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PCSPWRDWNCLR0;
    unsigned int PCSPWRDWNCLR1;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PSPWRDWNSET0;
    unsigned int PSPWRDWNSET1;
    unsigned int PSPWRDWNSET2;
    unsigned int PSPWRDWNSET3;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int PSPWRDWNCLR0;
    unsigned int PSPWRDWNCLR1;
    unsigned int PSPWRDWNCLR2;
    unsigned int PSPWRDWNCLR3;
    unsigned int PSPWRDWNCLR4;
} T_PCR;

#define PCR ((T_PCR *)0xFFFFE000)

/*----------------------------------------------------------------------------*/
/* vim registers                                                              */

typedef struct
{
    unsigned int : 24;
    unsigned int IRQIVEC : 8;
    unsigned int : 24;
    unsigned int FIQIVEC : 8;
    unsigned int : 32;
    unsigned int : 32;
    unsigned int FIRQPR0;
    unsigned int FIRQPR1;
    unsigned int FIRQPR2;
    unsigned int FIRQPR3;
    unsigned int INTREQ0;
    unsigned int INTREQ1;
    unsigned int INTREQ2;
    unsigned int INTREQ3;
    unsigned int REQMASKSET0;
    unsigned int REQMASKSET1;
    unsigned int REQMASKSET2;
    unsigned int REQMASKSET3;
    unsigned int REQMASKCLR0;
    unsigned int REQMASKCLR1;
    unsigned int REQMASKCLR2;
    unsigned int REQMASKCLR3;
    unsigned int WAKEMASKSET0;
    unsigned int WAKEMASKSET1;
    unsigned int WAKEMASKSET2;
    unsigned int WAKEMASKSET3;
    unsigned int WAKEMASKCLR0;
    unsigned int WAKEMASKCLR1;
    unsigned int WAKEMASKCLR2;
    unsigned int WAKEMASKCLR3;
    unsigned int IRQVECREG;
    unsigned int FIQVECREQ;
    unsigned int : 9;
    unsigned int CAPEVTSRC1 : 7;
    unsigned int : 9;
    unsigned int CAPEVTSRC0 : 7;
    unsigned int : 32;
    unsigned char CHANMAP[64];
} T_VIM;

#define VIM ((T_VIM *)0xFFFFFE00)

/*----------------------------------------------------------------------------*/
/* vim jump table                                                             */

typedef void (*T_isrFuncPTR)();

typedef struct
{
    T_isrFuncPTR ISR[96];
} T_VIM_RAM;

#define VIM_RAM ((T_VIM_RAM *)0xFFF82000)

/*----------------------------------------------------------------------------*/
/* vim initalisation table                                                    */

interrupt void IO_PHANTOM_INT()
{
  RTIINTFLAG = 0x01; 
}

interrupt void rtiHandler()
{
  RTIINTFLAG = 0x01; 
}

static T_isrFuncPTR s_vim_init[96] =
{
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    rtiHandler,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
    IO_PHANTOM_INT,
};


/*----------------------------------------------------------------------------*/
/* Startup Routine                                                            */


/* DO NOT STEP */ 
void c_int00()
{
    /* start pll lock */
    SYSTEM->CSDISCLR = 0x02;

    /* Initialize VIM table */

    {
        unsigned i;

        for (i = 0; i < 96; i++)
        {
            VIM_RAM->ISR[i] = s_vim_init[i];
        }
    }

    /* initalise the C global variables */  
    auto_initialize();
    
    /* power-up peripharals */
    PCR->PSPWRDWNCLR0 = 0xFFFFFFFF;
    PCR->PSPWRDWNCLR1 = 0xFFFFFFFF;
    PCR->PSPWRDWNCLR2 = 0xFFFFFFFF;
    PCR->PSPWRDWNCLR3 = 0xFFFFFFFF;

    /* enable peripharals */
    SYSTEM->CLKCNTL = 0x01010100;

    /* set IRQ/FIQ priorities */
    VIM->FIRQPR0 = 0x00000000;
    VIM->FIRQPR1 = 0x00000000;
    VIM->FIRQPR2 = 0x00000000;

    /* enable interrupts */
    VIM->REQMASKSET0 = 0x00000fff;
    VIM->REQMASKSET1 = 0x00000000;
    VIM->REQMASKSET2 = 0x00000000;

/* USER CODE BEGIN (2) */
	PCR->PCSPWRDWNSET0 = 0xFFFFFFFF; 
	PCR->PCSPWRDWNSET1 = 0xFFFFFFFF;
	SYSTEM->SYSPC1 = 0x00000001;
	SYSTEM->SYSPC2 = 0x00000001;
/* USER CODE END */

    /* switch to user mode */
//    asm(" mov   r0,#0xD0");   test code requires privilige mode
//    asm(" msr   cpsr,r0");

/* USER CODE BEGIN (3) */

/* USER CODE END */

    /* call the application */
    main();
    exit();
}

/* USER CODE BEGIN (4) */
/* USER CODE END */

/*----------------------------------------------------------------------------*/
void auto_initialize()
{
  unsigned char **table_ptr;
  unsigned char **table_limit;
/*--------------------------------------------------------------*/
/* Check if Handler table has entries. */
/*--------------------------------------------------------------*/
  if (&__TI_Handler_Table_Base >= &__TI_Handler_Table_Limit)
    return;
/*---------------------------------------------------------------*/
/* Get the Start and End of the CINIT Table. */
/*---------------------------------------------------------------*/
  table_ptr = (unsigned char **)&__TI_CINIT_Base;
  table_limit = (unsigned char **)&__TI_CINIT_Limit;
  while (table_ptr < table_limit)
  {
/*-------------------------------------------------------------*/
/* 1. Get the Load and Run address. */
/* 2. Read the 8-bit index from the load address. */
/* 3. Get the hander function pointer using the index from */
/* handler table. */
/*-------------------------------------------------------------*/
    unsigned char *load_addr = *table_ptr++;
    unsigned char *run_addr = *table_ptr++;
    unsigned char handler_idx = *load_addr++;
    handler_fptr handler =
    (handler_fptr)(&HANDLER_TABLE)[handler_idx];
/*-------------------------------------------------------------*/
/* 4. Call the handler and pass the pointer to the load data */
/* after index and the run address. */
/*-------------------------------------------------------------*/
    (*handler)((const unsigned char *)load_addr, run_addr);
  }
}  




