/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting;

import com.ti.ccstudio.scripting.CCSSession;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptServer;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CCSServer
extends ScriptServer {
    private IScriptSession mySession;

    public CCSServer(String sServerName, ScriptingEnvironment environment) throws ScriptingException {
        super(sServerName, environment);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    void start() throws ScriptingException {
        String myName = "start";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    @Override
    public void stop() throws ScriptingException {
        String myName = "stop";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        if (this.mySession != null) {
            this.mySession.terminate();
            this.mySession = null;
        }
        this.environment.errorHandler.success();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    @Override
    public IScriptSession openSession(String sParameter) throws ScriptingException {
        if (this.mySession != null) {
            return this.mySession;
        }
        this.mySession = new CCSSession(this.environment, this, sParameter);
        return this.mySession;
    }
}

