/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.ScriptServer;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class ScriptEnvironment {
    protected Logger traceLog;
    private HashMap<String, ScriptServer> servers = new HashMap();

    public void unregisterServer(IScriptServer server) {
        String key = server.getName();
        if (this.servers.containsKey(key)) {
            this.servers.remove(key);
        }
    }

    public void registerServer(ScriptServer server) {
        String key = server.getName();
        this.servers.put(key, server);
    }

    public boolean isRegistered(String sServerName) {
        String key = sServerName;
        return this.servers.containsKey(key);
    }

    protected ScriptServer getServerFromRegistry(String sServerName) {
        ScriptServer s = null;
        if (this.isRegistered(sServerName)) {
            String key = sServerName;
            s = this.servers.get(key);
        }
        return s;
    }

    public abstract IScriptServer getServer(String var1) throws ScriptingException;
}

