/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptSession;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class ScriptServer
implements IScriptServer {
    private String serverName = "";
    protected ScriptingEnvironment environment;
    protected Logger traceLog;
    private HashMap<String, ScriptSession> sessions = new HashMap();

    public ScriptServer(String sServerName, ScriptingEnvironment environment) throws ScriptingException {
        this.serverName = sServerName;
        try {
            if (environment == null) {
                throw new NullPointerException();
            }
            this.environment = environment;
        }
        catch (NullPointerException e) {
            throw new ScriptingException(1006, "Cannot create: " + sServerName + ", ScriptingEnvironment not initialized");
        }
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public boolean unregisterSession(IScriptSession session) throws ScriptingException {
        String key = session.getName();
        if (this.sessions.containsKey(key)) {
            this.sessions.remove(key);
        }
        return this.sessions.size() == 0;
    }

    @Override
    public void registerSession(ScriptSession session) throws ScriptingException {
        String key = session.getName();
        this.sessions.put(key, session);
    }

    @Override
    public int getSessionCount() {
        return this.sessions.size();
    }

    @Override
    public IScriptSession getSession(String sessionName) throws ScriptingException {
        if (this.sessions.containsKey(sessionName)) {
            return this.sessions.get(sessionName);
        }
        return null;
    }

    @Override
    public String[] getSessionNames() {
        String[] names = new String[this.sessions.size()];
        Iterator<String> i = this.sessions.keySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            names[index++] = i.next();
        }
        return names;
    }

    @Override
    public abstract void stop() throws ScriptingException;
}

