/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import java.util.logging.Logger;

public abstract class ScriptSession
implements IScriptSession {
    protected ScriptingEnvironment environment;
    protected IScriptServer server;
    protected Logger traceLog;

    public ScriptSession(ScriptingEnvironment environment, IScriptServer server) throws ScriptingException {
        try {
            if (environment == null || server == null) {
                throw new NullPointerException();
            }
            this.environment = environment;
            this.server = server;
        }
        catch (NullPointerException e) {
            throw new ScriptingException(1007, "Cannot create session, ScriptingEnvironment or ScriptServer not initialized");
        }
    }

    public ScriptSession(ScriptingEnvironment environment) throws ScriptingException {
        try {
            if (environment == null) {
                throw new NullPointerException();
            }
            this.environment = environment;
            this.server = null;
        }
        catch (NullPointerException e) {
            throw new ScriptingException(1007, "Cannot create session, ScriptingEnvironment not initialized");
        }
    }

    @Override
    public IScriptServer getServer() {
        return this.server;
    }

    @Override
    public abstract String getName() throws ScriptingException;

    @Override
    public abstract void terminate() throws ScriptingException;
}

