/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting;

import com.ti.ccstudio.scripting.IScriptSession;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class StyledXMLFormatter
extends XMLFormatter {
    private String styleSheet;

    public StyledXMLFormatter(String sStyleSheet) {
        this.styleSheet = sStyleSheet;
    }

    @Override
    public String format(LogRecord record) {
        Object[] objs = record.getParameters();
        Object obj = null;
        if (objs != null && objs.length > 0) {
            obj = objs[0];
        }
        if (obj != null && obj instanceof IScriptSession) {
            Object[] newObjs;
            String strLength = Integer.toString(objs.length - 1);
            if (objs.length == 1) {
                newObjs = null;
            } else {
                newObjs = new Object[objs.length - 1];
                for (int i = 1; i < objs.length; ++i) {
                    newObjs[i - 1] = objs[i];
                }
            }
            record.setParameters(newObjs);
            String newMsg = record.getMessage();
            if (newMsg.endsWith("{" + strLength + "}")) {
                newMsg = newMsg.substring(0, newMsg.length() - 4);
            }
            record.setMessage(newMsg);
        }
        if (record.getSourceClassName().equals("com.ti.debug.engine.scripting.DebugSession$CIOStdOutListener") || record.getSourceClassName().equals("com.ti.debug.engine.scripting.DebugSession$CIOStdErrListener")) {
            String result = super.format(record);
            if (result.indexOf("<message><![CDATA[") != -1) {
                result = result.replace("<message>", "<message><![CDATA[");
                result = result.replace("</message>", "]]></message>");
            }
            return result;
        }
        return super.format(record);
    }

    @Override
    public String getHead(Handler arg0) {
        String head = super.getHead(arg0);
        String parameter = "";
        if (this.styleSheet != null) {
            parameter = "<?xml-stylesheet type=\"text/xsl\" href=\"" + this.styleSheet + "\"?>\n";
        }
        head = head.replaceAll("<!DOCTYPE log SYSTEM \"logger.dtd\">\n", parameter);
        return head;
    }
}

