/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting.environment;

import com.ti.ccstudio.scripting.IScriptSession;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        Object[] objs = record.getParameters();
        Object obj = null;
        if (objs != null && objs.length > 0) {
            obj = objs[0];
        }
        if (obj != null && obj instanceof IScriptSession) {
            Object[] newObjs;
            String strLength = Integer.toString(objs.length - 1);
            if (objs.length == 1) {
                newObjs = null;
            } else {
                newObjs = new Object[objs.length - 1];
                for (int i = 1; i < objs.length; ++i) {
                    newObjs[i - 1] = objs[i];
                }
            }
            record.setParameters(newObjs);
            String newMsg = record.getMessage();
            if (newMsg.endsWith("{" + strLength + "}")) {
                newMsg = newMsg.substring(0, newMsg.length() - 4);
            }
            record.setMessage(newMsg);
        }
        StringBuffer sb = new StringBuffer();
        if (record.getLevel().intValue() >= Level.WARNING.intValue() && !ConsoleFormatter.isCIO(record)) {
            sb.append(record.getLevel().getName());
            sb.append(": ");
        }
        if (record.getLevel().intValue() <= Level.FINE.intValue()) {
            sb.append(record.getSourceMethodName());
            sb.append(": ");
        }
        sb.append(this.formatMessage(record));
        if (!ConsoleFormatter.isCIO(record)) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isCIO(LogRecord r) {
        return r.getSourceClassName().equals("com.ti.debug.engine.scripting.DebugSession$CIOStdOutListener") || r.getSourceClassName().equals("com.ti.debug.engine.scripting.DebugSession$CIOStdErrListener");
    }
}

