/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting.environment;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptEnvironment;
import com.ti.ccstudio.scripting.ScriptServer;
import com.ti.ccstudio.scripting.StyledXMLFormatter;
import com.ti.ccstudio.scripting.environment.ConsoleFormatter;
import com.ti.ccstudio.scripting.environment.DirectedConsoleHandler;
import com.ti.ccstudio.scripting.environment.ErrorHandler;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import com.ti.ccstudio.scripting.environment.SessionAwareFileHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScriptingEnvironment
extends ScriptEnvironment
implements ScriptingTimeout {
    private String sCurrentDirectory;
    private int debuggerTimeout = -1;
    public final ErrorHandler errorHandler = new ErrorHandler(this);
    private static final String SCRIPTING_LOGGER = "com.ti";
    private DirectedConsoleHandler traceConsoleHandler;
    private FileHandler traceFileHandler;
    private HashMap<IScriptSession, SessionAwareFileHandler> traceSessionFileHandlerMap;
    private static ScriptingEnvironment scriptingEnvironment = null;

    public static synchronized ScriptingEnvironment instance() {
        if (null == scriptingEnvironment) {
            scriptingEnvironment = new ScriptingEnvironment();
        }
        return scriptingEnvironment;
    }

    private ScriptingEnvironment() {
        this.sCurrentDirectory = this.toAbsolutePath(".");
        this.initializeParentLogger();
        this.traceSessionFileHandlerMap = new HashMap();
    }

    private void initializeParentLogger() {
        this.traceLog = Logger.getLogger(SCRIPTING_LOGGER);
        this.traceLog.setLevel(Level.ALL);
        this.traceLog.setUseParentHandlers(false);
        Handler[] registeredHandlers = this.traceLog.getHandlers();
        boolean bFound = false;
        if (registeredHandlers.length != 0) {
            for (int i = 0; i < registeredHandlers.length; ++i) {
                Handler h = registeredHandlers[i];
                String className = h.getClass().getName();
                if (!className.equals(DirectedConsoleHandler.class.getName())) continue;
                this.traceConsoleHandler = (DirectedConsoleHandler)h;
                bFound = true;
                break;
            }
        }
        if (!bFound) {
            this.traceConsoleHandler = new DirectedConsoleHandler();
            this.traceConsoleHandler.setLevel(Level.INFO);
            this.traceConsoleHandler.setFormatter(new ConsoleFormatter());
            this.traceLog.addHandler(this.traceConsoleHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentDirectory() {
        String result;
        String myName = "getCurrentDirectory";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        ScriptingEnvironment scriptingEnvironment = this;
        synchronized (scriptingEnvironment) {
            result = this.sCurrentDirectory;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentDirectory(String sDirName) throws ScriptingException {
        String myName = "setCurrentDirectory";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{"sDirName: " + sDirName});
        }
        ScriptingEnvironment scriptingEnvironment = this;
        synchronized (scriptingEnvironment) {
            this.sCurrentDirectory = this.toAbsolutePath(sDirName);
        }
        File f = new File(this.sCurrentDirectory);
        if (!f.exists()) {
            this.raise(new ScriptingException(1005, "Could not set Current Directory, \"" + this.sCurrentDirectory + "\" does not exist"));
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    @Override
    public int getScriptTimeout() {
        return this.debuggerTimeout;
    }

    public void setScriptTimeout(int nTimeout) {
        String myName = "setScriptTimeout";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{"nTimeout: " + nTimeout});
        }
        if (nTimeout < 0) {
            this.debuggerTimeout = -1;
            this.traceLog.finer("Timeout is infinite");
        } else {
            this.debuggerTimeout = nTimeout;
            this.traceLog.finer("Timeout is " + nTimeout + "ms");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    public int getDebuggerTimeout() {
        return this.getScriptTimeout();
    }

    public void traceSetConsoleLevel(String sLevel) throws ScriptingException {
        try {
            Level outLevel = Level.parse(sLevel);
            this.traceConsoleHandler.setLevel(outLevel);
        }
        catch (IllegalArgumentException e) {
            this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
        }
        catch (NullPointerException e) {
            this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
        }
    }

    public void traceSetFileLevel(String sLevel) throws ScriptingException {
        String myName = "traceSetFileLevel";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{"sLevel: " + sLevel});
        }
        if (this.traceFileHandler == null) {
            this.raise(new ScriptingException(1004, "Trace log not initialized. Call traceBegin() first"));
        } else {
            try {
                Level newLevel = Level.parse(sLevel);
                this.traceFileHandler.setLevel(newLevel);
            }
            catch (IllegalArgumentException e) {
                this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
            }
            catch (NullPointerException e) {
                this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    protected void removeFileHandler() {
        this.traceLog.removeHandler(this.traceFileHandler);
    }

    public void traceBegin(String sFileName) throws ScriptingException {
        this.traceBegin(sFileName, null, 0);
    }

    public void traceBegin(String sFileName, int byteSizeLimit) throws ScriptingException {
        this.traceBegin(sFileName, null, byteSizeLimit);
    }

    public void traceBegin(String sFileName, String sStylesheetName) throws ScriptingException {
        this.traceBegin(sFileName, sStylesheetName, 0);
    }

    public void traceBegin(String sFileName, String sStylesheetName, int byteSizeLimit) throws ScriptingException {
        String myName = "traceBegin";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{"sFileName: " + sFileName});
        }
        if (this.traceFileHandler == null) {
            try {
                String sFullPathName = this.toAbsolutePath(sFileName);
                this.traceFileHandler = byteSizeLimit > 0 ? new FileHandler(sFullPathName, byteSizeLimit, 100000) : new FileHandler(sFullPathName);
                this.traceFileHandler.setFormatter(new StyledXMLFormatter(sStylesheetName));
                this.traceFileHandler.setLevel(Level.INFO);
                this.traceLog.addHandler(this.traceFileHandler);
            }
            catch (IOException e) {
                this.raise(new ScriptingException(1005, "Could not open " + sFileName));
            }
        } else {
            try {
                Level newLevel = this.traceFileHandler.getLevel();
                this.traceFileHandler.flush();
                this.traceFileHandler.close();
                this.traceLog.removeHandler(this.traceFileHandler);
                String sFullPathName = this.toAbsolutePath(sFileName);
                this.traceFileHandler = new FileHandler(sFullPathName);
                this.traceFileHandler.setFormatter(new StyledXMLFormatter(sStylesheetName));
                this.traceFileHandler.setLevel(newLevel);
                this.traceLog.addHandler(this.traceFileHandler);
            }
            catch (IOException e) {
                this.raise(new ScriptingException(1005, "Could not open " + sFileName));
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    public void traceEnd() throws ScriptingException {
        String myName = "traceEnd";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        if (this.traceFileHandler == null) {
            this.raise(new ScriptingException(1004, "Trace log not initialized.  Call traceBegin() first"));
        }
        this.traceLog.finer("Flushing and closing file stream");
        this.traceFileHandler.flush();
        this.traceFileHandler.close();
        this.traceLog.finer("Removing handler " + this.traceFileHandler.toString());
        this.traceLog.removeHandler(this.traceFileHandler);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName);
        }
    }

    public void traceBegin(IScriptSession session, String sFileName) throws ScriptingException {
        this.traceBegin(session, sFileName, null, 0);
    }

    public void traceBegin(IScriptSession session, String sFileName, int byteSizeLimit) throws ScriptingException {
        this.traceBegin(session, sFileName, null, byteSizeLimit);
    }

    public void traceBegin(IScriptSession session, String sFileName, String sStylesheetName) throws ScriptingException {
        this.traceBegin(session, sFileName, sStylesheetName, 0);
    }

    public void traceBegin(IScriptSession session, String sFileName, String sStylesheetName, int byteSizeLimit) throws ScriptingException {
        String myName = "traceBegin";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{session, "sFileName: " + sFileName});
        }
        if (this.traceFileHandler != null) {
            this.traceLog.removeHandler(this.traceFileHandler);
        }
        if (this.traceConsoleHandler != null) {
            this.traceLog.removeHandler(this.traceConsoleHandler);
        }
        SessionAwareFileHandler curSessionHandler = null;
        curSessionHandler = this.traceSessionFileHandlerMap.get(session);
        if (curSessionHandler == null) {
            try {
                String sFullPathName = this.toAbsolutePath(sFileName);
                curSessionHandler = byteSizeLimit > 0 ? new SessionAwareFileHandler(sFullPathName, session, byteSizeLimit) : new SessionAwareFileHandler(sFullPathName, session);
                curSessionHandler.setFormatter(new StyledXMLFormatter(sStylesheetName));
                curSessionHandler.setLevel(Level.INFO);
                this.traceLog.addHandler(curSessionHandler);
                this.traceSessionFileHandlerMap.put(session, curSessionHandler);
            }
            catch (IOException e) {
                this.raise(new ScriptingException(1005, "Could not open " + sFileName));
            }
        } else {
            try {
                Level newLevel = curSessionHandler.getLevel();
                curSessionHandler.flush();
                curSessionHandler.close();
                this.traceLog.removeHandler(curSessionHandler);
                this.traceSessionFileHandlerMap.remove(curSessionHandler);
                String sFullPathName = this.toAbsolutePath(sFileName);
                curSessionHandler = new SessionAwareFileHandler(sFullPathName, session);
                curSessionHandler.setFormatter(new StyledXMLFormatter(sStylesheetName));
                curSessionHandler.setLevel(newLevel);
                this.traceLog.addHandler(curSessionHandler);
                this.traceSessionFileHandlerMap.put(session, curSessionHandler);
            }
            catch (IOException e) {
                this.raise(new ScriptingException(1005, "Could not open " + sFileName));
            }
        }
        if (this.traceFileHandler != null) {
            this.traceLog.addHandler(this.traceFileHandler);
        }
        if (this.traceConsoleHandler != null) {
            this.traceLog.addHandler(this.traceConsoleHandler);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, session);
        }
    }

    public void traceSetFileLevel(IScriptSession session, String sLevel) throws ScriptingException {
        String myName = "traceSetFileLevel";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{session, "sLevel: " + sLevel});
        }
        SessionAwareFileHandler curSessionHandler = null;
        curSessionHandler = this.traceSessionFileHandlerMap.get(session);
        if (curSessionHandler == null) {
            this.raise(new ScriptingException(1004, "Trace log not initialized. Call traceBegin() first"));
        } else {
            try {
                Level newLevel = Level.parse(sLevel);
                curSessionHandler.setLevel(newLevel);
            }
            catch (IllegalArgumentException e) {
                this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
            }
            catch (NullPointerException e) {
                this.raise(new ScriptingException(1002, "Expected one of TraceLevel.LEVEL, got " + sLevel));
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, session);
        }
    }

    public void traceWrite(IScriptSession session, String sText) {
        this.traceLog.log(Level.INFO, sText, session);
    }

    public void traceEnd(IScriptSession session) throws ScriptingException {
        String myName = "traceEnd";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, session);
        }
        SessionAwareFileHandler curSessionHandler = null;
        curSessionHandler = this.traceSessionFileHandlerMap.get(session);
        if (curSessionHandler == null) {
            this.raise(new ScriptingException(1004, "Trace log not initialized.  Call traceBegin() first"));
        }
        this.traceLog.log(Level.FINER, "Flushing and closing file stream", session);
        curSessionHandler.flush();
        curSessionHandler.close();
        this.traceLog.log(Level.FINER, "Removing handler " + curSessionHandler.toString(), session);
        this.traceLog.removeHandler(curSessionHandler);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, session);
        }
    }

    public void traceWrite(String sText) {
        this.traceLog.info(sText);
    }

    public synchronized String toAbsolutePath(String pathName) {
        File f = new File(pathName);
        if (f.isAbsolute()) {
            File parent;
            if (f.isDirectory()) {
                return pathName;
            }
            String parentFolderName = f.getParent();
            if (parentFolderName != null && (parent = new File(parentFolderName)).exists()) {
                return pathName;
            }
        }
        if (!f.exists()) {
            f = this.sCurrentDirectory != null ? new File(this.sCurrentDirectory + File.separator + pathName) : new File(pathName);
        }
        try {
            String myPath = f.getCanonicalPath();
            return myPath;
        }
        catch (IOException e) {
            String myPath = f.getAbsolutePath();
            return myPath;
        }
    }

    public void raise(ScriptingException e) throws ScriptingException {
        throw e;
    }

    @Override
    public IScriptServer getServer(String sServerName) throws ScriptingException {
        String myName = "getServer";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{"sServerName: " + sServerName});
        }
        ScriptServer server = null;
        if (this.isRegistered(sServerName)) {
            this.traceLog.finer("Getting cached server: " + sServerName);
            server = this.getServerFromRegistry(sServerName);
        } else {
            try {
                this.traceLog.finer("Getting definition for: " + sServerName);
                String serverClassName = this.getServerClassName(sServerName);
                Class<?> serverDefinition = Class.forName(serverClassName);
                Class[] constructorSignature = new Class[]{String.class, ScriptingEnvironment.class};
                Object[] constructorArgs = new Object[]{sServerName, this};
                this.traceLog.finer("Constructing server");
                if (serverClassName.equals("com.ti.debug.engine.scripting.DebugServer")) {
                    Method serverInstance = serverDefinition.getMethod("instance", constructorSignature);
                    server = (ScriptServer)serverInstance.invoke(null, constructorArgs);
                } else {
                    Constructor<?> serverConstructor = serverDefinition.getConstructor(constructorSignature);
                    server = (ScriptServer)serverConstructor.newInstance(constructorArgs);
                }
            }
            catch (InstantiationException e) {
                this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + e.getMessage()));
            }
            catch (IllegalAccessException e) {
                this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + e.getMessage()));
            }
            catch (NoSuchMethodException e) {
                this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + e.getMessage()));
            }
            catch (InvocationTargetException e) {
                this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + e.getMessage()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.registerServer(server);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, server);
        }
        return server;
    }

    private String getServerClassName(String sServerName) throws ScriptingException {
        if (sServerName.equals("DebugServer.1")) {
            return "com.ti.debug.engine.scripting.DebugServer";
        }
        if (sServerName.equals("CCSServer.1")) {
            return "com.ti.ccstudio.scripting.CCSServer";
        }
        if (sServerName.equals("RTDXServer.1")) {
            return "com.ti.debug.engine.scripting.RTDXServer";
        }
        if (sServerName.equals("DVTServer.1")) {
            return "com.ti.dvt.engine.scripting.DVTServer";
        }
        this.raise(new ScriptingException(1006, "Could not create server: " + sServerName + ": " + "Unknown server"));
        return null;
    }

    public static String arrayToString(Object[] a, String separator) {
        StringBuffer result = new StringBuffer();
        if (a != null && a.length > 0) {
            result.append(a[0].toString());
            for (int i = 1; i < a.length; ++i) {
                result.append(separator);
                result.append(a[i]);
            }
        }
        return result.toString();
    }

    public boolean isWithinCCS() {
        String myName = "isWithinCCS";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        boolean result = System.getProperty("eclipse.application").equals("org.eclipse.ui.ide.workbench");
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, result);
        }
        return result;
    }
}

