/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.scripting.environment;

import com.ti.ccstudio.scripting.IScriptSession;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;

public class SessionAwareFileHandler
extends FileHandler {
    IScriptSession mySession;

    public SessionAwareFileHandler(String pattern, IScriptSession debugSession) throws IOException, SecurityException {
        super(pattern);
        this.mySession = debugSession;
    }

    public SessionAwareFileHandler(String pattern, IScriptSession debugSession, int byteSizeLimit) throws IOException, SecurityException {
        super(pattern, byteSizeLimit, 100000);
        this.mySession = debugSession;
    }

    @Override
    public void publish(LogRecord record) {
        IScriptSession curSession;
        if (!this.isLoggable(record)) {
            return;
        }
        Object[] objs = record.getParameters();
        Object obj = null;
        if (objs != null && objs.length > 0) {
            obj = objs[0];
        }
        if (obj != null && obj instanceof IScriptSession && this.mySession.equals(curSession = (IScriptSession)obj)) {
            super.publish(record);
        }
    }
}

