/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine;

import com.ti.debug.engine.ICallFrame;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IFunctionInfo;
import com.ti.debug.engine.ILineInfo;
import com.ti.debug.engine.IServerObject;
import com.ti.debug.engine.events.ICallStackEvents;
import com.ti.debug.engine.framework.IDisposable;

public interface ICallStack
extends IServerObject,
ICallStackEvents {
    public boolean isConstructed();

    public FrameInfo getFrameInfo(int var1);

    public int getNumFrames();

    public ICallFrame getFrame(int var1);

    public String reasonUnwindHalted();

    public static class FrameInfo
    implements IDisposable {
        private IFunctionInfo funcInfo;
        private IDspValue fp;
        private IDspValue pc;
        private int frameNumber;
        private Type frameType;
        private boolean bDisposed = false;

        public FrameInfo(IFunctionInfo funcInfo, IDspValue fp, IDspValue pc, int frameNo) {
            this.funcInfo = funcInfo;
            this.fp = fp;
            this.pc = pc;
            this.frameNumber = frameNo;
            this.frameType = Type.Cpu;
        }

        public FrameInfo(IFunctionInfo funcInfo, IDspValue fp, IDspValue pc, int frameNo, Type type) {
            this.funcInfo = funcInfo;
            this.fp = fp;
            this.pc = pc;
            this.frameNumber = frameNo;
            this.frameType = type;
        }

        @Override
        public void dispose() {
        }

        public IFunctionInfo getFunctionInfo() {
            return this.funcInfo;
        }

        public IDspValue getFP() {
            return this.fp;
        }

        public IDspValue getPC() {
            return this.pc;
        }

        public int getFrameNumber() {
            return this.frameNumber;
        }

        public Type getFrameType() {
            return this.frameType;
        }

        @Override
        public boolean isDisposed() {
            return this.bDisposed;
        }

        @Override
        public void acquire() {
        }

        private String getSymbolString() {
            if (0 != this.getFunctionInfo().getName().length()) {
                int[] index = new int[]{0};
                ILineInfo lineInfo = this.getFunctionInfo().getStaticLineInfo();
                lineInfo.lookupLineByAddress(this.getPC().toUnsignedInt(), index);
                return this.getFunctionInfo() + " at " + this.getFunctionInfo().getFileFullName() + ":" + lineInfo.getLineNum(index[0]);
            }
            return "<symbol is not available>";
        }

        public String toString() {
            return this.getFrameNumber() + " " + this.getSymbolString() + " PC = " + this.getPC() + " FP = " + this.getFP();
        }

        public static enum Type {
            Cpu,
            Kernel,
            User;

        }
    }
}

