/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine;

import com.ti.debug.engine.IServerObject;
import java.util.List;

public interface IDspValue
extends IServerObject {
    public static final short TYPE_CHAR = 0;
    public static final short TYPE_UCHAR = 1;
    public static final short TYPE_SHORT = 2;
    public static final short TYPE_USHORT = 3;
    public static final short TYPE_ENUM = 4;
    public static final short TYPE_INT = 6;
    public static final short TYPE_UINT = 7;
    public static final short TYPE_LONG = 8;
    public static final short TYPE_ULONG = 9;
    public static final short TYPE_POINTER = 11;
    public static final short TYPE_DATA8 = 12;
    public static final short TYPE_DATA16 = 14;
    public static final short TYPE_DATA24 = 16;
    public static final short TYPE_DATA32 = 18;
    public static final short TYPE_DATA40 = 20;
    public static final short TYPE_DATA48 = 22;
    public static final short TYPE_DATA64 = 24;
    public static final short TYPE_UDATA8 = 13;
    public static final short TYPE_UDATA16 = 15;
    public static final short TYPE_UDATA24 = 17;
    public static final short TYPE_UDATA32 = 19;
    public static final short TYPE_UDATA40 = 21;
    public static final short TYPE_UDATA48 = 23;
    public static final short TYPE_UDATA64 = 25;
    public static final short TYPE_FARPOINTER = 27;
    public static final short TYPE_NEARPOINTER = 29;
    public static final short TYPE_LONGLONG = 30;
    public static final short TYPE_ULONGLONG = 31;
    public static final short TYPE_FLOAT = 32;
    public static final short TYPE_IEEE_FLOAT = 34;
    public static final short TYPE_DOUBLE = 36;
    public static final short TYPE_IEEE_DOUBLE = 38;
    public static final short TYPE_LDOUBLE = 40;

    public int getType();

    public Type getEnumType();

    public int toLong();

    public long toLongLong();

    public String toString();

    public String toStringCStyleHex();

    public String toStringTIStyleHex();

    public String toStringReal();

    public String toStringReal(short var1);

    public String toStringScientific();

    public String toStringScientific(short var1);

    public String toStringBinary();

    public short bitSizeOf();

    public int sizeOf();

    public void assignLong(int var1);

    public void assignLongLong(long var1);

    public boolean notEqual(IDspValue var1);

    public boolean equal(IDspValue var1);

    public IDspValue typeCast(int var1, int var2);

    public IDspValue typeCast(Type var1, int var2);

    public String toString(int var1);

    public String toString(int var1, int var2);

    public int bestMatchedUDataType(int var1, short var2);

    public Type bestMatchedUDataTypeType(int var1, short var2);

    public Type bestMatchedSignedDataTypeType(int var1, short var2);

    public List<SupportedType> getSupportedTypes(short var1);

    public int sizeOf2(short var1);

    public IDspValue shiftLeftShort(short var1);

    public IDspValue plusLong(int var1);

    public String toStringSignedInt();

    public String toStringUnsignedInt();

    public int getBit(int var1);

    public void setBit(int var1);

    public void clearBit(int var1);

    public void assignDouble(double var1);

    public String toStringChar();

    public float toDouble();

    public long toUnsignedInt();

    public void assign(IDspValue var1);

    public void parseString(String var1);

    public static class SupportedType {
        public Type Type;
        public Format Format;
        public String DisplayString;
    }

    public static class Convert {
        public static long intToLong(int nValue, int nTypeSize, boolean bSigned) {
            long nConvertedData = 0L;
            if (bSigned) {
                int rawData_UInt = nValue;
                long rawData_ULong = 0L;
                int shift = 32 - nTypeSize;
                nConvertedData = rawData_ULong = (long)(rawData_UInt << shift >> shift);
            } else {
                int rawData_UInt = nValue;
                long rawData_ULong = 0L;
                rawData_ULong = rawData_UInt < 0 ? (long)rawData_UInt + 0x100000000L : (long)rawData_UInt;
                int shift = 32 - nTypeSize;
                int mask = -1;
                nConvertedData = rawData_ULong &= (long)(mask >>>= shift);
            }
            return nConvertedData;
        }
    }

    public static enum Format {
        CSTYLEHEX(0),
        TISTYLEHEX(1),
        SIGNEDINT(2),
        UNSIGNEDINT(3),
        CHARACTER(4),
        PACKEDCHAR(5),
        BINARY(6),
        REAL(7),
        SCIENTIFIC(8),
        OCTAL(9);

        short val = (short)-1;

        private Format(short value) {
            this.val = value;
        }

        public short translateToDspValueFormatEnum() {
            return this.val;
        }

        public static Format getFromInt(short val) {
            for (Format format : Format.values()) {
                if (val != format.val) continue;
                return format;
            }
            return CSTYLEHEX;
        }
    }

    public static enum Type {
        CHAR,
        UCHAR,
        SHORT,
        USHORT,
        ENUM,
        INT,
        UINT,
        LONG,
        ULONG,
        POINTER,
        DATA8,
        DATA16,
        DATA24,
        DATA32,
        DATA40,
        DATA48,
        DATA64,
        UDATA8,
        UDATA16,
        UDATA24,
        UDATA32,
        UDATA40,
        UDATA48,
        UDATA64,
        FARPOINTER,
        NEARPOINTER,
        LONGLONG,
        ULONGLONG,
        FLOAT,
        IEEE_FLOAT,
        DOUBLE,
        IEEE_DOUBLE,
        LDOUBLE;

    }
}

