/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.armproperties.impl.Button;
import com.ti.debug.engine.armproperties.impl.PropertyFactory;
import com.ti.debug.engine.armproperties.impl.PropertySet;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.properties.IArmManager;
import com.ti.debug.properties.IDebugProperties;
import com.ti.debug.properties.IProperty;

public class ArmManager
extends Disposable
implements IArmManager {
    public static final int ARM9 = 2;
    public static final int ARM11 = 3;
    public static final int CortexA9 = 9;
    public static final int CortexA8 = 12;
    public static final int CortexR4 = 13;
    public static final int CortexM3 = 14;
    public static final int CortexA15 = 21;
    private int familyID;
    private int subFamilyID;
    private int targetRev;
    private int targetType;
    private IDebugProperties armDebugProperties;

    public ArmManager(IDspTask dspTask) {
        this.familyID = dspTask.getProcessorInfo().getTargetFamilyID();
        this.subFamilyID = dspTask.getProcessorInfo().getTargetSubFamilyID();
        this.targetRev = dspTask.getProcessorInfo().getTargetRev();
        this.targetType = dspTask.getProcessorInfo().getTargetType();
        if (this.isTargetSupported()) {
            PropertySet myPropertySet = PropertyFactory.createPropertySet(this.subFamilyID, this.targetRev);
            this.armDebugProperties = myPropertySet.createDebugProperties(dspTask);
        }
    }

    @Override
    public IDebugProperties getDebugProperties() {
        return this.armDebugProperties;
    }

    @Override
    public void performOperation(IArmManager.OperationID option) {
        String buttonId = "";
        switch (option) {
            case FlushInstructionCache: {
                buttonId = "FlushInstructionCache";
                break;
            }
            case FlushDataCache: {
                buttonId = "FlushDataCache";
                break;
            }
            case FlushAllCaches: {
                if (this.subFamilyID == 13) {
                    this.performOperation(IArmManager.OperationID.FlushInstructionCache);
                    this.performOperation(IArmManager.OperationID.FlushDataCache);
                    return;
                }
                buttonId = "FlushAllCaches";
                break;
            }
            case CleanDataCache: {
                buttonId = "CleanDataCache";
                break;
            }
            case FlushInstructionTLB: {
                buttonId = "FlushInstructionTLB";
                break;
            }
            case FlushDataTLB: {
                buttonId = "FlushDataTLB";
                break;
            }
            case FlushAllTLBs: {
                buttonId = "FlushAllTLBs";
                break;
            }
            case CohEstDataSide: {
                buttonId = "CohEstDataSide";
                break;
            }
            case CohEstInstSide: {
                buttonId = "CohEstInstSide";
                break;
            }
            case CohEstGlobalIMB: {
                buttonId = "CohEstGlobalIMB";
                break;
            }
            case CohEstTLB: {
                buttonId = "CohEstTLB";
                break;
            }
            case CohFlushPipeline: {
                buttonId = "CohFlushPipeline";
            }
        }
        IProperty prop = this.armDebugProperties.getProperty(buttonId);
        if (prop instanceof Button) {
            ((Button)prop).flushRegister();
        }
    }

    @Override
    public boolean isTargetSupported() {
        return this.familyID == 470 && this.targetType != 1 && (this.subFamilyID == 2 || this.subFamilyID == 3 || this.subFamilyID == 12 || this.subFamilyID == 9 || this.subFamilyID == 13 || this.subFamilyID == 14 || this.subFamilyID == 21);
    }
}

