/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.armproperties.impl.DebugProperties;
import com.ti.debug.engine.armproperties.impl.Property;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.properties.IBooleanProperty;

public class BooleanProperty
extends Property
implements IBooleanProperty {
    private String myConfigRegID;
    private int myConfigRegBitPos;
    private String myStatusRegID;
    private IDspRegister myStatusRegister;
    private IDspValue myStatusValue;
    private int myStatusRegBitPos;
    private String myControlRegID;
    private IDspRegister myControlRegister;
    private IDspValue myControlValue;
    private int myControlRegBitPos;
    private boolean curValue = false;
    private boolean hasListeners = false;
    private boolean isValueValid = false;
    private boolean isValueBeingRead = false;
    private boolean firstConnect = true;
    private boolean trueDisableStatus = true;
    private boolean isValueBeingWritten = false;
    private boolean justWritten = false;
    private final Object propertyLock = new Object();
    private final Object writeLock = new Object();
    private final ISimpleEventListener connectListener = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            if (BooleanProperty.this.firstConnect) {
                BooleanProperty.this.readEnableBit(BooleanProperty.this.myConfigRegID);
            } else if (!BooleanProperty.this.trueDisableStatus) {
                BooleanProperty.this.enable();
            }
        }
    };
    private final ISimpleEventListener disconnectListener = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            if (!BooleanProperty.this.getDisableStatus()) {
                BooleanProperty.this.disable();
            }
        }
    };
    private final OnRefresh refreshListener = new OnRefresh();

    void readEnableBit(String id) {
        this.firstConnect = false;
        if (!id.equals("")) {
            final String curId = id;
            final IDspRegister configReg = this.sharedDebugProp.createDspRegister(curId);
            this.sharedDebugProp.getRegisterAccess().requestRegisterRead(configReg, new IObjectEventListener<IRegisterAccessEventData>(){

                @Override
                public void onEvent(final IRegisterAccessEventData data) {
                    DebugProperties.eventReceiverExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean bitValue = false;
                            if (!data.wasRequestAborted()) {
                                IDspValue configValue = BooleanProperty.this.sharedDebugProp.createDspValue(curId);
                                bitValue = BooleanProperty.this.getValueFromRegister(configReg, configValue, BooleanProperty.this.myConfigRegBitPos);
                                if (bitValue) {
                                    BooleanProperty.this.myStatusRegister = BooleanProperty.this.sharedDebugProp.createDspRegister(BooleanProperty.this.myStatusRegID);
                                    BooleanProperty.this.myStatusValue = BooleanProperty.this.sharedDebugProp.createDspValue(BooleanProperty.this.myStatusRegID);
                                    BooleanProperty.this.myControlRegister = BooleanProperty.this.sharedDebugProp.createDspRegister(BooleanProperty.this.myControlRegID);
                                    BooleanProperty.this.myControlValue = BooleanProperty.this.sharedDebugProp.createDspValue(BooleanProperty.this.myControlRegID);
                                    BooleanProperty.this.trueDisableStatus = false;
                                    BooleanProperty.this.enable();
                                } else {
                                    BooleanProperty.this.trueDisableStatus = true;
                                    if (BooleanProperty.this.hasListeners) {
                                        BooleanProperty.this.sharedDebugProp.getDspUser().onRefreshWithReason().removeIObjectEventListener(BooleanProperty.this.refreshListener);
                                        BooleanProperty.this.hasListeners = false;
                                    }
                                }
                            }
                        }
                    });
                }
            });
        } else {
            this.myStatusRegister = this.sharedDebugProp.createDspRegister(this.myStatusRegID);
            this.myStatusValue = this.sharedDebugProp.createDspValue(this.myStatusRegID);
            this.myControlRegister = null;
            this.myControlValue = null;
            if (this.myStatusRegister != null && this.myStatusValue != null) {
                this.trueDisableStatus = false;
                this.enable();
            } else {
                this.trueDisableStatus = true;
                if (this.hasListeners) {
                    this.sharedDebugProp.getDspUser().onRefreshWithReason().removeIObjectEventListener(this.refreshListener);
                    this.hasListeners = false;
                }
            }
        }
    }

    BooleanProperty(String id, String name, Property parent, boolean disableStatus, String configRegID, int configRegBitPos, String statusRegID, int statusRegBitPos, String controlRegID, int controlRegBitPos) {
        super(id, name, parent, true, false);
        this.trueDisableStatus = disableStatus;
        if (!this.trueDisableStatus) {
            this.myConfigRegID = configRegID;
            this.myConfigRegBitPos = configRegBitPos;
            this.myStatusRegID = statusRegID;
            this.myStatusRegBitPos = statusRegBitPos;
            this.myControlRegID = controlRegID;
            this.myControlRegBitPos = controlRegBitPos;
            if (this.sharedDebugProp.getTargetConnection().getConnectionStatus() == ITargetConnection.ConnectionStatus.CONNECTED) {
                this.readEnableBit(this.myConfigRegID);
            }
            this.sharedDebugProp.getTargetConnection().onConnected().addISimpleEventListener(this.connectListener);
            this.sharedDebugProp.getTargetConnection().onDisconnected().addISimpleEventListener(this.disconnectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCurValue() {
        Object object = this.propertyLock;
        synchronized (object) {
            if (!(this.getDisableStatus() || this.getReadOnly() || this.isValueValid)) {
                if (this.isValueBeingWritten) {
                    try {
                        this.writeLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!this.isValueBeingRead) {
                    this.isValueBeingRead = true;
                    this.sharedDebugProp.getRegisterAccess().requestRegisterRead(this.myStatusRegister, new IObjectEventListener<IRegisterAccessEventData>(){

                        @Override
                        public void onEvent(final IRegisterAccessEventData registerData) {
                            DebugProperties.eventReceiverExecutor.execute(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = BooleanProperty.this.propertyLock;
                                    synchronized (object) {
                                        if (!registerData.wasRequestAborted()) {
                                            boolean newValue = BooleanProperty.this.getValueFromRegister(BooleanProperty.this.myStatusRegister, BooleanProperty.this.myStatusValue, BooleanProperty.this.myStatusRegBitPos);
                                            if (BooleanProperty.this.curValue != newValue) {
                                                BooleanProperty.this.curValue = newValue;
                                            }
                                            if (BooleanProperty.this.hasListeners) {
                                                BooleanProperty.this.isValueValid = true;
                                            }
                                        }
                                        BooleanProperty.this.isValueBeingRead = false;
                                        BooleanProperty.this.propertyLock.notifyAll();
                                    }
                                }
                            });
                        }
                    });
                }
                try {
                    this.propertyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.curValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurValue(boolean value) {
        if (this.getReadOnly() || this.getDisableStatus()) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.propertyLock;
            synchronized (object2) {
                IDspRegister curReg;
                if (this.isValueBeingRead) {
                    try {
                        this.propertyLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.isValueValid = false;
                if (this.myControlRegister != null && this.myControlValue != null) {
                    curReg = this.myControlRegister;
                    this.myControlValue.setBit(this.myControlRegBitPos);
                    curReg.setDspValue(this.myControlValue, 0);
                } else {
                    if (value == this.curValue && this.isValueValid) {
                        return;
                    }
                    curReg = this.myStatusRegister;
                    if (value) {
                        this.myStatusValue.setBit(this.myStatusRegBitPos);
                    } else {
                        this.myStatusValue.clearBit(this.myStatusRegBitPos);
                    }
                    curReg.setDspValue(this.myStatusValue, 0);
                }
                this.isValueBeingWritten = true;
                this.sharedDebugProp.getRegisterAccess().requestRegisterWrite(curReg, new IObjectEventListener<IRegisterAccessEventData>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onEvent(IRegisterAccessEventData registerData) {
                        Object object = BooleanProperty.this.writeLock;
                        synchronized (object) {
                            BooleanProperty.this.justWritten = true;
                            BooleanProperty.this.sharedDebugProp.propertyValueChanged(BooleanProperty.this.getIden());
                            BooleanProperty.this.isValueBeingWritten = false;
                            BooleanProperty.this.writeLock.notifyAll();
                        }
                    }
                });
                try {
                    this.writeLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public void restoreDefaultValue() {
        throw new UnsupportedOperationException();
    }

    private boolean getValueFromRegister(IDspRegister reg, IDspValue val, int bitPos) {
        int errorCode = reg.getDspValue(val, 0);
        if (errorCode != 0) {
            return false;
        }
        return val.getBit(bitPos) == 1;
    }

    void startListening() {
        if (!this.hasListeners && !this.trueDisableStatus) {
            this.sharedDebugProp.getDspUser().onRefreshWithReason().addIObjectEventListener(this.refreshListener);
            this.hasListeners = true;
        }
    }

    void stopListening() {
        if (this.hasListeners) {
            this.sharedDebugProp.getDspUser().onRefreshWithReason().removeIObjectEventListener(this.refreshListener);
            this.hasListeners = false;
        }
    }

    private class OnRefresh
    implements IObjectEventListener<IRefreshEventData> {
        private OnRefresh() {
        }

        @Override
        public void onEvent(IRefreshEventData object) {
            DebugProperties.eventReceiverExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = BooleanProperty.this.propertyLock;
                    synchronized (object) {
                        if (!BooleanProperty.this.isValueBeingRead && !BooleanProperty.this.justWritten) {
                            BooleanProperty.this.isValueValid = false;
                            BooleanProperty.this.sharedDebugProp.propertyValueChanged(BooleanProperty.this.getIden());
                        }
                        BooleanProperty.this.justWritten = false;
                    }
                }
            });
        }
    }
}

