/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.armproperties.impl.Property;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.properties.IButton;

public class Button
extends Property
implements IButton {
    private String action;
    private IDspRegister myRegister;
    private int myRegBitPos;
    private int myValue;
    private IDspValue myDspValue;
    private final ISimpleEventListener connectListener = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            if (Button.this.myRegister != null && Button.this.myDspValue != null) {
                Button.this.enable();
            }
        }
    };
    private final ISimpleEventListener disconnectListener = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            if (!Button.this.getDisableStatus()) {
                Button.this.disable();
            }
        }
    };

    Button(String id, String name, Property parent, String registerID, int regBitPos, int value, String action, boolean disableStatus) {
        super(id, name, parent, true, false);
        if (!disableStatus && registerID != null) {
            this.myRegister = this.sharedDebugProp.createDspRegister(registerID);
            this.myDspValue = this.sharedDebugProp.createDspValue(registerID);
            this.action = action;
            this.myRegBitPos = regBitPos;
            this.myValue = value;
            if (this.sharedDebugProp.getTargetConnection().getConnectionStatus() == ITargetConnection.ConnectionStatus.CONNECTED && (this.myRegister == null || this.myDspValue == null)) {
                this.disable();
            }
            this.sharedDebugProp.getTargetConnection().onConnected().addISimpleEventListener(this.connectListener);
            this.sharedDebugProp.getTargetConnection().onDisconnected().addISimpleEventListener(this.disconnectListener);
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    void flushRegister() {
        if (!this.getDisableStatus() && !this.getReadOnly()) {
            if (this.myRegBitPos == -1) {
                this.myDspValue.assignLong(0);
            } else {
                this.myDspValue.assignLong(0);
                if (this.myValue == 1) {
                    this.myDspValue.setBit(this.myRegBitPos);
                } else {
                    this.myDspValue.clearBit(this.myRegBitPos);
                }
            }
            this.myRegister.setDspValue(this.myDspValue, 0);
            this.sharedDebugProp.getRegisterAccess().requestRegisterWrite(this.myRegister, null);
        }
    }
}

