/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.armproperties.impl.DebugProperties;
import com.ti.debug.engine.armproperties.impl.Group;
import com.ti.debug.engine.armproperties.impl.Node;
import com.ti.debug.engine.armproperties.impl.PropertySet;

class CortexA9PropertySet
extends PropertySet {
    protected CortexA9PropertySet() {
    }

    @Override
    public DebugProperties createDebugProperties(IDspTask dspTask) {
        this.myDebugProperties = new DebugProperties(dspTask);
        Node mainNode = this.myDebugProperties.addRootNode("ARMNode", "");
        mainNode.addBoolean2("MMUEnabled", "MMU Enabled", "REG_SYSTEM_MMU", 0);
        mainNode.addBoolean2("DataCacheEnabled", "Data Cache Enabled", "REG_SYSTEM_MMU", 2);
        mainNode.addBoolean2("InstCacheEnabled", "Instruction Cache Enabled", "REG_SYSTEM_MMU", 1);
        mainNode.addBoolean2("NEONEnabled", "NEON Enabled", "REG_SYSTEM_TARGET", 24);
        mainNode.addBoolean2("SecurityEnabled", "Security Enabled", "REG_SYSTEM_TARGET", 18);
        mainNode.addBoolean2("SnoopControlEnabled", "Snoop Control Enabled", "REG_SYSTEM_TARGET", 19);
        mainNode.addBoolean2("SynchronousMP", "Synchronous Multiprocessor (off = Asynchronous)", "REG_SYSTEM_TARGET", 17);
        Group coherencyManagement = mainNode.addGroup("CoherencyManagement", "Coherency", false);
        coherencyManagement.addButton("CohEstDataSide", "Establish Data-side Coherency", "REG_SYSTEM_COHERENCY_CONTROL", 1, 1, "DPActiveDebugSession.armAdvancedFeatures.establishDataSideCoherency()", false);
        coherencyManagement.addButton("CohEstInstSide", "Establish Instruction-side Coherency", "REG_SYSTEM_COHERENCY_CONTROL", 2, 1, "DPActiveDebugSession.armAdvancedFeatures.establishInstructionSideCoherency()", false);
        coherencyManagement.addButton("CohEstGlobalIMB", "Establish Global IMB", "REG_SYSTEM_COHERENCY_CONTROL", 0, 1, "DPActiveDebugSession.armAdvancedFeatures.establishGlobalIMB()", false);
        coherencyManagement.addButton("CohEstTLB", "Establish TLB Coherency", "REG_SYSTEM_COHERENCY_CONTROL", 4, 1, "DPActiveDebugSession.armAdvancedFeatures.establishTLBCoherency()", false);
        coherencyManagement.addButton("CohFlushPipeline", "Flush the Pipeline", "REG_SYSTEM_COHERENCY_CONTROL", 3, 1, "DPActiveDebugSession.armAdvancedFeatures.establishDatasideCoherency()", false);
        this.REG_VECTOR_CATCH = "REG_VECTOR_CATCH";
        Group nonSecureOptions = mainNode.addGroup("NonSecureOptions", "Non-Secure", false);
        nonSecureOptions.addBoolean("NonSecure_BreakReset", "Break on Reset", this.REG_VECTOR_CATCH, 0, false);
        nonSecureOptions.addBoolean("NonSecure_BreakUndef", "Break on Undefined Instruction", this.REG_VECTOR_CATCH, 25, false);
        nonSecureOptions.addBoolean("NonSecure_BreakSWI", "Break on SWI", this.REG_VECTOR_CATCH, 26, false);
        nonSecureOptions.addBoolean("NonSecure_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, 27, false);
        nonSecureOptions.addBoolean("NonSecure_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, 28, false);
        nonSecureOptions.addBoolean("NonSecure_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, 30, false);
        nonSecureOptions.addBoolean("NonSecure_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, 31, false);
        Group secureOptions = mainNode.addGroup("SecureOptions", "Secure", false);
        secureOptions.addBoolean("Secure_BreakReset", "Break on Reset", this.REG_VECTOR_CATCH, 0, false);
        secureOptions.addBoolean("Secure_BreakUndef", "Break on Undefined Instruction", this.REG_VECTOR_CATCH, 1, false);
        secureOptions.addBoolean("Secure_BreakSWI", "Break on SWI", this.REG_VECTOR_CATCH, 2, false);
        secureOptions.addBoolean("Secure_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, 3, false);
        secureOptions.addBoolean("Secure_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, 4, false);
        secureOptions.addBoolean("Secure_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, 6, false);
        secureOptions.addBoolean("Secure_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, 7, false);
        Group secureMonitorOptions = mainNode.addGroup("SecureMonitorOptions", "Secure Monitor", false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakSMI", "Break on SMI", this.REG_VECTOR_CATCH, 10, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, 11, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, 12, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, 14, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, 15, false);
        return this.myDebugProperties;
    }
}

