/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterAccess;
import com.ti.debug.engine.IRegisterServer;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.armproperties.impl.BooleanProperty;
import com.ti.debug.engine.armproperties.impl.Node;
import com.ti.debug.engine.armproperties.impl.Properties;
import com.ti.debug.engine.armproperties.impl.Property;
import com.ti.debug.engine.events.impl.StringEvent;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.properties.IDebugProperties;
import com.ti.debug.properties.IProperties;
import com.ti.debug.properties.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DebugProperties
extends Disposable
implements IDebugProperties {
    private IDspUser myDspUser;
    private IRegisterServer myRegisterServer;
    private IRegisterAccess myRegisterAccess;
    private ITargetConnection myTargetConnection;
    private String tFullPath;
    private String tType;
    private HashMap<String, Property> propertiesMap = new HashMap();
    private ArrayList<Property> rootElements = new ArrayList();
    private final StringEvent onDisableStatusChangedEvent = new OnStringEvent();
    private final StringEvent onPropertyValueChangedEvent = new OnStringEvent();
    static final ExecutorService eventReceiverExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "arm properties event receiver ");
        }
    });
    static final ExecutorService eventBroadcasterExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "arm properties event broadcaster");
        }
    });

    DebugProperties(IDspTask dspTask) {
        this.myRegisterServer = dspTask.getRegisterServer();
        this.myDspUser = dspTask.createDspUser();
        this.myRegisterAccess = dspTask.getRegisterAccess();
        this.myTargetConnection = dspTask.getTargetConnection();
        this.tFullPath = dspTask.getFullPathName();
        this.tType = dspTask.getTargetType();
    }

    @Override
    public String getTargetFullPath() {
        return this.tFullPath;
    }

    @Override
    public String getTargetType() {
        return this.tType;
    }

    @Override
    public IProperties getRootMenuElements() {
        Properties rootMenuElements = new Properties(this.rootElements);
        return rootMenuElements;
    }

    @Override
    public IProperty getProperty(String propertyID) {
        IProperty property = this.propertiesMap.get(propertyID);
        return property;
    }

    @Override
    public String saveSettings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saveSettingsById(String Id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadSettings(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadDefaultSettings(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDefault() {
        Collection<Property> properties = this.propertiesMap.values();
        for (Property curObj : properties) {
            if (!(curObj instanceof BooleanProperty)) continue;
            BooleanProperty curBoolProp = (BooleanProperty)curObj;
            curBoolProp.restoreDefaultValue();
        }
    }

    @Override
    public IStringEvent onDisableStatusChanged() {
        return this.onDisableStatusChangedEvent;
    }

    @Override
    public IStringEvent onPropertyValueChanged() {
        return this.onPropertyValueChangedEvent;
    }

    @Override
    public boolean isModuleProperty(String moduleName, String propertyID) {
        IProperty property;
        return moduleName.equalsIgnoreCase("armadvancedfeatures") && (property = (IProperty)this.propertiesMap.get(propertyID)) != null;
    }

    IDspUser getDspUser() {
        return this.myDspUser;
    }

    IRegisterAccess getRegisterAccess() {
        return this.myRegisterAccess;
    }

    ITargetConnection getTargetConnection() {
        return this.myTargetConnection;
    }

    void addProperty(String id, Property property) {
        this.propertiesMap.put(id, property);
    }

    Node addRootNode(String id, String name) {
        Node property = new Node(id, name, null, this);
        this.rootElements.add(property);
        return property;
    }

    void propertyValueChanged(final String propertyId) {
        eventBroadcasterExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DebugProperties.this.onPropertyValueChangedEvent.fireEvent(propertyId);
            }
        });
    }

    void disableStatusChanged(final String propertyId) {
        eventBroadcasterExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DebugProperties.this.onDisableStatusChangedEvent.fireEvent(propertyId);
            }
        });
    }

    IDspValue createDspValue(String registerID) {
        IRegister register;
        if (registerID == null || (register = this.myRegisterServer.findRegisterByName(registerID)) == null) {
            return null;
        }
        IDspValue newDspValue = this.myDspUser.createDspValue(IDspValue.Type.UDATA32, 0L);
        IDspValue.Type bestMatchedType = newDspValue.bestMatchedUDataTypeType(register.getBitLength(), (short)register.getPage());
        newDspValue.typeCast(bestMatchedType, 0);
        return newDspValue;
    }

    IDspRegister createDspRegister(String registerID) {
        IRegister register;
        if (registerID == null || (register = this.myRegisterServer.findRegisterByName(registerID)) == null) {
            return null;
        }
        assert (register.getPage() == 121);
        IDspRegister dspRegister = this.myRegisterAccess.createDspRegister(register.getAddress());
        return dspRegister;
    }

    private class OnStringEvent
    extends StringEvent {
        Collection<Property> properties;
        BooleanProperty curBoolProp;

        private OnStringEvent() {
            this.properties = DebugProperties.this.propertiesMap.values();
        }

        @Override
        protected void registerForEvents() {
            for (Property curProp : this.properties) {
                if (!(curProp instanceof BooleanProperty)) continue;
                this.curBoolProp = (BooleanProperty)curProp;
                this.curBoolProp.startListening();
            }
        }

        @Override
        protected void unregisterForEvents() {
            for (Property curProp : this.properties) {
                if (!(curProp instanceof BooleanProperty)) continue;
                this.curBoolProp = (BooleanProperty)curProp;
                this.curBoolProp.stopListening();
            }
        }
    }
}

