/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.armproperties.impl.DebugProperties;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.properties.IProperty;

public abstract class Property
extends Disposable
implements IProperty {
    protected DebugProperties sharedDebugProp;
    private String id;
    private String name;
    private Property parent;
    private boolean disableStatus;
    private boolean readOnly;

    Property(String id, String name, Property parent, boolean disableStatus, boolean readOnly) {
        this(id, name, parent, disableStatus, readOnly, parent.sharedDebugProp);
    }

    Property(String id, String name, Property parent, boolean disableStatus, boolean readOnly, DebugProperties debugProp) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.disableStatus = disableStatus;
        this.readOnly = readOnly;
        this.sharedDebugProp = debugProp;
        debugProp.addProperty(id, this);
    }

    void disable() {
        if (!this.disableStatus) {
            this.disableStatus = true;
            this.sharedDebugProp.disableStatusChanged(this.id);
        }
    }

    void enable() {
        if (this.disableStatus) {
            this.disableStatus = false;
            this.sharedDebugProp.disableStatusChanged(this.id);
        }
    }

    @Override
    public String getIden() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getDisableStatus() {
        return this.disableStatus;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean getNoDefault() {
        return false;
    }

    @Override
    public IProperty getParent() {
        return this.parent;
    }
}

