/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.armproperties.impl.ARM11PropertySet;
import com.ti.debug.engine.armproperties.impl.ARM9PropertySet;
import com.ti.debug.engine.armproperties.impl.CortexA8PropertySet;
import com.ti.debug.engine.armproperties.impl.CortexA9PropertySet;
import com.ti.debug.engine.armproperties.impl.CortexM3PropertySet;
import com.ti.debug.engine.armproperties.impl.CortexR4PropertySet;
import com.ti.debug.engine.armproperties.impl.PropertySet;

abstract class PropertyFactory {
    PropertyFactory() {
    }

    public static PropertySet createPropertySet(int subFamilyID, int targetRev) {
        int ARM925 = 38;
        int ARM1176 = 118;
        boolean isARM925 = false;
        boolean isARM1176 = false;
        if (targetRev == 118) {
            isARM1176 = true;
        } else if (targetRev == 38) {
            isARM925 = true;
        }
        switch (subFamilyID) {
            case 2: {
                return new ARM9PropertySet(isARM925);
            }
            case 3: {
                return new ARM11PropertySet(isARM1176);
            }
            case 9: 
            case 21: {
                return new CortexA9PropertySet();
            }
            case 12: {
                return new CortexA8PropertySet();
            }
            case 13: {
                return new CortexR4PropertySet();
            }
            case 14: {
                return new CortexM3PropertySet();
            }
        }
        return null;
    }
}

