/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.armproperties.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.armproperties.impl.DebugProperties;
import com.ti.debug.engine.armproperties.impl.Group;
import com.ti.debug.engine.armproperties.impl.Node;
import com.ti.debug.engine.armproperties.impl.PropertyFactory;

public abstract class PropertySet
extends PropertyFactory {
    protected DebugProperties myDebugProperties;
    protected String CP15_MMU_ID;
    protected String CP15_MPU_ID;
    protected String CP15_ALNG_FLT_ID;
    protected String CP15_D_CACHE_ID;
    protected String CP15_I_CACHE_ID;
    protected String TZ_SECURE_ID;
    protected String AHB_DOWNLOAD_ID;
    protected String NEON_ENABLE_ID;
    protected String CP15_W_BUFF_ID;
    protected String CP15_FLSH_I_ID;
    protected String CP15_FLSH_D_ID;
    protected String CP15_FLSH_DI_ID;
    protected String CP15_CLEAN_DATA_ID;
    protected String CP15_FLUSH_I_TLB_ID;
    protected String CP15_FLUSH_D_TLB_ID;
    protected String CP15_FLUSH_DI_TLB_ID;
    protected String REG_VECTOR_CATCH;
    protected int MMUEnabled_bit = 0;
    protected int MPUEnabled_bit = 0;
    protected int AlignFaultEnabled_bit = 0;
    protected int DataCacheEnabled_bit = 0;
    protected int InstCacheEnabled_bit = 0;
    protected int WriteBufferEnabled_bit = 0;
    protected int NonSecure_BreakReset_bit = 0;
    protected int NonSecure_BreakUndef_bit = 1;
    protected int NonSecure_BreakSWI_bit = 2;
    protected int NonSecure_BreakProgramAbort_bit = 3;
    protected int NonSecure_BreakDataAbort_bit = 4;
    protected int NonSecure_BreakIRQ_bit = 6;
    protected int NonSecure_BreakFIQ_bit = 7;
    protected boolean MMUEnabled_enable = false;
    protected boolean MPUEnabled_enable = false;
    protected boolean AlignFaultEnabled_enable = false;
    protected boolean DataCacheEnabled_enable = false;
    protected boolean InstCacheEnabled_enable = false;
    protected boolean WriteBufferEnabled_enable = false;
    protected boolean SecureStateEnabled_enable = false;
    protected boolean FastDownload_enable = false;
    protected boolean NEONEnabled_enable = false;
    protected boolean CacheManagement_enable = false;
    protected boolean TLBManagement_enable = false;
    protected boolean NonSecureOptions_enable = false;
    protected boolean OtherOptions_enable = false;
    protected boolean SecureOptions_enable = false;
    protected boolean SecureMonitorOptions_enable = false;

    public DebugProperties createDebugProperties(IDspTask dspTask) {
        this.myDebugProperties = new DebugProperties(dspTask);
        Node mainNode = this.myDebugProperties.addRootNode("ARMNode", "");
        mainNode.addBoolean("MMUEnabled", "MMU Enabled", this.CP15_MMU_ID, this.MMUEnabled_bit, !this.MMUEnabled_enable);
        mainNode.addBoolean("MPUEnabled", "MPU Enabled", this.CP15_MPU_ID, this.MPUEnabled_bit, !this.MPUEnabled_enable);
        mainNode.addBoolean("AlignFaultEnabled", "Alignment Fault Checking Enabled", this.CP15_ALNG_FLT_ID, this.AlignFaultEnabled_bit, !this.AlignFaultEnabled_enable);
        mainNode.addBoolean("SecureStateEnabled", "Secure State Enabled", this.TZ_SECURE_ID, 0, !this.SecureStateEnabled_enable);
        mainNode.addBoolean("FastDownload", "AHB Download", this.AHB_DOWNLOAD_ID, 0, !this.FastDownload_enable);
        mainNode.addBoolean("NEONEnabled", "NEON Enabled", this.NEON_ENABLE_ID, 0, !this.NEONEnabled_enable);
        Group cacheManagement = mainNode.addGroup("CacheManagement", "Cache Management", !this.CacheManagement_enable);
        cacheManagement.addBoolean("DataCacheEnabled", "Data Cache Enabled", this.CP15_D_CACHE_ID, this.DataCacheEnabled_bit, !this.DataCacheEnabled_enable);
        cacheManagement.addBoolean("InstCacheEnabled", "Instruction Cache Enabled", this.CP15_I_CACHE_ID, this.InstCacheEnabled_bit, !this.InstCacheEnabled_enable);
        cacheManagement.addBoolean("WriteBufferEnabled", "Write Buffer Enabled", this.CP15_W_BUFF_ID, this.WriteBufferEnabled_bit, !this.WriteBufferEnabled_enable);
        cacheManagement.addButton("FlushInstructionCache", "Flush Instruction Cache", this.CP15_FLSH_I_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushInstructionCache()", false);
        cacheManagement.addButton("FlushDataCache", "Flush Data Cache", this.CP15_FLSH_D_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushInstructionCache()", false);
        cacheManagement.addButton("FlushAllCaches", "Flush All Caches", this.CP15_FLSH_DI_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushDataCache()", false);
        cacheManagement.addButton("CleanDataCache", "Clean Data Cache", this.CP15_CLEAN_DATA_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.cleanDataCache()", false);
        Group TLBManagement = mainNode.addGroup("TLBManagement", "TLB Management", !this.TLBManagement_enable);
        TLBManagement.addButton("FlushInstructionTLB", "Flush Instruction TLB", this.CP15_FLUSH_I_TLB_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushInstructionTLB()", false);
        TLBManagement.addButton("FlushDataTLB", "Flush Data TLB", this.CP15_FLUSH_D_TLB_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushDataTLB()", false);
        TLBManagement.addButton("FlushAllTLBs", "Flush All TLBs", this.CP15_FLUSH_DI_TLB_ID, -1, -1, "DPActiveDebugSession.armAdvancedFeatures.flushAllTLBs()", false);
        Group nonSecureOptions = mainNode.addGroup("NonSecureOptions", "Non-Secure", !this.NonSecureOptions_enable);
        nonSecureOptions.addBoolean("NonSecure_BreakReset", "Break on Reset", this.REG_VECTOR_CATCH, this.NonSecure_BreakReset_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakUndef", "Break on Undefined Instruction", this.REG_VECTOR_CATCH, this.NonSecure_BreakUndef_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakSWI", "Break on SWI", this.REG_VECTOR_CATCH, this.NonSecure_BreakSWI_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, this.NonSecure_BreakProgramAbort_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, this.NonSecure_BreakDataAbort_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, this.NonSecure_BreakIRQ_bit, false);
        nonSecureOptions.addBoolean("NonSecure_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, this.NonSecure_BreakFIQ_bit, false);
        Group otherOptions = mainNode.addGroup("OtherOptions", "", !this.OtherOptions_enable);
        otherOptions.addBoolean("BreakMemManageError", "Break on Memory Management Error", this.REG_VECTOR_CATCH, 4, false);
        otherOptions.addBoolean("BreakAcessCoproError", "Break on Access To Coprocessor Error", this.REG_VECTOR_CATCH, 5, false);
        otherOptions.addBoolean("BreakFaultEnableError", "Break on Fault Enable Checking Error", this.REG_VECTOR_CATCH, 6, false);
        otherOptions.addBoolean("BreakFaultCheckingError", "Break on Fault Checking Error", this.REG_VECTOR_CATCH, 7, false);
        otherOptions.addBoolean("BreakNormalBusError", "Break on Normal Bus Error", this.REG_VECTOR_CATCH, 8, false);
        otherOptions.addBoolean("BreakInterruptServiceError", "Break on Interrupt Service Error", this.REG_VECTOR_CATCH, 9, false);
        otherOptions.addBoolean("BreakHardFaultError", "Break on Hard Fault Error", this.REG_VECTOR_CATCH, 10, false);
        Group secureOptions = mainNode.addGroup("SecureOptions", "Secure", !this.SecureOptions_enable);
        secureOptions.addBoolean("Secure_BreakReset", "Break on Reset", this.REG_VECTOR_CATCH, 0, false);
        secureOptions.addBoolean("Secure_BreakUndef", "Break on Undefined Instruction", this.REG_VECTOR_CATCH, 1, false);
        secureOptions.addBoolean("Secure_BreakSWI", "Break on SWI", this.REG_VECTOR_CATCH, 2, false);
        secureOptions.addBoolean("Secure_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, 3, false);
        secureOptions.addBoolean("Secure_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, 4, false);
        secureOptions.addBoolean("Secure_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, 6, false);
        secureOptions.addBoolean("Secure_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, 7, false);
        Group secureMonitorOptions = mainNode.addGroup("SecureMonitorOptions", "Secure Monitor", !this.SecureMonitorOptions_enable);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakSMI", "Break on SMI", this.REG_VECTOR_CATCH, 10, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakProgramAbort", "Break on Prefetch Abort", this.REG_VECTOR_CATCH, 11, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakDataAbort", "Break on Data Abort", this.REG_VECTOR_CATCH, 12, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakIRQ", "Break on IRQ", this.REG_VECTOR_CATCH, 14, false);
        secureMonitorOptions.addBoolean("SecureMonitor_BreakFIQ", "Break on FIQ", this.REG_VECTOR_CATCH, 15, false);
        return this.myDebugProperties;
    }
}

