/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.cce;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.cce.ICCEDebugEngine;
import com.ti.debug.engine.cce.IDebugEngine;
import com.ti.debug.engine.impl.Application;
import com.ti.xpcom.interfaces.dsIDebugger;
import java.util.logging.Logger;

public class CCEDebugEngine
extends Application
implements IDebugEngine,
ICCEDebugEngine {
    private static CCEDebugEngine instance;
    protected boolean exitPolling = false;
    private static final int WAIT_TIME_AFTER_DEBUGGER_ACCESS;
    private int nLegacyDisposeCount = 0;

    private CCEDebugEngine() {
        this.traceLog = Logger.getLogger(this.getClass().getName());
        pollingThread = new PollingThread();
        pollingThread.start();
    }

    public static synchronized IApplication instance() {
        if (null == instance) {
            instance = new CCEDebugEngine();
        }
        return instance;
    }

    public static synchronized IApplication createInstance() throws Exception {
        IApplication app = CCEDebugEngine.instance();
        app.acquire();
        return app;
    }

    public static synchronized IApplication createInstanceNoAddref() throws Exception {
        return CCEDebugEngine.instance();
    }

    @Override
    public synchronized void dispose() {
        --this.nLegacyDisposeCount;
        if (0 == this.nLegacyDisposeCount && this.isConfigured()) {
            this.deConfigure();
        }
    }

    @Override
    public synchronized void acquire() {
        ++this.nLegacyDisposeCount;
    }

    protected static synchronized boolean hasLegacyInstance() {
        return null != instance && CCEDebugEngine.instance.nLegacyDisposeCount > 0;
    }

    public long pollThreadMain() {
        return ((dsIDebugger)this.wrappedObject).pollThreadMain();
    }

    static {
        WAIT_TIME_AFTER_DEBUGGER_ACCESS = Integer.parseInt(System.getProperty("com.ti.debug.engine.cce.CCEDebugEngine.WAIT_TIME_AFTER_DEBUGGER_ACCESS", "50"));
    }

    public class PollingThread
    extends Thread {
        private boolean pollOnce;

        public PollingThread() {
            super("polling thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeUp() {
            PollingThread pollingThread = this;
            synchronized (pollingThread) {
                this.pollOnce = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long waitInterval = 0L;
            while (!CCEDebugEngine.this.exitPolling) {
                PollingThread pollingThread = this;
                synchronized (pollingThread) {
                    if (waitInterval > 0L && !this.pollOnce) {
                        try {
                            this.wait(waitInterval);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                if (CCEDebugEngine.this.exitPolling) continue;
                try {
                    if (null == instance || CCEDebugEngine.this.exitPolling) continue;
                    pollingThread = this;
                    synchronized (pollingThread) {
                        if (!this.pollOnce) {
                            try {
                                this.wait(WAIT_TIME_AFTER_DEBUGGER_ACCESS);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    this.pollOnce = false;
                    waitInterval = instance.pollThreadMain();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static class Factory
    implements IDebugEngine.IFactory {
        @Override
        public IApplication createInstance() throws Exception {
            return CCEDebugEngine.createInstance();
        }

        public IApplication createInstanceNoAddref() throws Exception {
            return CCEDebugEngine.createInstanceNoAddref();
        }

        @Override
        public boolean hasInstance() {
            return CCEDebugEngine.hasLegacyInstance();
        }
    }
}

