/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.cce;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.cce.IDebugEngine;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.impl.Application;
import com.ti.xpcom.interfaces.dsIDebugger;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class TclDebugEngine
extends Application
implements IDebugEngine {
    private static IDebugEngine instance;
    private final StreamHandler handler;
    private TclConfigurer configurer = null;

    public TclDebugEngine() {
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.handler = new StreamHandler(System.out, new SimpleFormatter());
        this.traceLog.addHandler(this.handler);
    }

    public static synchronized IApplication createInstance() {
        if (null == instance) {
            instance = new TclDebugEngine();
        }
        return instance;
    }

    public void configure(String systemSetupXmlPath) throws IApplication.InitializationException {
        this.configure(systemSetupXmlPath, false);
    }

    public void configure(String systemSetupXmlPath, boolean disableCtools) throws IApplication.InitializationException {
        this.configurer = new TclConfigurer();
        this.configure(systemSetupXmlPath, this.configurer, false, disableCtools);
        this.configurer.go();
        this.configurer = null;
    }

    @Override
    public void deConfigure() {
        if (null != this.configurer) {
            this.configurer.deconfigure();
        } else {
            this.pollingDeconfigure();
        }
    }

    private void pollingDeconfigure() {
        class TclDeconfigurer
        implements ISimpleEventListener {
            private boolean gotEvent = false;

            TclDeconfigurer() {
            }

            @Override
            public void onEvent() {
                this.gotEvent = true;
            }

            private void go() {
                while (!this.gotEvent) {
                    TclDebugEngine.this.poll();
                }
            }
        }
        TclDeconfigurer listener = new TclDeconfigurer();
        this.deConfigure(listener);
        listener.go();
    }

    public String getAllocatedObjects(boolean bIncludeLocations) {
        return ((dsIDebugger)this.getWrappedObject()).getCurrentAllocatedObjects(bIncludeLocations);
    }

    public long poll() {
        return ((dsIDebugger)this.wrappedObject).poll();
    }

    private class TclConfigurer
    implements IObjectEventListener<IApplication.InitializationException> {
        private IApplication.InitializationException exception = null;
        private boolean gotEvent = false;
        private boolean doDeconfigure = false;

        private TclConfigurer() {
        }

        @Override
        public void onEvent(IApplication.InitializationException data) {
            this.exception = data;
            this.gotEvent = true;
        }

        private void go() throws IApplication.InitializationException {
            while (!this.gotEvent && !this.doDeconfigure) {
                TclDebugEngine.this.poll();
            }
            if (this.doDeconfigure) {
                TclDebugEngine.this.pollingDeconfigure();
            }
            if (null != this.exception) {
                throw this.exception;
            }
        }

        private void deconfigure() {
            this.doDeconfigure = true;
        }
    }
}

