/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.datastream.impl;

import com.ti.debug.engine.datastream.exception.BreakpointException;
import com.ti.debug.engine.datastream.exception.DriverException;
import com.ti.debug.engine.datastream.exception.InvalidDataSizeException;
import com.ti.debug.engine.datastream.exception.InvalidTargetStructureException;
import com.ti.debug.engine.datastream.exception.OverflowException;
import com.ti.debug.engine.datastream.exception.OverlapException;
import com.ti.debug.engine.datastream.exception.TargetAccessException;
import com.ti.debug.engine.datastream.exception.TargetDisconnectedException;
import com.ti.debug.engine.datastream.exception.UnsynchronizedAccessException;
import com.ti.debug.engine.xpcom.event.impl.AEventDataTranslator;
import com.ti.xpcom.interfaces.dsIOverflowException;
import com.ti.xpcom.interfaces.dsIStreamException;
import com.ti.xpcom.interfaces.nsISupports;
import java.io.IOException;

class ExceptionTranslator
extends AEventDataTranslator<IOException> {
    ExceptionTranslator() {
    }

    @Override
    public IOException translate(nsISupports event) {
        IOException exception = null;
        if (null != event) {
            dsIStreamException streamException = (dsIStreamException)event.queryInterface("{3ae51ee0-8c95-4516-9dab-0112ea36bbf5}");
            switch (streamException.getType()) {
                case 0: {
                    exception = new InvalidDataSizeException(streamException.getExplanation());
                    break;
                }
                case 1: {
                    exception = new InvalidTargetStructureException(streamException.getExplanation());
                    break;
                }
                case 2: {
                    dsIOverflowException overflowException = (dsIOverflowException)streamException.queryInterface("{f812bc2c-cd2c-429c-84b0-4ddae1cd3360}");
                    exception = new OverflowException(streamException.getExplanation(), overflowException.getCount(), overflowException.getRunningTotal());
                    break;
                }
                case 3: {
                    exception = new OverlapException(streamException.getExplanation());
                    break;
                }
                case 4: {
                    exception = new TargetAccessException(streamException.getExplanation());
                    break;
                }
                case 5: {
                    exception = new TargetDisconnectedException(streamException.getExplanation());
                    break;
                }
                case 6: {
                    exception = new UnsynchronizedAccessException(streamException.getExplanation());
                    break;
                }
                case 7: {
                    exception = new BreakpointException(streamException.getExplanation());
                }
                case 8: {
                    exception = new DriverException(streamException.getExplanation());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return exception;
    }

    void checkForErrors(dsIStreamException streamException) throws IOException {
        if (null != streamException) {
            throw this.translate(streamException);
        }
    }
}

